/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicy;
import com.jgoodies.looks.MicroLayouts;
import javax.swing.UIDefaults;

public final class MicroLayoutPolicies {
    private MicroLayoutPolicies() {
    }

    public static MicroLayoutPolicy getDefaultPlasticPolicy() {
        return new DefaultPlasticPolicy();
    }

    public static MicroLayoutPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    private static final class DefaultWindowsPolicy
    implements MicroLayoutPolicy {
        private DefaultWindowsPolicy() {
        }

        @Override
        public MicroLayout getMicroLayout(String string, UIDefaults uIDefaults) {
            boolean bl = !SystemUtils.IS_LAF_WINDOWS_XP_ENABLED;
            boolean bl2 = SystemUtils.IS_OS_WINDOWS_6_OR_LATER;
            boolean bl3 = SystemUtils.IS_LOW_RESOLUTION;
            if (bl) {
                return bl3 ? MicroLayouts.createWindowsClassicLowResMicroLayout() : MicroLayouts.createWindowsClassicHiResMicroLayout();
            }
            if (bl2) {
                return bl3 ? MicroLayouts.createWindowsModernLowResMicroLayout() : MicroLayouts.createWindowsModernHiResMicroLayout();
            }
            return bl3 ? MicroLayouts.createWindowsXPLowResMicroLayout() : MicroLayouts.createWindowsXPHiResMicroLayout();
        }
    }

    private static final class DefaultPlasticPolicy
    implements MicroLayoutPolicy {
        private DefaultPlasticPolicy() {
        }

        @Override
        public MicroLayout getMicroLayout(String string, UIDefaults uIDefaults) {
            boolean bl = SystemUtils.IS_LOW_RESOLUTION;
            if ("JGoodies Plastic".equals(string)) {
                return bl ? MicroLayouts.createPlasticLowResMicroLayout() : MicroLayouts.createPlasticHiResMicroLayout();
            }
            if ("JGoodies Plastic XP".equals(string)) {
                return bl ? MicroLayouts.createPlasticXPLowResMicroLayout() : MicroLayouts.createPlasticXPHiResMicroLayout();
            }
            return bl ? MicroLayouts.createPlasticModernLoResMicroLayout() : MicroLayouts.createPlasticModernHiResMicroLayout();
        }
    }
}

