/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.Options;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.JTextComponent;

public class ExtBasicCaret
extends BasicTextUI.BasicCaret {
    private boolean isKeyboardFocusEvent = true;

    @Override
    public final void focusGained(FocusEvent focusEvent) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        if (jTextComponent.isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if (!(jTextComponent.isEnabled() && this.isKeyboardFocusEvent && Options.isSelectOnFocusGainActive(jTextComponent))) {
            return;
        }
        if (jTextComponent instanceof JFormattedTextField) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtBasicCaret.this.selectAll();
                }
            });
        } else {
            this.selectAll();
        }
    }

    private void selectAll() {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        boolean bl = Boolean.TRUE.equals(jTextComponent.getClientProperty("JGoodies.invertSelection"));
        if (bl) {
            this.setDot(jTextComponent.getDocument().getLength());
            this.moveDot(0);
        } else {
            this.setDot(0);
            this.moveDot(jTextComponent.getDocument().getLength());
        }
    }

    @Override
    public final void focusLost(FocusEvent focusEvent) {
        try {
            super.focusLost(focusEvent);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (!focusEvent.isTemporary()) {
            this.isKeyboardFocusEvent = true;
            if (this.getComponent() != null && Boolean.TRUE.equals(this.getComponent().getClientProperty("JGoodies.setCaretToStartOnFocusLost"))) {
                this.setDot(0);
            }
        }
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(mouseEvent);
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }
}

