/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.common.ExtBasicCaret;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public final class FieldCaret
extends ExtBasicCaret {
    private static final LayeredHighlighter.LayerPainter WINDOWS_PAINTER = new ExtDefaultHighlightPainter(null);

    @Override
    protected void adjustVisibility(Rectangle rectangle) {
        if (!(this.getComponent() instanceof JTextField)) {
            return;
        }
        EventQueue.invokeLater(new SafeScroller(rectangle));
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return WINDOWS_PAINTER;
    }

    private static final class ExtDefaultHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        ExtDefaultHighlightPainter(Color color) {
            super(color);
        }

        @Override
        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            Rectangle rectangle = shape.getBounds();
            try {
                int n3;
                TextUI textUI = jTextComponent.getUI();
                Rectangle rectangle2 = textUI.modelToView(jTextComponent, n);
                Rectangle rectangle3 = textUI.modelToView(jTextComponent, n2);
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(jTextComponent.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                boolean bl = false;
                boolean bl2 = false;
                if (jTextComponent.isEditable()) {
                    n3 = jTextComponent.getCaretPosition();
                    bl = n == n3;
                    boolean bl3 = bl2 = n2 == n3;
                }
                if (rectangle2.y == rectangle3.y) {
                    Rectangle rectangle4 = rectangle2.union(rectangle3);
                    if (rectangle4.width > 0) {
                        if (bl) {
                            ++rectangle4.x;
                            --rectangle4.width;
                        } else if (bl2) {
                            --rectangle4.width;
                        }
                    }
                    graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                } else {
                    n3 = rectangle.x + rectangle.width - rectangle2.x;
                    if (bl && n3 > 0) {
                        ++rectangle2.x;
                        --n3;
                    }
                    graphics.fillRect(rectangle2.x, rectangle2.y, n3, rectangle2.height);
                    if (rectangle2.y + rectangle2.height != rectangle3.y) {
                        graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                    }
                    if (bl2 && rectangle3.x > rectangle.x) {
                        --rectangle3.x;
                    }
                    graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            Color color = this.getColor();
            if (color == null) {
                graphics.setColor(jTextComponent.getSelectionColor());
            } else {
                graphics.setColor(color);
            }
            boolean bl = false;
            boolean bl2 = false;
            if (jTextComponent.isEditable()) {
                int n3 = jTextComponent.getCaretPosition();
                bl = n == n3;
                boolean bl3 = bl2 = n2 == n3;
            }
            if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                if (bl && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height);
                } else if (bl2 && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                return rectangle;
            }
            try {
                Rectangle rectangle;
                Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                Rectangle rectangle2 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                if (bl && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height);
                } else if (bl2 && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }

    private final class SafeScroller
    implements Runnable {
        private final Rectangle r;

        SafeScroller(Rectangle rectangle) {
            this.r = rectangle;
        }

        @Override
        public void run() {
            JTextField jTextField = (JTextField)FieldCaret.this.getComponent();
            if (jTextField == null) {
                return;
            }
            TextUI textUI = jTextField.getUI();
            int n = FieldCaret.this.getDot();
            Position.Bias bias = Position.Bias.Forward;
            Rectangle rectangle = null;
            try {
                rectangle = textUI.modelToView(jTextField, n, bias);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            Insets insets = jTextField.getInsets();
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n2 = this.r.x + boundedRangeModel.getValue() - insets.left;
            int n3 = boundedRangeModel.getExtent() / 4;
            if (this.r.x < insets.left) {
                boundedRangeModel.setValue(n2 - n3);
            } else if (this.r.x + this.r.width > insets.left + boundedRangeModel.getExtent() + 1) {
                boundedRangeModel.setValue(n2 - 3 * n3);
            }
            if (rectangle == null) {
                return;
            }
            try {
                Rectangle rectangle2 = textUI.modelToView(jTextField, n, bias);
                if (rectangle2 != null && !rectangle2.equals(rectangle)) {
                    FieldCaret.this.damage(rectangle2);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

