/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.Options;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public final class RGBGrayFilter
extends RGBImageFilter {
    private RGBGrayFilter() {
        this.canFilterIndexColorModel = true;
    }

    public static Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        Image image;
        if (icon == null || jComponent == null || icon.getIconWidth() == 0 || icon.getIconHeight() == 0) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            image = ((ImageIcon)icon).getImage();
        } else {
            image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(jComponent, image.getGraphics(), 0, 0);
        }
        if (!Options.isHiResGrayFilterEnabled() || Boolean.FALSE.equals(jComponent.getClientProperty("generateHiResDisabledIcon"))) {
            return new ImageIcon(GrayFilter.createDisabledImage(image));
        }
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new RGBGrayFilter());
        return new ImageIcon(jComponent.createImage(filteredImageSource));
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        float f = ((float)(n3 >> 16 & 0xFF) / 255.0f + (float)(n3 >> 8 & 0xFF) / 255.0f + (float)(n3 & 0xFF) / 255.0f) / 3.0f;
        float f2 = (float)(n3 >> 24 & 0xFF) / 255.0f;
        f = Math.min(1.0f, 0.35f + 0.65f * f);
        return (int)(f2 * 255.0f) << 24 | (int)(f * 255.0f) << 16 | (int)(f * 255.0f) << 8 | (int)(f * 255.0f);
    }
}

