/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.decoration;

import com.jgoodies.looks.decoration.MetroBorders;
import com.jgoodies.looks.decoration.MetroTitlePane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;

public final class MetroRootPaneUI
extends BasicRootPaneUI {
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private JComponent titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static final int[] cursorMapping = new int[]{6, 6, 0, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetroRootPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.root = (JRootPane)jComponent;
        int n = this.root.getWindowDecorationStyle();
        if (n != 0) {
            this.installClientDecorations(this.root);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    static void installDefaultBorder(JRootPane jRootPane) {
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            LookAndFeel.uninstallBorder(jRootPane);
        } else {
            Border border = jRootPane.getBorder();
            if (border == null || border instanceof UIResource) {
                jRootPane.setBorder(new MetroBorders.DefaultFrameBorder());
            }
        }
    }

    static void installMaximizedBorder(JRootPane jRootPane) {
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            LookAndFeel.uninstallBorder(jRootPane);
        } else {
            Border border = jRootPane.getBorder();
            if (border == null || border instanceof UIResource) {
                jRootPane.setBorder(new MetroBorders.MaximizedFrameBorder());
            }
        }
    }

    private static void uninstallBorder(JRootPane jRootPane) {
        LookAndFeel.uninstallBorder(jRootPane);
    }

    private void installWindowListeners(Component component) {
        this.window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener();
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners() {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane jRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = MetroRootPaneUI.createLayoutManager();
        }
        this.savedOldLayout = jRootPane.getLayout();
        jRootPane.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane jRootPane) {
        if (this.savedOldLayout != null) {
            jRootPane.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane jRootPane) {
        MetroRootPaneUI.installDefaultBorder(jRootPane);
        JComponent jComponent = this.createTitlePane(jRootPane);
        this.setTitlePane(jRootPane, jComponent);
        this.installWindowListeners(jRootPane.getParent());
        this.installLayout(jRootPane);
        if (this.window != null) {
            jRootPane.revalidate();
            jRootPane.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane jRootPane) {
        MetroRootPaneUI.uninstallBorder(jRootPane);
        this.uninstallWindowListeners();
        this.setTitlePane(jRootPane, null);
        this.uninstallLayout(jRootPane);
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            jRootPane.repaint();
            jRootPane.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private JComponent createTitlePane(JRootPane jRootPane) {
        return new MetroTitlePane(jRootPane, this);
    }

    private MouseInputListener createWindowMouseInputListener() {
        return new MouseInputHandler();
    }

    private static LayoutManager createLayoutManager() {
        return new MetroRootLayout();
    }

    private void setTitlePane(JRootPane jRootPane, JComponent jComponent) {
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        JComponent jComponent2 = this.getTitlePane();
        if (jComponent2 != null) {
            jComponent2.setVisible(false);
            jLayeredPane.remove(jComponent2);
        }
        if (jComponent != null) {
            jLayeredPane.add((Component)jComponent, JLayeredPane.FRAME_CONTENT_LAYER);
            jComponent.setVisible(true);
        }
        this.titlePane = jComponent;
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals("windowDecorationStyle")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            int n = jRootPane.getWindowDecorationStyle();
            this.uninstallClientDecorations(jRootPane);
            if (n != 0) {
                this.installClientDecorations(jRootPane);
            }
        } else if (string.equals("ancestor")) {
            this.uninstallWindowListeners();
            if (((JRootPane)propertyChangeEvent.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root.getParent());
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private boolean inside = false;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            JRootPane jRootPane = MetroRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Window window = (Window)mouseEvent.getSource();
            if (window != null) {
                window.toFront();
            }
            Point point2 = SwingUtilities.convertPoint(window, point, MetroRootPaneUI.this.getTitlePane());
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n2 = n = frame != null ? frame.getExtendedState() : 0;
            if (MetroRootPaneUI.this.getTitlePane() != null && MetroRootPaneUI.this.getTitlePane().contains(point2)) {
                if ((frame != null && (n & 6) == 0 || dialog != null) && point.y >= 5 && point.x >= 5 && point.x < (window != null ? window.getWidth() : 0) - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = point.x;
                    this.dragOffsetY = point.y;
                }
            } else if (frame != null && frame.isResizable() && (n & 6) == 0 || dialog != null && dialog.isResizable()) {
                this.dragOffsetX = point.x;
                this.dragOffsetY = point.y;
                this.dragWidth = window != null ? window.getWidth() : 0;
                this.dragHeight = window != null ? window.getHeight() : 0;
                this.dragCursor = this.getCursor(this.calculateCorner(window, point.x, point.y));
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dragCursor != 0 && MetroRootPaneUI.this.window != null && !MetroRootPaneUI.this.window.isValid()) {
                MetroRootPaneUI.this.window.validate();
                MetroRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JRootPane jRootPane = MetroRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = (Window)mouseEvent.getSource();
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n = this.getCursor(this.calculateCorner(window, mouseEvent.getX(), mouseEvent.getY()));
            if (n != 0 && (frame != null && frame.isResizable() && (frame.getExtendedState() & 6) == 0 || dialog != null && dialog.isResizable())) {
                window.setCursor(Cursor.getPredefinedCursor(n));
            } else {
                window.setCursor(MetroRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle rectangle, Dimension dimension, int n, int n2, int n3, int n4) {
            rectangle.x += n;
            rectangle.y += n2;
            rectangle.width += n3;
            rectangle.height += n4;
            if (dimension != null) {
                int n5;
                if (rectangle.width < dimension.width) {
                    n5 = dimension.width - rectangle.width;
                    if (n != 0) {
                        rectangle.x -= n5;
                    }
                    rectangle.width = dimension.width;
                }
                if (rectangle.height < dimension.height) {
                    n5 = dimension.height - rectangle.height;
                    if (n2 != 0) {
                        rectangle.y -= n5;
                    }
                    rectangle.height = dimension.height;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            if (this.isMovingWindow) {
                Point point2 = mouseEvent.getLocationOnScreen();
                window.setLocation(point2.x - this.dragOffsetX, point2.y - this.dragOffsetY);
            } else if (this.dragCursor != 0) {
                Rectangle rectangle = window.getBounds();
                Rectangle rectangle2 = new Rectangle(rectangle);
                Dimension dimension = window.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + this.dragWidth - this.dragOffsetX - rectangle.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(rectangle, dimension, 0, 0, 0, point.y + this.dragHeight - this.dragOffsetY - rectangle.height);
                        break;
                    }
                    case 8: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, 0, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, point.x + this.dragWidth - this.dragOffsetX - rectangle.width, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + this.dragWidth - this.dragOffsetX - rectangle.width, point.y + this.dragHeight - this.dragOffsetY - rectangle.height);
                        break;
                    }
                    case 6: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, point.y - this.dragOffsetY, -(point.x - this.dragOffsetX), -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), point.y + this.dragHeight - this.dragOffsetY - rectangle.height);
                        break;
                    }
                }
                if (!rectangle.equals(rectangle2)) {
                    window.setBounds(rectangle);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        window.validate();
                        MetroRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.inside) {
                Window window = (Window)mouseEvent.getSource();
                MetroRootPaneUI.this.lastCursor = window.getCursor();
                this.inside = true;
            }
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            window.setCursor(MetroRootPaneUI.this.lastCursor);
            this.inside = false;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            Frame frame = null;
            if (!(window instanceof Frame)) {
                return;
            }
            frame = (Frame)window;
            Point point = SwingUtilities.convertPoint(window, mouseEvent.getPoint(), MetroRootPaneUI.this.getTitlePane());
            int n = frame.getExtendedState();
            if (MetroRootPaneUI.this.getTitlePane() != null && MetroRootPaneUI.this.getTitlePane().contains(point) && mouseEvent.getClickCount() % 2 == 0 && (mouseEvent.getModifiers() & 0x10) != 0 && frame.isResizable()) {
                if ((n & 6) != 0) {
                    frame.setExtendedState(n & 0xFFFFFFF9);
                } else {
                    frame.setExtendedState(n | 6);
                }
                return;
            }
        }

        private int calculateCorner(Window window, int n, int n2) {
            if (window == null) {
                return -1;
            }
            Insets insets = window.getInsets();
            int n3 = this.calculatePosition(n - insets.left, window.getWidth() - insets.left - insets.right);
            int n4 = this.calculatePosition(n2 - insets.top, window.getHeight() - insets.top - insets.bottom);
            if (n3 == -1 || n4 == -1) {
                return -1;
            }
            return n4 * 5 + n3;
        }

        private int getCursor(int n) {
            if (n == -1) {
                return 0;
            }
            return cursorMapping[n];
        }

        private int calculatePosition(int n, int n2) {
            if (n < 5) {
                return 0;
            }
            if (n < 16) {
                return 1;
            }
            if (n >= n2 - 5) {
                return 4;
            }
            if (n >= n2 - 16) {
                return 3;
            }
            return 2;
        }
    }

    private static class MetroRootLayout
    implements LayoutManager2 {
        private MetroRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getPreferredSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && jRootPane.getJMenuBar().isVisible() && (dimension2 = jRootPane.getJMenuBar().getPreferredSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof MetroRootPaneUI && (jComponent = ((MetroRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getPreferredSize()) != null) {
                n5 = dimension.width;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n5 + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getMinimumSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && jRootPane.getJMenuBar().isVisible() && (dimension2 = jRootPane.getJMenuBar().getMinimumSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof MetroRootPaneUI && (jComponent = ((MetroRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMinimumSize()) != null) {
                n5 = dimension.width;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n5 + insets.top + insets.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            int n;
            int n2;
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            Dimension dimension3;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MAX_VALUE;
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MAX_VALUE;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            if (jRootPane.getContentPane() != null && (dimension3 = jRootPane.getContentPane().getMaximumSize()) != null) {
                n3 = dimension3.width;
                n4 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && jRootPane.getJMenuBar().isVisible() && (dimension2 = jRootPane.getJMenuBar().getMaximumSize()) != null) {
                n5 = dimension2.width;
                n6 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof MetroRootPaneUI && (jComponent = ((MetroRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMaximumSize()) != null) {
                n7 = dimension.width;
                n8 = dimension.height;
            }
            if ((n2 = Math.max(Math.max(n4, n6), n8)) != Integer.MAX_VALUE) {
                n2 = n4 + n6 + n8 + insets.top + insets.bottom;
            }
            if ((n = Math.max(Math.max(n3, n5), n7)) != Integer.MAX_VALUE) {
                n += insets.left + insets.right;
            }
            return new Dimension(n, n2);
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension;
            Serializable serializable;
            JRootPane jRootPane = (JRootPane)container;
            Rectangle rectangle = jRootPane.getBounds();
            Insets insets = jRootPane.getInsets();
            int n = 0;
            int n2 = rectangle.width - insets.right - insets.left;
            int n3 = rectangle.height - insets.top - insets.bottom;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getGlassPane() != null) {
                jRootPane.getGlassPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof MetroRootPaneUI && (serializable = ((MetroRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = ((JComponent)serializable).getPreferredSize()) != null) {
                int n4 = dimension.height;
                ((Component)serializable).setBounds(0, 0, n2, n4);
                n += n4;
            }
            if (jRootPane.getJMenuBar() != null && jRootPane.getJMenuBar().isVisible()) {
                serializable = jRootPane.getJMenuBar().getPreferredSize();
                jRootPane.getJMenuBar().setBounds(0, n, n2, ((Dimension)serializable).height);
                n += ((Dimension)serializable).height;
            }
            if (jRootPane.getContentPane() != null) {
                jRootPane.getContentPane().setBounds(0, n, n2, n3 < n ? 0 : n3 - n);
            }
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }
    }
}

