/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.decoration;

import com.jgoodies.common.internal.RenderingUtils;
import com.jgoodies.looks.decoration.MetroRootPaneUI;
import com.jgoodies.looks.decoration.internal.MySwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class MetroTitlePane
extends JComponent {
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Color background;
    private Image systemIcon;
    private WindowListener windowListener;
    private Window window;
    private final JRootPane rootPane;
    private int state;

    public MetroTitlePane(JRootPane jRootPane, MetroRootPaneUI metroRootPaneUI) {
        this.rootPane = jRootPane;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int n = this.getWindowDecorationStyle();
        if (n == 1) {
            this.createActions();
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        this.setFont(new Font("Segoe UI", 0, 12));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu jMenu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(jMenu);
        }
        return jMenu;
    }

    private void addMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = jMenu.add(this.restoreAction);
        int n = -1;
        if (n != -1) {
            jMenuItem.setMnemonic(n);
        }
        jMenuItem = jMenu.add(this.iconifyAction);
        if (n != -1) {
            jMenuItem.setMnemonic(n);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jMenuItem = jMenu.add(this.maximizeAction);
            if (n != -1) {
                jMenuItem.setMnemonic(n);
            }
        }
        jMenu.add(new JSeparator());
        jMenuItem = jMenu.add(this.closeAction);
        if (n != -1) {
            jMenuItem.setMnemonic(n);
        }
    }

    private static JButton createTitleButton() {
        JButton jButton = new JButton();
        jButton.setFocusPainted(false);
        jButton.setFocusable(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(false);
        jButton.putClientProperty("ControlList.exclude", Boolean.TRUE);
        return jButton;
    }

    private void createButtons() {
        this.closeButton = MetroTitlePane.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(EMPTY_BORDER);
        this.closeButton.setIcon(MetroTitlePane.getIcon("close.inactive"));
        this.closeButton.setRolloverIcon(MetroTitlePane.getIcon("close.rollover"));
        this.closeButton.setPressedIcon(MetroTitlePane.getIcon("close.pressed"));
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton = MetroTitlePane.createTitleButton();
            this.iconifyButton.setAction(this.iconifyAction);
            this.iconifyButton.setText(null);
            this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
            this.iconifyButton.setBorder(EMPTY_BORDER);
            this.iconifyButton.setIcon(MetroTitlePane.getIcon("iconify.inactive"));
            this.iconifyButton.setRolloverIcon(MetroTitlePane.getIcon("iconify.rollover"));
            this.iconifyButton.setPressedIcon(MetroTitlePane.getIcon("iconify.pressed"));
            this.toggleButton = MetroTitlePane.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.setBorder(EMPTY_BORDER);
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean bl) {
        String string;
        Boolean bl2 = bl;
        this.closeButton.putClientProperty("paintActive", bl2);
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.putClientProperty("paintActive", bl2);
            this.toggleButton.putClientProperty("paintActive", bl2);
        }
        this.background = MetroTitlePane.getColor(bl ? "active.background" : "inactive.background");
        String string2 = string = bl ? ".active" : ".inactive";
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.setIcon(MetroTitlePane.getIcon("iconify" + string));
            boolean bl3 = (this.state & 6) != 0;
            String string3 = bl3 ? "restore" : "maximize";
            this.toggleButton.setIcon(MetroTitlePane.getIcon(string3 + string));
            this.toggleButton.setRolloverIcon(MetroTitlePane.getIcon(string3 + ".rollover"));
            this.toggleButton.setPressedIcon(MetroTitlePane.getIcon(string3 + ".pressed"));
        }
        this.closeButton.setIcon(MetroTitlePane.getIcon("close" + string));
        this.getRootPane().repaint();
    }

    private void setState(int n) {
        this.setState(n, false);
    }

    private void setState(int n, boolean bl) {
        Window window = this.getWindow();
        if (window != null && this.getWindowDecorationStyle() == 1) {
            boolean bl2;
            if (this.state == n && !bl) {
                return;
            }
            Frame frame = this.getFrame();
            boolean bl3 = bl2 = frame != null && frame.isActive();
            if (frame != null) {
                JRootPane jRootPane = this.getRootPane();
                if ((n & 6) != 0) {
                    MetroRootPaneUI.installMaximizedBorder(jRootPane);
                } else if ((n & 6) == 0) {
                    MetroRootPaneUI.installDefaultBorder(jRootPane);
                }
                if (frame.isResizable()) {
                    if ((n & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, bl2, true);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, bl2, false);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = n;
        }
    }

    private void updateToggleButton(Action action, boolean bl, boolean bl2) {
        this.toggleButton.setAction(action);
        this.toggleButton.setText(null);
        String string = bl ? ".active" : ".inactive";
        String string2 = bl2 ? "restore" : "maximize";
        this.toggleButton.setIcon(MetroTitlePane.getIcon(string2 + string));
        this.toggleButton.setRolloverIcon(MetroTitlePane.getIcon(string2 + ".rollover"));
        this.toggleButton.setPressedIcon(MetroTitlePane.getIcon(string2 + ".pressed"));
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return null;
    }

    private static Color getColor(String string) {
        return null;
    }

    private static Icon getIcon(String string) {
        return null;
    }

    private static String getString(String string) {
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Object object;
        String string;
        int n;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane jRootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean bl = window == null ? jRootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        boolean bl2 = window != null && window.isActive();
        Color color = bl2 ? Color.BLACK : new Color(128, 128, 128);
        graphics.setColor(this.background);
        graphics.fillRect(0, 0, n2, n3);
        int n4 = n = bl ? 12 : n2 - 12;
        if (this.getWindowDecorationStyle() == 1) {
            n += bl ? 0 : 0;
        }
        if ((string = this.getTitle()) != null) {
            object = jRootPane.getFontMetrics(graphics.getFont());
            graphics.setColor(color);
            int n5 = (n3 - ((FontMetrics)object).getHeight()) / 2 + ((FontMetrics)object).getAscent();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rectangle = this.iconifyButton.getBounds();
            }
            if (bl) {
                if (rectangle.x == 0 && null != window) {
                    rectangle.x = window.getWidth() - window.getInsets().right - 2;
                }
                int n6 = rectangle.x - n - 4;
                string = MySwingUtilities2.clipStringIfNecessary(jRootPane, (FontMetrics)object, string, n6);
            } else {
                int n7 = n - rectangle.x - rectangle.width - 4;
                string = MySwingUtilities2.clipStringIfNecessary(jRootPane, (FontMetrics)object, string, n7);
                n -= MySwingUtilities2.stringWidth(jRootPane, (FontMetrics)object, string);
            }
            int n8 = MySwingUtilities2.stringWidth(jRootPane, (FontMetrics)object, string);
            RenderingUtils.drawString(jRootPane, graphics, string, n, n5);
            n += bl ? n8 + 5 : -5;
        }
        if ((object = (String)jRootPane.getClientProperty("miniTitle")) == null) {
            return;
        }
        graphics.setFont(new Font("Segoe UI", 0, 10));
        FontMetrics fontMetrics = jRootPane.getFontMetrics(graphics.getFont());
        n = n2 - 165;
        int n9 = 6 + fontMetrics.getAscent();
        graphics.setColor(new Color(199, 80, 80));
        RenderingUtils.drawString(jRootPane, graphics, (String)object, n, n9);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            MetroTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            MetroTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("resizable".equals(string) || "state".equals(string)) {
                Frame frame = MetroTitlePane.this.getFrame();
                if (frame != null) {
                    MetroTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(string)) {
                    MetroTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(string)) {
                MetroTitlePane.this.repaint();
            } else if ("componentOrientation" == string) {
                MetroTitlePane.this.revalidate();
                MetroTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = this.computeHeight();
            return new Dimension(n, n);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private int computeHeight() {
            return 31;
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            boolean bl = MetroTitlePane.this.window == null ? MetroTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : MetroTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int n3 = MetroTitlePane.this.getWidth();
            int n4 = 0;
            int n5 = MetroTitlePane.this.iconifyButton != null && MetroTitlePane.this.iconifyButton.getIcon() != null ? MetroTitlePane.this.iconifyButton.getIcon().getIconWidth() : 16;
            int n6 = MetroTitlePane.this.toggleButton != null && MetroTitlePane.this.toggleButton.getIcon() != null ? MetroTitlePane.this.toggleButton.getIcon().getIconWidth() : 16;
            if (MetroTitlePane.this.closeButton != null && MetroTitlePane.this.closeButton.getIcon() != null) {
                n2 = MetroTitlePane.this.closeButton.getIcon().getIconHeight();
                n = MetroTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                n2 = 16;
                n = 16;
            }
            int n7 = bl ? n3 : 0;
            int n8 = 0;
            int n9 = n7 = bl ? n8 : n3 - n - n8;
            if (MetroTitlePane.this.menuBar != null) {
                MetroTitlePane.this.menuBar.setBounds(n7, n4, n, n2);
            }
            n7 = bl ? n3 : 0;
            n8 = 0;
            n7 += bl ? -n8 - n : n8;
            if (MetroTitlePane.this.closeButton != null) {
                MetroTitlePane.this.closeButton.setBounds(n7, n4, n, n2);
            }
            if (!bl) {
                n7 += n;
            }
            if (MetroTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && MetroTitlePane.this.toggleButton.getParent() != null) {
                    n8 = 0;
                    MetroTitlePane.this.toggleButton.setBounds(n7 += bl ? -n8 - n6 : n8, n4, n6, n2);
                    if (!bl) {
                        n7 += n6;
                    }
                }
                if (MetroTitlePane.this.iconifyButton != null && MetroTitlePane.this.iconifyButton.getParent() != null) {
                    n8 = 0;
                    MetroTitlePane.this.iconifyButton.setBounds(n7 += bl ? -n8 - n5 : n8, n4, n5, n2);
                    if (!bl) {
                        n7 += n5;
                    }
                }
            }
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (MetroTitlePane.this.systemIcon != null) {
                graphics.drawImage(MetroTitlePane.this.systemIcon, 0, 0, 16, 16, null);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(16, dimension.width), Math.max(dimension.height, 16));
        }
    }

    private final class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", MetroTitlePane.this.getLocale()));
            this.putValue("ShortDescription", MetroTitlePane.getString("maximize.Action.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetroTitlePane.this.maximize();
        }
    }

    private final class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", MetroTitlePane.this.getLocale()));
            this.putValue("ShortDescription", MetroTitlePane.getString("restore.Action.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetroTitlePane.this.restore();
        }
    }

    private final class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", MetroTitlePane.this.getLocale()));
            this.putValue("ShortDescription", MetroTitlePane.getString("iconify.Action.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetroTitlePane.this.iconify();
        }
    }

    private final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", MetroTitlePane.this.getLocale()));
            this.putValue("ShortDescription", MetroTitlePane.getString("close.Action.shortDescription"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetroTitlePane.this.close();
        }
    }
}

