/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.text.JTextComponent;

final class PlasticBorders {
    private static Border comboBoxEditorBorder;
    private static Border comboBoxArrowButtonBorder;
    private static Border etchedBorder;
    private static Border flush3DBorder;
    private static Border menuBarHeaderBorder;
    private static Border menuBorder;
    private static Border menuItemBorder;
    private static Border popupMenuBorder;
    private static Border noMarginPopupMenuBorder;
    private static Border rolloverButtonBorder;
    private static Border scrollPaneBorder;
    private static Border separatorBorder;
    private static Border textFieldBorder;
    private static Border thinLoweredBorder;
    private static Border thinRaisedBorder;
    private static Border toolBarHeaderBorder;

    private PlasticBorders() {
    }

    static Border getButtonBorder(Insets insets) {
        return new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(insets), new BasicBorders.MarginBorder());
    }

    static Border getComboBoxArrowButtonBorder() {
        if (comboBoxArrowButtonBorder == null) {
            comboBoxArrowButtonBorder = new CompoundBorder(new ComboBoxArrowButtonBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxArrowButtonBorder;
    }

    static Border getComboBoxEditorBorder() {
        if (comboBoxEditorBorder == null) {
            comboBoxEditorBorder = new CompoundBorder(new ComboBoxEditorBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxEditorBorder;
    }

    static Border getEtchedBorder() {
        if (etchedBorder == null) {
            etchedBorder = new BorderUIResource.CompoundBorderUIResource(new EtchedBorder(), new BasicBorders.MarginBorder());
        }
        return etchedBorder;
    }

    static Border getFlush3DBorder() {
        if (flush3DBorder == null) {
            flush3DBorder = new Flush3DBorder();
        }
        return flush3DBorder;
    }

    static Border getInternalFrameBorder() {
        return new InternalFrameBorder();
    }

    static Border getMenuBarHeaderBorder() {
        if (menuBarHeaderBorder == null) {
            menuBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBarHeaderBorder(), new BasicBorders.MarginBorder());
        }
        return menuBarHeaderBorder;
    }

    static Border getMenuBorder() {
        if (menuBorder == null) {
            menuBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBorder(), new BasicBorders.MarginBorder());
        }
        return menuBorder;
    }

    static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new BorderUIResource(new BasicBorders.MarginBorder());
        }
        return menuItemBorder;
    }

    static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder();
        }
        return popupMenuBorder;
    }

    static Border getNoMarginPopupMenuBorder() {
        if (noMarginPopupMenuBorder == null) {
            noMarginPopupMenuBorder = new NoMarginPopupMenuBorder();
        }
        return noMarginPopupMenuBorder;
    }

    static Border getPaletteBorder() {
        return new PaletteBorder();
    }

    static Border getRolloverButtonBorder() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new CompoundBorder(new RolloverButtonBorder(), new RolloverMarginBorder());
        }
        return rolloverButtonBorder;
    }

    static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    static Border getSeparatorBorder() {
        if (separatorBorder == null) {
            separatorBorder = new BorderUIResource.CompoundBorderUIResource(new SeparatorBorder(), new BasicBorders.MarginBorder());
        }
        return separatorBorder;
    }

    static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    static Border getThinLoweredBorder() {
        if (thinLoweredBorder == null) {
            thinLoweredBorder = new ThinLoweredBorder();
        }
        return thinLoweredBorder;
    }

    static Border getThinRaisedBorder() {
        if (thinRaisedBorder == null) {
            thinRaisedBorder = new ThinRaisedBorder();
        }
        return thinRaisedBorder;
    }

    static Border getToggleButtonBorder(Insets insets) {
        return new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(insets), new BasicBorders.MarginBorder());
    }

    static Border getToolBarHeaderBorder() {
        if (toolBarHeaderBorder == null) {
            toolBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new ToolBarHeaderBorder(), new BasicBorders.MarginBorder());
        }
        return toolBarHeaderBorder;
    }

    private static final class ToggleButtonBorder
    extends ButtonBorder {
        private ToggleButtonBorder(Insets insets) {
            super(insets);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                PlasticUtils.drawDisabledBorder(graphics, n, n2, n3 - 1, n4 - 1);
                return;
            }
            boolean bl2 = bl = buttonModel.isPressed() && buttonModel.isArmed();
            if (bl) {
                PlasticUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else if (buttonModel.isSelected()) {
                PlasticUtils.drawDark3DBorder(graphics, n, n2, n3, n4);
            } else {
                PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    private static final class TextFieldBorder
    extends Flush3DBorder {
        private TextFieldBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(component instanceof JTextComponent)) {
                if (component.isEnabled()) {
                    PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
                } else {
                    PlasticUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
                }
                return;
            }
            if (component.isEnabled() && ((JTextComponent)component).isEditable()) {
                PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            } else {
                PlasticUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    private static final class ScrollPaneBorder
    extends MetalBorders.ScrollPaneBorder {
        private ScrollPaneBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 2, n4 - 2);
            graphics.setColor(PlasticLookAndFeel.getControlHighlight());
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }
    }

    static final class RolloverMarginBorder
    extends EmptyBorder {
        RolloverMarginBorder() {
            super(1, 1, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }
    }

    private static final class RolloverButtonBorder
    extends ButtonBorder {
        private RolloverButtonBorder() {
            super(new Insets(3, 3, 3, 3));
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!(component instanceof JToggleButton)) {
                if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed())) {
                    super.paintBorder(component, graphics, n, n2, n3, n4);
                }
                return;
            }
            if (buttonModel.isRollover()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    PlasticUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
                } else {
                    PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
                }
            } else if (buttonModel.isSelected()) {
                PlasticUtils.drawDark3DBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    private static final class NoMarginPopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private NoMarginPopupMenuBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(3, 3, 3, 3);

        private PopupMenuBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(PlasticLookAndFeel.getMenuItemBackground());
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
            graphics.drawRect(2, 2, n3 - 5, n4 - 5);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class MenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private MenuBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            if (buttonModel.isArmed() || buttonModel.isSelected()) {
                graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
                graphics.drawLine(0, 0, n3 - 2, 0);
                graphics.drawLine(0, 0, 0, n4 - 1);
                graphics.setColor(PlasticLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            } else if (buttonModel.isRollover()) {
                graphics.translate(n, n2);
                PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
                graphics.translate(-n, -n2);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = MenuBorder.INSETS.top;
            insets.left = MenuBorder.INSETS.left;
            insets.bottom = MenuBorder.INSETS.bottom;
            insets.right = MenuBorder.INSETS.right;
            return insets;
        }
    }

    private static final class ToolBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 2, 2, 2);

        private ToolBarHeaderBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            PlasticUtils.drawThinPressed3DBorder(graphics, n, n2 - 1, n3, n4 + 1);
            PlasticUtils.drawThinFlush3DBorder(graphics, n + 1, n2, n3 - 2, n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class MenuBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 1, 2);

        private MenuBarHeaderBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            PlasticUtils.drawThinPressed3DBorder(graphics, n, n2, n3, n4 + 1);
            PlasticUtils.drawThinFlush3DBorder(graphics, n + 1, n2 + 1, n3 - 2, n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class EtchedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private EtchedBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            PlasticUtils.drawThinPressed3DBorder(graphics, n, n2, n3, n4);
            PlasticUtils.drawThinFlush3DBorder(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class ThinLoweredBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private ThinLoweredBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            PlasticUtils.drawThinPressed3DBorder(graphics, n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class ThinRaisedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private ThinRaisedBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            PlasticUtils.drawThinFlush3DBorder(graphics, n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class SeparatorBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(0, 0, 2, 1);

        private SeparatorBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(UIManager.getColor("Separator.foreground"));
            graphics.drawLine(0, n4 - 2, n3 - 1, n4 - 2);
            graphics.setColor(UIManager.getColor("Separator.background"));
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private PaletteBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets NORMAL_INSETS = new Insets(1, 1, 1, 1);
        private static final Insets MAXIMIZED_INSETS = new Insets(1, 1, 0, 0);

        private InternalFrameBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JInternalFrame jInternalFrame = (JInternalFrame)component;
            if (jInternalFrame.isMaximum()) {
                InternalFrameBorder.paintMaximizedBorder(graphics, n, n2, n3, n4);
            } else {
                PlasticUtils.drawThinFlush3DBorder(graphics, n, n2, n3, n4);
            }
        }

        private static void paintMaximizedBorder(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(PlasticLookAndFeel.getControlHighlight());
            graphics.drawLine(0, 0, n3 - 2, 0);
            graphics.drawLine(0, 0, 0, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return ((JInternalFrame)component).isMaximum() ? MAXIMIZED_INSETS : NORMAL_INSETS;
        }
    }

    private static final class ComboBoxEditorBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(2, 2, 2, 0);

        private ComboBoxEditorBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!component.isEnabled()) {
                PlasticUtils.drawDisabledBorder(graphics, n, n2, n3 + 2, n4 - 1);
                graphics.setColor(UIManager.getColor("control"));
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
                return;
            }
            PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3 + 2, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class ComboBoxArrowButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = new Insets(1, 1, 1, 1);

        private ComboBoxArrowButtonBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl;
            PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)component;
            ButtonModel buttonModel = plasticComboBoxButton.getModel();
            if (!buttonModel.isEnabled()) {
                PlasticUtils.drawDisabledBorder(graphics, n, n2, n3 - 1, n4 - 1);
                return;
            }
            boolean bl2 = bl = buttonModel.isPressed() && buttonModel.isArmed();
            if (bl) {
                PlasticUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else {
                PlasticUtils.drawButtonBorder(graphics, n, n2, n3, n4, false);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected final Insets insets;

        protected ButtonBorder(Insets insets) {
            this.insets = insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                PlasticUtils.drawDisabledBorder(graphics, n, n2, n3 - 1, n4 - 1);
                return;
            }
            boolean bl2 = buttonModel.isPressed() && buttonModel.isArmed();
            boolean bl3 = bl = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
            if (bl2 && bl) {
                PlasticUtils.drawPressedDefaultButtonBorder(graphics, n, n2, n3, n4);
            } else if (bl2) {
                PlasticUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else if (bl) {
                PlasticUtils.drawDefaultButtonBorder(graphics, n, n2, n3, n4, false);
            } else {
                PlasticUtils.drawButtonBorder(graphics, n, n2, n3, n4, false);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.insets.top;
            insets.left = this.insets.left;
            insets.bottom = this.insets.bottom;
            insets.right = this.insets.right;
            return insets;
        }
    }

    private static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private Flush3DBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component.isEnabled()) {
                PlasticUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            } else {
                PlasticUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = Flush3DBorder.INSETS.top;
            insets.left = Flush3DBorder.INSETS.left;
            insets.bottom = Flush3DBorder.INSETS.bottom;
            insets.right = Flush3DBorder.INSETS.right;
            return insets;
        }
    }
}

