/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

final class PlasticBumps
implements Icon {
    private static final List<BumpBuffer> BUFFERS = new ArrayList<BumpBuffer>();
    private int xBumps;
    private int yBumps;
    private Color topColor;
    private Color shadowColor;
    private Color backColor;
    private BumpBuffer buffer;

    PlasticBumps(int n, int n2, Color color, Color color2, Color color3) {
        this.setBumpArea(n, n2);
        this.setBumpColors(color, color2, color3);
    }

    void setBumpArea(int n, int n2) {
        this.xBumps = n / 2;
        this.yBumps = n2 / 2;
    }

    void setBumpColors(Color color, Color color2, Color color3) {
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = graphics instanceof Graphics2D ? ((Graphics2D)graphics).getDeviceConfiguration() : null;
        this.buffer = this.getBuffer(graphicsConfiguration, this.topColor, this.shadowColor, this.backColor);
        int n3 = BumpBuffer.getImageSize().width;
        int n4 = BumpBuffer.getImageSize().height;
        int n5 = this.getIconWidth();
        int n6 = this.getIconHeight();
        int n7 = n + n5;
        int n8 = n2 + n6;
        int n9 = n;
        while (n2 < n8) {
            int n10 = Math.min(n8 - n2, n4);
            for (n = n9; n < n7; n += n3) {
                int n11 = Math.min(n7 - n, n3);
                graphics.drawImage(this.buffer.getImage(), n, n2, n + n11, n2 + n10, 0, 0, n11, n10, null);
            }
            n2 += n4;
        }
    }

    @Override
    public int getIconWidth() {
        return this.xBumps * 2;
    }

    @Override
    public int getIconHeight() {
        return this.yBumps * 2;
    }

    private BumpBuffer getBuffer(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        if (this.buffer != null && this.buffer.hasSameConfiguration(graphicsConfiguration, color, color2, color3)) {
            return this.buffer;
        }
        BumpBuffer bumpBuffer = null;
        for (BumpBuffer bumpBuffer2 : BUFFERS) {
            BumpBuffer bumpBuffer3 = bumpBuffer2;
            if (!bumpBuffer3.hasSameConfiguration(graphicsConfiguration, color, color2, color3)) continue;
            bumpBuffer = bumpBuffer3;
            break;
        }
        if (bumpBuffer == null) {
            bumpBuffer = new BumpBuffer(graphicsConfiguration, this.topColor, this.shadowColor, this.backColor);
            BUFFERS.add(bumpBuffer);
        }
        return bumpBuffer;
    }

    private static final class BumpBuffer {
        private static final int IMAGE_SIZE = 64;
        private static Dimension imageSize = new Dimension(64, 64);
        transient Image image;
        private final Color topColor;
        private final Color shadowColor;
        private final Color backColor;
        private final GraphicsConfiguration gc;

        BumpBuffer(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
            this.gc = graphicsConfiguration;
            this.topColor = color;
            this.shadowColor = color2;
            this.backColor = color3;
            this.createImage();
            this.fillBumpBuffer();
        }

        boolean hasSameConfiguration(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
            if (this.gc != null ? !this.gc.equals(graphicsConfiguration) : graphicsConfiguration != null) {
                return false;
            }
            return this.topColor.equals(color) && this.shadowColor.equals(color2) && this.backColor.equals(color3);
        }

        Image getImage() {
            return this.image;
        }

        static Dimension getImageSize() {
            return imageSize;
        }

        private void fillBumpBuffer() {
            int n;
            int n2;
            Graphics graphics = this.image.getGraphics();
            graphics.setColor(this.backColor);
            graphics.fillRect(0, 0, 64, 64);
            graphics.setColor(this.topColor);
            for (n2 = 0; n2 < 64; n2 += 4) {
                for (n = 0; n < 64; n += 4) {
                    graphics.drawLine(n2, n, n2, n);
                    graphics.drawLine(n2 + 2, n + 2, n2 + 2, n + 2);
                }
            }
            graphics.setColor(this.shadowColor);
            for (n2 = 0; n2 < 64; n2 += 4) {
                for (n = 0; n < 64; n += 4) {
                    graphics.drawLine(n2 + 1, n + 1, n2 + 1, n + 1);
                    graphics.drawLine(n2 + 3, n + 3, n2 + 3, n + 3);
                }
            }
            graphics.dispose();
        }

        private void createImage() {
            if (this.gc != null) {
                this.image = this.gc.createCompatibleImage(64, 64);
            } else {
                int[] nArray = new int[]{this.backColor.getRGB(), this.topColor.getRGB(), this.shadowColor.getRGB()};
                IndexColorModel indexColorModel = new IndexColorModel(8, 3, nArray, 0, false, -1, 0);
                this.image = new BufferedImage(64, 64, 13, indexColorModel);
            }
        }
    }
}

