/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticComboBoxUI;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class PlasticComboBoxButton<E>
extends JButton {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Border EMPTY_BORDER = new EmptyBorder(EMPTY_INSETS);
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private final JList<E> listBox;
    private final CellRendererPane rendererPane;
    private JComboBox<E> comboBox;
    private Icon comboIcon;
    private boolean iconOnly = false;
    private final boolean borderPaintsFocus;
    private final Insets focusInsets;

    public PlasticComboBoxButton(JComboBox<E> jComboBox, Icon icon, boolean bl, CellRendererPane cellRendererPane, JList<E> jList) {
        super("");
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean bl) {
                super.setArmed(this.isPressed() || bl);
            }
        });
        this.comboBox = jComboBox;
        this.comboIcon = icon;
        this.iconOnly = bl;
        this.rendererPane = cellRendererPane;
        this.listBox = jList;
        this.setEnabled(jComboBox.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(jComboBox.isEnabled());
        this.setBorder(UIManager.getBorder("ComboBox.arrowButtonBorder"));
        this.setMargin(new Insets(0, 2, 0, 2));
        this.borderPaintsFocus = UIManager.getBoolean("ComboBox.borderPaintsFocus");
        this.focusInsets = UIManager.getInsets("ComboBox.focusInsets");
    }

    public final JComboBox<E> getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox<E> jComboBox) {
        this.comboBox = jComboBox;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon icon) {
        this.comboIcon = icon;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean bl) {
        this.iconOnly = bl;
    }

    @Override
    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    @Override
    public final boolean isFocusTraversable() {
        return false;
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        super.paintComponent(graphics);
        boolean bl = PlasticUtils.isLeftToRight(this.comboBox);
        Insets insets = this.getInsets();
        int n6 = this.getWidth() - (insets.left + insets.right);
        int n7 = this.getHeight() - (insets.top + insets.bottom);
        if (n7 <= 0 || n6 <= 0) {
            return;
        }
        int n8 = insets.left;
        int n9 = insets.top;
        int n10 = n8 + n6 - 1;
        int n11 = 0;
        int n12 = n5 = bl ? n10 : n8;
        if (this.comboIcon != null) {
            n11 = this.comboIcon.getIconWidth();
            n4 = this.comboIcon.getIconHeight();
            if (this.iconOnly) {
                n5 = (this.getWidth() - n11) / 2;
                n3 = (this.getHeight() - n4) / 2;
            } else {
                n5 = bl ? n8 + n6 - 1 - n11 : n8;
                n3 = (this.getHeight() - n4) / 2;
            }
            this.comboIcon.paintIcon(this, graphics, n5, n3);
        }
        if (!this.iconOnly && this.comboBox != null) {
            Serializable serializable;
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            n3 = this.getModel().isPressed();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, n3 != 0, false);
            n2 = bl ? n8 : n8 + n11;
            n = n9;
            int n13 = this.getWidth() - n8 - PlasticComboBoxUI.getEditableButtonWidth();
            int n14 = n7;
            Border border = null;
            if (component instanceof JComponent && !this.isTableCellEditor()) {
                JComponent jComponent = (JComponent)component;
                if (component instanceof BasicComboBoxRenderer.UIResource) {
                    border = jComponent.getBorder();
                    jComponent.setBorder(EMPTY_BORDER);
                }
                serializable = jComponent.getInsets();
                Insets insets2 = UIManager.getInsets("ComboBox.editorInsets");
                int n15 = Math.max(0, insets2.top - ((Insets)serializable).top);
                int n16 = Math.max(0, insets2.bottom - ((Insets)serializable).bottom);
                n += n15;
                n14 -= n15 + n16;
            }
            component.setFont(this.rendererPane.getFont());
            this.configureColors(component);
            boolean bl2 = component instanceof JPanel;
            if (!(PlasticComboBoxButton.is3D() && component instanceof JComponent && component.isOpaque())) {
                this.rendererPane.paintComponent(graphics, component, this, n2, n, n13, n14, bl2);
            } else {
                serializable = (JComponent)component;
                boolean bl3 = ((JComponent)serializable).isOpaque();
                ((JComponent)serializable).setOpaque(false);
                this.rendererPane.paintComponent(graphics, component, this, n2, n, n13, n14, bl2);
                ((JComponent)serializable).setOpaque(bl3);
            }
            if (border != null) {
                ((JComponent)component).setBorder(border);
            }
        }
        if (this.comboIcon != null) {
            n4 = this.comboBox.hasFocus() ? 1 : 0;
            if (!this.borderPaintsFocus && n4 != 0) {
                graphics.setColor(PlasticLookAndFeel.getFocusColor());
                n3 = this.focusInsets.left;
                int n17 = this.focusInsets.top;
                n2 = this.getWidth() - n3 - this.focusInsets.left;
                n = this.getHeight() - n17 - this.focusInsets.bottom;
                BasicGraphicsUtils.drawDashedRect(graphics, n3, n17, n2, n);
            }
        }
    }

    protected void configureColors(Component component) {
        if (this.model.isArmed() && this.model.isPressed()) {
            if (this.isOpaque()) {
                component.setBackground(UIManager.getColor("Button.select"));
            }
            component.setForeground(this.comboBox.getForeground());
        } else if (!this.comboBox.isEnabled()) {
            if (this.isOpaque()) {
                component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            }
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        } else {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        }
    }

    private static boolean is3D() {
        return PlasticUtils.is3D("ComboBox.");
    }

    private boolean isTableCellEditor() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty("JComboBox.isTableCellEditor"));
    }
}

