/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticModernUtils;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

final class PlasticModernBorders {
    private static Border comboBoxArrowButtonBorder;
    private static Border comboBoxEditorBorder;
    private static Border scrollPaneBorder;
    private static Border textFieldBorder;
    private static Border spinnerBorder;
    private static Border rolloverButtonBorder;

    private PlasticModernBorders() {
    }

    static Border getButtonBorder(Insets insets) {
        return new BorderUIResource.CompoundBorderUIResource(new ModernButtonBorder(insets), new BasicBorders.MarginBorder());
    }

    static Border getComboBoxArrowButtonBorder() {
        if (comboBoxArrowButtonBorder == null) {
            comboBoxArrowButtonBorder = new CompoundBorder(new ModernComboBoxArrowButtonBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxArrowButtonBorder;
    }

    static Border getComboBoxEditorBorder() {
        if (comboBoxEditorBorder == null) {
            comboBoxEditorBorder = new CompoundBorder(new ModernComboBoxEditorBorder(), new BasicBorders.MarginBorder());
        }
        return comboBoxEditorBorder;
    }

    static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ModernScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new ModernTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    static Border getToggleButtonBorder(Insets insets) {
        return new BorderUIResource.CompoundBorderUIResource(new ModernButtonBorder(insets), new BasicBorders.MarginBorder());
    }

    static Border getSpinnerBorder() {
        if (spinnerBorder == null) {
            spinnerBorder = new ModernSpinnerBorder();
        }
        return spinnerBorder;
    }

    static Border getSpinnerButtonBorder() {
        return new ModernSpinnerButtonBorder();
    }

    static Border getRolloverButtonBorder() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new CompoundBorder(new ModernRolloverButtonBorder(), new PlasticBorders.RolloverMarginBorder());
        }
        return rolloverButtonBorder;
    }

    private static final class ModernRolloverButtonBorder
    extends ModernButtonBorder {
        private ModernRolloverButtonBorder() {
            super(new Insets(3, 3, 3, 3));
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!(component instanceof JToggleButton)) {
                if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed())) {
                    super.paintBorder(component, graphics, n, n2, n3, n4);
                }
                return;
            }
            if (buttonModel.isRollover()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    PlasticModernUtils.drawPressedButtonBorder(graphics, n, n2, n3, n4);
                } else {
                    PlasticModernUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
                }
            } else if (buttonModel.isSelected()) {
                PlasticModernUtils.drawPressedButtonBorder(graphics, n, n2, n3, n4);
            }
        }
    }

    static final class ModernSpinnerButtonBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ModernSpinnerButtonBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(component.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            graphics.fillRect(n, n2, 1, n4 - 1);
            graphics.fillRect(n + n3 - 1, n2, 1, n4 - 1);
            graphics.fillRect(n, n2 + n4 - 1, n3, 1);
            if ("Spinner.previousButton".equals(component.getName())) {
                graphics.setColor(PlasticLookAndFeel.getControl());
            }
            graphics.fillRect(n + 1, n2, n3 - 2, 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = ModernSpinnerButtonBorder.INSETS.top;
            insets.left = ModernSpinnerButtonBorder.INSETS.left;
            insets.bottom = ModernSpinnerButtonBorder.INSETS.bottom;
            insets.right = ModernSpinnerButtonBorder.INSETS.right;
            return insets;
        }
    }

    static final class ModernSpinnerBorder
    extends MetalBorders.ScrollPaneBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ModernSpinnerBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(component.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            int n5 = UIManager.getInt("ScrollBar.width") - 1;
            graphics.fillRect(n, n2, n3 -= n5, 1);
            graphics.fillRect(n, n2 + 1, 1, n4 - 1);
            graphics.fillRect(n + 1, n2 + n4 - 1, n3 - 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = ModernSpinnerBorder.INSETS.top;
            insets.left = ModernSpinnerBorder.INSETS.left;
            insets.bottom = ModernSpinnerBorder.INSETS.bottom;
            insets.right = ModernSpinnerBorder.INSETS.right;
            return insets;
        }
    }

    private static final class ModernScrollPaneBorder
    extends MetalBorders.ScrollPaneBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private ModernScrollPaneBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(component.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = ModernScrollPaneBorder.INSETS.top;
            insets.left = ModernScrollPaneBorder.INSETS.left;
            insets.bottom = ModernScrollPaneBorder.INSETS.bottom;
            insets.right = ModernScrollPaneBorder.INSETS.right;
            return insets;
        }
    }

    static final class ModernTextFieldBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ModernTextFieldBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = component.isEnabled() && (!(component instanceof JTextComponent) || ((JTextComponent)component).isEditable());
            graphics.setColor(bl ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = ModernTextFieldBorder.INSETS.top;
            insets.left = ModernTextFieldBorder.INSETS.left;
            insets.bottom = ModernTextFieldBorder.INSETS.bottom;
            insets.right = ModernTextFieldBorder.INSETS.right;
            return insets;
        }
    }

    static final class ModernComboBoxEditorBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 0);

        ModernComboBoxEditorBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(component.isEnabled() ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            PlasticUtils.drawRect(graphics, n, n2, n3 + 1, n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class ModernComboBoxArrowButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = new Insets(1, 1, 1, 1);

        private ModernComboBoxArrowButtonBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)component;
            ButtonModel buttonModel = plasticComboBoxButton.getModel();
            boolean bl = !buttonModel.isEnabled();
            boolean bl2 = buttonModel.isPressed() && buttonModel.isArmed();
            boolean bl3 = buttonModel.isRollover();
            if (bl) {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                PlasticUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
            } else if (bl2) {
                graphics.setColor(PlasticModernUtils.DARK_BLUE);
                PlasticUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
            } else if (bl3) {
                graphics.setColor(PlasticModernUtils.LIGHT_BLUE);
                PlasticUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
            } else {
                graphics.setColor(PlasticLookAndFeel.getControlDarkShadow());
                PlasticUtils.drawRect(graphics, n, n2, n3 - 1, n4 - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static class ModernButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected final Insets insets;

        protected ModernButtonBorder(Insets insets) {
            this.insets = insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl = !buttonModel.isEnabled();
            boolean bl2 = buttonModel.isSelected() || buttonModel.isPressed() && buttonModel.isArmed();
            boolean bl3 = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
            boolean bl4 = buttonModel.isRollover();
            if (bl) {
                PlasticModernUtils.drawDisabledButtonBorder(graphics, n, n2, n3, n4);
            } else if (bl2) {
                PlasticModernUtils.drawPressedButtonBorder(graphics, n, n2, n3, n4);
            } else if (bl3) {
                PlasticModernUtils.drawDefaultButtonBorder(graphics, n, n2, n3, n4);
            } else if (bl4) {
                PlasticModernUtils.drawRolloverButtonBorder(graphics, n, n2, n3, n4);
            } else {
                PlasticModernUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.insets.top;
            insets.left = this.insets.left;
            insets.bottom = this.insets.bottom;
            insets.right = this.insets.right;
            return insets;
        }
    }
}

