/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.common.base.SystemUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public final class PlasticModernIconFactory {
    private static CheckBoxIcon checkBoxIcon;
    private static RadioButtonIcon radioButtonIcon;
    private static ComboBoxButtonIcon comboBoxButtonIcon;

    private PlasticModernIconFactory() {
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    static Icon getComboBoxButtonIcon() {
        if (comboBoxButtonIcon == null) {
            comboBoxButtonIcon = new ComboBoxButtonIcon();
        }
        return comboBoxButtonIcon;
    }

    private static final class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = SystemUtils.IS_LOW_RESOLUTION ? 13 : 15;

        private RadioButtonIcon() {
        }

        @Override
        public int getIconWidth() {
            return SIZE;
        }

        @Override
        public int getIconHeight() {
            return SIZE;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            State state = State.valueOf(abstractButton.getModel());
            String string = state.radioKey();
            UIManager.getIcon(string).paintIcon(component, graphics, 0, 4);
        }
    }

    private static final class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = SystemUtils.IS_LOW_RESOLUTION ? 13 : 15;

        private CheckBoxIcon() {
        }

        @Override
        public int getIconWidth() {
            return SIZE;
        }

        @Override
        public int getIconHeight() {
            return SIZE;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JCheckBox jCheckBox = (JCheckBox)component;
            State state = State.valueOf(jCheckBox.getModel());
            String string = state.checkKey();
            UIManager.getIcon(string).paintIcon(component, graphics, 0, 4);
        }
    }

    private static final class ComboBoxButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private ComboBoxButtonIcon() {
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 4;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JComponent jComponent = (JComponent)component;
            String string = jComponent.isEnabled() ? "enabled" : "disabled";
            UIManager.getIcon("ComboBox.arrowIcon." + string).paintIcon(component, graphics, n - 1, n2);
        }
    }

    public static enum State {
        SELECTED_PLAIN("on-plain"),
        SELECTED_ROLLOVER("on-rollover"),
        SELECTED_PRESSED("on-pressed"),
        SELECTED_DISABLED("on-disabled"),
        DESELECTED_PLAIN("off-plain"),
        DESELECTED_ROLLOVER("off-rollover"),
        DESELECTED_PRESSED("off-pressed"),
        DESELECTED_DISABLED("off-disabled");

        private final String code;

        private State(String string2) {
            this.code = string2;
        }

        public String radioKey() {
            return this.uiKey("RadioButton");
        }

        public String checkKey() {
            return this.uiKey("CheckBox");
        }

        private String uiKey(String string) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(".icon.");
            stringBuilder.append(this.code);
            return stringBuilder.toString();
        }

        public String iconPath(String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder("icons/");
            stringBuilder.append(string);
            stringBuilder.append('/');
            stringBuilder.append(string2);
            stringBuilder.append('-');
            stringBuilder.append(this.code);
            stringBuilder.append(".png");
            return stringBuilder.toString();
        }

        static State valueOf(ButtonModel buttonModel) {
            if (!buttonModel.isEnabled()) {
                return buttonModel.isSelected() ? SELECTED_DISABLED : DESELECTED_DISABLED;
            }
            if (buttonModel.isArmed() && buttonModel.isPressed()) {
                return buttonModel.isSelected() ? SELECTED_PRESSED : DESELECTED_PRESSED;
            }
            if (buttonModel.isRollover()) {
                return buttonModel.isSelected() ? SELECTED_ROLLOVER : DESELECTED_ROLLOVER;
            }
            return buttonModel.isSelected() ? SELECTED_PLAIN : DESELECTED_PLAIN;
        }
    }
}

