/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.plastic.PlasticArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class PlasticSpinnerUI
extends BasicSpinnerUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticSpinnerUI();
    }

    @Override
    protected Component createPreviousButton() {
        Component component = this.createArrowButton(5);
        component.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(component);
        return component;
    }

    @Override
    protected Component createNextButton() {
        Component component = this.createArrowButton(1);
        component.setName("Spinner.nextButton");
        this.installNextButtonListeners(component);
        return component;
    }

    protected Component createArrowButton(int n) {
        JButton jButton = this.createArrowButton0(n);
        Border border = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (border instanceof UIResource) {
            jButton.setBorder(new CompoundBorder(border, null));
        } else {
            jButton.setBorder(border);
        }
        jButton.setInheritsPopupMenu(true);
        return jButton;
    }

    protected JButton createArrowButton0(int n) {
        return new SpinnerArrowButton(n);
    }

    @Override
    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    @Override
    protected JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        PlasticSpinnerUI.configureEditorBorder(jComponent);
        return jComponent;
    }

    @Override
    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        this.spinner.remove(jComponent);
        PlasticSpinnerUI.configureEditorBorder(jComponent2);
        this.spinner.add((Component)jComponent2, "Editor");
    }

    private static void configureEditorBorder(JComponent jComponent) {
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            jFormattedTextField.setBorder(new EmptyBorder(insets));
        } else if (jComponent instanceof JPanel && jComponent.getBorder() == null && jComponent.getComponentCount() > 0) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(0);
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            jComponent2.setBorder(new EmptyBorder(insets));
        }
    }

    private static final class SpinnerArrowButton
    extends PlasticArrowButton {
        private SpinnerArrowButton(int n) {
            super(n, UIManager.getInt("ScrollBar.width"), true);
        }

        @Override
        protected int calculateArrowHeight(int n, int n2) {
            int n3 = Math.min((n - 4) / 3, (n2 - 4) / 3);
            return Math.max(n3, 3);
        }

        @Override
        protected int calculateArrowOffset() {
            return 1;
        }

        @Override
        protected boolean isPaintingNorthBottom() {
            return true;
        }
    }
}

