/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicCaret;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public final class PlasticTextAreaUI
extends BasicTextAreaUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticTextAreaUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        PlasticTextAreaUI.updateBackground((JTextComponent)jComponent);
    }

    @Override
    protected Caret createCaret() {
        return new ExtBasicCaret();
    }

    @Override
    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("editable".equals(string) || "enabled".equals(string)) {
            PlasticTextAreaUI.updateBackground((JTextComponent)propertyChangeEvent.getSource());
        }
    }

    private static void updateBackground(JTextComponent jTextComponent) {
        Color color = jTextComponent.getBackground();
        if (!(color instanceof UIResource)) {
            return;
        }
        Color color2 = null;
        if (!jTextComponent.isEnabled()) {
            color2 = UIManager.getColor("TextArea.disabledBackground");
        }
        if (color2 == null && !jTextComponent.isEditable()) {
            color2 = UIManager.getColor("TextArea.inactiveBackground");
        }
        if (color2 == null) {
            color2 = UIManager.getColor("TextArea.background");
        }
        if (color2 != null && color2 != color) {
            jTextComponent.setBackground(color2);
        }
    }
}

