/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public class PlasticToolBarUI
extends MetalToolBarUI {
    private static final String PROPERTY_PREFIX = "ToolBar.";
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticToolBarUI();
    }

    @Override
    protected Border createRolloverBorder() {
        return PlasticBorders.getRolloverButtonBorder();
    }

    @Override
    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            super.setBorderToRollover(component);
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                super.setBorderToRollover(container.getComponent(i));
            }
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.listener = new BorderStyleListener();
        this.toolBar.addPropertyChangeListener(this.listener);
    }

    @Override
    protected void uninstallListeners() {
        this.toolBar.removePropertyChangeListener(this.listener);
        this.listener = null;
        super.uninstallListeners();
    }

    private void installSpecialBorder() {
        HeaderStyle headerStyle;
        BorderStyle borderStyle = BorderStyle.from(this.toolBar, "Plastic.borderStyle");
        String string = borderStyle != null ? borderStyle.getSuffix() : ((headerStyle = HeaderStyle.from(this.toolBar)) == HeaderStyle.BOTH ? "headerBorder" : (headerStyle == HeaderStyle.SINGLE && this.is3D() ? "etchedBorder" : "border"));
        LookAndFeel.installBorder(this.toolBar, PROPERTY_PREFIX + string);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            if (this.is3D()) {
                Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
                boolean bl = ((JToolBar)jComponent).getOrientation() == 0;
                PlasticUtils.addLight3DEffekt(graphics, rectangle, bl);
            }
        }
        this.paint(graphics, jComponent);
    }

    private boolean is3D() {
        return PlasticUtils.is3D(PROPERTY_PREFIX) && HeaderStyle.from(this.toolBar) != null && BorderStyle.from(this.toolBar, "Plastic.borderStyle") != BorderStyle.EMPTY;
    }

    private final class BorderStyleListener
    implements PropertyChangeListener {
        private BorderStyleListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("jgoodies.headerStyle") || string.equals("Plastic.borderStyle")) {
                PlasticToolBarUI.this.installSpecialBorder();
            }
        }
    }
}

