/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class PlasticXPUtils {
    private PlasticXPUtils() {
    }

    static void drawPlainButtonBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        PlasticXPUtils.drawButtonBorder(graphics, n, n2, n3, n4, PlasticLookAndFeel.getControl(), PlasticLookAndFeel.getControlDarkShadow(), LookUtils.getSlightlyBrighter(PlasticLookAndFeel.getControlDarkShadow(), 1.25f));
    }

    static void drawPressedButtonBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        PlasticXPUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
        Color color = PlasticXPUtils.translucentColor(PlasticLookAndFeel.getControlDarkShadow(), 128);
        Color color2 = PlasticXPUtils.translucentColor(PlasticLookAndFeel.getControlHighlight(), 80);
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.fillRect(2, 1, n3 - 4, 1);
        graphics.setColor(color2);
        graphics.fillRect(2, n4 - 2, n3 - 4, 1);
        graphics.translate(-n, -n2);
    }

    static void drawDefaultButtonBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        PlasticXPUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
        PlasticXPUtils.drawInnerButtonDecoration(graphics, n, n2, n3, n4, PlasticLookAndFeel.getPrimaryControlDarkShadow());
    }

    static void drawFocusedButtonBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        PlasticXPUtils.drawPlainButtonBorder(graphics, n, n2, n3, n4);
        PlasticXPUtils.drawInnerButtonDecoration(graphics, n, n2, n3, n4, PlasticLookAndFeel.getFocusColor());
    }

    static void drawDisabledButtonBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        PlasticXPUtils.drawButtonBorder(graphics, n, n2, n3, n4, PlasticLookAndFeel.getControl(), MetalLookAndFeel.getControlShadow(), LookUtils.getSlightlyBrighter(MetalLookAndFeel.getControlShadow()));
    }

    private static void drawButtonBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3) {
        graphics.translate(n, n2);
        graphics.setColor(color2);
        PlasticUtils.drawRect(graphics, 0, 0, n3 - 1, n4 - 1);
        graphics.setColor(color3);
        graphics.fillRect(0, 0, 2, 2);
        graphics.fillRect(0, n4 - 2, 2, 2);
        graphics.fillRect(n3 - 2, 0, 2, 2);
        graphics.fillRect(n3 - 2, n4 - 2, 2, 2);
        graphics.setColor(color);
        graphics.fillRect(0, 0, 1, 1);
        graphics.fillRect(0, n4 - 1, 1, 1);
        graphics.fillRect(n3 - 1, 0, 1, 1);
        graphics.fillRect(n3 - 1, n4 - 1, 1, 1);
        graphics.translate(-n, -n2);
    }

    static void drawInnerButtonDecoration(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        Color color2 = PlasticXPUtils.translucentColor(color, 90);
        Color color3 = PlasticXPUtils.translucentColor(color, 120);
        Color color4 = PlasticXPUtils.translucentColor(color, 200);
        graphics.translate(n, n2);
        graphics.setColor(color2);
        graphics.fillRect(2, 1, n3 - 4, 1);
        graphics.setColor(color3);
        graphics.fillRect(1, 2, 1, n4 - 4);
        graphics.fillRect(n3 - 2, 2, 1, n4 - 4);
        PlasticUtils.drawRect(graphics, 2, 2, n3 - 5, n4 - 5);
        graphics.setColor(color4);
        graphics.fillRect(2, n4 - 2, n3 - 4, 1);
        graphics.translate(-n, -n2);
    }

    private static Color translucentColor(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }
}

