/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.windows.WindowsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;

final class WindowsBorders {
    private static Border menuBorder;
    private static Border xpMenuBorder;
    private static Border menuItemBorder;
    private static Border popupMenuBorder;
    private static Border noMarginPopupMenuBorder;
    private static Border separatorBorder;
    private static Border etchedBorder;
    private static Border menuBarHeaderBorder;
    private static Border toolBarHeaderBorder;
    private static Border rolloverButtonBorder;

    private WindowsBorders() {
    }

    public static Border getButtonBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ButtonBorder buttonBorder = new ButtonBorder(uIDefaults.getColor("Button.shadow"), uIDefaults.getColor("Button.darkShadow"), uIDefaults.getColor("Button.light"), uIDefaults.getColor("Button.highlight"), uIDefaults.getColor("controlText"));
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(buttonBorder, new BasicBorders.MarginBorder());
        return compoundBorderUIResource;
    }

    static Border getMenuBorder() {
        if (menuBorder == null) {
            menuBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBorder(), new BasicBorders.MarginBorder());
        }
        return menuBorder;
    }

    static Border getXPMenuBorder() {
        if (xpMenuBorder == null) {
            xpMenuBorder = new BasicBorders.MarginBorder();
        }
        return xpMenuBorder;
    }

    static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new BorderUIResource(new BasicBorders.MarginBorder());
        }
        return menuItemBorder;
    }

    static Border getSeparatorBorder() {
        if (separatorBorder == null) {
            separatorBorder = new BorderUIResource.CompoundBorderUIResource(new SeparatorBorder(), new BasicBorders.MarginBorder());
        }
        return separatorBorder;
    }

    static Border getEtchedBorder() {
        if (etchedBorder == null) {
            etchedBorder = new BorderUIResource.CompoundBorderUIResource(new EtchedBorder(), new BasicBorders.MarginBorder());
        }
        return etchedBorder;
    }

    static Border getMenuBarHeaderBorder() {
        if (menuBarHeaderBorder == null) {
            menuBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new MenuBarHeaderBorder(), new BasicBorders.MarginBorder());
        }
        return menuBarHeaderBorder;
    }

    static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new PopupMenuBorder();
        }
        return popupMenuBorder;
    }

    static Border getNoMarginPopupMenuBorder() {
        if (noMarginPopupMenuBorder == null) {
            noMarginPopupMenuBorder = new NoMarginPopupMenuBorder();
        }
        return noMarginPopupMenuBorder;
    }

    static Border getToolBarHeaderBorder() {
        if (toolBarHeaderBorder == null) {
            toolBarHeaderBorder = new BorderUIResource.CompoundBorderUIResource(new ToolBarHeaderBorder(), new BasicBorders.MarginBorder());
        }
        return toolBarHeaderBorder;
    }

    static Border getRolloverButtonBorder() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new CompoundBorder(new RolloverButtonBorder(), new RolloverMarginBorder());
        }
        return rolloverButtonBorder;
    }

    private static void drawBezel(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, Color color, Color color2, Color color3, Color color4, Color color5) {
        Color color6 = graphics.getColor();
        graphics.translate(n, n2);
        if (bl && bl2) {
            graphics.setColor(color2);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(color);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
        } else if (bl) {
            BasicGraphicsUtils.drawLoweredBezel(graphics, n, n2, n3, n4, color, color2, color3, color4);
        } else if (bl2) {
            graphics.setColor(color5);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(color4);
            graphics.drawLine(1, 1, 1, n4 - 3);
            graphics.drawLine(2, 1, n3 - 3, 1);
            graphics.setColor(color3);
            graphics.drawLine(2, 2, 2, n4 - 4);
            graphics.drawLine(3, 2, n3 - 4, 2);
            graphics.setColor(color);
            graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
            graphics.drawLine(n3 - 3, 2, n3 - 3, n4 - 4);
            graphics.setColor(color2);
            graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
            graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
        } else {
            graphics.setColor(color4);
            graphics.drawLine(0, 0, 0, n4 - 1);
            graphics.drawLine(1, 0, n3 - 2, 0);
            graphics.setColor(color3);
            graphics.drawLine(1, 1, 1, n4 - 3);
            graphics.drawLine(2, 1, n3 - 3, 1);
            graphics.setColor(color);
            graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
            graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 3);
            graphics.setColor(color2);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, 0);
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color6);
    }

    private static final class MenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private MenuBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isSelected()) {
                WindowsUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else if (buttonModel.isRollover()) {
                WindowsUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class ToolBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 2, 2, 2);

        private ToolBarHeaderBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WindowsUtils.drawPressed3DBorder(graphics, n, n2 - 1, n3, n4 + 1);
            WindowsUtils.drawFlush3DBorder(graphics, n + 1, n2, n3 - 2, n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class NoMarginPopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private NoMarginPopupMenuBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(3, 3, 3, 3);

        private PopupMenuBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.setColor(UIManager.getColor("MenuItem.background"));
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
            graphics.drawRect(2, 2, n3 - 5, n4 - 5);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class MenuBarHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 1, 2);

        private MenuBarHeaderBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WindowsUtils.drawPressed3DBorder(graphics, n, n2, n3, n4 + 1);
            WindowsUtils.drawFlush3DBorder(graphics, n + 1, n2 + 1, n3 - 2, n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class EtchedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private EtchedBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WindowsUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            WindowsUtils.drawFlush3DBorder(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    static final class ThinLoweredBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ThinLoweredBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WindowsUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    static final class ThinRaisedBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        ThinRaisedBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WindowsUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class SeparatorBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(0, 3, 2, 1);

        private SeparatorBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(UIManager.getColor("Separator.foreground"));
            graphics.drawLine(0, n4 - 2, n3 - 1, n4 - 2);
            graphics.setColor(UIManager.getColor("Separator.background"));
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class RolloverMarginBorder
    extends EmptyBorder {
        private RolloverMarginBorder() {
            super(1, 1, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }
    }

    private static final class RolloverButtonBorder
    extends AbstractButtonBorder {
        private RolloverButtonBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!(component instanceof JToggleButton)) {
                if (buttonModel.isRollover()) {
                    super.paintBorder(component, graphics, n, n2, n3, n4);
                }
                return;
            }
            if (buttonModel.isSelected()) {
                WindowsUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else if (buttonModel.isRollover()) {
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    private static abstract class AbstractButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private AbstractButtonBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isPressed()) {
                WindowsUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
            } else {
                WindowsUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return INSETS;
        }
    }

    private static final class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
        private final Color shadow;
        private final Color darkShadow;
        private final Color highlight;
        private final Color lightHighlight;
        private final Color defaultColor;

        public ButtonBorder(Color color, Color color2, Color color3, Color color4, Color color5) {
            this.shadow = color;
            this.darkShadow = color2;
            this.highlight = color3;
            this.lightHighlight = color4;
            this.defaultColor = color5;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = false;
            boolean bl2 = false;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                boolean bl3 = bl = buttonModel.isPressed() && buttonModel.isArmed();
                if (component instanceof JButton) {
                    bl2 = ((JButton)component).isDefaultButton();
                }
            }
            WindowsBorders.drawBezel(graphics, n, n2, n3, n4, bl, bl2, this.shadow, this.darkShadow, this.highlight, this.lightHighlight, this.defaultColor);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, EMPTY_INSETS);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 2;
            insets.right = 3;
            insets.bottom = 3;
            insets.left = 3;
            return insets;
        }
    }
}

