/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.windows.WindowsArrowButton;
import com.jgoodies.looks.windows.WindowsComboBoxEditor;
import com.jgoodies.looks.windows.WindowsUtils;
import com.sun.java.swing.plaf.windows.WindowsTextFieldUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsComboBoxUI
extends com.sun.java.swing.plaf.windows.WindowsComboBoxUI {
    private static final String CELL_EDITOR_KEY = "JComboBox.isTableCellEditor";
    private static final JTextField PHANTOM = new JTextField("Phantom");
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Border EMPTY_BORDER = new EmptyBorder(EMPTY_INSETS);
    private boolean tableCellEditor;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        WindowsComboBoxUI.ensurePhantomHasWindowsUI();
        return new WindowsComboBoxUI();
    }

    private static void ensurePhantomHasWindowsUI() {
        if (!(PHANTOM.getUI() instanceof WindowsTextFieldUI)) {
            PHANTOM.updateUI();
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tableCellEditor = this.isTableCellEditorReplaced();
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new TableCellEditorPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected JButton createArrowButton() {
        return SystemUtils.IS_LAF_WINDOWS_XP_ENABLED ? super.createArrowButton() : new WindowsArrowButton(5);
    }

    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor.UIResource(this.tableCellEditor);
    }

    protected LayoutManager createLayoutManager() {
        return new WindowsComboBoxLayoutManager();
    }

    protected void configureEditor() {
        super.configureEditor();
        if (!this.comboBox.isEnabled()) {
            this.editor.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
    }

    protected ComboPopup createPopup() {
        return new WindowsComboPopup(this.comboBox);
    }

    protected ListCellRenderer createRenderer() {
        if (this.tableCellEditor) {
            return super.createRenderer();
        }
        BasicComboBoxRenderer.UIResource uIResource = new BasicComboBoxRenderer.UIResource();
        uIResource.setBorder(UIManager.getBorder("ComboBox.rendererBorder"));
        return uIResource;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Serializable serializable;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets = this.getInsets();
        dimension.height += insets.top + insets.bottom;
        int n = WindowsComboBoxUI.getEditableButtonWidth();
        dimension.width += insets.left + insets.right + n;
        ++dimension.width;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer instanceof JComponent) {
            serializable = (JComponent)((Object)listCellRenderer);
            Insets insets2 = ((JComponent)serializable).getInsets();
            Insets insets3 = UIManager.getInsets("ComboBox.editorInsets");
            int n2 = Math.max(0, insets3.left - insets2.left);
            int n3 = Math.max(0, insets3.right - insets2.right);
            dimension.width += n2 + n3;
        }
        serializable = PHANTOM.getMinimumSize();
        dimension.height = SystemUtils.IS_OS_WINDOWS_6_OR_LATER && !SystemUtils.IS_LAF_WINDOWS_XP_ENABLED ? ((Dimension)serializable).height : Math.max(((Dimension)serializable).height, dimension.height);
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        int n;
        Serializable serializable;
        Serializable serializable2;
        Component component;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        boolean bl2 = this.isVistaXPStyleReadOnlyCombo();
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        Border border = null;
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (component instanceof JComponent && !this.tableCellEditor) {
            JComponent jComponent = (JComponent)component;
            if (this.isRendererBorderRemovable(jComponent)) {
                border = jComponent.getBorder();
                jComponent.setBorder(EMPTY_BORDER);
            }
            serializable2 = jComponent.getInsets();
            serializable = UIManager.getInsets("ComboBox.editorInsets");
            n = Math.max(0, serializable.left - ((Insets)serializable2).left);
            int n2 = Math.max(0, serializable.right - ((Insets)serializable2).right);
            int n3 = Math.max(0, serializable.top - ((Insets)serializable2).top);
            int n4 = Math.max(0, serializable.bottom - ((Insets)serializable2).bottom);
            rectangle.x += n;
            rectangle.y += n3;
            rectangle.width -= n + n2 - 1;
            rectangle.height -= n3 + n4;
        }
        component.setFont(this.comboBox.getFont());
        if (bl && !this.isPopupVisible(this.comboBox) && !bl2) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean bl3 = component instanceof JPanel;
        serializable2 = null;
        if (bl2 && component instanceof JComponent && !(component instanceof DefaultListCellRenderer)) {
            serializable2 = Boolean.valueOf(component.isOpaque());
            ((JComponent)component).setOpaque(false);
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl3);
        if (bl) {
            serializable = graphics.getColor();
            graphics.setColor(this.comboBox.getForeground());
            if (bl2) {
                n = rectangle2.width - 2;
                if (n % 2 == 0) {
                    ++n;
                }
                WindowsUtils.drawRoundedDashedRect(graphics, rectangle2.x + 1, rectangle2.y + 1, n, rectangle2.height - 2);
            }
            graphics.setColor((Color)serializable);
        }
        if (serializable2 != null) {
            ((JComponent)component).setOpaque((Boolean)serializable2);
        }
        if (border != null) {
            ((JComponent)component).setBorder(border);
        }
    }

    protected boolean isRendererBorderRemovable(JComponent jComponent) {
        if (jComponent instanceof BasicComboBoxRenderer.UIResource) {
            return true;
        }
        Object object = jComponent.getClientProperty("isBorderRemovable");
        if (object != null) {
            return Boolean.TRUE.equals(object);
        }
        Border border = jComponent.getBorder();
        return border instanceof EmptyBorder;
    }

    private boolean isVistaXPStyleReadOnlyCombo() {
        return SystemUtils.IS_OS_WINDOWS_6_OR_LATER && SystemUtils.IS_LAF_WINDOWS_XP_ENABLED && !this.comboBox.isEditable();
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = WindowsComboBoxUI.getEditableButtonWidth();
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + n3, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    private static int getEditableButtonWidth() {
        return UIManager.getInt("ScrollBar.width");
    }

    private boolean isTableCellEditorReplaced() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty(CELL_EDITOR_KEY));
    }

    private final class TableCellEditorPropertyChangeHandler
    implements PropertyChangeListener {
        private TableCellEditorPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WindowsComboBoxUI.this.tableCellEditor = WindowsComboBoxUI.this.isTableCellEditorReplaced();
            if (WindowsComboBoxUI.this.comboBox.getRenderer() == null || WindowsComboBoxUI.this.comboBox.getRenderer() instanceof UIResource) {
                WindowsComboBoxUI.this.comboBox.setRenderer(WindowsComboBoxUI.this.createRenderer());
            }
            if (WindowsComboBoxUI.this.comboBox.getEditor() == null || WindowsComboBoxUI.this.comboBox.getEditor() instanceof UIResource) {
                WindowsComboBoxUI.this.comboBox.setEditor(WindowsComboBoxUI.this.createEditor());
            }
        }
    }

    private static final class WindowsComboPopup
    extends BasicComboPopup {
        private WindowsComboPopup(JComboBox<?> jComboBox) {
            super(jComboBox);
        }

        @Override
        protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            Serializable serializable;
            boolean bl;
            Rectangle rectangle = super.computePopupBounds(n, n2, n3, n4);
            Object object = this.comboBox.getClientProperty("ComboBox.popupPrototypeDisplayValue");
            if (object == null) {
                return rectangle;
            }
            ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
            Component component = listCellRenderer.getListCellRendererComponent(this.list, object, -1, true, true);
            n3 = component.getPreferredSize().width;
            boolean bl2 = bl = this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount();
            if (bl) {
                serializable = this.scroller.getVerticalScrollBar();
                n3 += serializable.getPreferredSize().width;
            }
            serializable = super.computePopupBounds(n, n2, n3, n4);
            return ((Rectangle)serializable).width > rectangle.width ? serializable : rectangle;
        }
    }

    private final class WindowsComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private WindowsComboBoxLayoutManager() {
            super((BasicComboBoxUI)((Object)WindowsComboBoxUI.this));
        }

        @Override
        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = WindowsComboBoxUI.this.getInsets();
            int n3 = WindowsComboBoxUI.getEditableButtonWidth();
            int n4 = n2 - (insets.top + insets.bottom);
            if (WindowsComboBoxUI.this.arrowButton != null) {
                if (jComboBox.getComponentOrientation().isLeftToRight()) {
                    WindowsComboBoxUI.this.arrowButton.setBounds(n - (insets.right + n3), insets.top, n3, n4);
                } else {
                    WindowsComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, n3, n4);
                }
            }
            if (WindowsComboBoxUI.this.editor != null) {
                WindowsComboBoxUI.this.editor.setBounds(WindowsComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

