/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;

public final class WindowsScrollPaneUI
extends com.sun.java.swing.plaf.windows.WindowsScrollPaneUI {
    private PropertyChangeListener borderStyleChangeHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsScrollPaneUI();
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        super.installDefaults(jScrollPane);
        WindowsScrollPaneUI.installEtchedBorder(jScrollPane);
    }

    private static void installEtchedBorder(JScrollPane jScrollPane) {
        Object object = jScrollPane.getClientProperty("jgoodies.isEtched");
        boolean bl = Boolean.TRUE.equals(object);
        LookAndFeel.installBorder(jScrollPane, bl ? "ScrollPane.etchedBorder" : "ScrollPane.border");
    }

    public void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.borderStyleChangeHandler = new BorderStyleChangeHandler();
        jScrollPane.addPropertyChangeListener("jgoodies.isEtched", this.borderStyleChangeHandler);
    }

    protected void uninstallListeners(JComponent jComponent) {
        ((JScrollPane)jComponent).removePropertyChangeListener("jgoodies.isEtched", this.borderStyleChangeHandler);
        super.uninstallListeners(jComponent);
    }

    private class BorderStyleChangeHandler
    implements PropertyChangeListener {
        private BorderStyleChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JScrollPane jScrollPane = (JScrollPane)propertyChangeEvent.getSource();
            WindowsScrollPaneUI.installEtchedBorder(jScrollPane);
        }
    }
}

