/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.common.base.SystemUtils;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public final class WindowsTabbedPaneUI
extends com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI {
    private static final Insets CONTENT_BORDER_NORTH_INSETS = new Insets(0, 2, 4, 4);
    private static final Insets CONTENT_BORDER_WEST_INSETS = new Insets(2, 0, 4, 4);
    private static final Insets CONTENT_BORDER_SOUTH_INSETS = new Insets(4, 2, 0, 4);
    private static final Insets CONTENT_BORDER_EAST_INSETS = new Insets(2, 4, 4, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTabbedPaneUI();
    }

    protected Insets getContentBorderInsets(int n) {
        if (!SystemUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            return this.contentBorderInsets;
        }
        switch (n) {
            case 4: {
                return CONTENT_BORDER_EAST_INSETS;
            }
            case 2: {
                return CONTENT_BORDER_WEST_INSETS;
            }
            case 1: {
                return CONTENT_BORDER_NORTH_INSETS;
            }
        }
        return CONTENT_BORDER_SOUTH_INSETS;
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        switch (n) {
            case 4: {
                return bl ? 2 : 0;
            }
            case 2: {
                return bl ? -2 : 0;
            }
        }
        return 0;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        int n2;
        Insets insets = super.getSelectedTabPadInsets(n);
        insets.left = insets.right = (n2 = insets.left + insets.right / 2);
        return insets;
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        if (n != 1) {
            return;
        }
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        if (n != 1 || n2 < 0 || rectangle.y + rectangle.height + 1 < n4 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            super.paintContentBorderTopEdge(graphics, n, n2, n3, n4, n5, n6);
        } else {
            graphics.setColor(this.lightHighlight);
            graphics.fillRect(n3, n4, rectangle.x + 1 - n3, 1);
            graphics.fillRect(rectangle.x + rectangle.width, n4, n3 + n5 - 2 - rectangle.x - rectangle.width, 1);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        if (n != 3 || n2 < 0 || rectangle.y - 1 > n6 + n4 || rectangle.x < n3 || rectangle.x > n3 + n5) {
            super.paintContentBorderBottomEdge(graphics, n, n2, n3, n4, n5, n6);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        if (n != 2 || n2 < 0 || rectangle.x + rectangle.width + 1 < n3 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            super.paintContentBorderLeftEdge(graphics, n, n2, n3, n4, n5, n6);
        } else {
            graphics.setColor(this.lightHighlight);
            graphics.fillRect(n3, n4, 1, rectangle.y + 1 - n4);
            graphics.fillRect(n3, rectangle.y + rectangle.height, 1, n4 + n6 - 1 - rectangle.y - rectangle.height);
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = n2 < 0 ? null : this.getTabBounds(n2, this.calcRect);
        if (n != 4 || n2 < 0 || rectangle.x - 1 > n3 + n5 || rectangle.y < n4 || rectangle.y > n4 + n6) {
            super.paintContentBorderRightEdge(graphics, n, n2, n3, n4, n5, n6);
        } else {
            graphics.setColor(this.lightHighlight);
            graphics.fillRect(n3 + n5 - 1, n4, 1, 1);
            graphics.setColor(this.shadow);
            graphics.fillRect(n3 + n5 - 2, n4 + 1, 1, rectangle.y - 1 - n4);
            graphics.fillRect(n3 + n5 - 2, rectangle.y + rectangle.height, 1, n4 + n6 - 1 - rectangle.y - rectangle.height);
            graphics.setColor(this.darkShadow);
            graphics.fillRect(n3 + n5 - 1, n4, 1, rectangle.y - n4);
            graphics.fillRect(n3 + n5 - 1, rectangle.y + rectangle.height - 1, 1, n4 + n6 - rectangle.y - rectangle.height);
        }
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        if (!(n != 4 && n != 2 || icon == null || string == null || string.equals(""))) {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 2, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
            n3 += 4;
        } else {
            SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        }
        this.tabPane.putClientProperty("html", null);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }
}

