/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;

public class EmptyChannelBuffer
extends BigEndianHeapChannelBuffer {
    private static final byte[] BUFFER = new byte[0];

    EmptyChannelBuffer() {
        super(BUFFER);
    }

    @Override
    public void clear() {
    }

    @Override
    public void readerIndex(int readerIndex) {
        if (readerIndex != 0) {
            throw new IndexOutOfBoundsException("Invalid readerIndex: " + readerIndex + " - Maximum is 0");
        }
    }

    @Override
    public void writerIndex(int writerIndex) {
        if (writerIndex != 0) {
            throw new IndexOutOfBoundsException("Invalid writerIndex: " + writerIndex + " - Maximum is 0");
        }
    }

    @Override
    public void setIndex(int readerIndex, int writerIndex) {
        if (writerIndex != 0 || readerIndex != 0) {
            throw new IndexOutOfBoundsException("Invalid writerIndex: " + writerIndex + " - Maximum is " + readerIndex + " or " + this.capacity());
        }
    }

    @Override
    public void markReaderIndex() {
    }

    @Override
    public void resetReaderIndex() {
    }

    @Override
    public void markWriterIndex() {
    }

    @Override
    public void resetWriterIndex() {
    }

    @Override
    public void discardReadBytes() {
    }

    @Override
    public ChannelBuffer readBytes(int length) {
        this.checkReadableBytes(length);
        return this;
    }

    @Override
    public ChannelBuffer readSlice(int length) {
        this.checkReadableBytes(length);
        return this;
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
    }

    @Override
    public void readBytes(byte[] dst) {
        this.checkReadableBytes(dst.length);
    }

    @Override
    public void readBytes(ChannelBuffer dst) {
        this.checkReadableBytes(dst.writableBytes());
    }

    @Override
    public void readBytes(ChannelBuffer dst, int length) {
        this.checkReadableBytes(length);
    }

    @Override
    public void readBytes(ChannelBuffer dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
    }

    @Override
    public void readBytes(ByteBuffer dst) {
        this.checkReadableBytes(dst.remaining());
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        this.checkReadableBytes(length);
        return 0;
    }

    @Override
    public void readBytes(OutputStream out, int length) throws IOException {
        this.checkReadableBytes(length);
    }

    @Override
    public void skipBytes(int length) {
        this.checkReadableBytes(length);
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.checkWritableBytes(length);
    }

    @Override
    public void writeBytes(ChannelBuffer src, int length) {
        this.checkWritableBytes(length);
    }

    @Override
    public void writeBytes(ChannelBuffer src, int srcIndex, int length) {
        this.checkWritableBytes(length);
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        this.checkWritableBytes(src.remaining());
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        this.checkWritableBytes(length);
        return 0;
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        this.checkWritableBytes(length);
        return 0;
    }

    @Override
    public void writeZero(int length) {
        this.checkWritableBytes(length);
    }

    private void checkWritableBytes(int length) {
        if (length == 0) {
            return;
        }
        if (length > 0) {
            throw new IndexOutOfBoundsException("Writable bytes exceeded - Need " + length + ", maximum is " + 0);
        }
        throw new IndexOutOfBoundsException("length < 0");
    }

    @Override
    protected void checkReadableBytes(int length) {
        if (length == 0) {
            return;
        }
        if (length > 0) {
            throw new IndexOutOfBoundsException("Not enough readable bytes - Need " + length + ", maximum is " + this.readableBytes());
        }
        throw new IndexOutOfBoundsException("length < 0");
    }
}

