/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.ssl.NotSslRecordException;
import org.jboss.netty.handler.ssl.SslBufferPool;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.jboss.netty.util.internal.DetectionUtil;
import org.jboss.netty.util.internal.NonReentrantLock;

public class SslHandler
extends FrameDecoder
implements ChannelDownstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static SslBufferPool defaultBufferPool;
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslBufferPool bufferPool;
    private final boolean startTls;
    private volatile boolean enableRenegotiation = true;
    final Object handshakeLock = new Object();
    private boolean handshaking;
    private volatile boolean handshaken;
    private volatile ChannelFuture handshakeFuture;
    private volatile int sentFirstMessage;
    private volatile int sentCloseNotify;
    private volatile int closedOutboundAndChannel;
    private static final AtomicIntegerFieldUpdater<SslHandler> SENT_FIRST_MESSAGE_UPDATER;
    private static final AtomicIntegerFieldUpdater<SslHandler> SENT_CLOSE_NOTIFY_UPDATER;
    private static final AtomicIntegerFieldUpdater<SslHandler> CLOSED_OUTBOUND_AND_CHANNEL_UPDATER;
    int ignoreClosedChannelException;
    final Object ignoreClosedChannelExceptionLock = new Object();
    private final Queue<PendingWrite> pendingUnencryptedWrites = new LinkedList<PendingWrite>();
    private final NonReentrantLock pendingUnencryptedWritesLock = new NonReentrantLock();
    private final Queue<MessageEvent> pendingEncryptedWrites = new ConcurrentLinkedQueue<MessageEvent>();
    private final NonReentrantLock pendingEncryptedWritesLock = new NonReentrantLock();
    private volatile boolean issueHandshake;
    private volatile boolean writeBeforeHandshakeDone;
    private final SSLEngineInboundCloseFuture sslEngineCloseFuture = new SSLEngineInboundCloseFuture();
    private boolean closeOnSslException;
    private int packetLength;
    private final Timer timer;
    private final long handshakeTimeoutInMillis;
    private Timeout handshakeTimeout;

    public static synchronized SslBufferPool getDefaultBufferPool() {
        if (defaultBufferPool == null) {
            defaultBufferPool = new SslBufferPool();
        }
        return defaultBufferPool;
    }

    public SslHandler(SSLEngine engine) {
        this(engine, SslHandler.getDefaultBufferPool(), false, null, 0L);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool) {
        this(engine, bufferPool, false, null, 0L);
    }

    public SslHandler(SSLEngine engine, boolean startTls) {
        this(engine, SslHandler.getDefaultBufferPool(), startTls);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, boolean startTls) {
        this(engine, bufferPool, startTls, null, 0L);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, boolean startTls, Timer timer, long handshakeTimeoutInMillis) {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        if (bufferPool == null) {
            throw new NullPointerException("bufferPool");
        }
        if (timer == null && handshakeTimeoutInMillis > 0L) {
            throw new IllegalArgumentException("No Timer was given but a handshakeTimeoutInMillis, need both or none");
        }
        this.engine = engine;
        this.bufferPool = bufferPool;
        this.startTls = startTls;
        this.timer = timer;
        this.handshakeTimeoutInMillis = handshakeTimeoutInMillis;
    }

    public SSLEngine getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture handshake() {
        Object object = this.handshakeLock;
        synchronized (object) {
            ChannelFuture handshakeFuture;
            if (this.handshaken && !this.isEnableRenegotiation()) {
                throw new IllegalStateException("renegotiation disabled");
            }
            final ChannelHandlerContext ctx = this.ctx;
            final Channel channel = ctx.getChannel();
            Exception exception = null;
            if (this.handshaking) {
                return this.handshakeFuture;
            }
            this.handshaking = true;
            try {
                this.engine.beginHandshake();
                this.runDelegatedTasks();
                handshakeFuture = this.handshakeFuture = Channels.future(channel);
                if (this.handshakeTimeoutInMillis > 0L) {
                    this.handshakeTimeout = this.timer.newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            ChannelFuture future = SslHandler.this.handshakeFuture;
                            if (future != null && future.isDone()) {
                                return;
                            }
                            SslHandler.this.setHandshakeFailure(channel, new SSLException("Handshake did not complete within " + SslHandler.this.handshakeTimeoutInMillis + "ms"));
                        }
                    }, this.handshakeTimeoutInMillis, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                handshakeFuture = this.handshakeFuture = Channels.failedFuture(channel, e);
                exception = e;
            }
            if (exception == null) {
                try {
                    final ChannelFuture hsFuture = handshakeFuture;
                    this.wrapNonAppData(ctx, channel).addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                Throwable cause = future.getCause();
                                hsFuture.setFailure(cause);
                                Channels.fireExceptionCaught(ctx, cause);
                                if (SslHandler.this.closeOnSslException) {
                                    Channels.close(ctx, Channels.future(channel));
                                }
                            }
                        }
                    });
                }
                catch (SSLException e) {
                    handshakeFuture.setFailure(e);
                    Channels.fireExceptionCaught(ctx, (Throwable)e);
                    if (this.closeOnSslException) {
                        Channels.close(ctx, Channels.future(channel));
                    }
                }
            } else {
                Channels.fireExceptionCaught(ctx, (Throwable)exception);
                if (this.closeOnSslException) {
                    Channels.close(ctx, Channels.future(channel));
                }
            }
            return handshakeFuture;
        }
    }

    public ChannelFuture close() {
        ChannelHandlerContext ctx = this.ctx;
        Channel channel = ctx.getChannel();
        try {
            this.engine.closeOutbound();
            return this.wrapNonAppData(ctx, channel);
        }
        catch (SSLException e) {
            Channels.fireExceptionCaught(ctx, (Throwable)e);
            if (this.closeOnSslException) {
                Channels.close(ctx, Channels.future(channel));
            }
            return Channels.failedFuture(channel, e);
        }
    }

    public boolean isEnableRenegotiation() {
        return this.enableRenegotiation;
    }

    public void setEnableRenegotiation(boolean enableRenegotiation) {
        this.enableRenegotiation = enableRenegotiation;
    }

    public void setIssueHandshake(boolean issueHandshake) {
        this.issueHandshake = issueHandshake;
    }

    public boolean isIssueHandshake() {
        return this.issueHandshake;
    }

    public ChannelFuture getSSLEngineInboundCloseFuture() {
        return this.sslEngineCloseFuture;
    }

    public long getHandshakeTimeout() {
        return this.handshakeTimeoutInMillis;
    }

    public void setCloseOnSSLException(boolean closeOnSslException) {
        if (this.ctx != null) {
            throw new IllegalStateException("Can only get changed before attached to ChannelPipeline");
        }
        this.closeOnSslException = closeOnSslException;
    }

    public boolean getCloseOnSSLException() {
        return this.closeOnSslException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDownstream(ChannelHandlerContext context, ChannelEvent evt) throws Exception {
        ChannelEvent e;
        if (evt instanceof ChannelStateEvent) {
            e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    this.closeOutboundAndChannel(context, (ChannelStateEvent)e);
                    return;
                }
            }
        }
        if (!(evt instanceof MessageEvent)) {
            context.sendDownstream(evt);
            return;
        }
        e = (MessageEvent)evt;
        if (!(e.getMessage() instanceof ChannelBuffer)) {
            context.sendDownstream(evt);
            return;
        }
        if (this.startTls && SENT_FIRST_MESSAGE_UPDATER.compareAndSet(this, 0, 1)) {
            context.sendDownstream(evt);
            return;
        }
        ChannelBuffer msg = (ChannelBuffer)e.getMessage();
        PendingWrite pendingWrite = msg.readable() ? new PendingWrite(evt.getFuture(), msg.toByteBuffer(msg.readerIndex(), msg.readableBytes())) : new PendingWrite(evt.getFuture(), null);
        this.pendingUnencryptedWritesLock.lock();
        try {
            this.pendingUnencryptedWrites.add(pendingWrite);
        }
        finally {
            this.pendingUnencryptedWritesLock.unlock();
        }
        if (this.handshakeFuture == null || !this.handshakeFuture.isDone()) {
            this.writeBeforeHandshakeDone = true;
        }
        this.wrap(context, evt.getChannel());
    }

    private void cancelHandshakeTimeout() {
        if (this.handshakeTimeout != null) {
            this.handshakeTimeout.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.handshaking) {
                this.cancelHandshakeTimeout();
                this.handshakeFuture.setFailure(new ClosedChannelException());
            }
        }
        try {
            super.channelDisconnected(ctx, e);
        }
        finally {
            this.unwrapNonAppData(ctx, e.getChannel(), false);
            this.closeEngine();
        }
    }

    private void closeEngine() {
        block3: {
            this.engine.closeOutbound();
            if (this.sentCloseNotify == 0 && this.handshaken) {
                try {
                    this.engine.closeInbound();
                }
                catch (SSLException ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Failed to clean up SSLEngine.", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            if (cause instanceof ClosedChannelException) {
                Object object = this.ignoreClosedChannelExceptionLock;
                synchronized (object) {
                    if (this.ignoreClosedChannelException > 0) {
                        --this.ignoreClosedChannelException;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Swallowing an exception raised while writing non-app data", cause);
                        }
                        return;
                    }
                }
            } else if (this.ignoreException(cause)) {
                return;
            }
        }
        ctx.sendUpstream(e);
    }

    private boolean ignoreException(Throwable t) {
        if (!(t instanceof SSLException) && t instanceof IOException && this.engine.isOutboundDone()) {
            StackTraceElement[] elements;
            String message = String.valueOf(t.getMessage()).toLowerCase();
            if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                return true;
            }
            for (StackTraceElement element : elements = t.getStackTrace()) {
                String classname = element.getClassName();
                String methodname = element.getMethodName();
                if (classname.startsWith("org.jboss.netty.") || !"read".equals(methodname)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(classname).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(classname);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (DetectionUtil.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean isEncrypted(ChannelBuffer buffer) {
        return SslHandler.getEncryptedPacketLength(buffer, buffer.readerIndex()) != -1;
    }

    private static int getEncryptedPacketLength(ChannelBuffer buffer, int offset) {
        boolean tls;
        int packetLength = 0;
        switch (buffer.getUnsignedByte(offset)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                tls = true;
                break;
            }
            default: {
                tls = false;
            }
        }
        if (tls) {
            short majorVersion = buffer.getUnsignedByte(offset + 1);
            if (majorVersion == 3) {
                packetLength = (SslHandler.getShort(buffer, offset + 3) & 0xFFFF) + 5;
                if (packetLength <= 5) {
                    tls = false;
                }
            } else {
                tls = false;
            }
        }
        if (!tls) {
            boolean sslv2 = true;
            int headerLength = (buffer.getUnsignedByte(offset) & 0x80) != 0 ? 2 : 3;
            short majorVersion = buffer.getUnsignedByte(offset + headerLength + 1);
            if (majorVersion == 2 || majorVersion == 3) {
                packetLength = headerLength == 2 ? (SslHandler.getShort(buffer, offset) & Short.MAX_VALUE) + 2 : (SslHandler.getShort(buffer, offset) & 0x3FFF) + 3;
                if (packetLength <= headerLength) {
                    sslv2 = false;
                }
            } else {
                sslv2 = false;
            }
            if (!sslv2) {
                return -1;
            }
        }
        return packetLength;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer in) throws Exception {
        int readableBytes;
        int startOffset = in.readerIndex();
        int endOffset = in.writerIndex();
        int offset = startOffset;
        int totalLength = 0;
        if (this.packetLength > 0) {
            if (endOffset - startOffset < this.packetLength) {
                return null;
            }
            offset += this.packetLength;
            totalLength = this.packetLength;
            this.packetLength = 0;
        }
        boolean nonSslRecord = false;
        while (totalLength < 18713 && (readableBytes = endOffset - offset) >= 5) {
            int packetLength = SslHandler.getEncryptedPacketLength(in, offset);
            if (packetLength == -1) {
                nonSslRecord = true;
                break;
            }
            assert (packetLength > 0);
            if (packetLength > readableBytes) {
                this.packetLength = packetLength;
                break;
            }
            int newTotalLength = totalLength + packetLength;
            if (newTotalLength > 18713) break;
            offset += packetLength;
            totalLength = newTotalLength;
        }
        ChannelBuffer unwrapped = null;
        if (totalLength > 0) {
            in.skipBytes(totalLength);
            ByteBuffer inNetBuf = in.toByteBuffer(startOffset, totalLength);
            unwrapped = this.unwrap(ctx, channel, inNetBuf, totalLength, true);
        }
        if (nonSslRecord) {
            NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + ChannelBuffers.hexDump(in));
            in.skipBytes(in.readableBytes());
            if (this.closeOnSslException) {
                Channels.fireExceptionCaught(ctx, (Throwable)e);
                Channels.close(ctx, Channels.future(channel));
                return null;
            }
            throw e;
        }
        return unwrapped;
    }

    private static short getShort(ChannelBuffer buf, int offset) {
        return (short)(buf.getByte(offset) << 8 | buf.getByte(offset + 1) & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void wrap(ChannelHandlerContext context, Channel channel) throws SSLException {
        outNetBuf = this.bufferPool.acquireBuffer();
        success = true;
        offered = false;
        needsUnwrap = false;
        pendingWrite = null;
        try {
            block32: while (true) lbl-1000:
            // 6 sources

            {
                this.pendingUnencryptedWritesLock.lock();
                pendingWrite = this.pendingUnencryptedWrites.peek();
                if (pendingWrite == null) {
                    this.pendingUnencryptedWritesLock.unlock();
                    break;
                }
                outAppBuf = pendingWrite.outAppBuf;
                if (outAppBuf == null) {
                    this.pendingUnencryptedWrites.remove();
                    this.offerEncryptedWriteRequest(new DownstreamMessageEvent(channel, pendingWrite.future, ChannelBuffers.EMPTY_BUFFER, channel.getRemoteAddress()));
                    offered = true;
                    continue;
                }
                var10_11 = this.handshakeLock;
                // MONITORENTER : var10_11
                result = null;
                try {
                    result = this.engine.wrap(outAppBuf, outNetBuf);
                }
                finally {
                    if (!outAppBuf.hasRemaining()) {
                        this.pendingUnencryptedWrites.remove();
                    }
                }
                if (result.bytesProduced() > 0) {
                    outNetBuf.flip();
                    remaining = outNetBuf.remaining();
                    msg = this.ctx.getChannel().getConfig().getBufferFactory().getBuffer(remaining);
                    msg.writeBytes(outNetBuf);
                    outNetBuf.clear();
                    future = pendingWrite.outAppBuf.hasRemaining() != false ? Channels.succeededFuture(channel) : pendingWrite.future;
                    encryptedWrite = new DownstreamMessageEvent(channel, future, msg, channel.getRemoteAddress());
                    this.offerEncryptedWriteRequest(encryptedWrite);
                    offered = true;
                    continue;
                }
                if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                    success = false;
                    // MONITOREXIT : var10_11
                    this.pendingUnencryptedWritesLock.unlock();
                    break;
                }
                handshakeStatus = result.getHandshakeStatus();
                this.handleRenegotiation(handshakeStatus);
                switch (7.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[handshakeStatus.ordinal()]) {
                    case 1: {
                        if (outAppBuf.hasRemaining()) continue block32;
                        // MONITOREXIT : var10_11
                        this.pendingUnencryptedWritesLock.unlock();
                        break block32;
                    }
                    case 2: {
                        needsUnwrap = true;
                        // MONITOREXIT : var10_11
                        this.pendingUnencryptedWritesLock.unlock();
                        break block32;
                    }
                    case 3: {
                        this.runDelegatedTasks();
                        ** break;
                    }
                    case 4: {
                        this.setHandshakeSuccess(channel);
                        if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                            success = false;
                        }
                        // MONITOREXIT : var10_11
                        this.pendingUnencryptedWritesLock.unlock();
                        break block32;
                    }
                    case 5: {
                        this.setHandshakeSuccessIfStillHandshaking(channel);
                        if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                            success = false;
                        }
                        // MONITOREXIT : var10_11
                        this.pendingUnencryptedWritesLock.unlock();
                        break block32;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)handshakeStatus);
                    }
                }
                finally {
                    this.pendingUnencryptedWritesLock.unlock();
                    continue;
                }
                break;
            }
            this.bufferPool.releaseBuffer(outNetBuf);
            if (offered) {
                this.flushPendingEncryptedWrites(context);
            }
            if (success) ** GOTO lbl128
            v0 /* !! */  = cause /* !! */  = channel.isOpen() != false ? new SSLException("SSLEngine already closed") : new ClosedChannelException();
        }
        catch (SSLException e) {
            try {
                success = false;
                this.setHandshakeFailure(channel, e);
                throw e;
            }
            catch (Throwable var18_20) {
                block50: {
                    this.bufferPool.releaseBuffer(outNetBuf);
                    if (offered) {
                        this.flushPendingEncryptedWrites(context);
                    }
                    if (success != false) throw var18_20;
                    v1 /* !! */  = cause /* !! */  = channel.isOpen() != false ? new SSLException("SSLEngine already closed") : new ClosedChannelException();
                    if (pendingWrite != null) {
                        pendingWrite.future.setFailure(cause /* !! */ );
                    }
                    break block50;
lbl114:
                    // 2 sources

                    while (true) {
                        this.pendingUnencryptedWritesLock.lock();
                        try {
                            pendingWrite = this.pendingUnencryptedWrites.poll();
                            if (pendingWrite == null) {
                                break;
                            }
                        }
                        finally {
                            this.pendingUnencryptedWritesLock.unlock();
                        }
                        pendingWrite.future.setFailure(cause /* !! */ );
                    }
lbl128:
                    // 2 sources

                    if (needsUnwrap == false) return;
                    this.unwrapNonAppData(this.ctx, channel, true);
                    return;
                }
                while (true) {
                    this.pendingUnencryptedWritesLock.lock();
                    try {
                        pendingWrite = this.pendingUnencryptedWrites.poll();
                        if (pendingWrite == null) {
                            throw var18_20;
                        }
                    }
                    finally {
                        this.pendingUnencryptedWritesLock.unlock();
                    }
                    pendingWrite.future.setFailure(cause /* !! */ );
                }
            }
        }
        if (pendingWrite == null) ** GOTO lbl114
        pendingWrite.future.setFailure(cause /* !! */ );
        ** GOTO lbl114
    }

    private void offerEncryptedWriteRequest(MessageEvent encryptedWrite) {
        boolean locked = this.pendingEncryptedWritesLock.tryLock();
        try {
            this.pendingEncryptedWrites.add(encryptedWrite);
        }
        finally {
            if (locked) {
                this.pendingEncryptedWritesLock.unlock();
            }
        }
    }

    private void flushPendingEncryptedWrites(ChannelHandlerContext ctx) {
        while (!this.pendingEncryptedWrites.isEmpty()) {
            if (!this.pendingEncryptedWritesLock.tryLock()) {
                return;
            }
            try {
                MessageEvent e;
                while ((e = this.pendingEncryptedWrites.poll()) != null) {
                    ctx.sendDownstream(e);
                }
            }
            finally {
                this.pendingEncryptedWritesLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture wrapNonAppData(ChannelHandlerContext ctx, Channel channel) throws SSLException {
        ChannelFuture future = null;
        ByteBuffer outNetBuf = this.bufferPool.acquireBuffer();
        try {
            SSLEngineResult result;
            block15: do {
                Object object = this.handshakeLock;
                synchronized (object) {
                    result = this.engine.wrap(EMPTY_BUFFER, outNetBuf);
                }
                if (result.bytesProduced() > 0) {
                    outNetBuf.flip();
                    ChannelBuffer msg = ctx.getChannel().getConfig().getBufferFactory().getBuffer(outNetBuf.remaining());
                    msg.writeBytes(outNetBuf);
                    outNetBuf.clear();
                    future = Channels.future(channel);
                    future.addListener(new ChannelFutureListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.getCause() instanceof ClosedChannelException) {
                                Object object = SslHandler.this.ignoreClosedChannelExceptionLock;
                                synchronized (object) {
                                    ++SslHandler.this.ignoreClosedChannelException;
                                }
                            }
                        }
                    });
                    Channels.write(ctx, future, msg);
                }
                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                this.handleRenegotiation(handshakeStatus);
                switch (handshakeStatus) {
                    case FINISHED: {
                        this.setHandshakeSuccess(channel);
                        this.runDelegatedTasks();
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        break;
                    }
                    case NEED_UNWRAP: {
                        if (Thread.holdsLock(this.handshakeLock)) continue block15;
                        this.unwrapNonAppData(ctx, channel, true);
                        break;
                    }
                    case NOT_HANDSHAKING: {
                        if (!this.setHandshakeSuccessIfStillHandshaking(channel)) continue block15;
                        this.runDelegatedTasks();
                        break;
                    }
                    case NEED_WRAP: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected handshake status: " + (Object)((Object)handshakeStatus));
                    }
                }
            } while (result.bytesProduced() != 0);
        }
        catch (SSLException e) {
            this.setHandshakeFailure(channel, e);
            throw e;
        }
        finally {
            this.bufferPool.releaseBuffer(outNetBuf);
        }
        if (future == null) {
            future = Channels.succeededFuture(channel);
        }
        return future;
    }

    private void unwrapNonAppData(ChannelHandlerContext ctx, Channel channel, boolean mightNeedHandshake) throws SSLException {
        this.unwrap(ctx, channel, EMPTY_BUFFER, -1, mightNeedHandshake);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ChannelBuffer unwrap(ChannelHandlerContext ctx, Channel channel, ByteBuffer nioInNetBuf, int initialNettyOutAppBufCapacity, boolean mightNeedHandshake) throws SSLException {
        nioInNetBufStartOffset = nioInNetBuf.position();
        nioOutAppBuf = this.bufferPool.acquireBuffer();
        nettyOutAppBuf = null;
        try {
            needsWrap = false;
            block25: while (true) {
                needsHandshake = false;
                if (mightNeedHandshake) {
                    var12_13 = this.handshakeLock;
                    synchronized (var12_13) {
                        if (!(this.handshaken || this.handshaking || this.engine.getUseClientMode() || this.engine.isInboundDone() || this.engine.isOutboundDone())) {
                            needsHandshake = true;
                        }
                    }
                }
                if (needsHandshake) {
                    this.handshake();
                }
                var12_13 = this.handshakeLock;
                synchronized (var12_13) {
                    block26: while (true) {
                        outAppBufSize = this.engine.getSession().getApplicationBufferSize();
                        outAppBuf = nioOutAppBuf.capacity() < outAppBufSize ? ByteBuffer.allocate(outAppBufSize) : nioOutAppBuf;
                        try {
                            result = this.engine.unwrap(nioInNetBuf, outAppBuf);
                            switch (7.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[result.getStatus().ordinal()]) {
                                case 1: {
                                    this.sslEngineCloseFuture.setClosed();
                                    ** break;
lbl32:
                                    // 1 sources

                                    break block26;
                                }
                                ** case 2:
lbl34:
                                // 1 sources

                                continue block26;
                                ** default:
lbl36:
                                // 1 sources

                                break block26;
                            }
                        }
                        finally {
                            outAppBuf.flip();
                            if (outAppBuf.hasRemaining()) {
                                if (nettyOutAppBuf == null) {
                                    factory = ctx.getChannel().getConfig().getBufferFactory();
                                    nettyOutAppBuf = factory.getBuffer(initialNettyOutAppBufCapacity);
                                }
                                nettyOutAppBuf.writeBytes(outAppBuf);
                            }
                            outAppBuf.clear();
                            continue;
                        }
                        break;
                    }
                    handshakeStatus = result.getHandshakeStatus();
                    this.handleRenegotiation(handshakeStatus);
                    switch (7.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[handshakeStatus.ordinal()]) {
                        case 2: {
                            break;
                        }
                        case 1: {
                            this.wrapNonAppData(ctx, channel);
                            break;
                        }
                        case 3: {
                            this.runDelegatedTasks();
                            break;
                        }
                        case 4: {
                            this.setHandshakeSuccess(channel);
                            needsWrap = true;
                            continue block25;
                        }
                        case 5: {
                            if (this.setHandshakeSuccessIfStillHandshaking(channel)) {
                                needsWrap = true;
                                continue block25;
                            }
                            if (!this.writeBeforeHandshakeDone) break;
                            this.writeBeforeHandshakeDone = false;
                            needsWrap = true;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)handshakeStatus);
                        }
                    }
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW || result.bytesConsumed() == 0 && result.bytesProduced() == 0) {
                        if (nioInNetBuf.hasRemaining() && !this.engine.isInboundDone()) {
                            SslHandler.logger.warn("Unexpected leftover data after SSLEngine.unwrap(): status=" + (Object)result.getStatus() + " handshakeStatus=" + (Object)result.getHandshakeStatus() + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced() + " remaining=" + nioInNetBuf.remaining() + " data=" + ChannelBuffers.hexDump(ChannelBuffers.wrappedBuffer(nioInNetBuf)));
                        }
                        break;
                    }
                }
            }
            if (needsWrap && !Thread.holdsLock(this.handshakeLock) && !this.pendingEncryptedWritesLock.isHeldByCurrentThread()) {
                this.wrap(ctx, channel);
            }
        }
        catch (SSLException e) {
            this.setHandshakeFailure(channel, e);
            throw e;
        }
        finally {
            this.bufferPool.releaseBuffer(nioOutAppBuf);
        }
        if (nettyOutAppBuf != null && nettyOutAppBuf.readable()) {
            return nettyOutAppBuf;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRenegotiation(SSLEngineResult.HandshakeStatus handshakeStatus) {
        Object object = this.handshakeLock;
        synchronized (object) {
            boolean renegotiate;
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                return;
            }
            if (!this.handshaken) {
                return;
            }
            if (this.handshaking) {
                return;
            }
            if (this.engine.isInboundDone() || this.engine.isOutboundDone()) {
                return;
            }
            if (this.isEnableRenegotiation()) {
                renegotiate = true;
            } else {
                renegotiate = false;
                this.handshaking = true;
            }
            if (renegotiate) {
                this.handshake();
            } else {
                Channels.fireExceptionCaught(this.ctx, (Throwable)new SSLException("renegotiation attempted by peer; closing the connection"));
                Channels.close(this.ctx, Channels.succeededFuture(this.ctx.getChannel()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDelegatedTasks() {
        while (true) {
            Runnable task;
            Object object = this.handshakeLock;
            synchronized (object) {
                task = this.engine.getDelegatedTask();
            }
            if (task == null) break;
            task.run();
        }
    }

    private boolean setHandshakeSuccessIfStillHandshaking(Channel channel) {
        if (this.handshaking && !this.handshakeFuture.isDone()) {
            this.setHandshakeSuccess(channel);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeSuccess(Channel channel) {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.handshaking = false;
            this.handshaken = true;
            if (this.handshakeFuture == null) {
                this.handshakeFuture = Channels.future(channel);
            }
            this.cancelHandshakeTimeout();
        }
        if (logger.isDebugEnabled()) {
            logger.debug(channel + " HANDSHAKEN: " + this.engine.getSession().getCipherSuite());
        }
        this.handshakeFuture.setSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailure(Channel channel, SSLException cause) {
        Object object = this.handshakeLock;
        synchronized (object) {
            block8: {
                if (!this.handshaking) {
                    return;
                }
                this.handshaking = false;
                this.handshaken = false;
                if (this.handshakeFuture == null) {
                    this.handshakeFuture = Channels.future(channel);
                }
                this.cancelHandshakeTimeout();
                this.engine.closeOutbound();
                try {
                    this.engine.closeInbound();
                }
                catch (SSLException e) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("SSLEngine.closeInbound() raised an exception after a handshake failure.", e);
                }
            }
        }
        this.handshakeFuture.setFailure(cause);
        if (this.closeOnSslException) {
            Channels.close(this.ctx, Channels.future(channel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundAndChannel(final ChannelHandlerContext context, final ChannelStateEvent e) {
        if (!e.getChannel().isConnected()) {
            context.sendDownstream(e);
            return;
        }
        if (!CLOSED_OUTBOUND_AND_CHANNEL_UPDATER.compareAndSet(this, 0, 1)) {
            e.getChannel().getCloseFuture().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    context.sendDownstream(e);
                }
            });
            return;
        }
        boolean passthrough = true;
        try {
            block12: {
                try {
                    this.unwrapNonAppData(this.ctx, e.getChannel(), false);
                }
                catch (SSLException ex) {
                    if (!logger.isDebugEnabled()) break block12;
                    logger.debug("Failed to unwrap before sending a close_notify message", ex);
                }
            }
            if (!this.engine.isOutboundDone() && SENT_CLOSE_NOTIFY_UPDATER.compareAndSet(this, 0, 1)) {
                this.engine.closeOutbound();
                try {
                    ChannelFuture closeNotifyFuture = this.wrapNonAppData(context, e.getChannel());
                    closeNotifyFuture.addListener(new ClosingChannelFutureListener(context, e));
                    passthrough = false;
                }
                catch (SSLException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed to encode a close_notify message", ex);
                    }
                }
            }
        }
        finally {
            if (passthrough) {
                context.sendDownstream(e);
            }
        }
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        super.beforeAdd(ctx);
        this.ctx = ctx;
    }

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        MessageEvent ev;
        PendingWrite pw;
        this.closeEngine();
        IOException cause = null;
        while ((pw = this.pendingUnencryptedWrites.poll()) != null) {
            if (cause == null) {
                cause = new IOException("Unable to write data");
            }
            pw.future.setFailure(cause);
        }
        while ((ev = this.pendingEncryptedWrites.poll()) != null) {
            if (cause == null) {
                cause = new IOException("Unable to write data");
            }
            ev.getFuture().setFailure(cause);
        }
        if (cause != null) {
            Channels.fireExceptionCaughtLater(ctx, (Throwable)cause);
        }
    }

    @Override
    public void channelConnected(final ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
        if (this.issueHandshake) {
            this.handshake().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ctx.sendUpstream(e);
                    }
                }
            });
        } else {
            super.channelConnected(ctx, e);
        }
    }

    @Override
    public void channelClosed(final ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.getPipeline().execute(new Runnable(){

            @Override
            public void run() {
                if (!SslHandler.this.pendingUnencryptedWritesLock.tryLock()) {
                    return;
                }
                ArrayList<ChannelFuture> futures = null;
                try {
                    MessageEvent ev;
                    PendingWrite pw;
                    while ((pw = (PendingWrite)SslHandler.this.pendingUnencryptedWrites.poll()) != null) {
                        if (futures == null) {
                            futures = new ArrayList<ChannelFuture>();
                        }
                        futures.add(pw.future);
                    }
                    while ((ev = (MessageEvent)SslHandler.this.pendingEncryptedWrites.poll()) != null) {
                        if (futures == null) {
                            futures = new ArrayList();
                        }
                        futures.add(ev.getFuture());
                    }
                }
                finally {
                    SslHandler.this.pendingUnencryptedWritesLock.unlock();
                }
                if (futures != null) {
                    ClosedChannelException cause = new ClosedChannelException();
                    int size = futures.size();
                    for (int i = 0; i < size; ++i) {
                        ((ChannelFuture)futures.get(i)).setFailure(cause);
                    }
                    Channels.fireExceptionCaught(ctx, (Throwable)cause);
                }
            }
        });
        super.channelClosed(ctx, e);
    }

    static {
        SENT_FIRST_MESSAGE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SslHandler.class, "sentFirstMessage");
        SENT_CLOSE_NOTIFY_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SslHandler.class, "sentCloseNotify");
        CLOSED_OUTBOUND_AND_CHANNEL_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SslHandler.class, "closedOutboundAndChannel");
    }

    private final class SSLEngineInboundCloseFuture
    extends DefaultChannelFuture {
        SSLEngineInboundCloseFuture() {
            super(null, true);
        }

        void setClosed() {
            super.setSuccess();
        }

        @Override
        public Channel getChannel() {
            if (SslHandler.this.ctx == null) {
                return null;
            }
            return SslHandler.this.ctx.getChannel();
        }

        @Override
        public boolean setSuccess() {
            return false;
        }

        @Override
        public boolean setFailure(Throwable cause) {
            return false;
        }
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext context;
        private final ChannelStateEvent e;

        ClosingChannelFutureListener(ChannelHandlerContext context, ChannelStateEvent e) {
            this.context = context;
            this.e = e;
        }

        @Override
        public void operationComplete(ChannelFuture closeNotifyFuture) throws Exception {
            if (!(closeNotifyFuture.getCause() instanceof ClosedChannelException)) {
                Channels.close(this.context, this.e.getFuture());
            } else {
                this.e.getFuture().setSuccess();
            }
        }
    }

    private static final class PendingWrite {
        final ChannelFuture future;
        final ByteBuffer outAppBuf;

        PendingWrite(ChannelFuture future, ByteBuffer outAppBuf) {
            this.future = future;
            this.outAppBuf = outAppBuf;
        }
    }
}

