/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.ai.langchain4j;

import de.qfs.apps.qftest.ai.langchain4j.a;
import de.qfs.apps.qftest.shared.ExternalClassWrapperHelper;
import de.qfs.apps.qftest.shared.ai.AIModel;
import de.qfs.apps.qftest.shared.ai.c;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.webapi.TrustAllManager;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.AuthenticationException;
import dev.langchain4j.exception.ModelNotFoundException;
import dev.langchain4j.exception.RateLimitException;
import dev.langchain4j.exception.UnresolvedModelServerException;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.jdk.JdkHttpClientBuilder;
import dev.langchain4j.model.anthropic.AnthropicChatModel;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.chat.DisabledChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.googleai.GoogleAiGeminiChatModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import java.net.http.HttpClient;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class LangChain4JHelperImpl
extends ExternalClassWrapperHelper
implements a {
    private static final QFLogger c = new QFLogger("de.qfs.apps.qftest.ai.langchain4j.LangChain4JHelperImpl");

    @Override
    public AIModel.AIExecutionResult a(AIModel.ModelConfiguration modelConfiguration, String string, AIModel.RequestParameters requestParameters) throws TestException {
        if (LangChain4JHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "exec(ModelConfiguration,String,RequestParameters)", 63).addDetail("model", (Object)modelConfiguration)).addDetail("message", string)).addDetail("requestParameters", (Object)requestParameters)).log();
        }
        ChatRequestParameters chatRequestParameters = this.a(requestParameters, modelConfiguration.getModelName());
        try {
            JdkHttpClientBuilder jdkHttpClientBuilder = this.a(requestParameters);
            DisabledChatModel disabledChatModel = switch (modelConfiguration.getProvider()) {
                case de.qfs.apps.qftest.shared.ai.c.a -> OpenAiChatModel.builder().httpClientBuilder((HttpClientBuilder)jdkHttpClientBuilder).baseUrl(modelConfiguration.getBaseUrl()).apiKey(modelConfiguration.getApiKey()).defaultRequestParameters(chatRequestParameters).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).timeout(requestParameters.getTimeout()).build();
                case de.qfs.apps.qftest.shared.ai.c.b -> AnthropicChatModel.builder().httpClientBuilder((HttpClientBuilder)jdkHttpClientBuilder).baseUrl(modelConfiguration.getBaseUrl()).apiKey(modelConfiguration.getApiKey()).defaultRequestParameters(chatRequestParameters).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).timeout(requestParameters.getTimeout()).build();
                case de.qfs.apps.qftest.shared.ai.c.c -> GoogleAiGeminiChatModel.builder().httpClientBuilder((HttpClientBuilder)jdkHttpClientBuilder).baseUrl(modelConfiguration.getBaseUrl()).apiKey(modelConfiguration.getApiKey()).defaultRequestParameters(chatRequestParameters).logRequestsAndResponses(Boolean.valueOf(true)).timeout(requestParameters.getTimeout()).build();
                case de.qfs.apps.qftest.shared.ai.c.d -> ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().httpClientBuilder((HttpClientBuilder)jdkHttpClientBuilder)).baseUrl(modelConfiguration.getBaseUrl())).defaultRequestParameters(chatRequestParameters)).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).timeout(requestParameters.getTimeout())).build();
                default -> new DisabledChatModel();
            };
            ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)string)}).parameters(chatRequestParameters).build();
            ChatResponse chatResponse = disabledChatModel.chat(chatRequest);
            return this.a(chatResponse);
        }
        catch (UnresolvedModelServerException unresolvedModelServerException) {
            throw new TestException("Could not resolve model server address", "aiUnresolvedModelServerError", (Object[])new String[]{modelConfiguration.getBaseUrl(), unresolvedModelServerException.getMessage()}, (Throwable)unresolvedModelServerException);
        }
        catch (AuthenticationException authenticationException) {
            throw new TestException("Not authorized to access LLM", "aiAuthenticationError", (Object[])new String[]{authenticationException.getMessage()}, (Throwable)authenticationException);
        }
        catch (RateLimitException rateLimitException) {
            throw new TestException("LLM request rate limited", "aiRateLimitedError", (Object[])new String[]{rateLimitException.getMessage()}, (Throwable)rateLimitException);
        }
        catch (ModelNotFoundException modelNotFoundException) {
            if (modelNotFoundException.getMessage().contains("\"Not Found\"")) {
                throw new TestException("LLM model not found, base URL may be incorrect", "aiNotFoundError", (Object[])new String[]{modelConfiguration.getBaseUrl(), modelNotFoundException.getMessage()}, (Throwable)modelNotFoundException);
            }
            throw new TestException("LLM model not found, check model name", "aiModelNotFoundError", (Object[])new String[]{modelConfiguration.getModelName(), modelNotFoundException.getMessage(), this.a(modelConfiguration.getProvider()).toString()}, (Throwable)modelNotFoundException);
        }
        catch (Exception exception) {
            throw new TestException("LLM execution error", "aiCheckExecutionError", (Object[])new String[]{exception.getMessage()}, (Throwable)exception);
        }
    }

    @Override
    public List a(c c2) {
        if (LangChain4JHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "modelNames(AIProvider)", 158).addDetail("provider", (Object)c2)).log();
        }
        return switch (c2) {
            case de.qfs.apps.qftest.shared.ai.c.a -> Arrays.stream(OpenAiChatModelName.values()).map(Object::toString).toList();
            case de.qfs.apps.qftest.shared.ai.c.b -> Arrays.stream(AnthropicChatModelName.values()).map(Objects::toString).toList();
            case de.qfs.apps.qftest.shared.ai.c.c -> Misc.listOf((Object[])new String[]{"gemini-2.0-flash", "gemini-1.5-flash", "gemini-1.5-pro", "gemini-1.0-pro"});
            case de.qfs.apps.qftest.shared.ai.c.d -> Misc.listOf((Object[])new String[]{"tinydolphin", "llama3.2"});
            default -> new ArrayList();
        };
    }

    private ChatRequestParameters a(AIModel.RequestParameters requestParameters, String string) {
        if (LangChain4JHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "toChatRequestParameters(RequestParameters,String)", 171).addDetail("parameters", (Object)requestParameters)).addDetail("modelName", string)).log();
        }
        return ChatRequestParameters.builder().topP(requestParameters.getTopP()).topK(requestParameters.getTopK()).modelName(string).frequencyPenalty(requestParameters.getFrequencyPenalty()).presencePenalty(requestParameters.getPresencePenalty()).temperature(requestParameters.getTemperature()).maxOutputTokens(requestParameters.getMaxOutputTokens()).stopSequences(requestParameters.getStopSequences()).build();
    }

    private AIModel.AIExecutionResult a(ChatResponse chatResponse) {
        Object object;
        if (LangChain4JHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "toResult(ChatResponse)", 190).addDetail("response", (Object)chatResponse)).log();
        }
        if ((object = chatResponse.aiMessage().text()) == null && !Misc.emptyOrNull((Object)chatResponse.metadata().finishReason())) {
            object = "[No text content returned by LLM. Finish reason: " + String.valueOf(chatResponse.metadata().finishReason()) + "]";
        }
        return new AIModel.AIExecutionResult(object, chatResponse.toString().replaceAll("\\s*\\{\\s*", "\n{\n").replaceAll("\\s*}\\s*", "\n}\n").replaceAll("\\s*\\[\\s*", "\n[\n").replaceAll("\\s*]\\s*", "\n]\n").replaceAll(",\\s*", ",\n").replaceAll("}\\s*,", "},").replaceAll("]\\s*,", "],").replaceAll("\\{\\s*}", "{}").replaceAll("\\[\\s*]", "[]").replaceAll("\\s*=\\s*", " = ").replaceAll("\\s*=\\s*\\[]", " = []").replaceAll("\\s*=\\s*\\{}", " = {}").replaceAll("\n+", "\n"));
    }

    private JdkHttpClientBuilder a(AIModel.RequestParameters requestParameters) {
        JdkHttpClientBuilder jdkHttpClientBuilder;
        block4: {
            if (LangChain4JHelperImpl.c.level >= 7) {
                ((LevelAwareLogBuilder)c.lvlBuild(7, "buildHttpClientBuilder(RequestParameters)", 215).addDetail("requestParameters", (Object)requestParameters)).log();
            }
            jdkHttpClientBuilder = new JdkHttpClientBuilder();
            jdkHttpClientBuilder.connectTimeout(requestParameters.getTimeout());
            jdkHttpClientBuilder.readTimeout(requestParameters.getTimeout());
            if (requestParameters.isDisableSSLVerification()) {
                try {
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
                    HttpClient.Builder builder = HttpClient.newBuilder().sslContext(sSLContext);
                    jdkHttpClientBuilder.httpClientBuilder(builder);
                }
                catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
                    if (LangChain4JHelperImpl.c.level < 1) break block4;
                    ((LevelAwareLogBuilder)c.lvlBuild(1, "buildHttpClientBuilder(RequestParameters)", 228).add("e", (Object)generalSecurityException)).log();
                }
            }
        }
        return jdkHttpClientBuilder;
    }
}

