/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.daemon;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.start.QFSslRMIClientSocketFactory;
import de.qfs.apps.qftest.start.X509StoreSocketHelper;
import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.LinkedList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class DaemonSocketInitializer {
    private static final QFLogger k = new QFLogger("de.qfs.apps.qftest.daemon.DaemonSocketInitializer");
    protected static final String a = "daemon.keystore";
    protected static final String b = "123456";
    final Collection c = new LinkedList();
    final Collection d = new LinkedList();
    String e;
    String f;
    String g;
    String h;
    boolean i = false;

    public DaemonSocketInitializer setup() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "setup()", 106).log();
        }
        if ("".equals(this.e)) {
            this.a();
            return this;
        }
        X509StoreSocketHelper x509StoreSocketHelper = this.getStoreHelper();
        if (DaemonSocketInitializer.k.level >= 9) {
            ((LevelAwareLogBuilder)k.lvlBuild(9, "setup()", 115).add("storeHelper", (Object)x509StoreSocketHelper)).log();
        }
        if (x509StoreSocketHelper != null) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
                KeyManager[] keyManagerArray = x509StoreSocketHelper.getKeyManagers();
                TrustManager[] trustManagerArray = x509StoreSocketHelper.getTrustManagers();
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                Globals.addGlobal((Option)new Option("daemonserversocketfactory", (Object)new SslRMIServerSocketFactory(sSLContext, null, new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"}, true)));
                Globals.addGlobal((Option)new Option("daemonsslcontext", (Object)sSLContext));
                Globals.addGlobal((Option)new Option("daemonclientsocketfactory", (Object)new QFSslRMIClientSocketFactory()));
            }
            catch (Throwable throwable) {
                if (DaemonSocketInitializer.k.level >= 1) {
                    ((LevelAwareLogBuilder)k.lvlBuild(1, "setup()", 127).add("ex", (Object)throwable)).log();
                }
                String string = x509StoreSocketHelper.getKeyManagerData().getStoreFile();
                this.d.add(new Message.ParameterizedResource("cannotReadKeystore", new String[]{string}));
            }
        } else {
            this.c.add("no daemon keystore");
        }
        return this;
    }

    public X509StoreSocketHelper getStoreHelper() {
        Object object;
        String string;
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "getStoreHelper()", 141).log();
        }
        X509StoreSocketHelper.StoreData storeData = new X509StoreSocketHelper.StoreData("", "");
        X509StoreSocketHelper x509StoreSocketHelper = new X509StoreSocketHelper();
        x509StoreSocketHelper.setKeyManagerData(storeData);
        assert (storeData != null);
        if (this.e != null) {
            if (DaemonSocketInitializer.k.level >= 9) {
                ((LevelAwareLogBuilder)k.lvlBuild(9, "getStoreHelper()", 152).add("keystore", this.e)).log();
            }
            storeData.setStoreFile(this.e);
        } else {
            string = System.getProperty("javax.net.ssl.keyStore");
            if (string != null && !"NONE".equalsIgnoreCase(string)) {
                if (DaemonSocketInitializer.k.level >= 9) {
                    ((LevelAwareLogBuilder)k.lvlBuild(9, "getStoreHelper()", 155).add("prop", string)).log();
                }
                storeData.setStoreFile(string);
            } else {
                object = this.b();
                if (DaemonSocketInitializer.k.level >= 9) {
                    ((LevelAwareLogBuilder)k.lvlBuild(9, "getStoreHelper()", 159).add("defaultKeystoreFile", object)).log();
                }
                if (object != null) {
                    String string2 = Misc.getBestPath((File)object);
                    storeData.setStoreFile(string2);
                } else {
                    if (DaemonSocketInitializer.k.level >= 3) {
                        ((LevelAwareLogBuilder)k.lvlBuild(3, "getStoreHelper()", 165).add("No daemon.keystore found to use.")).log();
                    }
                    x509StoreSocketHelper = null;
                }
            }
        }
        if (DaemonSocketInitializer.k.level >= 9) {
            ((LevelAwareLogBuilder)k.lvlBuild(9, "getStoreHelper()", 171).add("storeHelper", (Object)x509StoreSocketHelper)).log();
        }
        if (x509StoreSocketHelper != null) {
            this.c.add("daemon keystore file: " + storeData.getStoreFile());
            if (this.f != null) {
                storeData.setPassword(this.f);
            } else {
                string = System.getProperty("javax.net.ssl.keyStorePassword");
                if (string != null) {
                    storeData.setPassword(string);
                } else {
                    storeData.setPassword(b);
                }
            }
            object = storeData.clone();
            x509StoreSocketHelper.setTrustManagerData((X509StoreSocketHelper.StoreData)object);
            assert (object != null);
            if (this.g != null) {
                ((X509StoreSocketHelper.StoreData)object).setStoreFile(this.g);
            } else {
                string = System.getProperty("javax.net.ssl.trustStore");
                if (string != null && !"NONE".equalsIgnoreCase(string)) {
                    ((X509StoreSocketHelper.StoreData)object).setStoreFile(string);
                }
            }
            if (this.h != null) {
                ((X509StoreSocketHelper.StoreData)object).setPassword(this.h);
            } else {
                string = System.getProperty("javax.net.ssl.trustStorePassword");
                if (string != null) {
                    ((X509StoreSocketHelper.StoreData)object).setPassword(string);
                }
            }
            assert (x509StoreSocketHelper.getKeyManagerData() != null);
            assert (x509StoreSocketHelper.getTrustManagerData() != null);
        }
        return x509StoreSocketHelper;
    }

    protected DaemonSocketInitializer a() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "reset()", 214).log();
        }
        Globals.removeGlobal((String)"daemonserversocketfactory");
        Globals.removeGlobal((String)"daemonsslcontext");
        Globals.removeGlobal((String)"daemonclientsocketfactory");
        return this;
    }

    protected File b() {
        LinkedList<Object> linkedList;
        block11: {
            if (DaemonSocketInitializer.k.level >= 7) {
                k.lvlBuild(7, "getDefaultKeystoreFile()", 226).log();
            }
            File file = Util.getTopicFile((String)a, null, (Util.FileState)Util.FileState.EXISTS, (Util.LocationPreference)Util.LocationPreference.PREFER_SYSTEM_DIR);
            if (DaemonSocketInitializer.k.level >= 9) {
                ((LevelAwareLogBuilder)k.lvlBuild(9, "getDefaultKeystoreFile()", 230).add("keystoreFile", (Object)file)).log();
            }
            if (file != null) {
                return file;
            }
            if (!this.i) {
                if (DaemonSocketInitializer.k.level >= 9) {
                    ((LevelAwareLogBuilder)k.lvlBuild(9, "getDefaultKeystoreFile()", 235).add("Not looking at other places for daemon keystore")).log();
                }
                return null;
            }
            linkedList = new LinkedList<Object>();
            String string = Misc.getFilenameOfClass(DaemonSocketInitializer.class);
            if (DaemonSocketInitializer.k.level >= 9) {
                ((LevelAwareLogBuilder)k.lvlBuild(9, "getDefaultKeystoreFile()", 242).add("filenameOfClass", string)).log();
            }
            if (string != null) {
                try {
                    File file2 = new File(string).getParentFile();
                    linkedList.add(file2.getParentFile());
                    linkedList.add(file2);
                }
                catch (NullPointerException nullPointerException) {
                    if (DaemonSocketInitializer.k.level < 5) break block11;
                    ((LevelAwareLogBuilder)k.lvlBuild(5, "getDefaultKeystoreFile()", 249).add("ex", (Object)nullPointerException)).log();
                }
            }
        }
        linkedList.add(new File("."));
        for (File file : linkedList) {
            File file3 = new File(file, a);
            boolean bl2 = file3.exists();
            if (DaemonSocketInitializer.k.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)k.lvlBuild(9, "getDefaultKeystoreFile()", 256).add("candidate", (Object)file3)).add("exists", bl2)).log();
            }
            if (!bl2) continue;
            return file3;
        }
        return null;
    }

    public Collection getMessages() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "getMessages()", 76).log();
        }
        return this.c;
    }

    public Collection getErrors() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "getErrors()", 77).log();
        }
        return this.d;
    }

    public String getKeystore() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "getKeystore()", 79).log();
        }
        return this.e;
    }

    public String getKeypass() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "getKeypass()", 80).log();
        }
        return this.f;
    }

    public String getTruststore() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "getTruststore()", 82).log();
        }
        return this.g;
    }

    public String getTrustpass() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "getTrustpass()", 83).log();
        }
        return this.h;
    }

    public boolean isExtendedDefaultKeystoreSearch() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "isExtendedDefaultKeystoreSearch()", 94).log();
        }
        return this.i;
    }

    public DaemonSocketInitializer setKeystore(String string) {
        if (DaemonSocketInitializer.k.level >= 7) {
            ((LevelAwareLogBuilder)k.lvlBuild(7, "setKeystore(String)", 54).addDetail("keystore", string)).log();
        }
        this.e = string;
        return this;
    }

    public DaemonSocketInitializer setKeypass(String string) {
        if (DaemonSocketInitializer.k.level >= 7) {
            ((LevelAwareLogBuilder)k.lvlBuild(7, "setKeypass(String)", 54).addDetail("keypass", string)).log();
        }
        this.f = string;
        return this;
    }

    public DaemonSocketInitializer setTruststore(String string) {
        if (DaemonSocketInitializer.k.level >= 7) {
            ((LevelAwareLogBuilder)k.lvlBuild(7, "setTruststore(String)", 54).addDetail("truststore", string)).log();
        }
        this.g = string;
        return this;
    }

    public DaemonSocketInitializer setTrustpass(String string) {
        if (DaemonSocketInitializer.k.level >= 7) {
            ((LevelAwareLogBuilder)k.lvlBuild(7, "setTrustpass(String)", 54).addDetail("trustpass", string)).log();
        }
        this.h = string;
        return this;
    }

    public DaemonSocketInitializer setExtendedDefaultKeystoreSearch(boolean bl2) {
        if (DaemonSocketInitializer.k.level >= 7) {
            ((LevelAwareLogBuilder)k.lvlBuild(7, "setExtendedDefaultKeystoreSearch(boolean)", 54).addDetail("extendedDefaultKeystoreSearch", bl2)).log();
        }
        this.i = bl2;
        return this;
    }

    public boolean equals(Object object) {
        if (DaemonSocketInitializer.k.level >= 7) {
            ((LevelAwareLogBuilder)k.lvlBuild(7, "equals(Object)", 54).addDetail("o", object)).log();
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof DaemonSocketInitializer)) {
            return false;
        }
        DaemonSocketInitializer daemonSocketInitializer = (DaemonSocketInitializer)object;
        if (!daemonSocketInitializer.a(this)) {
            return false;
        }
        if (this.isExtendedDefaultKeystoreSearch() != daemonSocketInitializer.isExtendedDefaultKeystoreSearch()) {
            return false;
        }
        Collection collection = this.getMessages();
        Collection collection2 = daemonSocketInitializer.getMessages();
        if (collection == null ? collection2 != null : !((Object)collection).equals(collection2)) {
            return false;
        }
        Collection collection3 = this.getErrors();
        Collection collection4 = daemonSocketInitializer.getErrors();
        if (collection3 == null ? collection4 != null : !((Object)collection3).equals(collection4)) {
            return false;
        }
        String string = this.getKeystore();
        String string2 = daemonSocketInitializer.getKeystore();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getKeypass();
        String string4 = daemonSocketInitializer.getKeypass();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getTruststore();
        String string6 = daemonSocketInitializer.getTruststore();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getTrustpass();
        String string8 = daemonSocketInitializer.getTrustpass();
        return !(string7 == null ? string8 != null : !string7.equals(string8));
    }

    protected boolean a(Object object) {
        if (DaemonSocketInitializer.k.level >= 7) {
            ((LevelAwareLogBuilder)k.lvlBuild(7, "canEqual(Object)", 54).addDetail("other", object)).log();
        }
        return object instanceof DaemonSocketInitializer;
    }

    public int hashCode() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "hashCode()", 54).log();
        }
        int n2 = 1;
        n2 = n2 * 59 + (this.isExtendedDefaultKeystoreSearch() ? 79 : 97);
        Collection collection = this.getMessages();
        n2 = n2 * 59 + (collection == null ? 43 : ((Object)collection).hashCode());
        Collection collection2 = this.getErrors();
        n2 = n2 * 59 + (collection2 == null ? 43 : ((Object)collection2).hashCode());
        String string = this.getKeystore();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getKeypass();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getTruststore();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getTrustpass();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        return n2;
    }

    public String toString() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "toString()", 54).log();
        }
        return "DaemonSocketInitializer(messages=" + String.valueOf(this.getMessages()) + ", errors=" + String.valueOf(this.getErrors()) + ", keystore=" + this.getKeystore() + ", keypass=" + this.getKeypass() + ", truststore=" + this.getTruststore() + ", trustpass=" + this.getTrustpass() + ", extendedDefaultKeystoreSearch=" + this.isExtendedDefaultKeystoreSearch() + ")";
    }

    public DaemonSocketInitializer(String string, String string2, String string3, String string4, boolean bl2) {
        if (DaemonSocketInitializer.k.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)k.lvlBuild(7, "DaemonSocketInitializer(String,String,String,String,boolean)", 55).addDetail("keystore", string)).addDetail("keypass", string2)).addDetail("truststore", string3)).addDetail("trustpass", string4)).addDetail("extendedDefaultKeystoreSearch", bl2)).log();
        }
        this.e = string;
        this.f = string2;
        this.g = string3;
        this.h = string4;
        this.i = bl2;
    }

    public DaemonSocketInitializer() {
        if (DaemonSocketInitializer.k.level >= 7) {
            k.lvlBuild(7, "DaemonSocketInitializer()", 56).log();
        }
    }
}

