/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.extras;

import de.qfs.apps.qftest.shared.exceptions.UserException;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.CommentLineStrippingInputStream;
import de.qfs.lib.util.Misc;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MobileDeviceInfo {
    private static final QFLogger g = new QFLogger("de.qfs.apps.qftest.extras.MobileDeviceInfo");
    private static final String h = "[\n          {\n            \"title\": \"default\",\n            \"orientation\": \"vertical\"\n          },\n          {\n            \"title\": \"default\",\n            \"orientation\": \"horizontal\"\n          }\n        ]";
    public static final String CUSTOM_NAME = "Custom";
    static final Pattern a = Pattern.compile("([^/]+ )(?:([^/]+)/)?(?:([^/]+)/)?(?:([^/]+)/)?([^/ ]+)( .+)?");
    static final Pattern b = Pattern.compile("\\s*(\\d+)\\s*,?\\s*(\\d+)?\\s*,?\\s*(\\d+)?\\s*,?\\s*(\\d+)?");
    private static final AtomicReference i = new AtomicReference();
    final String c;
    final JsonObject d;
    String e = "vertical";
    @Nullable
    String f;

    public void setOrientation(String string) {
        if (MobileDeviceInfo.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "setOrientation(String)", 85).addDetail("orientation", string)).log();
        }
        this.e = Misc.emptyOrNull((String)string) ? "vertical" : string;
    }

    public void setInsetsTitle(String string) {
        if (MobileDeviceInfo.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "setInsetsTitle(String)", 92).addDetail("insetsTitle", string)).log();
        }
        this.f = Misc.emptyOrNull((String)string) || string.equalsIgnoreCase("false") || string.equals("0") ? null : (string.equalsIgnoreCase("true") || string.equals("1") ? "default" : string);
        this.c();
    }

    public int getWidth() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "getWidth()", 107).log();
        }
        JsonObject jsonObject = this.c();
        return this.b().getInt("width", 200) - jsonObject.getInt("left", 0) - jsonObject.getInt("right", 0);
    }

    public int getHeight() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "getHeight()", 116).log();
        }
        JsonObject jsonObject = this.c();
        return this.b().getInt("height", 400) - jsonObject.getInt("top", 0) - jsonObject.getInt("bottom", 0);
    }

    public double getPixelRatio() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "getPixelRatio()", 125).log();
        }
        return this.a().getDouble("device-pixel-ratio", 1.0);
    }

    public String getUserAgent() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "getUserAgent()", 133).log();
        }
        return this.d.getString("user-agent", "");
    }

    JsonObject a() {
        JsonObject jsonObject;
        block6: {
            if (MobileDeviceInfo.g.level >= 7) {
                g.lvlBuild(7, "getScreenData()", 143).log();
            }
            jsonObject = null;
            try {
                jsonObject = this.d.getObject("screen");
            }
            catch (NullPointerException nullPointerException) {
                if (MobileDeviceInfo.g.level < 5) break block6;
                ((LevelAwareLogBuilder)g.lvlBuild(5, "getScreenData()", 149).add("ex", (Object)nullPointerException)).log();
            }
        }
        if (jsonObject == null) {
            throw new UserException(String.format("For the %s device, no screen data could be found.", this.c));
        }
        return jsonObject;
    }

    JsonObject b() {
        JsonObject jsonObject;
        block6: {
            if (MobileDeviceInfo.g.level >= 7) {
                g.lvlBuild(7, "getOrientedScreenData()", 162).log();
            }
            jsonObject = null;
            try {
                jsonObject = this.a().getObject(this.e);
            }
            catch (NullPointerException nullPointerException) {
                if (MobileDeviceInfo.g.level < 5) break block6;
                ((LevelAwareLogBuilder)g.lvlBuild(5, "getOrientedScreenData()", 168).add("ex", (Object)nullPointerException)).log();
            }
        }
        if (jsonObject == null) {
            throw new UserException(String.format("For the %s device, no screen data for %s orientation could be found.", this.c, this.e));
        }
        return jsonObject;
    }

    JsonObject c() {
        LinkedHashSet<CallSite> linkedHashSet;
        JsonObject jsonObject;
        block11: {
            if (MobileDeviceInfo.g.level >= 7) {
                g.lvlBuild(7, "getInsets()", 182).log();
            }
            if (this.f == null) {
                return new JsonObject();
            }
            jsonObject = null;
            Matcher matcher = b.matcher(this.f);
            if (matcher.matches()) {
                jsonObject = new JsonObject();
                String string = matcher.group(1);
                String string2 = matcher.group(2);
                String string3 = matcher.group(3);
                String string4 = matcher.group(4);
                jsonObject.add("top", Integer.parseInt(string));
                jsonObject.add("right", Integer.parseInt(Misc.emptyOrNull((String)string2) ? string : string2));
                jsonObject.add("bottom", Integer.parseInt(Misc.emptyOrNull((String)string3) ? string : string3));
                jsonObject.add("left", Integer.parseInt(Misc.emptyOrNull((String)string4) ? (Misc.emptyOrNull((String)string2) ? string : string2) : string4));
                return jsonObject;
            }
            linkedHashSet = new LinkedHashSet<CallSite>();
            try {
                this.a(this.d);
                JsonArray jsonArray = this.d.get("modes").asArray();
                for (JsonValue jsonValue : jsonArray) {
                    if (MobileDeviceInfo.g.level >= 9) {
                        ((LevelAwareLogBuilder)g.lvlBuild(9, "getInsets()", 209).add("mode", (Object)jsonValue)).log();
                    }
                    JsonObject jsonObject2 = jsonValue.asObject();
                    String string = jsonObject2.getString("title", "default");
                    linkedHashSet.add((CallSite)((Object)("  * " + string)));
                    String string5 = jsonObject2.getString("orientation", "vertical");
                    if (!string.equals(this.f) || !string5.equals(this.e)) continue;
                    jsonObject = jsonObject2.getObject("insets");
                    if (jsonObject == null) {
                        jsonObject = new JsonObject();
                    }
                    this.a("left", jsonObject);
                    this.a("top", jsonObject);
                    this.a("right", jsonObject);
                    this.a("bottom", jsonObject);
                    break;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (MobileDeviceInfo.g.level < 5) break block11;
                ((LevelAwareLogBuilder)g.lvlBuild(5, "getInsets()", 229).add("ex", (Object)nullPointerException)).log();
            }
        }
        if (jsonObject == null) {
            throw new UserException(String.format("For the %s device, no insets data width mode %s for %s orientation could be found.\n\nValid options are:\n%s", this.c, this.f, this.e, Misc.join(linkedHashSet, (String)"\n")));
        }
        return jsonObject;
    }

    private void a(JsonObject jsonObject) {
        if (MobileDeviceInfo.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "ensureModesInDeviceData(JsonObject)", 244).addDetail("deviceData2", (Object)jsonObject)).log();
        }
        if (!this.d.contains("modes")) {
            this.d.add("modes", Json.parse((String)h));
        }
    }

    private void a(String string, JsonObject jsonObject) {
        if (MobileDeviceInfo.g.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)g.lvlBuild(7, "addDefaultValueToInsetsObject(String,JsonObject)", 255).addDetail("key", string)).addDetail("insets", (Object)jsonObject)).log();
        }
        if (!jsonObject.contains(string)) {
            jsonObject.add(string, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Map d() {
        LinkedHashMap<String, MobileDeviceInfo> linkedHashMap;
        block8: {
            if (MobileDeviceInfo.g.level >= 7) {
                g.lvlBuild(7, "readDeviceData()", 264).log();
            }
            linkedHashMap = new LinkedHashMap<String, MobileDeviceInfo>();
            try {
                JsonObject jsonObject = (JsonObject)Json.parse((Reader)new InputStreamReader((InputStream)new CommentLineStrippingInputStream(MobileDeviceInfo.class.getResourceAsStream("/de/qfs/apps/qftest/resources/properties/emulated_devices.json")), "UTF-8"));
                for (JsonValue jsonValue : jsonObject.get("extensions").asArray()) {
                    JsonObject jsonObject2 = jsonValue.asObject().getObject("device");
                    String string = jsonObject2.getString("title", "");
                    LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
                    linkedHashSet.add(string);
                    Matcher matcher = a.matcher(string);
                    if (matcher.matches()) {
                        String string2 = matcher.group(1);
                        String string3 = matcher.group(matcher.groupCount());
                        if (string3 == null) {
                            String string4 = "";
                        }
                        for (int i2 = 2; i2 <= matcher.groupCount() - 1; ++i2) {
                            void var9_13;
                            String string5 = matcher.group(i2);
                            if (Misc.emptyOrNull((String)string5)) continue;
                            linkedHashSet.add((String)string2 + string5 + (String)var9_13);
                        }
                    }
                    for (String string6 : linkedHashSet) {
                        linkedHashMap.put(string6, new MobileDeviceInfo(string6, jsonObject2));
                    }
                }
            }
            catch (Exception exception) {
                if (MobileDeviceInfo.g.level < 3) break block8;
                ((LevelAwareLogBuilder)g.lvlBuild(3, "readDeviceData()", 302).add("e", (Object)exception)).log();
            }
        }
        return linkedHashMap;
    }

    public static void main(String[] stringArray) {
        if (MobileDeviceInfo.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "main(String[])", 314).addDetail("args", (Object)stringArray)).log();
        }
        String string2 = new String(new char[80]).replace("\u0000", "-");
        System.out.println(string2);
        System.out.println(MobileDeviceInfo.getDevices().keySet().stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(", ")));
        System.out.println(string2);
        System.out.format("\noption.SUTSetup.mobiledevice.name.numchoices =     %d\n", MobileDeviceInfo.getDevices().size());
        int n2 = 1;
        for (String string3 : MobileDeviceInfo.getDevices().keySet()) {
            if (string3.equals(CUSTOM_NAME)) {
                string3 = "Customized";
            }
            System.out.format("option.SUTSetup.mobiledevice.name.choice%d.label = %s\n", n2, string3);
            ++n2;
        }
        System.out.println(string2);
        System.out.format("option.SUTSetup.mobiledevice.name.choice%d.label = %s\n", n2 - 1, "Angepasst");
    }

    public MobileDeviceInfo(String string, JsonObject jsonObject) {
        if (MobileDeviceInfo.g.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)g.lvlBuild(7, "MobileDeviceInfo(String,JsonObject)", 48).addDetail("deviceName", string)).addDetail("deviceData", (Object)jsonObject)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("deviceName is marked non-null but is null");
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException("deviceData is marked non-null but is null");
        }
        this.c = string;
        this.d = jsonObject;
    }

    public String getDeviceName() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "getDeviceName()", 76).log();
        }
        return this.c;
    }

    public JsonObject getDeviceData() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "getDeviceData()", 77).log();
        }
        return this.d;
    }

    public String getOrientation() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "getOrientation()", 78).log();
        }
        return this.e;
    }

    @Nullable
    public String getInsetsTitle() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "getInsetsTitle()", 80).log();
        }
        return this.f;
    }

    public boolean equals(Object object) {
        if (MobileDeviceInfo.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "equals(Object)", 48).addDetail("o", object)).log();
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof MobileDeviceInfo)) {
            return false;
        }
        MobileDeviceInfo mobileDeviceInfo = (MobileDeviceInfo)object;
        if (!mobileDeviceInfo.a(this)) {
            return false;
        }
        String string = this.getDeviceName();
        String string2 = mobileDeviceInfo.getDeviceName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        JsonObject jsonObject = this.getDeviceData();
        JsonObject jsonObject2 = mobileDeviceInfo.getDeviceData();
        if (jsonObject == null ? jsonObject2 != null : !jsonObject.equals(jsonObject2)) {
            return false;
        }
        String string3 = this.getOrientation();
        String string4 = mobileDeviceInfo.getOrientation();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getInsetsTitle();
        String string6 = mobileDeviceInfo.getInsetsTitle();
        return !(string5 == null ? string6 != null : !string5.equals(string6));
    }

    protected boolean a(Object object) {
        if (MobileDeviceInfo.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "canEqual(Object)", 48).addDetail("other", object)).log();
        }
        return object instanceof MobileDeviceInfo;
    }

    public int hashCode() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "hashCode()", 48).log();
        }
        int n2 = 1;
        String string = this.getDeviceName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        JsonObject jsonObject = this.getDeviceData();
        n2 = n2 * 59 + (jsonObject == null ? 43 : jsonObject.hashCode());
        String string2 = this.getOrientation();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getInsetsTitle();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        return n2;
    }

    public String toString() {
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "toString()", 48).log();
        }
        return "MobileDeviceInfo(deviceName=" + this.getDeviceName() + ", deviceData=" + String.valueOf(this.getDeviceData()) + ", orientation=" + this.getOrientation() + ", insetsTitle=" + this.getInsetsTitle() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getDevices() {
        Object object;
        if (MobileDeviceInfo.g.level >= 7) {
            g.lvlBuild(7, "getDevices()", 70).log();
        }
        if ((object = i.get()) == null) {
            AtomicReference atomicReference = i;
            synchronized (atomicReference) {
                object = i.get();
                if (object == null) {
                    Map map = MobileDeviceInfo.d();
                    object = map == null ? i : map;
                    i.set(object);
                }
            }
        }
        return object == i ? null : object;
    }
}

