/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.influx.helper;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.WriteApi;
import com.influxdb.client.WriteOptions;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import com.influxdb.client.write.events.EventListener;
import com.influxdb.client.write.events.WriteErrorEvent;
import com.influxdb.exceptions.InfluxException;
import de.qfs.apps.qftest.influx.helper.InfluxObserverHelper;
import de.qfs.apps.qftest.shared.ExternalClassWrapperHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.Notification;
import de.qfs.lib.util.Misc;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class InfluxObserverHelperImpl
extends ExternalClassWrapperHelper
implements InfluxObserverHelper {
    private static final QFLogger c = new QFLogger("de.qfs.apps.qftest.influx.helper.InfluxObserverHelperImpl");
    private InfluxConnectionHandler d;

    @Override
    public boolean connectInflux(String string, String string2, String string3, String string4, String string5) {
        if (InfluxObserverHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "connectInflux(String,String,String,String,String)", 75).addDetail("host", string)).addDetail("port", string2)).addDetail("token", string3)).addDetail("org", string4)).addDetail("defaultBucket", string5)).log();
        }
        this.disconnectInflux();
        this.d = new InfluxConnectionHandler(string, string2, string3, string4, string5);
        return this.d.connect();
    }

    @Override
    public void disconnectInflux() {
        if (InfluxObserverHelperImpl.c.level >= 7) {
            c.lvlBuild(7, "disconnectInflux()", 91).log();
        }
        if (this.d == null) {
            return;
        }
        this.d.disconnect();
        this.d = null;
    }

    @Override
    public void writeDirect(Notification notification) {
        if (InfluxObserverHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "writeDirect(Notification)", 101).addDetail("notification", (Object)notification)).log();
        }
        Point point = Point.measurement((String)notification.getUserInfoValue("measurement", (Object)"detail").toString());
        if (!notification.getUserInfo().containsKey("fields")) {
            if (InfluxObserverHelperImpl.c.level >= 5) {
                ((LevelAwareLogBuilder)c.lvlBuild(5, "writeDirect(Notification)", 105).add("Missing key 'fields'")).log();
            }
            return;
        }
        Map map = InfluxObserverHelperImpl.a(notification.getUserInfoValue("fields").toString());
        if (InfluxObserverHelperImpl.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "writeDirect(Notification)", 109).add("fields", (Object)map)).log();
        }
        point.addFields(Collections.unmodifiableMap(map));
        if (notification.getUserInfo().containsKey("tags")) {
            point.addTags(InfluxObserverHelperImpl.a(notification.getUserInfoValue("tags").toString()));
        }
        if (InfluxObserverHelperImpl.c.level >= 9) {
            ((LevelAwareLogBuilder)c.lvlBuild(9, "writeDirect(Notification)", 115).add("point", (Object)point)).log();
        }
        if (notification.getUserInfo().containsKey("bucket")) {
            String string = notification.getUserInfoValue("bucket").toString();
            if (InfluxObserverHelperImpl.c.level >= 9) {
                ((LevelAwareLogBuilder)c.lvlBuild(9, "writeDirect(Notification)", 119).add("bucket", string)).log();
            }
            this.d.write(string, point);
        } else {
            this.d.write(point);
        }
    }

    @Override
    public void writeRunStarted(Notification notification) {
        block7: {
            if (InfluxObserverHelperImpl.c.level >= 7) {
                ((LevelAwareLogBuilder)c.lvlBuild(7, "writeRunStarted(Notification)", 129).addDetail("notification", (Object)notification)).log();
            }
            try {
                Point point = Point.measurement((String)"start");
                point.time(Long.valueOf((Long)notification.getUserInfoValue("timestamp", (Object)Float.valueOf(0.0f))), WritePrecision.MS);
                point.addField("dummy", 0L);
                String string = notification.getUserInfoValue("id", (Object)"").toString();
                point.addTag("id", string);
                Object object = notification.getUserInfoValue("suite", (Object)"");
                if (object != null) {
                    point.addTag("suite", object.toString());
                }
                if ((object = notification.getUserInfoValue("author", (Object)"")) != null) {
                    point.addTag("author", object.toString());
                }
                if ((object = notification.getUserInfoValue("runid", (Object)"")) != null) {
                    point.addTag("runid", object.toString());
                }
                point.addTag("os", Misc.OS_IS_WINDOWS ? "windows" : (Misc.OS_IS_LINUX ? "linux" : "macos"));
                point.addTag("machine", InfluxObserverHelperImpl.a());
                if (InfluxObserverHelperImpl.c.level >= 9) {
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "writeRunStarted(Notification)", 157).add("point", (Object)point)).log();
                }
                this.d.write(point);
            }
            catch (ClassCastException classCastException) {
                if (InfluxObserverHelperImpl.c.level < 3) break block7;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(3, "writeRunStarted(Notification)", 160).add("Error on starting test measurement: wrong format for time")).addDetail("e.getMessage()", classCastException.getMessage())).log();
            }
        }
    }

    @Override
    public void writeRunStopped(String string, Notification notification) {
        block8: {
            if (InfluxObserverHelperImpl.c.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "writeRunStopped(String,Notification)", 167).addDetail("id", string)).addDetail("notification", (Object)notification)).log();
            }
            try {
                Point point = Point.measurement((String)"stop");
                point.time(Long.valueOf((Long)notification.getUserInfoValue("timestamp", (Object)Float.valueOf(0.0f))), WritePrecision.MS);
                point.addField("ok", (long)((Integer)notification.getUserInfoValue("ok", (Object)0)).intValue());
                point.addField("exception", (long)((Integer)notification.getUserInfoValue("exc", (Object)0)).intValue());
                point.addField("error", (long)((Integer)notification.getUserInfoValue("err", (Object)0)).intValue());
                point.addField("warning", (long)((Integer)notification.getUserInfoValue("wrn", (Object)0)).intValue());
                point.addField("tests", (long)((Integer)notification.getUserInfoValue("tests", (Object)0)).intValue());
                point.addField("duration", ((Long)notification.getUserInfoValue("duration", (Object)1)).longValue());
                Object object = notification.getUserInfoValue("suite", (Object)"");
                if (object != null) {
                    point.addTag("suite", object.toString());
                }
                if ((object = notification.getUserInfoValue("author", (Object)"")) != null) {
                    point.addTag("author", object.toString());
                }
                if ((object = notification.getUserInfoValue("runid", (Object)"")) != null) {
                    point.addTag("runid", object.toString());
                }
                if ((object = notification.getUserInfoValue("state", (Object)"")) != null) {
                    point.addTag("state", object.toString());
                }
                point.addTag("os", Misc.OS_IS_WINDOWS ? "windows" : (Misc.OS_IS_LINUX ? "linux" : "macos"));
                point.addTag("machine", InfluxObserverHelperImpl.a());
                point.addTag("id", string);
                if (InfluxObserverHelperImpl.c.level >= 9) {
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "writeRunStopped(String,Notification)", 202).add("point", (Object)point)).log();
                }
                this.d.write(point);
            }
            catch (NumberFormatException numberFormatException) {
                if (InfluxObserverHelperImpl.c.level < 3) break block8;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(3, "writeRunStopped(String,Notification)", 206).add("Error on starting test measurement: wrong format for time")).addDetail("e.getMessage()", numberFormatException.getMessage())).log();
            }
        }
    }

    @Override
    public void writeTestCaseEntered(String string, Notification notification) {
        if (InfluxObserverHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "writeTestCaseEntered(String,Notification)", 214).addDetail("id", string)).addDetail("notification", (Object)notification)).log();
        }
        Point point = Point.measurement((String)"testcase_enter");
        point.time(Long.valueOf((Long)notification.getUserInfoValue("timestamp", (Object)Float.valueOf(0.0f))), WritePrecision.MS);
        point.addField("dummy", 0L);
        point.addTag("id", string);
        point.addTag("node", notification.getUserInfoValue("node", (Object)"?").toString());
        this.d.write(point);
    }

    @Override
    public void writeTestCaseExited(String string, Notification notification) {
        if (InfluxObserverHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "writeTestCaseExited(String,Notification)", 232).addDetail("id", string)).addDetail("notification", (Object)notification)).log();
        }
        Point point = Point.measurement((String)"testcase_exit");
        point.time(Long.valueOf((Long)notification.getUserInfoValue("timestamp", (Object)Float.valueOf(0.0f))), WritePrecision.MS);
        int n2 = Integer.valueOf(notification.getUserInfoValue("state", (Object)-3).toString());
        point.addField("state", (long)n2);
        point.addTag("id", string);
        this.d.write(point);
    }

    @Override
    public void writeRunDetail(String string, Notification notification) {
        if (InfluxObserverHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "writeRunDetail(String,Notification)", 247).addDetail("id", string)).addDetail("notification", (Object)notification)).log();
        }
        Point point = Point.measurement((String)notification.getUserInfoValue("measurement", (Object)"detail").toString());
        point.time(Long.valueOf((Long)notification.getUserInfoValue("timestamp", (Object)Float.valueOf(0.0f))), WritePrecision.MS);
        String string2 = notification.getUserInfoValue("field", (Object)"dummy").toString();
        Object object = notification.getUserInfoValue("value", (Object)0);
        if (object instanceof Integer) {
            point.addField(string2, (long)((Integer)object).intValue());
        } else if (object instanceof Long) {
            point.addField(string2, ((Long)object).longValue());
        } else if (object instanceof Number) {
            point.addField(string2, (Number)object);
        } else {
            point.addField(string2, object.toString());
        }
        if (string != null) {
            point.addTag("id", string);
        }
        point.addTags(InfluxObserverHelperImpl.a(notification.getUserInfoValue("tags").toString()));
        this.d.write(point);
    }

    private static Map a(String string) {
        if (InfluxObserverHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "parsePairs(String)", 278).addDetail("line", string)).log();
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String string2 : string.split(",")) {
            String[] stringArray = string2.split("=", 2);
            if (stringArray.length != 2) continue;
            treeMap.put(stringArray[0], stringArray[1]);
        }
        return treeMap;
    }

    private static String a() {
        if (InfluxObserverHelperImpl.c.level >= 7) {
            c.lvlBuild(7, "getMachineName()", 291).log();
        }
        try {
            return InetAddress.getLocalHost().getHostName().split("\\.")[0];
        }
        catch (UnknownHostException unknownHostException) {
            if (System.getenv().containsKey("COMPUTERNAME")) {
                return System.getenv("COMPUTERNAME");
            }
            if (System.getenv().containsKey("HOSTNAME")) {
                return System.getenv("HOSTNAME");
            }
            return System.getProperty("user.name");
        }
    }

    private static class InfluxConnectionHandler
    implements EventListener {
        private final String a;
        private final char[] b;
        private final String c;
        private final String d;
        private InfluxDBClient e;
        private WriteApi f;
        private static final int g = 1000;
        private static final int h = 1000;

        public InfluxConnectionHandler(String string, String string2, String string3, String string4, String string5) {
            if (InfluxObserverHelperImpl.c.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "InfluxConnectionHandler.InfluxConnectionHandler(String,String,String,String,String)", 364).addDetail("host", string)).addDetail("port", string2)).addDetail("token", string3)).addDetail("org", string4)).addDetail("defaultBucket", string5)).log();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("http://").append(string).append(":").append(string2).append("/");
            this.a = stringBuilder.toString();
            this.b = string3.toCharArray();
            this.c = string5;
            this.d = string4;
        }

        public boolean connect() {
            if (InfluxObserverHelperImpl.c.level >= 7) {
                c.lvlBuild(7, "InfluxConnectionHandler.connect()", 387).log();
            }
            if (this.testConnection()) {
                return true;
            }
            try {
                this.e = InfluxDBClientFactory.create((String)this.a, (char[])this.b, (String)this.d, (String)this.c);
                if (InfluxObserverHelperImpl.c.level >= 9) {
                    ((LevelAwareLogBuilder)c.lvlBuild(9, "InfluxConnectionHandler.connect()", 392).add("database", (Object)this.e)).log();
                }
                this.f = this.e.getWriteApi(WriteOptions.builder().batchSize(1000).flushInterval(1000).build());
                this.f.listenEvents(WriteErrorEvent.class, (EventListener)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (InfluxObserverHelperImpl.c.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(3, "InfluxConnectionHandler.connect()", 398).addDetail("invalid database arguments: ")).addDetail("e.getMessage()", illegalArgumentException.getMessage())).addDetail("url", this.a)).addDetail("token", (Object)this.b)).addDetail("org", this.d)).log();
                }
                return false;
            }
            return this.testConnection();
        }

        public void disconnect() {
            if (InfluxObserverHelperImpl.c.level >= 7) {
                c.lvlBuild(7, "InfluxConnectionHandler.disconnect()", 411).log();
            }
            if (this.e == null) {
                return;
            }
            this.e.close();
            if (this.f != null) {
                this.f.close();
            }
            this.f = null;
            this.e = null;
        }

        public boolean isConnected() {
            return this.e != null;
        }

        public boolean testConnection() {
            if (this.e == null) {
                return false;
            }
            this.e.health().getStatus();
            return true;
        }

        public void write(String string, Point point) {
            block9: {
                if (point == null) {
                    if (InfluxObserverHelperImpl.c.level >= 3) {
                        ((LevelAwareLogBuilder)c.lvlBuild(3, "InfluxConnectionHandler.write(String,Point)", 469).addDetail("point is null")).log();
                    }
                    return;
                }
                if (InfluxObserverHelperImpl.c.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "InfluxConnectionHandler.write(String,Point)", 472).add("bucket", string)).add("point", point.toLineProtocol())).log();
                }
                if (!this.isConnected()) {
                    if (InfluxObserverHelperImpl.c.level >= 5) {
                        ((LevelAwareLogBuilder)c.lvlBuild(5, "InfluxConnectionHandler.write(String,Point)", 475).add("disconnected")).log();
                    }
                    return;
                }
                try {
                    if (this.f == null) {
                        if (InfluxObserverHelperImpl.c.level >= 3) {
                            ((LevelAwareLogBuilder)c.lvlBuild(3, "InfluxConnectionHandler.write(String,Point)", 480).addDetail("writeApi is null")).log();
                        }
                        return;
                    }
                    this.f.writePoint(string, this.d, point);
                    this.f.flush();
                }
                catch (InfluxException influxException) {
                    if (InfluxObserverHelperImpl.c.level < 3) break block9;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(3, "InfluxConnectionHandler.write(String,Point)", 486).addDetail("point skipped: ")).add("ex.getMessage()", influxException.getMessage())).addDetail("point", (Object)point)).log();
                }
            }
        }

        public void write(Point point) {
            this.write(this.c, point);
        }

        public void onEvent(WriteErrorEvent writeErrorEvent) {
            if (InfluxObserverHelperImpl.c.level >= 7) {
                ((LevelAwareLogBuilder)c.lvlBuild(7, "InfluxConnectionHandler.onEvent(WriteErrorEvent)", 507).addDetail("arg0", (Object)writeErrorEvent)).log();
            }
        }
    }
}

