/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.jedit;

import de.qfs.apps.qftest.jedit.JEditTextArea;
import de.qfs.apps.qftest.jedit.SyntaxStyle;
import de.qfs.apps.qftest.jedit.SyntaxUtilities;
import de.qfs.apps.qftest.jedit.TextAreaDefaults;
import de.qfs.apps.qftest.jedit.Token;
import de.qfs.apps.qftest.jedit.TokenMarker;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    public static final Font a = new Font("Monospaced", 0, 14);
    int b;
    Token c;
    Segment d;
    protected JEditTextArea e;
    protected SyntaxStyle[] f;
    protected Color g;
    protected Color h;
    protected Color i;
    protected Color j;
    protected Color k;
    protected boolean l;
    protected boolean m;
    protected boolean n;
    protected boolean o;
    protected boolean p;
    protected int q;
    protected int r;
    protected int s;
    protected FontMetrics t;
    protected Highlight u;

    public TextAreaPainter(JEditTextArea jEditTextArea, TextAreaDefaults textAreaDefaults) {
        this.e = jEditTextArea;
        this.setAutoscrolls(true);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.d = new Segment();
        this.b = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setFont(a);
        this.setForeground(UIManager.getColor("Painter.foreground"));
        this.setBackground(UIManager.getColor("Painter.background"));
        this.l = textAreaDefaults.f;
        this.f = textAreaDefaults.l;
        this.q = textAreaDefaults.j;
        this.r = textAreaDefaults.k;
        this.g = textAreaDefaults.m;
        this.h = textAreaDefaults.n;
        this.i = textAreaDefaults.o;
        this.m = textAreaDefaults.p;
        this.j = textAreaDefaults.q;
        this.n = textAreaDefaults.r;
        this.o = textAreaDefaults.u;
        this.k = textAreaDefaults.s;
        this.p = textAreaDefaults.t;
    }

    @Override
    public final boolean isManagingFocus() {
        return false;
    }

    public final SyntaxStyle[] a() {
        return this.f;
    }

    public final void a(SyntaxStyle[] syntaxStyleArray) {
        this.f = syntaxStyleArray;
        this.repaint();
    }

    public final Color b() {
        return this.g;
    }

    public final void a(Color color) {
        this.g = color;
        this.m();
    }

    public final Color c() {
        return this.h;
    }

    public final void b(Color color) {
        this.h = color;
        this.m();
    }

    public final Color d() {
        return this.i;
    }

    public final void c(Color color) {
        this.i = color;
        this.m();
    }

    public final boolean e() {
        return this.m;
    }

    public final void a(boolean bl2) {
        this.m = bl2;
        this.m();
    }

    public final Color f() {
        return this.j;
    }

    public final void d(Color color) {
        this.j = color;
        this.a(this.e.getBracketLine());
    }

    public final boolean g() {
        return this.n;
    }

    public final void b(boolean bl2) {
        this.n = bl2;
        this.a(this.e.getBracketLine());
    }

    public final boolean h() {
        return this.l;
    }

    public final void c(boolean bl2) {
        this.l = bl2;
        this.m();
    }

    public final Color i() {
        return this.k;
    }

    public final void e(Color color) {
        this.k = color;
        this.repaint();
    }

    public final boolean j() {
        return this.p;
    }

    public final void d(boolean bl2) {
        this.p = bl2;
        this.repaint();
    }

    public boolean k() {
        return this.o;
    }

    public void e(boolean bl2) {
        this.o = bl2;
    }

    public void a(Highlight highlight) {
        highlight.init(this.e, this.u);
        this.u = highlight;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.u != null) {
            return this.u.getToolTipText(mouseEvent);
        }
        return null;
    }

    public FontMetrics l() {
        if (this.getFont() != null) {
            this.t = this.getFontMetrics(this.getFont());
        }
        return this.t;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.t = this.getFontMetrics(font);
        this.e.recalculateVisibleLines();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(UIManager.getColor("Painter.foreground"));
        this.setBackground(UIManager.getColor("Painter.background"));
        if (this.e != null) {
            this.e.setForeground(UIManager.getColor("TextArea.foreground"));
            this.e.setBackground(UIManager.getColor("TextArea.background"));
            this.e.updateUI();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        }
        this.s = this.b((Integer)this.e.getDocument().getProperty("tabSize"));
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n2 = this.t.getHeight();
        int n3 = this.e.getFirstLine();
        int n4 = n3 + rectangle.y / n2;
        int n5 = n3 + (rectangle.y + rectangle.height - 1) / n2;
        try {
            int n6;
            TokenMarker tokenMarker = this.e.getDocument().a();
            int n7 = this.e.getHorizontalOffset();
            for (n6 = n4; n6 <= n5; ++n6) {
                this.a(graphics, tokenMarker, n6, n7);
            }
            if (tokenMarker != null && tokenMarker.d()) {
                n6 = rectangle.y + rectangle.height;
                this.repaint(0, n6, this.getWidth(), this.getHeight() - n6);
            }
        }
        catch (Exception exception) {
            System.err.println("Error repainting line range {" + n4 + "," + n5 + "}:");
            exception.printStackTrace();
        }
    }

    public final void a(int n2) {
        this.repaint(0, this.e.lineToY(n2) + this.t.getMaxDescent() + this.t.getLeading(), this.getWidth(), this.t.getHeight());
    }

    public final void a(int n2, int n3) {
        this.repaint(0, this.e.lineToY(n2) + this.t.getMaxDescent() + this.t.getLeading(), this.getWidth(), (n3 - n2 + 1) * this.t.getHeight());
    }

    public final void m() {
        this.a(this.e.getSelectionStartLine(), this.e.getSelectionEndLine());
    }

    @Override
    public float nextTabStop(float f2, int n2) {
        int n3 = this.e.getHorizontalOffset();
        if (this.s == 0) {
            this.s = this.b((Integer)this.e.getDocument().getProperty("tabSize"));
        }
        int n4 = ((int)f2 - n3) / this.s;
        return (n4 + 1) * this.s + n3;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        dimension.width = this.t.charWidth('w') * this.q;
        dimension.height = this.t.getHeight() * this.r;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int b(int n2) {
        char[] cArray = new char[n2];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
            cArray[i2] = 32;
        }
        return this.t.stringWidth(new String(cArray));
    }

    protected void a(Graphics graphics, TokenMarker tokenMarker, int n2, int n3) {
        Font font = this.getFont();
        Color color = this.getForeground();
        this.b = n2;
        int n4 = this.e.lineToY(n2);
        if (n2 < 0 || n2 >= this.e.getLineCount()) {
            if (this.o) {
                this.a(graphics, n2, n4);
                this.f[10].a(graphics, font);
                graphics.drawString("~", 0, n4 + this.t.getHeight());
            }
        } else if (tokenMarker == null) {
            this.a(graphics, n2, font, color, n3, n4);
        } else {
            this.a(graphics, tokenMarker, n2, font, color, n3, n4);
        }
    }

    protected void a(Graphics graphics, int n2, Font font, Color color, int n3, int n4) {
        this.a(graphics, n2, n4);
        this.e.getLineText(n2, this.d);
        graphics.setFont(font);
        graphics.setColor(color);
        n3 = Utilities.drawTabbedText(this.d, n3, n4 += this.t.getHeight(), graphics, (TabExpander)this, 0);
        if (this.p) {
            graphics.setColor(this.k);
            graphics.drawString(".", n3, n4);
        }
    }

    protected void a(Graphics graphics, TokenMarker tokenMarker, int n2, Font font, Color color, int n3, int n4) {
        this.e.getLineText(this.b, this.d);
        this.c = tokenMarker.b(this.d, this.b);
        this.a(graphics, n2, n4);
        graphics.setFont(font);
        graphics.setColor(color);
        n3 = SyntaxUtilities.a(this, this.d, this.c, this.f, this, graphics, n3, n4 += this.t.getHeight());
        if (this.p) {
            graphics.setColor(this.k);
            graphics.drawString(".", n3, n4);
        }
    }

    protected void a(Graphics graphics, int n2, int n3) {
        if (n2 >= this.e.getSelectionStartLine() && n2 <= this.e.getSelectionEndLine()) {
            this.b(graphics, n2, n3);
        }
        if (this.u != null) {
            this.u.paintHighlight(graphics, n2, n3);
        }
        if (this.n && n2 == this.e.getBracketLine()) {
            this.c(graphics, n2, n3);
        }
        if (n2 == this.e.getCaretLine()) {
            this.d(graphics, n2, n3);
        }
    }

    protected void b(Graphics graphics, int n2, int n3) {
        int n4;
        int n5 = this.t.getHeight();
        n3 += this.t.getLeading() + this.t.getMaxDescent();
        int n6 = this.e.getSelectionStart();
        if (n6 == (n4 = this.e.getSelectionEnd())) {
            if (this.m) {
                graphics.setColor(this.i);
                graphics.fillRect(0, n3, this.getWidth(), n5);
            }
        } else {
            int n7;
            int n8;
            graphics.setColor(this.h);
            int n9 = this.e.getSelectionStartLine();
            int n10 = this.e.getSelectionEndLine();
            int n11 = this.e.getLineStartOffset(n2);
            if (this.e.isSelectionRectangular()) {
                int n12 = this.e.getLineLength(n2);
                n8 = this.e._offsetToX(n2, Math.min(n12, n6 - this.e.getLineStartOffset(n9)));
                if (n8 == (n7 = this.e._offsetToX(n2, Math.min(n12, n4 - this.e.getLineStartOffset(n10))))) {
                    ++n7;
                }
            } else if (n9 == n10) {
                n8 = this.e._offsetToX(n2, n6 - n11);
                n7 = this.e._offsetToX(n2, n4 - n11);
            } else if (n2 == n9) {
                n8 = this.e._offsetToX(n2, n6 - n11);
                n7 = this.getWidth();
            } else if (n2 == n10) {
                n8 = 0;
                n7 = this.e._offsetToX(n2, n4 - n11);
            } else {
                n8 = 0;
                n7 = this.getWidth();
            }
            graphics.fillRect(n8 > n7 ? n7 : n8, n3, n8 > n7 ? n8 - n7 : n7 - n8, n5);
        }
    }

    protected void c(Graphics graphics, int n2, int n3) {
        int n4 = this.e.getBracketPosition();
        if (n4 == -1) {
            return;
        }
        int n5 = this.e._offsetToX(n2, n4);
        graphics.setColor(this.j);
        graphics.drawRect(n5, n3 += this.t.getLeading() + this.t.getMaxDescent(), this.t.charWidth('(') - 1, this.t.getHeight() - 1);
    }

    protected void d(Graphics graphics, int n2, int n3) {
        if (this.e.isCaretVisible()) {
            int n4 = this.e.getCaretPosition() - this.e.getLineStartOffset(n2);
            int n5 = this.e._offsetToX(n2, n4);
            int n6 = this.l || this.e.isOverwriteEnabled() ? this.t.charWidth('w') : 1;
            n3 += this.t.getLeading() + this.t.getMaxDescent();
            int n7 = this.t.getHeight();
            graphics.setColor(this.g);
            if (this.e.isOverwriteEnabled()) {
                graphics.fillRect(n5, n3 + n7 - 1, n6, 1);
            } else {
                graphics.drawRect(n5, n3, n6 - 1, n7 - 1);
            }
        }
    }

    public static interface Highlight {
        public void init(JEditTextArea var1, Highlight var2);

        public void paintHighlight(Graphics var1, int var2, int var3);

        public String getToolTipText(MouseEvent var1);
    }

    public class SearchHighlight
    implements Highlight {
        Highlight next = null;
        JEditTextArea textArea = null;
        Color color;
        int[] positions;

        @Override
        public void init(JEditTextArea jEditTextArea, Highlight highlight) {
            this.next = highlight;
            this.textArea = jEditTextArea;
            this.color = TextAreaPainter.this.h;
        }

        @Override
        public void paintHighlight(Graphics graphics, int n2, int n3) {
            if (this.positions != null) {
                for (int i2 = 0; i2 < this.positions.length; i2 += 2) {
                    this.doPaintHighlight(graphics, n2, n3, this.positions[i2], this.positions[i2 + 1]);
                }
            }
            if (this.next != null) {
                this.next.paintHighlight(graphics, n2, n3);
            }
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            if (this.next != null) {
                return this.next.getToolTipText(mouseEvent);
            }
            return null;
        }

        private void doPaintHighlight(Graphics graphics, int n2, int n3, int n4, int n5) {
            int n6;
            int n7;
            if (n4 == n5) {
                if (n5 == 0) {
                    int n8 = 0;
                    int n9 = this.textArea.getWidth();
                    int n10 = this.textArea.getHeight();
                    graphics.setColor(this.color);
                    graphics.fillRect(n8 > n9 ? n9 : n8, n3, n8 > n9 ? n8 - n9 : n9 - n8, n10);
                }
                return;
            }
            int n11 = this.textArea.getLineOfOffset(n4);
            int n12 = this.textArea.getLineOfOffset(n5);
            if (n11 > n2 || n2 > n12) {
                return;
            }
            int n13 = this.textArea.getLineStartOffset(n2);
            int n14 = this.textArea.getLineText(n2).length();
            if (n11 == n12) {
                n7 = this.textArea._offsetToX(n2, n4 - n13);
                n6 = this.textArea._offsetToX(n2, n5 - n13);
            } else if (n2 == n11) {
                n7 = this.textArea._offsetToX(n2, n4 - n13);
                n6 = this.textArea._offsetToX(n2, n13 + n14);
            } else if (n2 == n12) {
                n7 = 0;
                n6 = this.textArea._offsetToX(n2, n5 - n13);
            } else {
                n7 = 0;
                n6 = this.textArea._offsetToX(n2, n13 + n14);
            }
            int n15 = TextAreaPainter.this.t.getHeight();
            graphics.setColor(this.color);
            graphics.fillRect(n7 > n6 ? n6 : n7, n3 += TextAreaPainter.this.t.getLeading() + TextAreaPainter.this.t.getMaxDescent(), n7 > n6 ? n7 - n6 : n6 - n7, n15);
        }

        public void addHighlight(int n2, int n3) {
            int n4 = this.positions != null ? this.positions.length : 0;
            int[] nArray = new int[n4 + 2];
            if (this.positions != null) {
                System.arraycopy(this.positions, 0, nArray, 0, n4);
            }
            nArray[n4] = n2;
            nArray[n4 + 1] = n3;
            this.positions = nArray;
            TextAreaPainter.this.repaint();
        }

        public void removeHighlights() {
            if (this.positions != null) {
                this.positions = null;
                TextAreaPainter.this.repaint();
            }
        }

        public void setHighlightingColor(Color color) {
            this.color = color;
        }

        public Color getHighlightingColor() {
            return this.color;
        }
    }
}

