/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.junit5;

import de.qfs.apps.qftest.App;
import de.qfs.apps.qftest.log.TestRunLog;
import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.extensions.TestOptionsProvider;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessEvent;
import de.qfs.lib.util.ProcessListener;
import de.qfs.lib.util.ProcessManager;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.TestFactory;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

public class QFTest
implements Iterable {
    private static final QFLogger i = new QFLogger("de.qfs.apps.qftest.junit5.QFTest");
    private static final Logger j = LoggerFactory.getLogger(QFTest.class);
    private static final Set k = Misc.setOf((Object[])new String[]{"-report", "-reportjunit", "reporthtml"});
    final List a = new ArrayList();
    final List b = new ArrayList();
    String c;
    String d;
    boolean e;
    String f;
    final List g = new ArrayList();
    boolean h;

    public static QFTest runSuite(String string) {
        return QFTest.runSuites(string);
    }

    public static QFTest runSuite(File file) {
        return QFTest.runSuites(file);
    }

    public static QFTest runSuite(Path path) {
        return QFTest.runSuites(path);
    }

    public static QFTest runSuites(String ... stringArray) {
        return new QFTest().paths(stringArray);
    }

    public static QFTest runSuites(File ... fileArray) {
        String[] stringArray = new String[fileArray.length];
        int n2 = 0;
        for (File file : fileArray) {
            stringArray[n2++] = file.getAbsolutePath();
        }
        return QFTest.runSuites(stringArray);
    }

    public static QFTest runSuites(Path ... pathArray) {
        String[] stringArray = new String[pathArray.length];
        int n2 = 0;
        for (Path path : pathArray) {
            stringArray[n2++] = path.toAbsolutePath().toString();
        }
        return QFTest.runSuites(stringArray);
    }

    public static File getQFTestBinary() {
        File file = QFTest.getVersionDir();
        if (file == null) {
            return null;
        }
        File file2 = new File(file, "bin");
        if (Misc.OS_IS_WINDOWS) {
            return new File(file2, "qftestc.exe");
        }
        if (Misc.OS_IS_MAC_OS_X) {
            try {
                File file3 = new File(file2, "../../../../MacOS/QF-Test").getCanonicalFile();
                if (file3.exists()) {
                    return file3;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new File(file2, "qftest");
    }

    public static String startQFTestProcess(String ... stringArray) throws ProcessManager.RunProcessException {
        return QFTest.a(stringArray, null);
    }

    @Deprecated
    public static String startProcess(String ... stringArray) throws ProcessManager.RunProcessException {
        return QFTest.startQFTestProcess(stringArray);
    }

    private static String a(String[] stringArray, ProcessListener processListener) throws ProcessManager.RunProcessException {
        File file = QFTest.getQFTestBinary();
        if (file == null || !file.exists()) {
            throw new IllegalStateException("Could not find QF-Test binary: " + String.valueOf(file));
        }
        ArrayList arrayList = new ArrayList();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = file.getAbsolutePath();
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return ProcessManager.runProcess((String[])stringArray2, (int)0, (ProcessListener)processListener);
    }

    private String a(List list, List list2) throws ProcessManager.RunProcessException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : list2) {
            arrayList.add(object);
            if (!((String)object).startsWith("-")) continue;
            hashSet.add(ArgsParser.simplifiedOptionName((String)object));
            if (!k.contains(object)) continue;
            hashSet.addAll(k);
        }
        boolean bl2 = false;
        for (String string2 : list) {
            if (string2.startsWith("-")) {
                if (hashSet.contains(ArgsParser.simplifiedOptionName((String)string2))) {
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    bl2 = false;
                    continue;
                }
            }
            bl2 = false;
            arrayList.add(string2);
        }
        if (QFTest.i.level >= 5) {
            ((LevelAwareLogBuilder)i.lvlBuild(5, "startQFTestProcessWithAdditionalArguments(List<String>,List<String>)", 340).add("runArguments.stream().map((s)->\"\\\"\" + s + \"\\\"\").collect(Collectors.joining(\" \"))", arrayList.stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(" ")))).log();
        }
        return QFTest.a(arrayList.toArray(new String[arrayList.size()]), new a());
    }

    public static File getVersionDir() {
        String string = Native.getVersionDir();
        if (Misc.emptyOrNull((String)string)) {
            return null;
        }
        return new File(string);
    }

    public static boolean openReport(String string) {
        File file = new File(string);
        if (!string.endsWith("html")) {
            file = new File(file, "report.html");
        }
        String string2 = file.getAbsolutePath();
        if (!file.exists()) {
            j.error(() -> "Report not found at " + string2);
            return false;
        }
        String string3 = "file://" + (string2.startsWith("/") ? "" : "/") + string2.replace(File.separator, "/");
        if (!Desktop.isDesktopSupported()) {
            j.error(() -> "java.awt.Desktop not supported, cannot open browser for " + string3);
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (desktop == null) {
            j.error(() -> "Could not create instance of java.awt.Desktop, cannot open browser for " + string3);
            return false;
        }
        try {
            j.info(() -> "Opening report " + string2);
            desktop.browse(new URI(string3));
        }
        catch (Exception exception) {
            if (QFTest.i.level >= 3) {
                ((LevelAwareLogBuilder)i.lvlBuild(3, "openReport(String)", 392).add("e", (Object)exception)).log();
            }
            j.error(() -> "Could not open browser for " + string3);
            return false;
        }
        return true;
    }

    public static boolean openReport(File file) {
        return QFTest.openReport(file.getAbsolutePath());
    }

    public static boolean openReport(Path path) {
        return QFTest.openReport(path.toAbsolutePath().toString());
    }

    protected QFTest() {
        TestOptionsProvider.newRegisteredProvider();
        File file = QFTest.getVersionDir();
        if (!Misc.emptyOrNull((Object)file)) {
            Globals.addGlobal((Option)new StringOption("qftestversiondir", file.getAbsolutePath()));
        }
        this.a();
        App.d.a();
    }

    private void a() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = System.getProperty("qftest.options");
        if (QFTest.i.level >= 9) {
            ((LevelAwareLogBuilder)i.lvlBuild(9, "addArgumentsFromSystemProperties()", 438).add("options", string5)).log();
        }
        if (string5 != null) {
            try {
                string4 = this.a(string5);
                string4.forEach(member -> this.withOption(member.getName(), this.a(member.getValue())));
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not add options from system properties.", exception);
            }
        }
        string4 = System.getProperty("qftest.variables");
        if (QFTest.i.level >= 9) {
            ((LevelAwareLogBuilder)i.lvlBuild(9, "addArgumentsFromSystemProperties()", 449).add("variables", string4)).log();
        }
        if (string4 != null) {
            try {
                string3 = this.a(string4);
                string3.forEach(member -> this.withVariable(member.getName(), this.a(member.getValue())));
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not add variables from system properties.", exception);
            }
        }
        string3 = System.getProperty("qftest.arguments");
        if (QFTest.i.level >= 9) {
            ((LevelAwareLogBuilder)i.lvlBuild(9, "addArgumentsFromSystemProperties()", 460).add("args", string3)).log();
        }
        if (string3 != null) {
            try {
                string2 = this.c(string3);
                string2.forEach(jsonValue -> this.withArgument(this.a((JsonValue)jsonValue)));
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not add arguments from system properties.", exception);
            }
        }
        string2 = System.getProperty("qftest.keeprunlogs");
        if (QFTest.i.level >= 9) {
            ((LevelAwareLogBuilder)i.lvlBuild(9, "addArgumentsFromSystemProperties()", 471).add("keepRunLog", string2)).log();
        }
        if (string2 != null) {
            try {
                string = this.a(QFTest.b(string2)).toLowerCase();
                if ("yes".equals(string) || "true".equals(string) || "1".equals(string)) {
                    this.e = true;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not add report arguments from system properties.", exception);
            }
        }
        string = System.getProperty("qftest.reportargs");
        if (QFTest.i.level >= 9) {
            ((LevelAwareLogBuilder)i.lvlBuild(9, "addArgumentsFromSystemProperties()", 484).add("reportArgString", string)).log();
        }
        if (string != null) {
            try {
                JsonArray jsonArray = this.c(string);
                jsonArray.forEach(jsonValue -> this.g.add(this.a((JsonValue)jsonValue)));
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not add report arguments from system properties.", exception);
            }
        }
    }

    private JsonObject a(String string) {
        JsonValue jsonValue2 = QFTest.b(string);
        if (jsonValue2 instanceof JsonArray) {
            JsonObject jsonObject = new JsonObject();
            jsonValue2.asArray().forEach(jsonValue -> {
                String[] stringArray = Misc.fastSplit((String)this.a((JsonValue)jsonValue), (char)'=', (int)2);
                jsonObject.add(stringArray[0], stringArray.length > 1 ? stringArray[1] : "true");
            });
            return jsonObject;
        }
        if (jsonValue2 instanceof JsonObject) {
            return (JsonObject)jsonValue2;
        }
        JsonObject jsonObject = new JsonObject();
        String[] stringArray = Misc.fastSplit((String)this.a(jsonValue2), (char)'=', (int)2);
        jsonObject.add(stringArray[0], stringArray.length > 1 ? stringArray[1] : "true");
        return jsonObject;
    }

    private static JsonValue b(String string) {
        if (QFTest.i.level >= 7) {
            ((LevelAwareLogBuilder)i.lvlBuild(7, "parseJsonWithStringFallback(String)", 518).addDetail("json", string)).log();
        }
        if (Misc.OS_IS_WINDOWS && string != null && string.endsWith("\"\"") && !string.endsWith("\\\"\"")) {
            string = string.substring(0, string.length() - 1);
            if (QFTest.i.level >= 9) {
                ((LevelAwareLogBuilder)i.lvlBuild(9, "parseJsonWithStringFallback(String)", 522).add("json", string)).log();
            }
        }
        try {
            return Json.parse((String)string);
        }
        catch (Exception exception) {
            if (QFTest.i.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)i.lvlBuild(5, "parseJsonWithStringFallback(String)", 527).add("ex", (Object)exception)).addDetail("json", string)).log();
            }
            return Json.value((String)string);
        }
    }

    private JsonArray c(String string) {
        JsonValue jsonValue = QFTest.b(string);
        if (jsonValue instanceof JsonObject) {
            JsonArray jsonArray = new JsonArray();
            jsonValue.asObject().forEach(member -> jsonArray.add(member.getName() + "=" + this.a(member.getValue())));
            return jsonArray;
        }
        if (jsonValue.isString()) {
            String[] stringArray;
            JsonArray jsonArray = new JsonArray();
            for (String string2 : stringArray = ProcessManager.translateCommandline((String)jsonValue.asString())) {
                jsonArray.add(string2);
            }
            return jsonArray;
        }
        if (jsonValue instanceof JsonArray) {
            return (JsonArray)jsonValue;
        }
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(jsonValue);
        return jsonArray;
    }

    private String a(JsonValue jsonValue) {
        if (jsonValue != null && jsonValue.isString()) {
            return jsonValue.asString();
        }
        return String.valueOf(jsonValue);
    }

    public QFTest paths(String ... stringArray) {
        for (String string : stringArray) {
            if (Misc.emptyOrNull((String)string)) continue;
            this.a.add(string);
        }
        return this;
    }

    public QFTest suites(String ... stringArray) {
        return this.paths(stringArray);
    }

    public QFTest withArgument(String string) {
        this.b.add(string);
        return this;
    }

    public QFTest withArguments(String ... stringArray) {
        for (String string : stringArray) {
            this.withArgument(string);
        }
        return this;
    }

    public QFTest withReportArgument(String string) {
        this.g.add(string);
        return this;
    }

    public QFTest withReportArguments(String ... stringArray) {
        for (String string : stringArray) {
            this.withReportArgument(string);
        }
        return this;
    }

    public QFTest withLicense(String string) {
        this.c = string;
        return this;
    }

    public QFTest withLicense(File file) {
        return this.withLicense(file.getAbsolutePath());
    }

    public QFTest withLicense(Path path) {
        return this.withLicense(path.toAbsolutePath().toString());
    }

    public QFTest withOption(String string, String string2) {
        if (Misc.emptyOrNull((String)string)) {
            throw new IllegalArgumentException("Option name must not be empty");
        }
        return this.withArguments("-option", string + "=" + string2);
    }

    public QFTest withOptions(String ... stringArray) {
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            String string = stringArray[i2];
            String string2 = i2 + 1 < stringArray.length ? stringArray[i2 + 1] : "";
            this.withOption(string, string2);
        }
        return this;
    }

    public QFTest withVariable(String string, String string2) {
        if (Misc.emptyOrNull((String)string)) {
            throw new IllegalArgumentException("Variable name must not be empty");
        }
        return this.withArguments("-variable", string + "=" + string2);
    }

    public QFTest withVariables(String ... stringArray) {
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            String string = stringArray[i2];
            String string2 = i2 + 1 < stringArray.length ? stringArray[i2 + 1] : "";
            this.withVariable(string, string2);
        }
        return this;
    }

    public QFTest withRunLogPath(String string) {
        return this.withRunLogPath(string, true);
    }

    public QFTest withRunLogPath(File file) {
        return this.withRunLogPath(file.getAbsolutePath());
    }

    public QFTest withRunLogPath(Path path) {
        return this.withRunLogPath(path.toFile());
    }

    public QFTest withRunLogPath(String string, boolean bl2) {
        this.d = string;
        this.e = bl2;
        return this;
    }

    public QFTest withRunLogPath(File file, boolean bl2) {
        return this.withRunLogPath(file.getAbsolutePath(), bl2);
    }

    public QFTest withRunLogPath(Path path, boolean bl2) {
        return this.withRunLogPath(path.toFile(), bl2);
    }

    private File a(List list) {
        File file = null;
        String string = this.c;
        if (Misc.emptyOrNull((String)string)) {
            string = System.getProperty("qftest.license");
            if (QFTest.i.level >= 9) {
                ((LevelAwareLogBuilder)i.lvlBuild(9, "addLicenseToArgs(List<String>)", 815).add("license", string)).log();
            }
            if (string != null) {
                try {
                    if (Misc.OS_IS_WINDOWS) {
                        string = string.replaceAll("\\\\\"", "\"");
                    }
                    string = this.a(QFTest.b(string));
                }
                catch (Exception exception) {
                    throw new RuntimeException("Could not add license from system properties.", exception);
                }
            }
        }
        if (!Misc.emptyOrNull((String)string)) {
            if (QFTest.i.level >= 9) {
                ((LevelAwareLogBuilder)i.lvlBuild(9, "addLicenseToArgs(List<String>)", 828).add("license", string)).log();
            }
            if (string.contains("signature = ")) {
                file = File.createTempFile("qftest-", ".license");
                Files.write(file.toPath(), string.getBytes(Misc.UTF8_CHARSET), new OpenOption[0]);
                string = file.getAbsolutePath();
            }
            list.add("-license");
            list.add(string);
        }
        return file;
    }

    public QFTest withReport() {
        this.withReport((String)null, new String[0]);
        return this;
    }

    public QFTest withReport(String string, String ... stringArray) {
        if (Misc.emptyOrNull((String)string)) {
            try {
                File file = Files.createTempDirectory("qftest-report", new FileAttribute[0]).toFile();
                string = file.getAbsolutePath();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Could not create temporary report dir", iOException);
            }
        }
        this.f = string;
        for (String string2 : stringArray) {
            this.g.add(string2);
        }
        return this;
    }

    public QFTest withReport(File file, String ... stringArray) {
        return this.withReport(file.getAbsolutePath(), stringArray);
    }

    public QFTest withReport(Path path, String ... stringArray) {
        return this.withReport(path.toFile(), stringArray);
    }

    public QFTest withReportOpen() {
        this.h = true;
        if (Misc.emptyOrNull((String)this.f)) {
            this.withReport();
        }
        return this;
    }

    public Iterator iterator() {
        return new b();
    }

    private static class a
    implements ProcessListener {
        private a() {
        }

        public void processStarted(ProcessEvent processEvent) {
        }

        public void processTerminated(ProcessEvent processEvent) {
        }

        public void inputReceived(ProcessEvent processEvent) {
            if (processEvent.isStderr()) {
                System.err.print(processEvent.getData());
            } else {
                System.out.print(processEvent.getData());
            }
        }
    }

    public static final class SystemProperties {
        public static final String a = "qftest.runlogdir";
        public static final String b = "qftest.keeprunlogs";
        public static final String c = "qftest.withreportindir";
        public static final String d = "qftest.reportargs";
        public static final String e = "qftest.versiondir";
        public static final String f = "qftest.license";
        public static final String g = "qftest.arguments";
        public static final String h = "qftest.variables";
        public static final String i = "qftest.options";
    }

    private final class b
    implements Iterator {
        int a = -1;
        final File b;
        final String c;
        boolean d = false;
        final List e = new LinkedList();

        private b() {
            this.b = this.b();
            this.c = this.c();
        }

        private File b() {
            File file;
            String string = System.getProperty("qftest.runlogdir");
            if (QFTest.i.level >= 9) {
                ((LevelAwareLogBuilder)i.lvlBuild(9, "SuiteIterator.setRunlogDir()", 941).add("runLogDirPath", string)).log();
            }
            if (!Misc.isTrimmedEmptyOrNull((String)QFTest.this.d) && !this.a(QFTest.this.d)) {
                string = QFTest.this.d;
            }
            if (QFTest.this.d == null && Misc.emptyOrNull((String)string)) {
                try {
                    file = Files.createTempDirectory("qftest", new FileAttribute[0]).toFile();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Could not create tempdir for runlogs: " + iOException.getMessage());
                }
                this.d = true;
            } else {
                file = new File(string);
            }
            return file;
        }

        private boolean a(String string) {
            return !Misc.emptyOrNull((String)string) && (string.toLowerCase().endsWith(".qzp") || string.toLowerCase().endsWith(".qrl") || string.toLowerCase().endsWith(".qrz"));
        }

        private String c() {
            String string = System.getProperty("qftest.withreportindir");
            if (QFTest.i.level >= 9) {
                ((LevelAwareLogBuilder)i.lvlBuild(9, "SuiteIterator.setReportDir()", 966).add("reportDirPath", string)).log();
            }
            if (!Misc.emptyOrNull((String)string)) {
                return string;
            }
            if (!Misc.emptyOrNull((String)QFTest.this.f)) {
                return QFTest.this.f;
            }
            return null;
        }

        private void d() {
            if (this.c != null) {
                this.e();
                if (QFTest.this.h) {
                    QFTest.openReport(this.c);
                }
            }
        }

        private boolean e() {
            block9: {
                File file2;
                assert (this.c != null);
                if (this.e.size() == 0) {
                    j.warn(() -> "No run logs available to create report for.");
                    return false;
                }
                j.info(() -> "Creating report in " + this.c);
                String[] stringArray = (String[])this.e.stream().map(file -> file.getAbsolutePath()).toArray(String[]::new);
                String string = Misc.commonPath((String[])stringArray);
                if (Misc.emptyOrNull((String)string)) {
                    file2 = ((File)this.e.get(0)).getParentFile();
                } else {
                    file2 = new File(string);
                    if (!file2.isDirectory()) {
                        file2 = file2.getParentFile();
                    }
                }
                try {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    linkedList.add("-batch");
                    linkedList.add("-genreport");
                    linkedList.add("-report");
                    linkedList.add(this.c);
                    linkedList.add("-runlogdir");
                    linkedList.add(file2.getAbsolutePath());
                    for (String string2 : stringArray) {
                        linkedList.add(string2);
                    }
                    QFTest.this.a(linkedList, QFTest.this.g);
                }
                catch (ProcessManager.RunProcessException runProcessException) {
                    int n2;
                    if (QFTest.i.level >= 9) {
                        ((LevelAwareLogBuilder)i.lvlBuild(9, "SuiteIterator.createReport()", 1021).add("e", (Object)runProcessException)).log();
                    }
                    if ((n2 = runProcessException.getExitCode()) >= 0 && n2 <= 3) break block9;
                    throw new RuntimeException(runProcessException.getOutput());
                }
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            if (QFTest.this.a.isEmpty()) {
                throw new IllegalStateException("No Testsuites found: " + String.valueOf(this));
            }
            return this.a < QFTest.this.a.size() - 1;
        }

        public DynamicNode a() {
            String string;
            ++this.a;
            String string2 = (String)QFTest.this.a.get(this.a);
            String[] stringArray = Misc.fastSplit((String)string2, (char)'#', (int)2);
            File file = new File(stringArray[0]);
            String string3 = string = stringArray.length > 1 ? stringArray[1] : null;
            if (!file.exists()) {
                throw new NoSuchElementException(String.format("Testsuite '%s' not found.", file.getAbsolutePath()));
            }
            TestRunLog testRunLog = this.a(file, string);
            File file2 = testRunLog.getFile();
            if (file2 != null) {
                this.e.add(file2);
            }
            de.qfs.apps.qftest.junit5.b b2 = new de.qfs.apps.qftest.junit5.b(testRunLog, testRunLog.l());
            if (!this.hasNext()) {
                this.d();
            }
            return DynamicContainer.dynamicContainer((String)string2, (Iterable)b2);
        }

        private TestRunLog a(File file, String string) {
            String string2 = file.getName();
            if (string2.toLowerCase().endsWith(".qft")) {
                return this.b(file, string);
            }
            return this.a(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TestRunLog b(File file, String string) {
            String string2 = file.getName();
            File file2 = this.b(string2);
            boolean bl2 = false;
            File file3 = null;
            try {
                Object object;
                Object object2;
                block10: {
                    try {
                        object2 = file.getAbsolutePath();
                        if (!Misc.emptyOrNull((String)string)) {
                            object2 = (String)object2 + "#" + string;
                        }
                        object = new LinkedList<String>();
                        object.add("-batch");
                        object.add("-runlog");
                        object.add(file2.getAbsolutePath());
                        file3 = QFTest.this.a((List)object);
                        object.add("-run");
                        object.add(object2);
                        QFTest.this.a((List)object, QFTest.this.b);
                        bl2 = true;
                    }
                    catch (ProcessManager.RunProcessException runProcessException) {
                        int n2;
                        if (QFTest.i.level >= 9) {
                            ((LevelAwareLogBuilder)i.lvlBuild(9, "SuiteIterator.runTest(File,String)", 1103).add("e", (Object)runProcessException)).log();
                        }
                        if ((n2 = runProcessException.getExitCode()) >= 0 && n2 <= 3) break block10;
                        throw new RuntimeException(runProcessException.getOutput());
                    }
                }
                if (QFTest.i.level >= 9) {
                    ((LevelAwareLogBuilder)i.lvlBuild(9, "SuiteIterator.runTest(File,String)", 1109).add("testSuccessful", bl2)).log();
                }
                object2 = this.a(file2);
                if (this.d || bl2 && !QFTest.this.e) {
                    file2.deleteOnExit();
                }
                object = object2;
                return object;
            }
            finally {
                if (file3 != null) {
                    file3.deleteOnExit();
                }
            }
        }

        private File b(String string) {
            int n2;
            File file = this.a(QFTest.this.d) ? (this.a == 0 ? new File(QFTest.this.d) : ((n2 = QFTest.this.d.lastIndexOf(46)) > -1 ? new File(QFTest.this.d.substring(0, n2) + "-" + this.a + QFTest.this.d.substring(n2)) : new File(QFTest.this.d + "-" + this.a))) : new File(this.b, string.substring(0, string.length() - 3) + "qzp");
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                Files.createDirectories(file2.toPath(), new FileAttribute[0]);
            }
            return file;
        }

        private TestRunLog a(File file) {
            return new TestRunLog(file, null, false);
        }

        public /* synthetic */ Object next() {
            return this.a();
        }
    }

    public static class Error
    extends AssertionError {
        public Error(String string) {
            super((Object)string);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @TestFactory
    public static @interface Test {
    }
}

