/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.io.a;
import de.qfs.apps.qftest.record.procbuilder.BaseProcbuilder;
import de.qfs.apps.qftest.record.procbuilder.ComponentProcbuilder;
import de.qfs.apps.qftest.record.procbuilder.ProcDef;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.ClientData;
import de.qfs.apps.qftest.shared.data.ElementInfo;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.notifications.TerminalOutput;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.step.CheckBooleanStep;
import de.qfs.apps.qftest.step.CheckGeometryStep;
import de.qfs.apps.qftest.step.CheckImageStep;
import de.qfs.apps.qftest.step.CheckItemsStep;
import de.qfs.apps.qftest.step.CheckSelectableItemsStep;
import de.qfs.apps.qftest.step.CheckStringStep;
import de.qfs.apps.qftest.step.CommentStep;
import de.qfs.apps.qftest.step.ComponentEventStep;
import de.qfs.apps.qftest.step.ComponentWaiter;
import de.qfs.apps.qftest.step.DocumentWaiter;
import de.qfs.apps.qftest.step.DownloadWaiter;
import de.qfs.apps.qftest.step.KeyEventStep;
import de.qfs.apps.qftest.step.MouseEventStep;
import de.qfs.apps.qftest.step.Package;
import de.qfs.apps.qftest.step.PackageRoot;
import de.qfs.apps.qftest.step.Procedure;
import de.qfs.apps.qftest.step.RootStep;
import de.qfs.apps.qftest.step.SelectionEventStep;
import de.qfs.apps.qftest.step.TextInputStep;
import de.qfs.apps.qftest.step.WindowEventStep;
import de.qfs.apps.qftest.suite.Suite;
import de.qfs.apps.qftest.suite.SuiteMap;
import de.qfs.apps.qftest.suite.include.Includer;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ProcedureDefinitions
implements TraversalCallback {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.ProcedureDefinitions");
    public static final String MULTI = "_multi_";
    public static final String NO_PROCEDURE_CALL = "NO_PROCEDURE_CALL";
    public static final String REMOVE = "REMOVE";
    public static final String PARAMETER = "PARAMETER";
    public static final String PARAMETER_APPEND = "PARAMETER_APPEND";
    public static final String PARAMETER_REPLACE = "PARAMETER_REPLACE";
    public static final String REPEAT = "REPEAT";
    public static final String REPEATCOUNT = "REPEATCOUNT";
    public static final String UNDEFINED = "UNDEFINED";
    public static final String ALTERNATIVE = "ALTERNATIVE";
    public static final String IGNORE = "IGNORE";
    public static final String SEPARATOR = "SEPARATOR";
    List procDefs = new ArrayList();
    static Map dictionaries = new LinkedHashMap();
    private List definitionNodes = new ArrayList();
    private List dictionaryNodes = new ArrayList();

    public ProcedureDefinitions() {
        if (ProcedureDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "ProcedureDefinitions()", 145).log();
        }
        File file = BaseProcbuilder.getRecordingProcessorConfFile();
        Suite suite = SuiteMap.instance().b(a.normalizeFile(file), true, false);
        if (suite != null) {
            HashSet hashSet = new HashSet();
            Stack stack = new Stack();
            new Includer(this, suite).searchIncludes(suite, this, hashSet, stack);
            if (this.definitionNodes.isEmpty()) {
                ProcedureDefinitions.logWarningToTerminal("Error: Neither the definition suite " + file.getPath() + " nor any include file contains a top level package 'definitions' in the section 'Packages'");
            } else {
                for (Package package_ : this.definitionNodes) {
                    this.getProcDefsFromPackage(package_);
                }
                for (Package package_ : this.dictionaryNodes) {
                    this.getDictionariesFromPackage(package_);
                }
            }
        } else {
            ProcedureDefinitions.logWarningToTerminal("Error: The definition suite " + file.getPath() + " could not be read");
        }
    }

    public static String getDefinitionFileName() {
        String string;
        if (ProcedureDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "getDefinitionFileName()", 175).log();
        }
        File file = BaseProcbuilder.getRecordingProcessorConfFile();
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string = file.getAbsolutePath();
        }
        string = string.replace("\\", "/");
        if (ProcedureDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getDefinitionFileName()", 185).add("file", string)).log();
        }
        return string;
    }

    public void getProcDefsFromPackage(Package package_) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getProcDefsFromPackage(Package)", 202).addDetail("procedures", (Object)package_)).log();
        }
        for (int i2 = 0; i2 < package_.getChildCount(); ++i2) {
            int n2;
            String[] stringArray;
            AbstractStep abstractStep = package_.getChild(i2);
            if (abstractStep.isDisabled()) continue;
            if (abstractStep instanceof Package) {
                this.getProcDefsFromPackage((Package)abstractStep);
                continue;
            }
            if (!(abstractStep instanceof Procedure)) continue;
            Procedure procedure = (Procedure)abstractStep;
            String string = procedure.getId();
            String string2 = procedure.getName();
            String[][] stringArray2 = procedure.getVariables();
            String string3 = "";
            String string4 = "";
            String string5 = "";
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            Object object = stringArray2;
            int n3 = ((String[][])object).length;
            block11: for (int i3 = 0; i3 < n3; ++i3) {
                stringArray = object[i3];
                switch (stringArray[0]) {
                    case "procdef_calledProcedure": {
                        string3 = stringArray[1];
                        continue block11;
                    }
                    case "procdef_condition": {
                        string4 = stringArray[1];
                        if (string4 != null) continue block11;
                        string4 = "";
                        continue block11;
                    }
                    case "procdef_returnVariable": {
                        string5 = stringArray[1];
                        if (string5 != null) continue block11;
                        string5 = "";
                        continue block11;
                    }
                    default: {
                        arrayList.add(stringArray);
                    }
                }
            }
            if (ProcedureDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getProcDefsFromPackage(Package)", 246).add("pvars", arrayList)).log();
            }
            if ((object = procedure.getComment()) == null) {
                object = "";
            }
            ArrayList arrayList2 = this.getDefinitionStepsWithoutComments(procedure);
            AbstractStep abstractStep2 = (AbstractStep)arrayList2.get(0);
            stringArray = ProcedureDefinitions.getStepSpecificsAndSetPlaceholders(null, abstractStep2, null, null);
            String string6 = stringArray[0];
            String string7 = "/" + stringArray[1].replace(",", "/").replace(" ", "") + "/";
            if (ProcedureDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getProcDefsFromPackage(Package)", 258).add("pclasses", string7)).log();
            }
            String[][] stringArray3 = new String[arrayList.size()][2];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                stringArray3[n2] = (String[])arrayList.get(n2);
            }
            if (ProcedureDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getProcDefsFromPackage(Package)", 264).add("procVars", (Object)stringArray3)).log();
            }
            n2 = arrayList2.size();
            ProcDef procDef = new ProcDef(string, string2, string6, string7, string4, string3, stringArray3, (String)object, n2, string5);
            this.procDefs.add(procDef);
            for (int i4 = 1; i4 < n2; ++i4) {
                abstractStep2 = (AbstractStep)arrayList2.get(i4);
                stringArray = ProcedureDefinitions.getStepSpecificsAndSetPlaceholders(null, abstractStep2, null, null);
                string6 = stringArray[0];
                string7 = "/" + stringArray[1].replace(",", "/").replace(" ", "") + "/";
                object = abstractStep2.getComment();
                procDef = new ProcDef(string + MULTI + i4, string2 + MULTI + i4, string6, string7, "", "", new String[0][0], (String)object, 0, "");
                this.procDefs.add(procDef);
            }
        }
    }

    public void getDictionariesFromPackage(Package package_) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getDictionariesFromPackage(Package)", 304).addDetail("dictionariesPackage", (Object)package_)).log();
        }
        for (int i2 = 0; i2 < package_.getChildCount(); ++i2) {
            String[][] stringArray;
            AbstractStep abstractStep = package_.getChild(i2);
            if (abstractStep.isDisabled()) continue;
            if (abstractStep instanceof Package) {
                this.getDictionariesFromPackage((Package)abstractStep);
                continue;
            }
            if (!(abstractStep instanceof Procedure)) continue;
            Procedure procedure = (Procedure)abstractStep;
            String string = procedure.getName();
            HashMap<String, String> hashMap = (HashMap<String, String>)dictionaries.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                dictionaries.put(string, hashMap);
            }
            for (String[] stringArray2 : stringArray = procedure.getVariables()) {
                if (hashMap.containsKey(stringArray2[0])) continue;
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
        }
        if (ProcedureDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getDictionariesFromPackage(Package)", 330).add("dictionaries", (Object)dictionaries)).log();
        }
    }

    public void addProcDef(ProcDef procDef) {
        this.procDefs.add(procDef);
    }

    public ArrayList getDefinitionStepsWithoutComments(Procedure procedure) {
        ArrayList<AbstractStep> arrayList = new ArrayList<AbstractStep>();
        int n2 = procedure.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            AbstractStep abstractStep = procedure.getChild(i2);
            if (abstractStep instanceof CommentStep || abstractStep.isDisabled()) continue;
            arrayList.add(abstractStep);
        }
        return arrayList;
    }

    public ArrayList getMatches(String string, ElementInfo elementInfo, HashMap hashMap) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getMatches(String,ElementInfo,HashMap<String, String>)", 377).addDetail("kind", string)).addDetail("info", (Object)elementInfo)).addDetail("placeholderValues", (Object)hashMap)).log();
        }
        ProcDef procDef = new ProcDef(NO_PROCEDURE_CALL, "", "", "", "", "", new String[0][0], string, 0, "");
        if (hashMap.get("COMPCLASS") == null || hashMap.get("COMPID") == null || string.equals(UNDEFINED)) {
            ArrayList<ProcDef> arrayList = new ArrayList<ProcDef>();
            arrayList.add(procDef.copyAndReplacePlaceholders(elementInfo));
            return arrayList;
        }
        boolean bl2 = false;
        ArrayList<ProcDef> arrayList = new ArrayList<ProcDef>();
        for (int i2 = 0; i2 < this.procDefs.size(); ++i2) {
            if (!((ProcDef)this.procDefs.get(i2)).matches(string, elementInfo, hashMap)) continue;
            arrayList.add(((ProcDef)this.procDefs.get(i2)).copyAndReplacePlaceholders(elementInfo));
            bl2 = true;
        }
        if (ProcedureDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getMatches(String,ElementInfo,HashMap<String, String>)", 399).add("procCalls", arrayList)).log();
        }
        if (bl2) {
            return arrayList;
        }
        ArrayList<ProcDef> arrayList2 = new ArrayList<ProcDef>();
        arrayList2.add(procDef.copyAndReplacePlaceholders(elementInfo));
        return arrayList2;
    }

    public ArrayList findMultiEventProcedures(ArrayList arrayList) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "findMultiEventProcedures(ArrayList<ArrayList<ProcDef>>)", 421).addDetail("procCallBuffer", (Object)arrayList)).log();
        }
        ArrayList<ProcDef> arrayList2 = new ArrayList<ProcDef>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ArrayList arrayList3 = new ArrayList();
            ProcDef procDef = (ProcDef)((ArrayList)arrayList.get(i2)).get(0);
            for (int i3 = 0; i3 < ((ArrayList)arrayList.get(i2)).size() && Misc.emptyOrNull(arrayList3); ++i3) {
                procDef = (ProcDef)((ArrayList)arrayList.get(i2)).get(i3);
                arrayList3 = this.findMultiEventProcedure(procDef, arrayList, i2);
            }
            arrayList2.add(procDef);
            if (ProcedureDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "findMultiEventProcedures(ArrayList<ArrayList<ProcDef>>)", 436).add("procCalls", arrayList2)).log();
            }
            if (arrayList3 == null) {
                procDef.setProcDefId(NO_PROCEDURE_CALL);
                continue;
            }
            procDef.setProcCallComment(Util.stripDoctags((String)procDef.getProcCallComment(), (String)PARAMETER));
            procDef.setProcCallComment(Util.stripDoctags((String)procDef.getProcCallComment(), (String)PARAMETER_REPLACE));
            if (procDef.getNumEvents() > 1) {
                String[][] stringArray;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string = null;
                String string2 = null;
                for (int i4 = 1; i4 < procDef.getNumEvents(); ++i4) {
                    object4 = ((ProcDef)((ArrayList)arrayList.get(i2 + i4)).get((Integer)arrayList3.get(i4))).getProcCallComment();
                    List list = Util.getNamedDoctags((String)object4, (String)PARAMETER);
                    object3 = new String[list.size()][2];
                    for (int i5 = 0; i5 < list.size(); ++i5) {
                        object3[i5] = (String[])list.get(i5);
                    }
                    object2 = ComponentProcbuilder.mergeParameterLists(procDef.procVars, object3);
                    procDef.procVars = (String[][])object2.clone();
                    list = Util.getNamedDoctags((String)object4, (String)PARAMETER_REPLACE);
                    object = new String[list.size()][2];
                    for (int i6 = 0; i6 < list.size(); ++i6) {
                        object[i6] = (String[])list.get(i6);
                    }
                    stringArray = ComponentProcbuilder.mergeParameterLists(procDef.procVars, (String[][])object, true);
                    procDef.procVars = (String[][])stringArray.clone();
                    arrayList2.add(new ProcDef(REMOVE, "", "", "", "", "", new String[0][0], "", i4, ""));
                    string2 = Util.getDoctag((String)object4, (String)"scope");
                    string = Util.getDoctag((String)object4, (String)"vscope");
                }
                List list = Util.getNamedDoctags((String)procDef.getProcCallComment(), (String)PARAMETER_APPEND);
                object4 = Util.stripDoctags((String)procDef.getProcCallComment(), (String)PARAMETER_APPEND);
                if (string2 != null) {
                    object4 = Util.stripDoctags((String)object4, (String)"scope");
                    object4 = (String)object4 + "\n@scope " + string2;
                }
                if (string != null) {
                    object4 = Util.stripDoctags((String)object4, (String)"vscope");
                    object4 = (String)object4 + "\n@vscope " + string;
                }
                procDef.setProcCallComment((String)object4);
                if (list != null) {
                    for (int i7 = 0; i7 < list.size(); ++i7) {
                        object3 = ((String[])list.get(i7))[1];
                        object2 = null;
                        object = ((String[])list.get(i7))[1].split("<SEPARATOR:");
                        if (((String[])object).length > 1) {
                            object3 = object[0].trim();
                            object2 = object[1].split(">")[0];
                        }
                        procDef.procVars = ComponentProcbuilder.appendParameter(procDef.procVars, ((String[])list.get(i7))[0], (String)object3, (String)object2);
                    }
                }
                for (int i8 = 1; i8 < procDef.getNumEvents(); ++i8) {
                    list = Util.getNamedDoctags((String)((ProcDef)((ArrayList)arrayList.get(i2 + i8)).get((Integer)arrayList3.get(i8))).getProcCallComment(), (String)PARAMETER_APPEND);
                    if (list == null) continue;
                    for (int i9 = 0; i9 < list.size(); ++i9) {
                        object2 = ((String[])list.get(i9))[1];
                        object = null;
                        stringArray = ((String[])list.get(i9))[1].split("<SEPARATOR:");
                        if (stringArray.length > 1) {
                            object2 = stringArray[0].trim();
                            object = stringArray[1].split(">")[0];
                        }
                        procDef.procVars = ComponentProcbuilder.appendParameter(procDef.procVars, ((String[])list.get(i9))[0], (String)object2, (String)object);
                    }
                }
                i2 += procDef.getNumEvents() - 1;
                continue;
            }
            procDef.setProcCallComment(Util.stripDoctags((String)procDef.getProcCallComment(), (String)PARAMETER_APPEND));
        }
        if (ProcedureDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "findMultiEventProcedures(ArrayList<ArrayList<ProcDef>>)", 538).add("procCalls", arrayList2)).log();
        }
        return arrayList2;
    }

    public ArrayList findMultiEventProcedure(ProcDef procDef, ArrayList arrayList, int n2) {
        int n3;
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "findMultiEventProcedure(ProcDef,ArrayList<ArrayList<ProcDef>>,int)", 592).addDetail("procCall", (Object)procDef)).addDetail("procCallBuffer", (Object)arrayList)).addDetail("mainIndex", n2)).log();
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n4 = procDef.getNumEvents();
        String string = procDef.getProcDefId();
        if (string.indexOf(MULTI) != -1 || string.equals(NO_PROCEDURE_CALL)) {
            return null;
        }
        arrayList2.add(-1);
        int n5 = this.handleRepeat(procDef, arrayList, n2, arrayList2);
        procDef.setProcCallComment(Util.stripDoctags((String)procDef.getProcCallComment(), (String)REPEAT));
        if (n4 == 1) {
            procDef.setNumEvents(arrayList2.size());
            return arrayList2;
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        boolean bl2 = this.isAlternative(string);
        boolean bl3 = false;
        int n6 = 1;
        for (n3 = n2 + n5 + 1; n6 < n4 && n3 < arrayList.size(); ++n6, ++n3) {
            bl3 = true;
            if (n3 >= arrayList.size()) continue;
            boolean bl4 = false;
            for (int i2 = 0; i2 < ((ArrayList)arrayList.get(n3)).size() && !bl4; ++i2) {
                String string2 = ((ProcDef)((ArrayList)arrayList.get(n3)).get(i2)).getProcDefId();
                if (string2.equals(NO_PROCEDURE_CALL) && this.getProcDef(string + MULTI + n6).getKind().equals(UNDEFINED)) {
                    arrayList3.add(i2);
                    bl4 = true;
                } else if (string2.equals(string + MULTI + n6)) {
                    arrayList3.add(i2);
                    n3 += this.handleRepeat((ProcDef)((ArrayList)arrayList.get(n3)).get(i2), arrayList, n3, arrayList3);
                    bl4 = true;
                }
                if (!bl4) continue;
                bl2 = this.isAlternative(string2);
                break;
            }
            if (bl4) continue;
            if (this.isIgnore(string + MULTI + n6)) {
                --n3;
                continue;
            }
            if (this.isAlternative(string + MULTI + n6)) {
                --n3;
                continue;
            }
            arrayList3 = null;
            ++n6;
            break;
        }
        if (n2 + n5 + n6 == arrayList.size()) {
            for (n3 = n6; n3 < n4; ++n3) {
                if (this.isAlternative(string + MULTI + n3) && bl2 || this.isIgnore(string + MULTI + n3)) continue;
                return null;
            }
        }
        if (Misc.emptyOrNull(arrayList3)) {
            if (!bl3) {
                procDef.setNumEvents(arrayList2.size());
                if (ProcedureDefinitions.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "findMultiEventProcedure(ProcDef,ArrayList<ArrayList<ProcDef>>,int)", 682).add("matchList", arrayList2)).log();
                }
                return arrayList2;
            }
            return null;
        }
        arrayList2.addAll(arrayList3);
        procDef.setNumEvents(arrayList2.size());
        if (ProcedureDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "findMultiEventProcedure(ProcDef,ArrayList<ArrayList<ProcDef>>,int)", 693).add("matchList", arrayList2)).log();
        }
        return arrayList2;
    }

    private boolean isAlternative(String string) {
        String string2;
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isAlternative(String)", 704).addDetail("procDefId", string)).log();
        }
        if ((string2 = this.getProcDef(string).getProcCallComment()) == null) {
            return false;
        }
        return Util.getDoctag((String)string2, (String)ALTERNATIVE) != null;
    }

    private boolean isIgnore(String string) {
        String string2;
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isIgnore(String)", 719).addDetail("procDefId", string)).log();
        }
        if ((string2 = this.getProcDef(string).getProcCallComment()) == null) {
            return false;
        }
        return Util.getDoctag((String)string2, (String)IGNORE) != null;
    }

    private int handleRepeat(ProcDef procDef, ArrayList arrayList, int n2, ArrayList arrayList2) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "handleRepeat(ProcDef,ArrayList<ArrayList<ProcDef>>,int,ArrayList<Integer>)", 743).addDetail("procCall", (Object)procDef)).addDetail("procCallBuffer", (Object)arrayList)).addDetail("currIndex", n2)).addDetail("matchList", (Object)arrayList2)).log();
        }
        String string = Util.getDoctag((String)procDef.getProcCallComment(), (String)REPEAT);
        int n3 = 1;
        if (string != null) {
            procDef.setProcCallComment(procDef.getProcCallComment().replaceAll("<REPEATCOUNT>", "0"));
            String string2 = procDef.getProcDefId();
            boolean bl2 = true;
            block0: while (bl2) {
                bl2 = false;
                if (n2 + n3 >= arrayList.size()) continue;
                for (int i2 = 0; i2 < ((ArrayList)arrayList.get(n2 + n3)).size(); ++i2) {
                    String string3 = ((ProcDef)((ArrayList)arrayList.get(n2 + n3)).get(i2)).getProcDefId();
                    if (!string3.equals(string2)) continue;
                    ((ProcDef)((ArrayList)arrayList.get(n2 + n3)).get(i2)).setProcCallComment(((ProcDef)((ArrayList)arrayList.get(n2 + n3)).get(i2)).getProcCallComment().replaceAll("<REPEATCOUNT>", Integer.toString(n3)));
                    bl2 = true;
                    ++n3;
                    arrayList2.add(i2);
                    continue block0;
                }
            }
        }
        if (ProcedureDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "handleRepeat(ProcDef,ArrayList<ArrayList<ProcDef>>,int,ArrayList<Integer>)", 776).add("cntRepeat - 1", n3 - 1)).log();
        }
        return n3 - 1;
    }

    public ProcDef getProcDef(String string) {
        for (int i2 = 0; i2 < this.procDefs.size(); ++i2) {
            if (!string.equals(((ProcDef)this.procDefs.get(i2)).getProcDefId())) continue;
            return (ProcDef)this.procDefs.get(i2);
        }
        return null;
    }

    public String getProcDefId(int n2) {
        return ((ProcDef)this.procDefs.get(n2)).getProcDefId();
    }

    protected static String[] getStepSpecificsAndSetPlaceholders(HashMap hashMap, AbstractStep abstractStep, ElementInfo elementInfo, ClientData clientData) {
        Object object;
        Object object2;
        String string;
        Object object3;
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getStepSpecificsAndSetPlaceholders(HashMap<String, String>,AbstractStep,ElementInfo,ClientData)", 813).addDetail("placeholderValues", (Object)hashMap)).addDetail("step", (Object)abstractStep)).addDetail("info", (Object)elementInfo)).addDetail("data", (Object)clientData)).log();
        }
        if (hashMap != null) {
            BaseProcbuilder.setInfoValue(elementInfo, "COMPCLASS");
            BaseProcbuilder.setInfoValue(elementInfo, "ENGINE");
            hashMap.put("INITIALSELECTEDSTATE", String.valueOf(elementInfo.getCurrentSelectedState()));
            hashMap.put("INITIALVALUE", elementInfo.getCurrentValue());
            hashMap.put("CURRENTSELECTEDSTATE", String.valueOf(elementInfo.getCurrentSelectedState()));
            hashMap.put("CURRENTENABLEDSTATE", String.valueOf(elementInfo.getCurrentEnabledState()));
            hashMap.put("CURRENTEDITABLESTATE", String.valueOf(elementInfo.getCurrentEditableState()));
            hashMap.put("CURRENTVALUE", elementInfo.getCurrentValue());
            ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "QFSLABELTOP", "labeltop");
            ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "QFSLABELBOTTOM", "labelbottom");
            ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "QFSLABELLEFT", "labelleft");
            ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "QFSLABELRIGHT", "labelright");
        }
        Object object4 = null;
        String string2 = "";
        String string3 = "";
        if (abstractStep instanceof MouseEventStep) {
            object3 = (MouseEventStep)abstractStep;
            object4 = object3.getEvent() == 2003 ? "click" : (object3.getEvent() == 2010 ? "doubleclick" : "mouse event");
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                string = object3.getX();
                if (string != null) {
                    hashMap.put("CURRENTX", string);
                } else {
                    hashMap.put("CURRENTX", "");
                }
                object2 = object3.getY();
                if (object2 != null) {
                    hashMap.put("CURRENTY", object2);
                } else {
                    hashMap.put("CURRENTY", "");
                }
                hashMap.put("CURRENTEVENTNAME", object3.m());
                hashMap.put("CURRENTMODIFIERS", object3.k());
                hashMap.put("CURRENTCLICKCOUNT", object3.l());
                hashMap.put("CURRENTPOPUPTRIGGER", object3.o());
                hashMap.put("CURRENTHARDCLICK", object3.p());
                if (elementInfo.getClazz().equals("CheckBox") || elementInfo.getClazz().equals("RadioButton") || elementInfo.getClazz().equals("ToggleButton")) {
                    object = elementInfo.getCurrentSelectedState();
                    if (Boolean.TRUE.equals(object)) {
                        hashMap.put("CURRENTSELECTEDSTATE", "false");
                        hashMap.put("CURRENTCHECKEDSTATE", "false");
                        hashMap.put("CURRENTVALUE", "true");
                    } else {
                        hashMap.put("CURRENTSELECTEDSTATE", "true");
                        hashMap.put("CURRENTCHECKEDSTATE", "true");
                        hashMap.put("CURRENTVALUE", "false");
                    }
                } else if (elementInfo.getClazz().equals("Button") || elementInfo.getClazz().equals("ComboBox") || elementInfo.getClazz().equals("Label") || elementInfo.getClazz().equals("TextArea") || elementInfo.getClazz().equals("TextField")) {
                    object = elementInfo.getCurrentValue();
                    if (object != null) {
                        hashMap.put("CURRENTVALUE", object);
                    }
                } else if (elementInfo.getClazz().equals("Table")) {
                    object = ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "CURRENTVALUE", "currentValue");
                    if ("true".equals(object)) {
                        hashMap.put("CURRENTCHECKEDSTATE", "false");
                    } else if ("false".equals(object)) {
                        hashMap.put("CURRENTCHECKEDSTATE", "true");
                    }
                }
            }
        }
        if (abstractStep instanceof SelectionEventStep) {
            object4 = "selection";
            object3 = (SelectionEventStep)abstractStep;
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                hashMap.put("CURRENTDETAIL", object3.k());
                string = object3.k();
                hashMap.put("CURRENTDETAIL", string);
                if (string.startsWith("swipe: ") && (object2 = string.split(" ")) != null && ((String[])object2).length == 6) {
                    hashMap.put("STARTX", object2[1]);
                    hashMap.put("STARTY", object2[2]);
                    hashMap.put("ENDX", object2[3]);
                    hashMap.put("ENDY", object2[4]);
                    hashMap.put("SWIPEDURATION", object2[5]);
                }
            }
        }
        if (abstractStep instanceof KeyEventStep) {
            object4 = "key";
            object3 = (KeyEventStep)abstractStep;
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                hashMap.put("CURRENTEVENTNAME", object3.m());
                hashMap.put("CURRENTKEYCHAR", object3.l());
                hashMap.put("CURRENTKEYCODE", object3.k());
                hashMap.put("CURRENTMODIFIERS", object3.o());
            }
        }
        if (abstractStep instanceof ComponentEventStep) {
            object4 = "component event";
            object3 = (ComponentEventStep)abstractStep;
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                hashMap.put("CURRENTX", object3.k());
                hashMap.put("CURRENTY", object3.l());
                hashMap.put("CURRENTEVENTNAME", object3.m());
            }
        }
        if (abstractStep instanceof WindowEventStep) {
            object4 = "window event";
            object3 = (WindowEventStep)abstractStep;
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                hashMap.put("CURRENTEVENTNAME", object3.m());
            }
        }
        if (abstractStep instanceof TextInputStep) {
            object4 = "text";
            object3 = (TextInputStep)abstractStep;
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string = object3.getText();
                hashMap.put("CURRENTVALUE", string);
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                hashMap.put("CURRENTTEXTCLEAR", object3.k());
                hashMap.put("CURRENTSINGLEEVENTS", object3.l());
            }
        }
        if (abstractStep instanceof CheckStringStep) {
            object3 = abstractStep.getAttributeValue("checktype");
            object4 = "check string " + (String)object3;
            string3 = ((CheckStringStep)abstractStep).getComponentId();
            if (hashMap != null) {
                string = ((CheckStringStep)abstractStep).getText();
                hashMap.put("CURRENTVALUE", string);
                string2 = ((CheckStringStep)abstractStep).getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
            }
        }
        if (abstractStep instanceof CheckBooleanStep) {
            object3 = abstractStep.getAttributeValue("checktype");
            object4 = "check " + (String)object3;
            string3 = ((CheckBooleanStep)abstractStep).getComponentId();
            if (hashMap != null) {
                boolean bl2 = ((BooleanCheckData)clientData).getState();
                if (bl2) {
                    hashMap.put("CURRENTSTATE", "true");
                    if (object3.equals("selected") || object3.equals("item_selected")) {
                        hashMap.put("CURRENTSELECTEDSTATE", "true");
                    }
                    if (object3.equals("checked")) {
                        hashMap.put("CURRENTCHECKEDSTATE", "true");
                    } else if (object3.equals("focused")) {
                        hashMap.put("CURRENTFOCUSEDSTATE", "true");
                    } else if (object3.equals("visible")) {
                        hashMap.put("CURRENTVISIBLESTATE", "true");
                    } else if (object3.equals("enabled")) {
                        hashMap.put("CURRENTENABLEDSTATE", "true");
                    } else if (object3.equals("editable")) {
                        hashMap.put("CURRENTEDITABLESTATE", "true");
                    }
                } else {
                    hashMap.put("CURRENTSTATE", "false");
                    if (object3.equals("selected") || object3.equals("item_selected")) {
                        hashMap.put("CURRENTSELECTEDSTATE", "false");
                    }
                    if (object3.equals("checked")) {
                        hashMap.put("CURRENTCHECKEDSTATE", "false");
                    } else if (object3.equals("focused")) {
                        hashMap.put("CURRENTFOCUSEDSTATE", "false");
                    } else if (object3.equals("visible")) {
                        hashMap.put("CURRENTVISIBLESTATE", "false");
                    } else if (object3.equals("enabled")) {
                        hashMap.put("CURRENTENABLEDSTATE", "false");
                    } else if (object3.equals("editable")) {
                        hashMap.put("CURRENTEDITABLESTATE", "false");
                    }
                }
                string2 = ((CheckBooleanStep)abstractStep).getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
            }
        }
        if (abstractStep instanceof CheckGeometryStep) {
            object4 = "check geometry";
            object3 = (CheckGeometryStep)abstractStep;
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                hashMap.put("CURRENTHEIGHT", object3.n());
                hashMap.put("CURRENTWIDTH", object3.m());
                hashMap.put("CURRENTX", object3.getX());
                hashMap.put("CURRENTY", object3.getY());
            }
        }
        if (abstractStep instanceof CheckImageStep) {
            object4 = "check image";
            string3 = ((CheckImageStep)abstractStep).getComponentId();
            if (hashMap != null) {
                string2 = ((CheckImageStep)abstractStep).getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
            }
        }
        if (abstractStep instanceof CheckItemsStep) {
            object3 = abstractStep.getAttributeValue("checktype");
            object4 = "check items" + (String)object3;
            CheckItemsStep checkItemsStep = (CheckItemsStep)abstractStep;
            string3 = checkItemsStep.getComponentId();
            if (hashMap != null) {
                string2 = checkItemsStep.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                object2 = checkItemsStep.getItems();
                object = ProcedureDefinitions.itemsToString((Object[][])object2, false);
                hashMap.put("CURRENTITEMS", object);
            }
        }
        if (abstractStep instanceof CheckSelectableItemsStep) {
            object4 = "check selectable items";
            object3 = (CheckSelectableItemsStep)abstractStep;
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                Object[][] objectArray = object3.getItems();
                object2 = ProcedureDefinitions.itemsToString(objectArray, true);
                hashMap.put("CURRENTITEMSWITHSELECTION", object2);
            }
        }
        if (abstractStep instanceof ComponentWaiter) {
            object4 = "wait for component";
            object3 = (ComponentWaiter)abstractStep;
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
            }
        }
        if (abstractStep instanceof DocumentWaiter) {
            object4 = "wait for document";
            object3 = (DocumentWaiter)abstractStep;
            string3 = object3.getComponentId();
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                hashMap.put("CURRENTWINDOW", object3.p());
            }
        }
        if (abstractStep instanceof DownloadWaiter) {
            object4 = "wait for download";
            object3 = (DownloadWaiter)abstractStep;
            string3 = UNDEFINED;
            if (hashMap != null) {
                string2 = object3.getClient();
                hashMap.put("CLIENT", string2);
                hashMap.put("COMPID", string3);
                hashMap.put("CURRENTFILE", object3.k());
            }
        }
        if (object4 == null) {
            object4 = UNDEFINED;
            string3 = UNDEFINED;
        }
        if (elementInfo != null) {
            if (elementInfo.getClazz().equals("Table")) {
                if (ProcedureDefinitions.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getStepSpecificsAndSetPlaceholders(HashMap<String, String>,AbstractStep,ElementInfo,ClientData)", 1149).add("table component found - set place holders")).log();
                }
                object3 = elementInfo.getItemIndexes();
                if (ProcedureDefinitions.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getStepSpecificsAndSetPlaceholders(HashMap<String, String>,AbstractStep,ElementInfo,ClientData)", 1151).add("idxs", object3)).log();
                }
                if (!Misc.emptyOrNull((Object[])object3)) {
                    block9: for (int i2 = 0; i2 < ((Object[])object3).length; ++i2) {
                        object2 = object3[i2].getIndex();
                        if (object2 == null) {
                            object2 = "";
                        }
                        switch (i2) {
                            case 0: {
                                object = ProcedureDefinitions.getSeparator((SubItemIndex)object3[i2]);
                                hashMap.put("SUBINDEXCOL", object2);
                                hashMap.put("SUBINDEXCOLSEPARATOR", object);
                                continue block9;
                            }
                            case 1: {
                                object = ProcedureDefinitions.getSeparator((SubItemIndex)object3[i2]);
                                hashMap.put("SUBINDEXROW", object2);
                                hashMap.put("SUBINDEXROWSEPARATOR", object);
                                continue block9;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                ProcedureDefinitions.setPlaceholderValuesForItemcomponent(hashMap, i2 - 2, (String)object2);
                                continue block9;
                            }
                            default: {
                                ProcedureDefinitions.logWarningToTerminal("The maximum level for nesting of components in a table cell is 5!");
                            }
                        }
                    }
                    if (ProcedureDefinitions.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getStepSpecificsAndSetPlaceholders(HashMap<String, String>,AbstractStep,ElementInfo,ClientData)", 1190).add("info", (Object)elementInfo)).add("info.retrieveExtraData(\"textIndexRow\")", (Object)elementInfo.retrieveExtraData("textIndexRow"))).add("info.retrieveExtraData(\"numIndexRow\")", (Object)elementInfo.retrieveExtraData("numIndexRow"))).add("info.retrieveExtraData(\"textIndexCol\")", (Object)elementInfo.retrieveExtraData("textIndexCol"))).add("info.retrieveExtraData(\"numIndexCol\")", (Object)elementInfo.retrieveExtraData("numIndexCol"))).log();
                    }
                    ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "SUBINDEXROWTEXT", "textIndexRow");
                    ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "SUBINDEXROWNUMERIC", "numIndexRow");
                    ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "SUBINDEXCOLTEXT", "textIndexCol");
                    ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "SUBINDEXCOLNUMERIC", "numIndexCol");
                    ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "CELLVALUE", "cellValue");
                    ProcedureDefinitions.setPlaceholderCompidwithoutindex(hashMap, elementInfo, string3);
                }
            } else {
                if (ProcedureDefinitions.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getStepSpecificsAndSetPlaceholders(HashMap<String, String>,AbstractStep,ElementInfo,ClientData)", 1202).add("Complex component found")).log();
                }
                object3 = elementInfo.getItemIndexes();
                if (ProcedureDefinitions.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getStepSpecificsAndSetPlaceholders(HashMap<String, String>,AbstractStep,ElementInfo,ClientData)", 1204).add("idxs", object3)).log();
                }
                if (object3 != null && elementInfo.getItemIndexes().length > 0) {
                    block10: for (int i3 = 0; i3 < ((Object[])object3).length; ++i3) {
                        object2 = object3[i3].getIndex();
                        if (object2 == null) {
                            object2 = "";
                        }
                        switch (i3) {
                            case 0: {
                                object = ProcedureDefinitions.getSeparator((SubItemIndex)object3[i3]);
                                hashMap.put("SUBINDEX", object2);
                                hashMap.put("SUBINDEXSEPARATOR", object);
                                continue block10;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                ProcedureDefinitions.setPlaceholderValuesForItemcomponent(hashMap, i3 - 1, (String)object2);
                                continue block10;
                            }
                            default: {
                                ProcedureDefinitions.logWarningToTerminal("The maximum level for nesting of components in an item is 5!");
                            }
                        }
                    }
                    ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "SUBINDEXTEXT", "textIndex");
                    ProcedureDefinitions.setPlaceholderWithExtraData(hashMap, elementInfo, "SUBINDEXNUMERIC", "numIndex");
                    ProcedureDefinitions.setPlaceholderCompidwithoutindex(hashMap, elementInfo, string3);
                }
            }
        }
        object3 = new String[]{object4, string3};
        if (ProcedureDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getStepSpecificsAndSetPlaceholders(HashMap<String, String>,AbstractStep,ElementInfo,ClientData)", 1246).add("result", object3)).log();
        }
        return object3;
    }

    private static void setPlaceholderCompidwithoutindex(HashMap hashMap, ElementInfo elementInfo, String string) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setPlaceholderCompidwithoutindex(HashMap<String, String>,ElementInfo,String)", 1255).addDetail("placeholderValues", (Object)hashMap)).addDetail("info", (Object)elementInfo)).addDetail("id", string)).log();
        }
        if (string.startsWith("#")) {
            hashMap.put("COMPIDWITHOUTINDEX", elementInfo.getSuggestedSmartID());
        } else {
            String string2 = string.split("@|%|&")[0];
            hashMap.put("COMPIDWITHOUTINDEX", string2);
        }
    }

    private static String setPlaceholderWithExtraData(HashMap hashMap, ElementInfo elementInfo, String string, String string2) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setPlaceholderWithExtraData(HashMap<String, String>,ElementInfo,String,String)", 1268).addDetail("placeholderValues", (Object)hashMap)).addDetail("info", (Object)elementInfo)).addDetail("placeholder", string)).addDetail("extrDataKey", string2)).log();
        }
        String string3 = null;
        try {
            string3 = elementInfo.retrieveExtraData(string2).toString();
            if (ProcedureDefinitions.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "setPlaceholderWithExtraData(HashMap<String, String>,ElementInfo,String,String)", 1273).add("value", string3)).log();
            }
            if (string3 != null) {
                hashMap.put(string, string3);
            }
        }
        catch (Exception exception) {
            try {
                string3 = (String)((Object)elementInfo.retrieveExtraData(string2));
                if (ProcedureDefinitions.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "setPlaceholderWithExtraData(HashMap<String, String>,ElementInfo,String,String)", 1280).add("value", string3)).log();
                }
                if (string3 != null) {
                    hashMap.put(string, string3);
                }
            }
            catch (Exception exception2) {
                if (ProcedureDefinitions.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "setPlaceholderWithExtraData(HashMap<String, String>,ElementInfo,String,String)", 1285).add("value", string3)).log();
                }
                ProcedureDefinitions.logWarningToTerminal("Cannot set the placeholder " + string + " with info.extrDataKey('" + string2 + "')");
            }
        }
        return string3;
    }

    private static void setPlaceholderValuesForItemcomponent(HashMap hashMap, int n2, String string) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setPlaceholderValuesForItemcomponent(HashMap<String, String>,int,String)", 1296).addDetail("placeholderValues", (Object)hashMap)).addDetail("itemCompLevel", n2)).addDetail("val", string)).log();
        }
        if (string.charAt(0) == ':') {
            hashMap.put(String.format("%s%s", "ITEMCOMPONENT", n2), string.substring(1));
        } else {
            hashMap.put(String.format("%s%s", "ITEMCOMPONENT", n2), string);
        }
    }

    private static String getSeparator(SubItemIndex subItemIndex) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getSeparator(SubItemIndex)", 1309).addDetail("idx", (Object)subItemIndex)).log();
        }
        String string = "";
        switch (subItemIndex.getType()) {
            case 0: {
                string = "@";
                break;
            }
            case 1: {
                string = "&";
                break;
            }
            case 2: {
                string = "&";
            }
        }
        return string;
    }

    private static String itemsToString(Object[][] objectArray, Boolean bl2) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "itemsToString(Object[][],Boolean)", 1337).addDetail("items", (Object)objectArray)).addDetail("addSelectionState", (Object)bl2)).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2][0].toString().replace(Options.cached_OPT_RECORDING_PROCESSOR_ITEMLIST_SEPARATOR, Options.cached_OPT_RECORDING_PROCESSOR_ITEMLIST_SEPARATOR_ESCAPE_STRING);
            if (Boolean.TRUE.equals(bl2)) {
                String string = objectArray[i2][2].toString();
                object = (String)object + " selected=" + string;
            }
            if (i2 == 0) {
                stringBuilder.append((String)object);
                continue;
            }
            stringBuilder.append(Options.cached_OPT_RECORDING_PROCESSOR_ITEMLIST_SEPARATOR).append((String)object);
        }
        return stringBuilder.toString();
    }

    private static void logProcCallToTerminal(ProcDef procDef) {
        String string;
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "logProcCallToTerminal(ProcDef)", 1365).addDetail("procDef", (Object)procDef)).log();
        }
        if (Options.cached_OPT_RECORDING_PROCESSOR_LOGLEVEL == 10 && ((string = Options.cached_OPT_RECORDING_PROCESSOR_LOGDEFNAME).equals("all") || string.equals(procDef.getProcDefName()) || procDef.getProcDefName().indexOf(string + MULTI) == 0)) {
            ProcedureDefinitions.logToTerminal(procDef.toString());
        }
    }

    private static void logToTerminal(String string) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "logToTerminal(String)", 1384).addDetail("output", string)).log();
        }
        if (Options.cached_OPT_RECORDING_PROCESSOR_LOGLEVEL == 10) {
            String string2 = string.replace("|||", "\n            ");
            string2 = string2.replace("||", "\n        ");
            string2 = string2.replace("|", "\n    ");
            if (TerminalOutput.NOTIFIER.level >= 1) {
                TerminalOutput.NOTIFIER.postNotification(1, "terminal.output", null, new Object[]{"data", string2 + "\n", "source", "ProcedureCallRecorder"});
            }
        }
        if (ProcedureDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "logToTerminal(String)", 1392).add("output", string)).log();
        }
    }

    public static void logWarningToTerminal(String string) {
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "logWarningToTerminal(String)", 1401).addDetail("output", string)).log();
        }
        if (TerminalOutput.NOTIFIER.level >= 1) {
            TerminalOutput.NOTIFIER.postNotification(1, "terminal.output", null, new Object[]{"data", string + "\n", "source", "ProcedureCallRecorder"});
        }
        if (ProcedureDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "logWarningToTerminal(String)", 1404).add("output", string)).log();
        }
    }

    public void visit(Suite suite) {
        PackageRoot packageRoot;
        if (ProcedureDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "visit(Suite)", 1413).addDetail("suite", (Object)suite)).log();
        }
        if (suite.getRoot() instanceof RootStep && (packageRoot = ((RootStep)suite.getRoot()).getProcedures()) != null && !packageRoot.isDisabled()) {
            TreeUtil.traverse((TreeAdapter)suite, (Object)packageRoot, (TraversalCallback)this);
        }
    }

    public boolean nodeEntered(Traversal traversal) {
        if (traversal.getNode() instanceof Package) {
            Package package_ = (Package)traversal.getNode();
            if (ProcedureDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "nodeEntered(Traversal)", 1431).add("pkg", (Object)package_)).log();
            }
            if (package_.isDisabled()) {
                return false;
            }
            if ("definitions".equals(package_.getName())) {
                this.definitionNodes.add(package_);
                return false;
            }
            if ("dictionaries".equals(package_.getName())) {
                this.dictionaryNodes.add(package_);
                return false;
            }
        }
        return true;
    }

    public void nodeExited(Traversal traversal) {
    }
}

