/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.record.procbuilder.RppExtractStep;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholder;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholdersForStep;
import de.qfs.apps.qftest.shared.data.e;
import de.qfs.apps.qftest.step.AbstractComponentDependant;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RppCompIdData {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppCompIdData");
    private static final String RPP_COMPONENT_ID = "rpp_component_id";
    private static final String RPP_ANY = "any";
    private static final String RPP_VAR_IS_NO_INDEX = "rpp_var_is_no_index";
    private static final Map duplicateComponents = new HashMap();
    private String componentAttribute = null;
    private String compIdWithoutSubIndex = null;
    private String componentSuite;
    private final List variables = new ArrayList();
    private List subindexes = new ArrayList();
    private List scopeIds = new ArrayList();
    private StringBuilder sbError = new StringBuilder();

    protected RppCompIdData(String string) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "RppCompIdData(String)", 124).addDetail("id", string)).log();
        }
        this.updateCompIdVariables(string);
    }

    @Nullable
    public String getSubindexValue(int n2) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getSubindexValue(int)", 133).addDetail("idx", n2)).log();
        }
        if (this.subindexes.size() > n2) {
            return (String)((Map)this.subindexes.get(n2)).get("index");
        }
        return null;
    }

    @Nullable
    public String getSubindexSeparator(int n2) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getSubindexSeparator(int)", 143).addDetail("idx", n2)).log();
        }
        if (this.subindexes.size() > n2) {
            return (String)((Map)this.subindexes.get(n2)).get("separator");
        }
        return null;
    }

    void updateCompIdVariables(String string) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "updateCompIdVariables(String)", 157).addDetail("newComponentAttribute", string)).log();
        }
        if (this.componentAttribute == null || !this.componentAttribute.equals(string)) {
            int n2;
            this.componentAttribute = string;
            String[] stringArray = AbstractComponentDependant.e(this.componentAttribute);
            this.componentSuite = stringArray[0];
            int n3 = 1;
            if (e.a((String)stringArray[1])) {
                String string2;
                for (n2 = 2; n2 < stringArray.length && (string2 = stringArray[n2]) != null && string2.startsWith("@#"); ++n2) {
                    ++n3;
                }
            }
            this.compIdWithoutSubIndex = n3 == 1 ? stringArray[n3] : stringArray[n3].substring(1);
            for (n2 = 1; n2 < n3; ++n2) {
                if (n2 == 1) {
                    this.scopeIds.add(stringArray[n2]);
                    continue;
                }
                this.scopeIds.add(stringArray[n2].substring(1));
            }
            for (n2 = n3 + 1; n2 < stringArray.length && this.addSubindex(null, stringArray[n2], n2 - 1 - n3); ++n2) {
            }
            this.compIdWithoutSubIndex = AbstractComponentDependant.f(this.compIdWithoutSubIndex);
        }
    }

    private void removeVariablesFromCompIdWithoutIndex(RppPlaceholdersForStep rppPlaceholdersForStep) {
        String[] stringArray;
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeVariablesFromCompIdWithoutIndex(RppPlaceholdersForStep)", 228).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).log();
        }
        if ((stringArray = this.compIdWithoutSubIndex.split(Misc.quoteRegex((String)"$("))).length == 1) {
            return;
        }
        boolean bl2 = false;
        if (rppPlaceholdersForStep.getStep() != null) {
            boolean bl3 = bl2 = rppPlaceholdersForStep.getStep().getDoctag(RPP_VAR_IS_NO_INDEX) != null;
        }
        if (bl2) {
            return;
        }
        int n2 = 1;
        if ("".equals(stringArray[0])) {
            this.addVariableForParameters(stringArray[1].substring(0, stringArray[1].length() - 1), "id", true);
            this.compIdWithoutSubIndex = null;
            n2 = 2;
        }
        if ((stringArray.length + n2) % 2 == 1) {
            this.compIdWithoutSubIndex = stringArray[0];
            this.sbError.append("\nCannot create a definition which will work for ('").append(this.compIdWithoutSubIndex).append("') because it contains an uneven number of variables.").append("The algorithm can only handle subindex variable pairs with separator and index value,").append("when the separator is not hardcoded. If the variable is not for an index mark the").append("step with the doctag @").append(RPP_VAR_IS_NO_INDEX).append(".");
            return;
        }
        for (int i2 = n2; i2 < stringArray.length; i2 += 2) {
            if (RppCompIdData.remainingVariableSyntaxIsOk(stringArray[i2]) && RppCompIdData.remainingVariableSyntaxIsOk(stringArray[i2 + 1])) {
                this.addSubindex("$(" + stringArray[i2], "$(" + stringArray[i2 + 1], (i2 - 1) / 2);
                continue;
            }
            this.sbError.append("\nThe definition will not work for (\"").append(this.compIdWithoutSubIndex).append("\") because the indexes are a mixture of text and variables.");
        }
        this.compIdWithoutSubIndex = stringArray[0];
    }

    private static boolean remainingVariableSyntaxIsOk(String string) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "remainingVariableSyntaxIsOk(String)", 276).addDetail("variableRemainder", string)).log();
        }
        return ")".equals(string.substring(string.length() - 1)) && !string.substring(0, string.length() - 1).contains(")");
    }

    private static String findVariableReference(String string, List list) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "findVariableReference(String,List<String>)", 282).addDetail("string", string)).addDetail("variableNames", (Object)list)).log();
        }
        if (string == null || list == null) {
            return null;
        }
        for (String string2 : list) {
            if (!string.contains(RppPlaceholder.addVariableReference(string2))) continue;
            return string2;
        }
        return null;
    }

    protected boolean addComponentAttributeAndIdToCode(RppPlaceholdersForStep rppPlaceholdersForStep, String[][] stringArray) {
        String string;
        Object object;
        String string2;
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addComponentAttributeAndIdToCode(RppPlaceholdersForStep,String[][])", 307).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).addDetail("hierarchyParameters", (Object)stringArray)).log();
        }
        if (Misc.emptyOrNull((String)this.componentAttribute)) {
            return false;
        }
        String string3 = RppPlaceholder.replaceCallerVariables(this.componentAttribute, stringArray);
        this.updateCompIdVariables(string3);
        String string4 = null;
        String string5 = null;
        if (rppPlaceholdersForStep.getStep() != null && rppPlaceholdersForStep.getStep().getDoctag("rpp_parameter") != null) {
            string2 = rppPlaceholdersForStep.getStep().getDoctag("rpp_parameter");
            object = string2.split("=");
            if (((String[])object).length != 2) {
                this.sbError.append("Invalid doctag 'rpp_parameter'. Expected syntax: '@rpp_parameter <varname>=<varvalue>'. Got: ").append(string2);
            } else {
                string4 = object[0];
                string5 = object[1];
            }
        }
        if (string4 != null) {
            string3 = this.componentAttribute.replace(RppPlaceholder.addVariableReference(string4), string5);
            this.updateCompIdVariables(string3);
        }
        string2 = null;
        if (rppPlaceholdersForStep.getStep() != null && rppPlaceholdersForStep.getStep().getDoctag(RPP_COMPONENT_ID) != null) {
            string2 = rppPlaceholdersForStep.getStep().getDoctag(RPP_COMPONENT_ID);
        }
        if (RppExtractStep.isAVariable(this.componentAttribute)) {
            this.addVariableForParameters(RppPlaceholder.stripVarReference(this.componentAttribute), "component id", true);
            if (string2 == null) {
                this.compIdWithoutSubIndex = null;
                return false;
            }
            this.updateCompIdVariables(string2);
        }
        if (RPP_ANY.equals(string2)) {
            this.compIdWithoutSubIndex = null;
            return false;
        }
        this.removeVariablesFromCompIdWithoutIndex(rppPlaceholdersForStep);
        object = rppPlaceholdersForStep.getPlaceholderValue("name");
        if (object != null ? ((String)object).contains("$(") : (string = rppPlaceholdersForStep.getPlaceholderValue("feature")) != null && string.contains("$(")) {
            return false;
        }
        if (duplicateComponents.containsKey(this.compIdWithoutSubIndex)) {
            string = (String)duplicateComponents.get(this.compIdWithoutSubIndex);
            this.componentAttribute = this.componentAttribute.replace(this.compIdWithoutSubIndex, string);
            this.compIdWithoutSubIndex = string;
        }
        return this.compIdWithoutSubIndex != null;
    }

    private void addVariableForParameters(String string, String string2, boolean bl2) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addVariableForParameters(String,String,boolean)", 396).addDetail("parameterName", string)).addDetail("parameterValue", string2)).addDetail("valueIsPlaceholderName", bl2)).log();
        }
        if (string == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        hashMap.put("value", string2);
        hashMap.put("valueIsPlaceholderName", String.valueOf(bl2));
        this.variables.add(hashMap);
    }

    private boolean addSubindex(String string, String string2, int n2) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "addSubindex(String,String,int)", 415).addDetail("separator", string)).addDetail("subindexValue", string2)).addDetail("index", n2)).log();
        }
        if (Misc.emptyOrNull((String)string2)) {
            return false;
        }
        if (string == null) {
            string = string2.substring(0, 1);
            string2 = string2.length() == 1 ? "" : string2.substring(1);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("separator", string);
        hashMap.put("index", string2);
        if (n2 == this.subindexes.size()) {
            this.subindexes.add(hashMap);
        } else if (n2 < this.subindexes.size()) {
            this.subindexes.add(n2, hashMap);
        } else {
            this.sbError.append("Invalid index structure: The index '").append(string2).append("' cannot be added at position ").append(n2).append(" because there have only been added ").append(this.subindexes.size()).append(" subindexes to the list so far (").append(this.subindexes).append(").");
        }
        return true;
    }

    public String getComponentAttribute() {
        if (RppCompIdData.logger.level >= 7) {
            logger.lvlBuild(7, "getComponentAttribute()", 63).log();
        }
        return this.componentAttribute;
    }

    public RppCompIdData setComponentAttribute(String string) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setComponentAttribute(String)", 63).addDetail("componentAttribute", string)).log();
        }
        this.componentAttribute = string;
        return this;
    }

    public String getCompIdWithoutSubIndex() {
        if (RppCompIdData.logger.level >= 7) {
            logger.lvlBuild(7, "getCompIdWithoutSubIndex()", 78).log();
        }
        return this.compIdWithoutSubIndex;
    }

    public RppCompIdData setCompIdWithoutSubIndex(String string) {
        if (RppCompIdData.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCompIdWithoutSubIndex(String)", 78).addDetail("compIdWithoutSubIndex", string)).log();
        }
        this.compIdWithoutSubIndex = string;
        return this;
    }

    public String getComponentSuite() {
        if (RppCompIdData.logger.level >= 7) {
            logger.lvlBuild(7, "getComponentSuite()", 92).log();
        }
        return this.componentSuite;
    }

    public List getVariables() {
        if (RppCompIdData.logger.level >= 7) {
            logger.lvlBuild(7, "getVariables()", 99).log();
        }
        return this.variables;
    }

    public List getSubindexes() {
        if (RppCompIdData.logger.level >= 7) {
            logger.lvlBuild(7, "getSubindexes()", 106).log();
        }
        return this.subindexes;
    }

    public List getScopeIds() {
        if (RppCompIdData.logger.level >= 7) {
            logger.lvlBuild(7, "getScopeIds()", 112).log();
        }
        return this.scopeIds;
    }

    public StringBuilder getSbError() {
        if (RppCompIdData.logger.level >= 7) {
            logger.lvlBuild(7, "getSbError()", 118).log();
        }
        return this.sbError;
    }

    static {
        duplicateComponents.put("Message.error", "WizardMessage.error");
        duplicateComponents.put("StepLogFrame", "CommonStepLogFrame");
    }
}

