/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.record.procbuilder.BaseProcbuilder;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholdersForStep;
import de.qfs.apps.qftest.script.languages.ScriptLanguageFactoryServer;
import de.qfs.apps.qftest.shared.script.m;
import de.qfs.apps.qftest.shared.script.n;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.MessageCollector;
import de.qfs.lib.util.Misc;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;

public class RppConditionDefinition {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppConditionDefinition");
    protected static final String JYTHON = "jython";
    protected static final String GROOVY = "groovy";
    protected static final String JAVASCRIPT = "javascript";
    protected static final String REGEXP = "regexp";
    private String expression;

    public boolean evaluateCondition(RppPlaceholdersForStep rppPlaceholdersForStep, String string, @Nullable String string2, String[] stringArray) {
        boolean bl2;
        if (RppConditionDefinition.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "evaluateCondition(RppPlaceholdersForStep,String,String,String[])", 56).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).addDetail("nodeName", string)).addDetail("interpreter", string2)).addDetail("conditionGot", (Object)stringArray)).log();
        }
        if (rppPlaceholdersForStep == null) {
            throw new IllegalArgumentException("stepPlaceholders is marked non-null but is null");
        }
        String string3 = this.expression;
        if (Misc.isTrimmedEmptyOrNull((String)string3) || string3.equals("your-condition")) {
            bl2 = true;
        } else {
            String string4 = rppPlaceholdersForStep.replacePlaceholders(string3, string2);
            bl2 = RppConditionDefinition.performConditionCheck(string, string4, string2, stringArray);
        }
        return bl2;
    }

    protected static boolean verifyOneRegexCondition(String string, String string2, String string3, boolean bl2) {
        int n2;
        if (RppConditionDefinition.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "verifyOneRegexCondition(String,String,String,boolean)", 84).addDetail("nodeName", string)).addDetail("comment", string2)).addDetail("condition", string3)).addDetail("matchOrNot", bl2)).log();
        }
        if (RppConditionDefinition.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "verifyOneRegexCondition(String,String,String,boolean)", 87).addDetail("nodeName", string)).addDetail("comment", string2)).addDetail("condition", string3)).addDetail("matchOrNot", bl2)).log();
        }
        if ((n2 = string2.indexOf(string3)) != -1) {
            String string4 = string2.substring(0, n2);
            String string5 = string2.substring(n2 + 2);
            if (!Misc.emptyOrNull((String)string4) && !Misc.emptyOrNull((String)string5)) {
                string5 = string5.trim();
                string4 = string4.trim();
                string5 = BaseProcbuilder.getTextWithoutQuotes(string5);
                string4 = BaseProcbuilder.getTextWithoutQuotes(string4);
                if (string5 == null || string4 == null) {
                    MessageCollector.instance().logFatalError("Syntax of regular expression seems to be wrong for '" + string + "'.");
                    return false;
                }
                try {
                    Pattern pattern = Pattern.compile(string5);
                    Matcher matcher = pattern.matcher(string4);
                    return matcher.matches() == bl2;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if (RppConditionDefinition.logger.level >= 3) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "verifyOneRegexCondition(String,String,String,boolean)", 111).add("Syntax of regular expression seems to be wrong.", (Object)patternSyntaxException)).log();
                    }
                    MessageCollector.instance().logFatalError("Syntax of regular expression seems to be wrong for '" + string + "'.");
                    return false;
                }
            }
            if (RppConditionDefinition.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "verifyOneRegexCondition(String,String,String,boolean)", 119).add("Something wrong with the pattern it should be:\n\"regexp\"=~\"text\"")).log();
            }
            MessageCollector.instance().logFatalError("Something wrong with the pattern for '" + string + "'\n. It should be:\n\"regexp\"=~\"text\" ");
            return false;
        }
        if (RppConditionDefinition.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "verifyOneRegexCondition(String,String,String,boolean)", 130).add("no such condition, ok")).log();
        }
        return true;
    }

    public static boolean performConditionCheck(String string, String string2, String string3, String[] stringArray) {
        if (RppConditionDefinition.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "performConditionCheck(String,String,String,String[])", 148).addDetail("nodeName", string)).addDetail("condition", string2)).addDetail("interpreter", string3)).addDetail("conditionGot", (Object)stringArray)).log();
        }
        if (RppConditionDefinition.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "performConditionCheck(String,String,String,String[])", 151).addDetail("nodeName", string)).addDetail("condition", string2)).addDetail("interpreter", string3)).addDetail("conditionGot", (Object)stringArray)).log();
        }
        if (Misc.emptyOrNull((String)string2)) {
            return true;
        }
        if (RppConditionDefinition.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "performConditionCheck(String,String,String,String[])", 157).add("go through condition: ")).add(string2)).log();
        }
        for (m m2 : n.a()) {
            if (!string3.equals(m2.getInterpreterName())) continue;
            boolean bl2 = ((ScriptLanguageFactoryServer)m2).verifyCondition(string, string3 + " " + string2.trim(), null);
            if (stringArray != null) {
                stringArray[0] = string2;
            }
            if (bl2) continue;
            if (RppConditionDefinition.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "performConditionCheck(String,String,String,String[])", 170).add(m2.getInterpreterName())).add(" condition failed.")).log();
            }
            return false;
        }
        if (string3.equals(REGEXP)) {
            boolean bl3 = RppConditionDefinition.verifyRegexpCondition(string, string2);
            if (stringArray != null) {
                stringArray[0] = string2;
            }
            if (!bl3) {
                if (RppConditionDefinition.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "performConditionCheck(String,String,String,String[])", 182).add("Regex condition failed.")).log();
                }
                return false;
            }
        }
        if (RppConditionDefinition.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "performConditionCheck(String,String,String,String[])", 186).add("Condition ok.")).log();
        }
        return true;
    }

    protected static boolean verifyRegexpCondition(String string, String string2) {
        String string3;
        int n2;
        if (RppConditionDefinition.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "verifyRegexpCondition(String,String)", 201).addDetail("nodeName", string)).addDetail("workComment", string2)).log();
        }
        if (RppConditionDefinition.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "verifyRegexpCondition(String,String)", 204).addDetail("nodeName", string)).addDetail("workComment", string2)).log();
        }
        if ((n2 = (string3 = string2).indexOf(REGEXP)) != -1) {
            if (!(string3 = string3.substring(n2 + REGEXP.length())).contains("=~") && !string3.contains("!~")) {
                MessageCollector.instance().logFatalError("No separator for regexp for '" + string + "'.\n Use either =~ or !~.");
                return false;
            }
            return RppConditionDefinition.verifyOneRegexCondition(string, string3, "=~", true) && RppConditionDefinition.verifyOneRegexCondition(string, string3, "!~", false);
        }
        if (RppConditionDefinition.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "verifyRegexpCondition(String,String)", 223).add("no condition -> ok")).log();
        }
        return true;
    }

    public String getExpression() {
        if (RppConditionDefinition.logger.level >= 7) {
            logger.lvlBuild(7, "getExpression()", 46).log();
        }
        return this.expression;
    }

    public RppConditionDefinition setExpression(String string) {
        if (RppConditionDefinition.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setExpression(String)", 35).addDetail("expression", string)).log();
        }
        this.expression = string;
        return this;
    }
}

