/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.record.procbuilder.RppCompIdData;
import de.qfs.apps.qftest.record.procbuilder.RppExtractStep;
import de.qfs.apps.qftest.record.procbuilder.RppProcCallDefinitions;
import de.qfs.apps.qftest.shared.data.ClientData;
import de.qfs.apps.qftest.shared.data.ElementInfo;
import de.qfs.apps.qftest.shared.data.ExtraFeatureSet;
import de.qfs.apps.qftest.shared.data.e;
import de.qfs.apps.qftest.shared.data.event.TestEventNames;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.step.AbstractComponent;
import de.qfs.apps.qftest.step.AbstractComponentDependant;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.step.CheckBooleanStep;
import de.qfs.apps.qftest.step.CheckItemsStep;
import de.qfs.apps.qftest.step.CheckSelectableItemsStep;
import de.qfs.apps.qftest.step.CheckStep;
import de.qfs.apps.qftest.step.CheckStringStep;
import de.qfs.apps.qftest.step.ComponentDependant;
import de.qfs.apps.qftest.step.ComponentEventStep;
import de.qfs.apps.qftest.step.DocumentWaiter;
import de.qfs.apps.qftest.step.EventStep;
import de.qfs.apps.qftest.step.FetchIndexStep;
import de.qfs.apps.qftest.step.MouseEventStep;
import de.qfs.apps.qftest.step.ProcedureCall;
import de.qfs.apps.qftest.step.SelectionEventStep;
import de.qfs.apps.qftest.step.TextInputStep;
import de.qfs.apps.qftest.step.WindowStep;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RppPlaceholder {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppPlaceholder");
    public static final String UNDEFINED = "UNDEFINED";
    public static final String OPEN_BRACKETS = "<";
    public static final String CLOSE_BRACKETS = ">";
    public static final String SEPARATOR = "/";
    public static final String DICTIONARY_SEPARATOR = ":";
    public static final String PLACEHOLDER_SEPARATOR = "/";
    public static final String COMP_PARAM_DIVIDER = "*";
    public static final String ANCESTOR = "ANCESTOR";
    public static final String PREFIX_NONEXITENT_PLACEHOLDER = "no_";
    public static final String VALUE = "VALUE";
    public static final String SELECTEDSTATE = "selectedstate";
    public static final String CHECKEDSTATE = "checkedstate";
    public static final String ENABLEDSTATE = "enabledstate";
    public static final String EDITABLESTATE = "editablestate";
    public static final String FOCUSEDSTATE = "focusedstate";
    public static final String VISIBLESTATE = "visiblestate";
    public static final String LABEL = "label";
    public static final String NAME = "name";
    public static final String CLASS = "class";
    public static final String FEATURE = "feature";
    public static final String COMPEF = "compef-";
    public static final String COMPONENT_SECTION_SHORT = "comp";
    public static final String EXTRADATA_PREFIX = "extradata-";
    public static final String EXTRADATA = "extradata";
    public static final String EXTRAFEATURES = "extrafeatures";
    public static final String PARAM = "param";
    public static final String SMARTID = "SMARTID";
    public static final String SMARTID_INDEX = "SMARTID_INDEX";
    public static final String SUBINDEXROW = "subindexrow";
    public static final String SUBINDEXROWTEXT = "subindexrowtext";
    public static final String SUBINDEXROWNUMERIC = "subindexrownumeric";
    public static final String SUBINDEXROWREGEXP = "subindexrowregexp";
    public static final String SUBINDEXROWSEPARATOR = "subindexrowseparator";
    public static final String SUBINDEXCOL = "subindexcol";
    public static final String SUBINDEXCOLTEXT = "subindexcoltext";
    public static final String SUBINDEXCOLNUMERIC = "subindexcolnumeric";
    public static final String SUBINDEXCOLREGEXP = "subindexcolrecexp";
    public static final String SUBINDEXCOLSEPARATOR = "subindexcolseparator";
    public static final String CELLVALUE = "CELLVALUE";
    public static final String ITEMCOMPONENT = "ITEMCOMPONENT";
    public static final String ITEMCOMPONENT0 = "ITEMCOMPONENT0";
    public static final String ITEMCOMPONENT1 = "ITEMCOMPONENT1";
    public static final String ITEMCOMPONENT2 = "ITEMCOMPONENT2";
    public static final String ITEMCOMPONENT3 = "ITEMCOMPONENT3";
    public static final String ITEMCOMPONENT4 = "ITEMCOMPONENT4";
    public static final String SUBINDEX = "subindex";
    public static final String SUBINDEXTEXT = "subindextext";
    public static final String SUBINDEXNUMERIC = "subindexnumeric";
    public static final String SUBINDEXREGEXP = "subindexrexexp";
    public static final String SUBINDEXSEPARATOR = "subindexseparator";
    public static final String INITIALVALUE = "INITIALVALUE";
    public static final String INITIALSELECTEDSTATE = "INITIALSELECTEDSTATE";
    public static final String ENGINE2 = "engine2";
    public static final String RETURNVARIABLE = "returnvariable";
    public static final String LOCALVARIABLE = "localvariable";
    static final String CHECK_TYPE_SEPARATOR = "___";
    static Map alternatives = Map.ofEntries(Map.entry("subindex", "subindex0"), Map.entry("subindexcol", "subindex0"), Map.entry("subindexrow", "subindex1"), Map.entry("subindexseparator", "subindexseparator0"), Map.entry("subindexcolseparator", "subindexseparator0"), Map.entry("subindexrowseparator", "subindexseparator1"), Map.entry("subindextext", "subindextext0"), Map.entry("subindexrowtext", "subindextext1"), Map.entry("subindexcoltext", "subindextext0"), Map.entry("subindexnumeric", "subindexnumeric0"), Map.entry("subindexcolnumeric", "subindexnumeric0"), Map.entry("subindexrownumeric", "subindexnumeric1"), Map.entry("checktype", "check type"), Map.entry("clientname", "client name"), Map.entry("compname", "name"), Map.entry("compfeature", "feature"), Map.entry("compclass", "class"), Map.entry("compid", "component id"), Map.entry("componentid", "component id"), Map.entry("compidwithoutindex", "id"), Map.entry("currentx", "x"), Map.entry("currenty", "y"), Map.entry("currentheight", "height"), Map.entry("durrentwidth", "width"), Map.entry("currentmodifiers", "modifiers"), Map.entry("currentclickcount", "clicks"), Map.entry("currentpopuptrigger", "popup"), Map.entry("currenthardclick", "hardclick"), Map.entry("currenttextclear", "clear"), Map.entry("currentsingleevents", "singleevents"), Map.entry("currentkeychar", "keychar"), Map.entry("currentkeycode", "keycode"), Map.entry("currentfile", "file"), Map.entry("currentwindow", "window"), Map.entry("eventname", "event"), Map.entry("currenteventname", "event"), Map.entry("currentstate", "state"), Map.entry("currentitems", "items"), Map.entry("currentitemswithselection", "itemswithselection"), Map.entry("currentdetail", "detail"), Map.entry("currentvalue", "text"), Map.entry("value", "text"), Map.entry("currentselectedstate", "selectedstate"), Map.entry("currentcheckedstate", "checkedstate"), Map.entry("currentenabledstate", "enabledstate"), Map.entry("currenteditablestate", "editablestate"), Map.entry("currentfocusedstate", "focusedstate"), Map.entry("currentvisiblestate", "visiblestate"), Map.entry("returnvariable", "variable name"), Map.entry("variablename", "variable name"));
    private static List smartIdMatchesForLabel = new ArrayList<String>(Arrays.asList("qlabel", "left", "labelleft", "top", "labeltop", "right", "labelright", "bottom", "labelbottom", "topleft", "labeltopleft", "inherited", "labelinherited", "title", "labeltitle", "for", "labelfor", "tooltip", "labeltooltip", "image", "labelimage", "placeholder", "labelplaceholder", "best", "labelbest", "qtext", "text", "labeltext", "feature", "qfs:label", "label"));
    private String placeholder;
    private String dictionaryName;
    private Map keywordParameters;
    private String paramCompId = null;
    private boolean paramComp = false;
    private String paramValue = null;
    private String name = null;
    private int ancestorLevel;
    private AbstractStep step;
    private String value = null;
    private int truncate = -1;

    public RppPlaceholder(String string, int n2, @Nullable AbstractStep abstractStep, @Nullable Map map) {
        this.extractPlaceholderFromString(string, n2);
        this.parse(map);
        if (this.name != null) {
            this.step = abstractStep;
            this.truncate = this.name.toLowerCase().contains("id") ? Options.cached_OPT_TREE_MAX_COMPONENT_ID_LENGTH : AbstractStep.getOptTreeValueLength();
        }
    }

    private void extractPlaceholderFromString(String string, int n2) {
        String[] stringArray;
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "extractPlaceholderFromString(String,int)", 335).addDetail("string", string)).addDetail("offset", n2)).log();
        }
        if ((stringArray = RppPlaceholder.extractPlaceholderString(string, n2)) != null) {
            this.placeholder = stringArray[0];
        }
    }

    protected static String[] extractPlaceholderString(String string, int n2) {
        int n3;
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "extractPlaceholderString(String,int)", 355).addDetail("string", string)).addDetail("offset", n2)).log();
        }
        String string2 = null;
        if (string == null || n2 >= string.length()) {
            return null;
        }
        int n4 = Misc.unquotedIndexOf((String)string, (String)OPEN_BRACKETS, (int)n2);
        if (n4 > -1 && n4 + 1 < string.length() && (n3 = Misc.unquotedIndexOf((String)string, (String)CLOSE_BRACKETS, (int)(n4 + 1))) > -1) {
            string2 = string.substring(n4 + OPEN_BRACKETS.length(), n3);
        }
        if (Misc.emptyOrNull(string2) || n4 == -1) {
            return null;
        }
        n3 = Misc.unquotedIndexOf(string2, (String)OPEN_BRACKETS, (int)0);
        while (n3 != -1) {
            string2 = string2.substring(n3 + OPEN_BRACKETS.length());
            n4 += n3 + 1;
            if (Misc.emptyOrNull((String)string2)) {
                n3 = -1;
                continue;
            }
            n3 = Misc.unquotedIndexOf((String)string2, (String)OPEN_BRACKETS, (int)0);
        }
        if (Misc.emptyOrNull(string2) && n4 + 1 < string.length()) {
            return RppPlaceholder.extractPlaceholderString(string, n4 + 1);
        }
        return new String[]{string2, Integer.toString(n4)};
    }

    private void parse(@Nullable Map map) {
        String[] stringArray;
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "parse(Map<String, String>)", 407).addDetail("keywordParameters", (Object)map)).log();
        }
        if (this.placeholder == null) {
            return;
        }
        int n2 = Misc.unquotedIndexOf((String)this.placeholder, (String)DICTIONARY_SEPARATOR, (int)0);
        String string = this.placeholder;
        if (n2 > -1 && RppProcCallDefinitions.dictionaries.containsKey(stringArray = string.substring(0, n2))) {
            string = string.substring(n2 + DICTIONARY_SEPARATOR.length());
            this.dictionaryName = stringArray;
        }
        if (map != null) {
            int n3 = Misc.unquotedIndexOf((String)string, (String)COMP_PARAM_DIVIDER, (int)0);
            if (n3 > -1) {
                String string2 = string.substring(0, n3);
                if (map.containsKey(string2)) {
                    string = string.substring(n3 + COMP_PARAM_DIVIDER.length());
                    this.paramValue = (String)map.get(string2);
                    this.paramComp = true;
                }
            } else if (string.length() > PARAM.length() + 1 && string.toLowerCase().startsWith("param-")) {
                if (map.containsKey(string = string.substring(PARAM.length() + 1))) {
                    this.paramValue = (String)map.get(string);
                }
            } else if (map.containsKey(string)) {
                this.paramValue = (String)map.get(string);
            }
        }
        this.ancestorLevel = 0;
        if (string.toLowerCase().startsWith("pcomp")) {
            string = string.substring(1);
            this.ancestorLevel = 1;
        } else if (string.toLowerCase().startsWith("gpcomp")) {
            string = string.substring(2);
            this.ancestorLevel = 2;
        } else if (string.startsWith(ANCESTOR)) {
            string = string.split(ANCESTOR)[1];
            stringArray = string.split("-");
            this.ancestorLevel = 1000;
            if (stringArray.length > 1) {
                try {
                    this.ancestorLevel = Integer.parseInt(stringArray[0]);
                    string = string.substring(stringArray[0].length() + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        string = string.replace("\\<", OPEN_BRACKETS).replace("\\>", CLOSE_BRACKETS);
        this.name = RppPlaceholder.getUniquePlaceholderName(string);
    }

    String getValueTranslateString() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getValueTranslateString()", 469).log();
        }
        String string = null;
        if (!Misc.emptyOrNull((String)this.name) && (this.name.startsWith("'") || this.name.startsWith("\""))) {
            string = this.name.substring(1, this.name.length() - 1);
        }
        this.value = this.translateReplacement(string);
        return this.value;
    }

    protected void setValueFromSubIndex(RppCompIdData rppCompIdData, @Nullable String[][] stringArray) {
        String string;
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setValueFromSubIndex(RppCompIdData,String[][])", 483).addDetail("compIdData", (Object)rppCompIdData)).addDetail("hierarchyParameters", (Object)stringArray)).log();
        }
        if (!(string = this.name.toLowerCase()).startsWith(SUBINDEX) || rppCompIdData.getSubindexes() == null) {
            return;
        }
        String string2 = null;
        for (int i2 = 0; i2 < rppCompIdData.getSubindexes().size(); ++i2) {
            Serializable serializable;
            String string3 = rppCompIdData.getSubindexValue(i2);
            String string4 = rppCompIdData.getSubindexSeparator(i2);
            if ((SUBINDEX + i2).equals(string)) {
                string2 = string3 == null ? "" : string3;
                break;
            }
            if ((SUBINDEXSEPARATOR + i2).equals(string)) {
                string2 = string4;
                break;
            }
            if ((SUBINDEXTEXT + i2).equals(string) || (SUBINDEXREGEXP + i2).equals(string)) {
                serializable = ((AbstractComponentDependant)this.step).getSourceInfo().retrieveExtraData("textIndex" + i2);
                if (serializable != null) {
                    string2 = (String)((Object)serializable);
                    break;
                }
                if ("@".equals(string4) || "%".equals(string4)) {
                    string2 = string3 == null ? "" : string3;
                    break;
                }
            }
            if (!(SUBINDEXNUMERIC + i2).equals(string)) continue;
            serializable = ((AbstractComponentDependant)this.step).getSourceInfo().retrieveExtraData("numIdx" + i2);
            if (serializable instanceof Integer) {
                Integer n2 = (Integer)serializable;
                string2 = Integer.toString(n2);
                break;
            }
            if (serializable instanceof String) {
                String string5;
                string2 = string5 = (String)((Object)serializable);
                break;
            }
            if (!"&".equals(string4)) continue;
            string2 = string3 == null ? "" : string3;
            break;
        }
        this.value = this.translateReplacement(string2);
        this.value = RppPlaceholder.replaceCallerVariables(this.value, stringArray);
    }

    String getValueComponentAttribute(@Nullable String[][] stringArray, AbstractComponent abstractComponent, e e2) {
        String string;
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getValueComponentAttribute(String[][],AbstractComponent,SmartID)", 538).addDetail("hierarchyParameters", (Object)stringArray)).addDetail("component", (Object)abstractComponent)).addDetail("smartID", (Object)e2)).log();
        }
        if ((string = this.getPlaceholderForSmartId(e2)) == null) {
            string = this.getComponentPlaceholderInHierarchy(abstractComponent);
        }
        this.value = this.translateReplacement(string);
        this.value = RppPlaceholder.replaceCallerVariables(this.value, stringArray);
        return this.value;
    }

    String getValueStepAttribute(@Nullable String[][] stringArray) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getValueStepAttribute(String[][])", 558).addDetail("hierarchyParameters", (Object)stringArray)).log();
        }
        String string = null;
        String string2 = this.name.toLowerCase();
        if (this.step != null) {
            switch (string2) {
                case "client": 
                case "check type": 
                case "detail": 
                case "file": 
                case "height": 
                case "keychar": 
                case "keycode": 
                case "modifiers": 
                case "width": {
                    string = this.step.getAttributeValue(string2) == null ? "" : this.step.getAttributeValue(string2);
                    break;
                }
                case "clicks": {
                    string = this.step.getAttributeValue(MouseEventStep.B) == null ? "" : this.step.getAttributeValue(MouseEventStep.B);
                    break;
                }
                case "hardclick": {
                    string = this.step.getAttributeValue(MouseEventStep.F);
                    break;
                }
                case "localvariable": {
                    string = this.step.getAttributeValue(CheckStep.ah);
                    break;
                }
                case "popup": {
                    string = this.step.getAttributeValue(MouseEventStep.D);
                    break;
                }
                case "procedure": {
                    string = this.step.getName() == null ? "" : this.step.getName();
                    break;
                }
                case "resultvariable": {
                    string = this.step.getAttributeValue(FetchIndexStep.q) == null ? "" : this.step.getAttributeValue(FetchIndexStep.q);
                    break;
                }
                case "variable name": {
                    string = this.step.getAttributeValue(ProcedureCall.RETVARNAME) == null ? "" : this.step.getAttributeValue(ProcedureCall.RETVARNAME);
                    break;
                }
                case "singleevents": {
                    string = this.step.getAttributeValue(TextInputStep.s);
                    break;
                }
                case "clear": {
                    string = this.step.getAttributeValue(TextInputStep.q);
                    break;
                }
                case "window": {
                    string = this.step.getAttributeValue(DocumentWaiter.Z) == null ? "" : this.step.getAttributeValue(DocumentWaiter.Z);
                    break;
                }
                case "client name": {
                    AbstractComponentDependant abstractComponentDependant;
                    AbstractStep abstractStep = this.step;
                    if (!(abstractStep instanceof AbstractComponentDependant) || (abstractStep = (abstractComponentDependant = (AbstractComponentDependant)abstractStep).getSourceData()) == null) break;
                    string = ((ClientData)abstractStep).client;
                    break;
                }
                case "startx": 
                case "starty": 
                case "endx": 
                case "endy": 
                case "swipeduration": {
                    String[] stringArray2;
                    String string3 = this.step.getAttributeValue(SelectionEventStep.q);
                    if (!string3.startsWith("swipe: ") || (stringArray2 = string3.split(" ")).length != 6) break;
                    string = switch (string2) {
                        case "startx" -> {
                            if (stringArray2[1] == null) {
                                yield "";
                            }
                            yield stringArray2[1];
                        }
                        case "starty" -> {
                            if (stringArray2[2] == null) {
                                yield "";
                            }
                            yield stringArray2[2];
                        }
                        case "endx" -> {
                            if (stringArray2[3] == null) {
                                yield "";
                            }
                            yield stringArray2[3];
                        }
                        case "endy" -> {
                            if (stringArray2[4] == null) {
                                yield "";
                            }
                            yield stringArray2[4];
                        }
                        case "swipeduration" -> {
                            if (stringArray2[5] == null) {
                                yield "";
                            }
                            yield stringArray2[5];
                        }
                        default -> null;
                    };
                    break;
                }
                case "x": {
                    AbstractStep abstractStep = this.step;
                    if (abstractStep instanceof ComponentEventStep) {
                        ComponentEventStep componentEventStep = (ComponentEventStep)abstractStep;
                        string = componentEventStep.k() == null ? "" : componentEventStep.k();
                        break;
                    }
                    string = this.step.getAttributeValue(string2) == null ? "" : this.step.getAttributeValue(string2);
                    break;
                }
                case "y": {
                    AbstractStep abstractStep = this.step;
                    if (abstractStep instanceof ComponentEventStep) {
                        ComponentEventStep componentEventStep = (ComponentEventStep)abstractStep;
                        string = componentEventStep.l() == null ? "" : componentEventStep.l();
                        break;
                    }
                    string = this.step.getAttributeValue(string2) == null ? "" : this.step.getAttributeValue(string2);
                    break;
                }
                case "text": 
                case "VALUE": {
                    AbstractStep abstractStep = this.step;
                    if (abstractStep instanceof TextInputStep) {
                        TextInputStep textInputStep = (TextInputStep)abstractStep;
                        string = textInputStep.getText() == null ? "" : textInputStep.getText();
                        break;
                    }
                    abstractStep = this.step;
                    if (abstractStep instanceof CheckStringStep) {
                        CheckStringStep checkStringStep = (CheckStringStep)abstractStep;
                        string = checkStringStep.getText() == null ? "" : checkStringStep.getText();
                        break;
                    }
                    abstractStep = this.extractInfo();
                    if (abstractStep == null) break;
                    if (abstractStep.getItemIndexes() != null) {
                        int n2 = abstractStep.getItemIndexes().length - 1;
                        string = (String)((Object)abstractStep.retrieveExtraData("textIndex" + n2));
                        break;
                    }
                    string = abstractStep.getCurrentValue();
                    if (string != null) break;
                    string = Boolean.toString(abstractStep.getCurrentSelectedState()).toLowerCase();
                    break;
                }
                case "selectedstate": 
                case "checkedstate": 
                case "focusedstate": 
                case "visiblestate": 
                case "enabledstate": 
                case "editablestate": 
                case "state": {
                    Object object;
                    ElementInfo elementInfo = this.extractInfo();
                    if (elementInfo != null) {
                        switch (string2) {
                            case "selectedstate": {
                                String string4 = Boolean.toString(elementInfo.getCurrentSelectedState());
                                break;
                            }
                            case "checkedstate": {
                                String string4 = Boolean.toString(elementInfo.getCurrentCheckedState());
                                break;
                            }
                            case "visiblestate": {
                                String string4 = Boolean.toString(elementInfo.getCurrentVisibility());
                                break;
                            }
                            case "enabledstate": {
                                String string4 = Boolean.toString(elementInfo.getCurrentEnabledState());
                                break;
                            }
                            case "editablestate": {
                                String string4 = Boolean.toString(elementInfo.getCurrentEditableState());
                                break;
                            }
                            default: {
                                String string4 = string = null;
                            }
                        }
                        if (elementInfo.getClazz() != null && this.step instanceof MouseEventStep && ("CheckBox".equals(elementInfo.getClazz()) || "RadioButton".equals(elementInfo.getClazz()) || "ToggleButton".equals(elementInfo.getClazz()) || "MenuItem".equals(elementInfo.getClazz()))) {
                            boolean bl2 = elementInfo.getCurrentSelectedState();
                            string = CHECKEDSTATE.equals(string2) || SELECTEDSTATE.equals(string2) ? Boolean.toString(!bl2).toLowerCase() : String.valueOf(bl2).toLowerCase();
                        }
                    }
                    if (string != null || !((object = this.step) instanceof CheckBooleanStep)) break;
                    CheckBooleanStep checkBooleanStep = (CheckBooleanStep)object;
                    object = this.step.getAttributeValue("checktype");
                    String string5 = checkBooleanStep.m();
                    boolean bl3 = Boolean.parseBoolean(string5);
                    string = switch (string2) {
                        case "state" -> string5;
                        case SELECTEDSTATE -> Boolean.toString(bl3 && ("selected".equals(object) || "item_selected".equals(object)));
                        case CHECKEDSTATE -> Boolean.toString(bl3 && "checked".equals(object));
                        case FOCUSEDSTATE -> Boolean.toString(bl3 && "focused".equals(object));
                        case VISIBLESTATE -> Boolean.toString(bl3 && "visible".equals(object));
                        case ENABLEDSTATE -> Boolean.toString(bl3 && "enabled".equals(object));
                        case EDITABLESTATE -> Boolean.toString(bl3 && "editable".equals(object));
                        default -> null;
                    };
                    break;
                }
                case "itemswithselection": {
                    CheckSelectableItemsStep checkSelectableItemsStep;
                    Object[][] objectArray = this.step;
                    if (!(objectArray instanceof CheckSelectableItemsStep) || Misc.emptyOrNull((Object[])(objectArray = (checkSelectableItemsStep = (CheckSelectableItemsStep)objectArray).getItems()))) break;
                    string = RppPlaceholder.itemsToString(objectArray, true);
                    break;
                }
                case "items": {
                    CheckItemsStep checkItemsStep;
                    Object[][] objectArray = this.step;
                    if (!(objectArray instanceof CheckItemsStep) || Misc.emptyOrNull((Object[])(objectArray = (checkItemsStep = (CheckItemsStep)objectArray).getItems()))) break;
                    string = RppPlaceholder.itemsToString(objectArray, false);
                    break;
                }
                case "event": {
                    AbstractStep abstractStep = this.step;
                    if (!(abstractStep instanceof EventStep)) break;
                    EventStep eventStep = (EventStep)abstractStep;
                    string = TestEventNames.getEnglishName((int)eventStep.getEvent());
                    break;
                }
            }
        }
        this.value = this.translateReplacement(string);
        this.value = RppPlaceholder.replaceCallerVariables(this.value, stringArray);
        return this.value;
    }

    protected static String replaceCallerVariables(@Nullable String string, @Nullable String[][] stringArray) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "replaceCallerVariables(String,String[][])", 767).addDetail("string", string)).addDetail("hierarchyParameters", (Object)stringArray)).log();
        }
        if (Misc.emptyOrNull((String)string) || Misc.emptyOrNull((Object[])stringArray)) {
            return string;
        }
        String string2 = string;
        for (String[] stringArray2 : stringArray) {
            string2 = RppExtractStep.replaceVariable(string2, "$(" + stringArray2[0] + ")", stringArray2[1]);
        }
        return string2;
    }

    @Nullable
    String getProcedureParameter() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getProcedureParameter()", 792).log();
        }
        if (this.isParamComp()) {
            return null;
        }
        String string = this.paramValue;
        this.value = this.translateReplacement(string);
        return this.value;
    }

    private static String itemsToString(Object[][] objectArray, Boolean bl2) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "itemsToString(Object[][],Boolean)", 814).addDetail("items", (Object)objectArray)).addDetail("addSelectionState", (Object)bl2)).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2][0].toString().replace(Options.cached_OPT_RECORDING_PROCESSOR_ITEMLIST_SEPARATOR, Options.cached_OPT_RECORDING_PROCESSOR_ITEMLIST_SEPARATOR_ESCAPE_STRING);
            if (Boolean.TRUE.equals(bl2)) {
                String string = objectArray[i2][2] != null ? objectArray[i2][2].toString() : "false";
                object = (String)object + " selected=" + string;
            }
            if (i2 == 0) {
                stringBuilder.append((String)object);
                continue;
            }
            stringBuilder.append(Options.cached_OPT_RECORDING_PROCESSOR_ITEMLIST_SEPARATOR).append((String)object);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String getComponentPlaceholderInHierarchy(AbstractComponent abstractComponent) {
        String string;
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getComponentPlaceholderInHierarchy(AbstractComponent)", 848).addDetail(COMPONENT_SECTION_SHORT, (Object)abstractComponent)).log();
        }
        for (int i2 = 0; i2 < this.ancestorLevel && abstractComponent != null; ++i2) {
            AbstractStep abstractStep = abstractComponent.getParent();
            if (!(abstractStep instanceof AbstractComponent)) {
                abstractComponent = null;
                break;
            }
            abstractComponent = (AbstractComponent)abstractStep;
        }
        if ((string = this.getComponentPlaceholder(abstractComponent)) != null) {
            return string;
        }
        return this.getComponentPlaceholder(this.extractInfo());
    }

    @Nullable
    private ElementInfo extractInfo() {
        AbstractComponentDependant abstractComponentDependant;
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "extractInfo()", 868).log();
        }
        ElementInfo elementInfo = null;
        AbstractStep abstractStep = this.step;
        if (abstractStep instanceof AbstractComponentDependant && (elementInfo = (abstractComponentDependant = (AbstractComponentDependant)abstractStep).getSourceInfo()) != null) {
            for (int n2 = 0; n2 < this.ancestorLevel && elementInfo != null; elementInfo = elementInfo.getParentInfo(), ++n2) {
            }
        }
        return elementInfo;
    }

    @Nullable
    public String getComponentPlaceholder(ElementInfo elementInfo) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getComponentPlaceholder(ElementInfo)", 892).addDetail("info", (Object)elementInfo)).log();
        }
        if (elementInfo == null) {
            return null;
        }
        return switch (this.name.toLowerCase()) {
            case NAME -> elementInfo.getName();
            case FEATURE -> elementInfo.getFeature();
            case CLASS -> elementInfo.getClazz();
            case "engine" -> elementInfo.getEngine();
            case ENGINE2 -> RppPlaceholder.getEngine2(elementInfo.getEngine());
            default -> this.getOtherComponentPlaceholder(elementInfo);
        };
    }

    @Nullable
    public String getComponentPlaceholder(AbstractComponent abstractComponent) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getComponentPlaceholder(AbstractComponent)", 917).addDetail(COMPONENT_SECTION_SHORT, (Object)abstractComponent)).log();
        }
        if (abstractComponent == null) {
            return null;
        }
        return switch (this.name.toLowerCase()) {
            case NAME -> abstractComponent.getName();
            case FEATURE -> abstractComponent.k();
            case CLASS -> abstractComponent.getClazz();
            case "engine" -> ((WindowStep)abstractComponent.t()).w();
            case ENGINE2 -> RppPlaceholder.getEngine2(((WindowStep)abstractComponent.t()).w());
            default -> this.getOtherComponentPlaceholder(abstractComponent);
        };
    }

    @Nullable
    private String getOtherComponentPlaceholder(ElementInfo elementInfo) {
        Object object;
        Object object2;
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getOtherComponentPlaceholder(ElementInfo)", 945).addDetail("info", (Object)elementInfo)).log();
        }
        if (elementInfo == null) {
            throw new IllegalArgumentException("info is marked non-null but is null");
        }
        if (LABEL.equals(this.name.toLowerCase())) {
            ExtraFeatureSet extraFeatureSet = elementInfo.getParameters();
            if (extraFeatureSet != null && extraFeatureSet.get("qfs:labelBest") != null) {
                return extraFeatureSet.getValue("qfs:labelBest");
            }
            if (extraFeatureSet != null && extraFeatureSet.get("qfs:label") != null) {
                return extraFeatureSet.getValue("qfs:label");
            }
            if (elementInfo.getFeature() != null) {
                return elementInfo.getFeature();
            }
            if (elementInfo.getName() != null) {
                return elementInfo.getName();
            }
            if (this.ancestorLevel == 0) {
                return this.getComponentIdOfStep();
            }
            return elementInfo.getId();
        }
        ExtraFeatureSet extraFeatureSet = elementInfo.getParameters();
        if (extraFeatureSet != null) {
            if (this.name.toLowerCase().startsWith(COMPEF) && (object2 = extraFeatureSet.get((String)(object = this.name.substring(COMPEF.length())))) != null) {
                return object2.getValue();
            }
            object = extraFeatureSet.get(this.name);
            if (object != null) {
                return object.getValue();
            }
        }
        if (this.name.toLowerCase().startsWith(EXTRADATA_PREFIX) && (object2 = elementInfo.retrieveExtraData((String)(object = this.name.substring(EXTRADATA_PREFIX.length())))) != null) {
            return object2.toString();
        }
        object = elementInfo.retrieveExtraData(this.name);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    @Nullable
    private String getOtherComponentPlaceholder(AbstractComponent abstractComponent) {
        Serializable serializable;
        Object object;
        AbstractStep abstractStep;
        ExtraFeatureSet extraFeatureSet;
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getOtherComponentPlaceholder(AbstractComponent)", 1013).addDetail(COMPONENT_SECTION_SHORT, (Object)abstractComponent)).log();
        }
        if (abstractComponent == null) {
            throw new IllegalArgumentException("comp is marked non-null but is null");
        }
        if (LABEL.equals(this.name)) {
            extraFeatureSet = abstractComponent.getParameters();
            if (extraFeatureSet != null && extraFeatureSet.get("qfs:labelBest") != null) {
                return extraFeatureSet.getValue("qfs:labelBest");
            }
            if (extraFeatureSet != null && extraFeatureSet.get("qfs:label") != null) {
                return extraFeatureSet.getValue("qfs:label");
            }
            if (abstractComponent.k() != null) {
                return abstractComponent.k();
            }
        }
        if ((extraFeatureSet = abstractComponent.getParameters()) != null) {
            if (this.name.startsWith(COMPEF) && (abstractStep = extraFeatureSet.get((String)(object = this.name.split(COMPEF)[1]))) != null) {
                return abstractStep.getValue();
            }
            object = extraFeatureSet.get(this.name);
            if (object != null) {
                return object.getValue();
            }
        }
        if ((abstractStep = this.step) instanceof AbstractComponentDependant && (abstractStep = ((AbstractComponentDependant)(object = (AbstractComponentDependant)abstractStep)).getSourceInfo()) != null && (serializable = abstractStep.retrieveExtraData(this.name)) != null) {
            return serializable.toString();
        }
        return null;
    }

    @Nullable
    private String getComponentIdOfStep() {
        AbstractStep abstractStep;
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getComponentIdOfStep()", 1058).log();
        }
        if ((abstractStep = this.step) instanceof ComponentDependant) {
            ComponentDependant componentDependant = (ComponentDependant)((Object)abstractStep);
            return componentDependant.getComponentId();
        }
        return null;
    }

    protected static String getKindOfNode(AbstractStep abstractStep) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getKindOfNode(AbstractStep)", 1076).addDetail("step", (Object)abstractStep)).log();
        }
        if (abstractStep == null) {
            throw new IllegalArgumentException("step is marked non-null but is null");
        }
        String string = abstractStep.getClass().getSimpleName();
        return RppPlaceholder.userFriendlyNodeTypeName(string);
    }

    public static String userFriendlyNodeTypeName(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "userFriendlyNodeTypeName(String)", 1082).addDetail("nodeType", string)).log();
        }
        if (string == null) {
            return "";
        }
        if (string.endsWith("Step")) {
            return string.substring(0, string.length() - 4);
        }
        return string;
    }

    @Nullable
    protected static String getNodeType(AbstractStep abstractStep) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getNodeType(AbstractStep)", 1103).addDetail("step", (Object)abstractStep)).log();
        }
        if (abstractStep == null) {
            throw new IllegalArgumentException("step is marked non-null but is null");
        }
        if (abstractStep instanceof CheckStep) {
            return abstractStep.getAttributeValue(CheckStep.al.toLowerCase());
        }
        return null;
    }

    @Nullable
    String getPlaceholderForSmartId(e e2) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getPlaceholderForSmartId(SmartID)", 1118).addDetail("smartID", (Object)e2)).log();
        }
        if (e2 == null || this.ancestorLevel != 0) {
            return null;
        }
        switch (this.name) {
            case "label": {
                String string;
                if (e2.m() && smartIdMatchesForLabel.contains(string = e2.h().toLowerCase())) {
                    return e2.b();
                }
                return null;
            }
            case "class": {
                String string = e2.g();
                if ("Dialog|Window:Dialog".equals(string)) {
                    return "Dialog";
                }
                return string;
            }
            case "name": {
                if (e2.k()) {
                    return e2.b();
                }
                return null;
            }
            case "feature": {
                if (FEATURE.equalsIgnoreCase(e2.h())) {
                    return e2.b();
                }
                return null;
            }
            case "engine": {
                return e2.c();
            }
            case "engine2": {
                String string = e2.c();
                if ("awt".equalsIgnoreCase(string)) {
                    return "swing";
                }
                return string;
            }
        }
        if (this.name.startsWith(COMPEF) && e2.m()) {
            String string = e2.h();
            if (string == null) {
                return null;
            }
            if (string.equals(this.name.split(COMPEF)[0])) {
                return e2.b();
            }
            if ("compef-qfs:labelLeft".equals(this.name) && ("left".equalsIgnoreCase(string) || "labelleft".equalsIgnoreCase(string))) {
                return e2.b();
            }
            if ("compef-qfs:labelText".equals(this.name) && ("text".equalsIgnoreCase(string) || "labeltext".equalsIgnoreCase(string))) {
                return e2.b();
            }
            if ("compef-qfs:labelBest".equals(this.name) && ("best".equalsIgnoreCase(string) || "labelbest".equalsIgnoreCase(string))) {
                return e2.b();
            }
        }
        return null;
    }

    public static String getEngine2(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getEngine2(String)", 1195).addDetail("engine", string)).log();
        }
        if ("awt".equals(string)) {
            return "swing";
        }
        return string;
    }

    static String removeDefaultIdGroup(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeDefaultIdGroup(String)", 1205).addDetail("compId", string)).log();
        }
        if (string != null && string.length() > 6 && string.startsWith("${id:") && string.endsWith("}")) {
            return string.substring(5, string.length() - 1);
        }
        return string;
    }

    public String replaceOnePlaceholder(String string, String object, @Nullable String string2) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "replaceOnePlaceholder(String,String,String)", 1233).addDetail("string", string)).addDetail("replacement", (String)object)).addDetail("conditionLanguage", string2)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return string;
        }
        if (object != null) {
            if (this.name.equals("component id") && e.a((String)object)) {
                string = string.replace("${id:<" + this.placeholder + ">}", (CharSequence)object);
            }
            if (this.name.equals("component id") && ((String)object).startsWith("\\.")) {
                object = ((String)object).substring(2);
            }
            if (string2 != null) {
                if (string2.equalsIgnoreCase("JYTHON")) {
                    if (((String)object).equals("true")) {
                        object = "True";
                    } else if (((String)object).equals("false")) {
                        object = "False";
                    }
                } else if (string2.equalsIgnoreCase("GROOVY") && ((String)object).contains("$")) {
                    object = Misc.quote((String)object, (String)"$");
                }
            } else {
                if (this.truncate > 0) {
                    object = AbstractStep.truncateValue((String)object, this.truncate, true);
                }
                if (this.truncate <= 0 && ((String)object).contains("\n")) {
                    object = ((String)object).substring(0, ((String)object).indexOf("\n")) + "\u2026";
                } else {
                    Pattern pattern = Pattern.compile("\\s*");
                    Matcher matcher = pattern.matcher((CharSequence)object);
                }
            }
            if (object != null) {
                return string.replace(OPEN_BRACKETS + this.placeholder + CLOSE_BRACKETS, (CharSequence)object);
            }
        }
        return string.replace(OPEN_BRACKETS + this.placeholder + CLOSE_BRACKETS, "<no_" + this.placeholder + CLOSE_BRACKETS);
    }

    public String translateReplacement(String string) {
        String string2;
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "translateReplacement(String)", 1290).addDetail("replacement", string)).log();
        }
        if (this.dictionaryName != null && string != null && RppProcCallDefinitions.dictionaries != null && (string2 = (String)((Map)RppProcCallDefinitions.dictionaries.get(this.dictionaryName)).get(string)) != null) {
            string = string2;
        }
        return string;
    }

    protected static String addVariableReference(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addVariableReference(String)", 1306).addDetail(NAME, string)).log();
        }
        if (string == null) {
            return null;
        }
        return "$(" + string + ")";
    }

    protected static String stripVarReference(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "stripVarReference(String)", 1314).addDetail("variableReference", string)).log();
        }
        if (string == null || string.length() < 4) {
            return null;
        }
        return string.substring(2, string.length() - 1);
    }

    private static String getUniquePlaceholderName(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getUniquePlaceholderName(String)", 1328).addDetail("placeholderName", string)).log();
        }
        String string2 = string;
        if (alternatives.containsKey(string.toLowerCase())) {
            string2 = (String)alternatives.get(string.toLowerCase());
        }
        return string2;
    }

    public String toString() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "toString()", 1340).log();
        }
        if (this.placeholder == null) {
            return "not a placeholder";
        }
        return this.placeholder + ": " + this.value;
    }

    public Map getKeywordParameters() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getKeywordParameters()", 243).log();
        }
        return this.keywordParameters;
    }

    public int getAncestorLevel() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getAncestorLevel()", 262).log();
        }
        return this.ancestorLevel;
    }

    public AbstractStep getStep() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getStep()", 268).log();
        }
        return this.step;
    }

    public String getValue() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getValue()", 277).log();
        }
        return this.value;
    }

    public int getTruncate() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getTruncate()", 280).log();
        }
        return this.truncate;
    }

    public RppPlaceholder setPlaceholder(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setPlaceholder(String)", 84).addDetail("placeholder", string)).log();
        }
        this.placeholder = string;
        return this;
    }

    public RppPlaceholder setDictionaryName(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDictionaryName(String)", 84).addDetail("dictionaryName", string)).log();
        }
        this.dictionaryName = string;
        return this;
    }

    public RppPlaceholder setKeywordParameters(Map map) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setKeywordParameters(Map<String, String>)", 84).addDetail("keywordParameters", (Object)map)).log();
        }
        this.keywordParameters = map;
        return this;
    }

    public RppPlaceholder setParamCompId(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setParamCompId(String)", 84).addDetail("paramCompId", string)).log();
        }
        this.paramCompId = string;
        return this;
    }

    public RppPlaceholder setParamComp(boolean bl2) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setParamComp(boolean)", 84).addDetail("paramComp", bl2)).log();
        }
        this.paramComp = bl2;
        return this;
    }

    public RppPlaceholder setParamValue(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setParamValue(String)", 84).addDetail("paramValue", string)).log();
        }
        this.paramValue = string;
        return this;
    }

    public RppPlaceholder setName(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setName(String)", 84).addDetail(NAME, string)).log();
        }
        this.name = string;
        return this;
    }

    public RppPlaceholder setAncestorLevel(int n2) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setAncestorLevel(int)", 84).addDetail("ancestorLevel", n2)).log();
        }
        this.ancestorLevel = n2;
        return this;
    }

    public RppPlaceholder setStep(AbstractStep abstractStep) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setStep(AbstractStep)", 84).addDetail("step", (Object)abstractStep)).log();
        }
        this.step = abstractStep;
        return this;
    }

    public RppPlaceholder setValue(String string) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(String)", 84).addDetail("value", string)).log();
        }
        this.value = string;
        return this;
    }

    public RppPlaceholder setTruncate(int n2) {
        if (RppPlaceholder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setTruncate(int)", 84).addDetail("truncate", n2)).log();
        }
        this.truncate = n2;
        return this;
    }

    public String getPlaceholder() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getPlaceholder()", 235).log();
        }
        return this.placeholder;
    }

    public String getDictionaryName() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getDictionaryName()", 239).log();
        }
        return this.dictionaryName;
    }

    public String getParamCompId() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getParamCompId()", 246).log();
        }
        return this.paramCompId;
    }

    public boolean isParamComp() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "isParamComp()", 250).log();
        }
        return this.paramComp;
    }

    public String getParamValue() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getParamValue()", 254).log();
        }
        return this.paramValue;
    }

    public String getName() {
        if (RppPlaceholder.logger.level >= 7) {
            logger.lvlBuild(7, "getName()", 258).log();
        }
        return this.name;
    }
}

