/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.log.DefinitionStepLog;
import de.qfs.apps.qftest.log.StepLog;
import de.qfs.apps.qftest.record.procbuilder.RppConditionDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppDebug;
import de.qfs.apps.qftest.record.procbuilder.RppDebugGroup;
import de.qfs.apps.qftest.record.procbuilder.RppEventDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppGroupAnywhere;
import de.qfs.apps.qftest.record.procbuilder.RppGroupDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppParameterDefinition;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholders;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholdersForStep;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.notifications.TerminalOutput;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.step.DefinitionStep;
import de.qfs.apps.qftest.step.KeywordProcedureStep;
import de.qfs.apps.qftest.step.KeywordStep;
import de.qfs.apps.qftest.step.Procedure;
import de.qfs.apps.qftest.step.ProcedureCall;
import de.qfs.apps.qftest.suite.Suite;
import de.qfs.apps.qftest.suite.convert.StepConverter;
import de.qfs.apps.qftest.suite.include.Includer;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;

public class RppProcCallDef {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppProcCallDef");
    private DefinitionStep defStep;
    private String codeEntryName;
    private int prio;
    private String procCallDefName;
    private String procName;
    private String[][] procVars;
    private String procCallComment;
    private String interpreter;
    private RppGroupDefinition expectedSteps;
    private RppGroupAnywhere expectedOccurrences = new RppGroupAnywhere();
    private boolean checkForOccurrencesBeforeGroup;
    private boolean checkForOccurrencesAfterGroup;
    private boolean invalid = false;
    KeywordProcedureStep keywordProcedureStep = null;
    Suite suite;

    public String toString() {
        return this.prio + " " + this.procName + ", node of first event: " + ((RppEventDefinition)this.expectedSteps.events.get(0)).getNode();
    }

    void setFullProcName(Suite suite, Suite suite2) {
        String string;
        Suite[] suiteArray;
        AbstractStep abstractStep;
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setFullProcName(Suite,Suite)", 134).addDetail("recordingSuite", (Object)suite)).addDetail("definitionSuite", (Object)suite2)).log();
        }
        if ((abstractStep = suite2.locateCallable(this.procName, suiteArray = new Suite[1], DefinitionStep.z)) != null && suiteArray[0] != null && !Misc.emptyOrNull((String)(string = suite.computeReference(suiteArray[0].getFile())))) {
            this.procName = Misc.quote((String)string, (String)"\\#@&%") + "#" + this.procName;
        }
    }

    public int matches(RppPlaceholders rppPlaceholders, int n2, List list, RppDebug rppDebug, ProcedureCall procedureCall) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "matches(RppPlaceholders,int,List<AbstractStep>,RppDebug,ProcedureCall)", 164).addDetail("placeholders", (Object)rppPlaceholders)).addDetail("currIndex", n2)).addDetail("steps", (Object)list)).addDetail("debug", (Object)rppDebug)).addDetail("resultProcCall", (Object)procedureCall)).log();
        }
        DefinitionStepLog definitionStepLog = (DefinitionStepLog)StepLog.makeLog(this.defStep, rppDebug.getCurrentSuite());
        rppDebug.pushLog(definitionStepLog);
        if (this.expectedSteps == null) {
            if (RppProcCallDef.logger.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "matches(RppPlaceholders,int,List<AbstractStep>,RppDebug,ProcedureCall)", 171).add("Definition does not contain any steps: ")).add((Object)this)).log();
            }
            return 0;
        }
        this.expectedOccurrences.resetAllOccurrencesCounters();
        RppDebugGroup rppDebugGroup = new RppDebugGroup();
        procedureCall.setName(this.procName);
        rppPlaceholders.setDefinitionSuite(this.suite);
        int n3 = this.expectedSteps.match(rppPlaceholders, n2, procedureCall, this.expectedOccurrences, this.checkForOccurrencesBeforeGroup, rppDebug, rppDebugGroup, this.interpreter);
        if (n3 > 0 && this.checkForOccurrencesAfterGroup) {
            n2 += n3;
            n3 += this.expectedOccurrences.match(rppPlaceholders, n2, procedureCall, this.expectedOccurrences, false, rppDebug, rppDebugGroup, this.interpreter);
        }
        if (this.expectedOccurrences.minimumOccurrencesNotReached()) {
            n3 = 0;
        }
        if (RppProcCallDef.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "matches(RppPlaceholders,int,List<AbstractStep>,RppDebug,ProcedureCall)", 192).add("steps processed: ", n3)).log();
        }
        rppDebug.popLog();
        rppDebug.updateDebugInfoInDefinitionLog(rppDebugGroup, this.procName, definitionStepLog);
        return n3;
    }

    public ProcedureCall createProcCallAndUpdateProcedure(RppPlaceholders rppPlaceholders, int n2, RppDebug rppDebug, ProcedureCall procedureCall, @Nullable String string) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createProcCallAndUpdateProcedure(RppPlaceholders,int,RppDebug,ProcedureCall,String)", 207).addDetail("placeholders", (Object)rppPlaceholders)).addDetail("currStep", n2)).addDetail("debugSequence", (Object)rppDebug)).addDetail("resultProcCall", (Object)procedureCall)).addDetail("interpreter", string)).log();
        }
        String string2 = rppPlaceholders.getStep(n2).replacePlaceholders(this.procName, string);
        int n3 = this.getNumKeywords(rppDebug, rppPlaceholders.getRecordingSuite());
        if (n3 == 0 || !Options.cached_OPT_RECORDING_PROCESSOR_CONVERT) {
            return this.createProcCall(rppPlaceholders.getStep(n2), procedureCall, string2, rppPlaceholders.getRecordingSuite());
        }
        Suite suite = rppPlaceholders.getRecordingSuite();
        String string3 = this.extractKeyword(n3);
        List list = this.expectedSteps.events;
        String string4 = this.extractCondition(list);
        if (this.keywordProcedureStep != null) {
            ProcedureCall procedureCall2 = this.createProcCall(rppPlaceholders.getStep(n2), procedureCall, string2, suite);
            this.keywordProcedureStep.a(string4, string3);
            return procedureCall2;
        }
        Includer includer = new Includer(string2, suite, "procedure");
        Procedure procedure = (Procedure)includer.getElement();
        if (procedure != null) {
            if (procedure instanceof KeywordProcedureStep) {
                this.keywordProcedureStep = (KeywordProcedureStep)procedure;
            } else {
                Suite suite2 = suite;
                if (includer.getStackSize() > 0) {
                    suite2 = includer.getCurrentSuite();
                }
                StepConverter stepConverter = StepConverter.a(suite2, procedure, "KeywordProcedureStep");
                try {
                    this.keywordProcedureStep = (KeywordProcedureStep)stepConverter.a("KeywordProcedureStep", false);
                }
                catch (TestException testException) {
                    this.keywordProcedureStep = new KeywordProcedureStep(this.procName.replace(".", ";"));
                    rppDebug.logInvalidDefinition("Cannot convert the procedure referenced by the definition to a procedure with keyword", this.defStep, suite);
                }
            }
            this.keywordProcedureStep.a(string4, string3);
        }
        return this.createProcCall(rppPlaceholders.getStep(n2), procedureCall, string2, suite);
    }

    private ProcedureCall createProcCall(RppPlaceholdersForStep rppPlaceholdersForStep, ProcedureCall procedureCall, String string, Suite suite) {
        Object object;
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createProcCall(RppPlaceholdersForStep,ProcedureCall,String,Suite)", 288).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).addDetail("resultProcCall", (Object)procedureCall)).addDetail("procedureName", string)).addDetail("suite", (Object)suite)).log();
        }
        Includer includer = new Includer(string, suite, "procedure");
        Procedure procedure = (Procedure)includer.getElement();
        ProcedureCall procedureCall2 = this.keywordProcedureStep != null || procedure instanceof KeywordProcedureStep ? new KeywordStep(string) : new ProcedureCall(string);
        if (procedureCall2.getId() == null && procedureCall2.getUid() == null) {
            procedureCall2.setId(suite.genAutoId());
        }
        procedureCall2.setVariables(procedureCall.getVariables());
        if (procedureCall2 instanceof KeywordStep) {
            object = (KeywordStep)procedureCall2;
            ((KeywordStep)object).a((KeywordProcedureStep)procedure, suite);
        }
        this.transferComment(rppPlaceholdersForStep, procedureCall, procedureCall2);
        object = procedureCall.getVariable();
        if (!Misc.emptyOrNull((String)object)) {
            procedureCall2.setVariable((String)object);
            procedureCall2.setLocal(procedureCall.isLocal());
        }
        if (RppProcCallDef.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "createProcCall(RppPlaceholdersForStep,ProcedureCall,String,Suite)", 320).add("call", (Object)procedureCall2)).log();
        }
        return procedureCall2;
    }

    void transferComment(RppPlaceholdersForStep rppPlaceholdersForStep, ProcedureCall procedureCall, AbstractStep abstractStep) {
        Object object;
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "transferComment(RppPlaceholdersForStep,ProcedureCall,AbstractStep)", 327).addDetail("stepPlaceholders", (Object)rppPlaceholdersForStep)).addDetail("resultProcCall", (Object)procedureCall)).addDetail("step", (Object)abstractStep)).log();
        }
        if (Misc.emptyOrNull((String)(object = rppPlaceholdersForStep.replacePlaceholders(this.procCallComment, "")))) {
            abstractStep.setComment(procedureCall.getComment());
        } else if (Misc.emptyOrNull((String)procedureCall.getComment())) {
            abstractStep.setComment((String)object);
        } else {
            object = (String)object + "\n" + procedureCall.getComment();
            abstractStep.setComment((String)object);
        }
    }

    private void setKeyword(KeywordStep keywordStep, ArrayList arrayList, HashMap hashMap) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setKeyword(KeywordStep,ArrayList<String[]>,HashMap<String, String>)", 352).addDetail("call", (Object)keywordStep)).addDetail("parameters", (Object)arrayList)).addDetail("placeholderValues", (Object)hashMap)).log();
        }
    }

    public static void logWarningToTerminal(String string) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "logWarningToTerminal(String)", 382).addDetail("output", string)).log();
        }
        if (TerminalOutput.NOTIFIER.level >= 1) {
            TerminalOutput.NOTIFIER.postNotification(1, "terminal.output", null, new Object[]{"data", string + "\n", "source", "ProcedureCallRecorder"});
        }
        if (RppProcCallDef.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "logWarningToTerminal(String)", 385).add("output", string)).log();
        }
    }

    protected ArrayList cloneParameters() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "cloneParameters()", 395).log();
        }
        String[][] stringArray = this.getProcVars();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (!Misc.emptyOrNull((Object[])stringArray)) {
            for (String[] stringArray2 : stringArray) {
                String string = "";
                if (!Misc.emptyOrNull((String)stringArray2[1])) {
                    string = stringArray2[1];
                }
                String[] stringArray3 = new String[]{stringArray2[0], string};
                arrayList.add(stringArray3);
            }
        }
        return arrayList;
    }

    boolean ignoreEvent() {
        String string;
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "ignoreEvent()", 418).log();
        }
        return (string = this.getProcName()) != null && (string.equals("qfs.ignore.event") || string.equals("qfs.event.ignore"));
    }

    protected boolean doNotConvertEvent() {
        String string;
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "doNotConvertEvent()", 429).log();
        }
        return (string = this.getProcName()) != null && string.equals("qfs.do.not.convert");
    }

    private int getNumKeywords(RppDebug rppDebug, Suite suite) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getNumKeywords(RppDebug,Suite)", 437).addDetail("debugSequence", (Object)rppDebug)).addDetail("suite", (Object)suite)).log();
        }
        String string = Util.getDoctag((String)this.procCallComment, (String)"keywords");
        int n2 = 0;
        if (!Misc.emptyOrNull((String)string) && !"0".equals(string)) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                rppDebug.logInvalidDefinition("Invalid 'keywords' doctag", this.defStep, suite);
            }
        }
        return n2;
    }

    private String extractKeyword(int n2) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "extractKeyword(int)", 453).addDetail("numKeywords", n2)).log();
        }
        StringBuilder stringBuilder = new StringBuilder();
        List list = this.expectedSteps.events;
        RppEventDefinition rppEventDefinition = (RppEventDefinition)list.get(0);
        List list2 = rppEventDefinition.getParams();
        if (list2.size() < n2) {
            this.keywordProcedureStep.setComment(this.procCallComment + "\n\nLess parameters than numKeywords in first event\n@red");
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            RppParameterDefinition rppParameterDefinition = (RppParameterDefinition)list2.get(i2);
            String string = rppParameterDefinition.getParameterValue();
            String string2 = rppParameterDefinition.getParameterName();
            if (!stringBuilder.isEmpty()) {
                char c2;
                char c3 = stringBuilder.charAt(stringBuilder.length() - 1);
                char c4 = c2 = Misc.emptyOrNull((String)string) ? (char)'\u0000' : string.charAt(0);
                if (c3 != '\'' && c3 != '\"' && c3 != '(' && c3 != '[' && c3 != '{' && c3 != '<' && c2 != '\'' && c2 != '\"' && c2 != ')' && c2 != ']' && c2 != '}' && c2 != '>') {
                    stringBuilder.append(" ");
                }
            }
            if (string2.toLowerCase().startsWith("dummy")) {
                stringBuilder.append(string);
                continue;
            }
            if (string.startsWith("<") && string.endsWith(">")) {
                stringBuilder.append("<").append("param").append("/").append(string2).append(">");
                continue;
            }
            stringBuilder.append(string);
            this.keywordProcedureStep.setComment(this.procCallComment + "\n\nOne keyword value has a mixture of plain text and placeholder\n@red");
        }
        return stringBuilder.toString();
    }

    private String extractCondition(List list) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "extractCondition(List<RppEventDefinition>)", 501).addDetail("eventDefinitions", (Object)list)).log();
        }
        if (Misc.emptyOrNull((Collection)list)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (RppEventDefinition rppEventDefinition : list) {
            String string;
            RppConditionDefinition rppConditionDefinition = rppEventDefinition.getCondition();
            if (rppConditionDefinition == null || (string = rppConditionDefinition.getExpression()) == null) continue;
            if (bl2) {
                stringBuilder.append(string);
                bl2 = false;
                continue;
            }
            stringBuilder.append(" && ");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public DefinitionStep getDefStep() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getDefStep()", 67).log();
        }
        return this.defStep;
    }

    public String getCodeEntryName() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getCodeEntryName()", 68).log();
        }
        return this.codeEntryName;
    }

    public int getPrio() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getPrio()", 69).log();
        }
        return this.prio;
    }

    public String getProcCallDefName() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getProcCallDefName()", 71).log();
        }
        return this.procCallDefName;
    }

    public String getProcName() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getProcName()", 73).log();
        }
        return this.procName;
    }

    public String[][] getProcVars() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getProcVars()", 75).log();
        }
        return this.procVars;
    }

    public String getProcCallComment() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getProcCallComment()", 77).log();
        }
        return this.procCallComment;
    }

    public String getInterpreter() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getInterpreter()", 79).log();
        }
        return this.interpreter;
    }

    public RppGroupDefinition getExpectedSteps() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getExpectedSteps()", 90).log();
        }
        return this.expectedSteps;
    }

    public RppGroupAnywhere getExpectedOccurrences() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getExpectedOccurrences()", 91).log();
        }
        return this.expectedOccurrences;
    }

    public boolean isCheckForOccurrencesBeforeGroup() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "isCheckForOccurrencesBeforeGroup()", 92).log();
        }
        return this.checkForOccurrencesBeforeGroup;
    }

    public boolean isCheckForOccurrencesAfterGroup() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "isCheckForOccurrencesAfterGroup()", 93).log();
        }
        return this.checkForOccurrencesAfterGroup;
    }

    public boolean isInvalid() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "isInvalid()", 97).log();
        }
        return this.invalid;
    }

    public KeywordProcedureStep getKeywordProcedureStep() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getKeywordProcedureStep()", 103).log();
        }
        return this.keywordProcedureStep;
    }

    public Suite getSuite() {
        if (RppProcCallDef.logger.level >= 7) {
            logger.lvlBuild(7, "getSuite()", 109).log();
        }
        return this.suite;
    }

    public RppProcCallDef setDefStep(DefinitionStep definitionStep) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDefStep(DefinitionStep)", 59).addDetail("defStep", (Object)definitionStep)).log();
        }
        this.defStep = definitionStep;
        return this;
    }

    public RppProcCallDef setCodeEntryName(String string) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCodeEntryName(String)", 59).addDetail("codeEntryName", string)).log();
        }
        this.codeEntryName = string;
        return this;
    }

    public RppProcCallDef setPrio(int n2) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setPrio(int)", 59).addDetail("prio", n2)).log();
        }
        this.prio = n2;
        return this;
    }

    public RppProcCallDef setProcCallDefName(String string) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setProcCallDefName(String)", 59).addDetail("procCallDefName", string)).log();
        }
        this.procCallDefName = string;
        return this;
    }

    public RppProcCallDef setProcName(String string) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setProcName(String)", 59).addDetail("procName", string)).log();
        }
        this.procName = string;
        return this;
    }

    public RppProcCallDef setProcVars(String[][] stringArray) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setProcVars(String[][])", 59).addDetail("procVars", (Object)stringArray)).log();
        }
        this.procVars = stringArray;
        return this;
    }

    public RppProcCallDef setProcCallComment(String string) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setProcCallComment(String)", 59).addDetail("procCallComment", string)).log();
        }
        this.procCallComment = string;
        return this;
    }

    public RppProcCallDef setInterpreter(String string) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setInterpreter(String)", 59).addDetail("interpreter", string)).log();
        }
        this.interpreter = string;
        return this;
    }

    public RppProcCallDef setExpectedSteps(RppGroupDefinition rppGroupDefinition) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setExpectedSteps(RppGroupDefinition)", 59).addDetail("expectedSteps", (Object)rppGroupDefinition)).log();
        }
        this.expectedSteps = rppGroupDefinition;
        return this;
    }

    public RppProcCallDef setExpectedOccurrences(RppGroupAnywhere rppGroupAnywhere) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setExpectedOccurrences(RppGroupAnywhere)", 59).addDetail("expectedOccurrences", (Object)rppGroupAnywhere)).log();
        }
        this.expectedOccurrences = rppGroupAnywhere;
        return this;
    }

    public RppProcCallDef setCheckForOccurrencesBeforeGroup(boolean bl2) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCheckForOccurrencesBeforeGroup(boolean)", 59).addDetail("checkForOccurrencesBeforeGroup", bl2)).log();
        }
        this.checkForOccurrencesBeforeGroup = bl2;
        return this;
    }

    public RppProcCallDef setCheckForOccurrencesAfterGroup(boolean bl2) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCheckForOccurrencesAfterGroup(boolean)", 59).addDetail("checkForOccurrencesAfterGroup", bl2)).log();
        }
        this.checkForOccurrencesAfterGroup = bl2;
        return this;
    }

    public RppProcCallDef setInvalid(boolean bl2) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setInvalid(boolean)", 59).addDetail("invalid", bl2)).log();
        }
        this.invalid = bl2;
        return this;
    }

    public RppProcCallDef setKeywordProcedureStep(KeywordProcedureStep keywordProcedureStep) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setKeywordProcedureStep(KeywordProcedureStep)", 102).addDetail("keywordProcedureStep", (Object)keywordProcedureStep)).log();
        }
        this.keywordProcedureStep = keywordProcedureStep;
        return this;
    }

    public RppProcCallDef setSuite(Suite suite) {
        if (RppProcCallDef.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSuite(Suite)", 108).addDetail("suite", (Object)suite)).log();
        }
        this.suite = suite;
        return this;
    }
}

