/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.record.procbuilder;

import de.qfs.apps.qftest.io.a;
import de.qfs.apps.qftest.log.MessageLog;
import de.qfs.apps.qftest.log.StepLog;
import de.qfs.apps.qftest.record.procbuilder.BaseProcbuilder;
import de.qfs.apps.qftest.record.procbuilder.RppDebug;
import de.qfs.apps.qftest.record.procbuilder.RppPlaceholders;
import de.qfs.apps.qftest.record.procbuilder.RppProcCallDef;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.notifications.TerminalOutput;
import de.qfs.apps.qftest.shared.script.DataFormatException;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.step.DefinitionStep;
import de.qfs.apps.qftest.step.Package;
import de.qfs.apps.qftest.step.Procedure;
import de.qfs.apps.qftest.step.ProcedureCall;
import de.qfs.apps.qftest.step.RootStep;
import de.qfs.apps.qftest.step.datastep.metadata.MetadataValidationException;
import de.qfs.apps.qftest.suite.Suite;
import de.qfs.apps.qftest.suite.SuiteMap;
import de.qfs.apps.qftest.suite.include.Includer;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class RppProcCallDefinitions
implements TraversalCallback {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.record.procbuilder.RppProcCallDefinitions");
    private static final String ERROR = "error";
    private static final ArrayList procCallDefs = new ArrayList();
    private static final ArrayList procCallDefsIgnore = new ArrayList();
    private static Suite procSettings;
    private String definitionPckName;
    private String dictionaryPckName;
    static Map dictionaries;
    private final List definitionPackages = new ArrayList();
    private final List definitionPackageSuites = new ArrayList();
    private final List dictionaryPackages = new ArrayList();
    private List includedProcedureFiles = new ArrayList();

    public RppProcCallDefinitions(Suite suite, RppDebug rppDebug) {
        Suite suite2;
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RppProcCallDefinitions(Suite,RppDebug)", 133).addDetail("recordingSuite", (Object)suite)).addDetail("debugSequence", (Object)rppDebug)).log();
        }
        procCallDefs.clear();
        procCallDefsIgnore.clear();
        File file = BaseProcbuilder.getRecordingProcessorConfFile();
        try {
            suite2 = SuiteMap.instance().b(a.normalizeFile(file), true, false);
        }
        catch (Exception exception) {
            rppDebug.logMessage("msg.plain", new String[]{exception.getMessage()}, 2);
            RppProcCallDefinitions.logWarningToTerminal("Error: The definition file \"" + file.getPath() + "\" could not be read", "ProcedureCallRecorder");
            return;
        }
        this.definitionPckName = Options.cached_OPT_RECORDING_PROCESSOR_CONFIG_PACKAGE;
        this.dictionaryPckName = Options.cached_OPT_RECORDING_PROCESSOR_DICTIONARY_PACKAGE;
        HashSet hashSet = new HashSet();
        Stack stack = new Stack();
        new Includer(this, suite2).searchIncludes(suite2, this, hashSet, stack);
        if (this.definitionPackages.isEmpty()) {
            rppDebug.logMessage("msg.plain", new String[]{"Error: Neither the definition suite " + file.getPath() + " nor any include file contains a top level package '" + this.definitionPckName + "' in the section 'Packages'"}, 2);
            RppProcCallDefinitions.logWarningToTerminal("Error: Neither the definition suite " + file.getPath() + " nor any include file contains a top level package '" + this.definitionPckName + "' in the section 'Packages'", "ProcedureCallRecorder");
            return;
        }
        for (int i2 = 0; i2 < this.definitionPackages.size(); ++i2) {
            Package package_ = (Package)this.definitionPackages.get(i2);
            Suite suite3 = (Suite)this.definitionPackageSuites.get(i2);
            this.getProcCallDefsFromPackage(rppDebug, package_, suite, suite3);
            procCallDefs.sort((rppProcCallDef, rppProcCallDef2) -> Integer.compare(rppProcCallDef2.getPrio(), rppProcCallDef.getPrio()));
            if (RppProcCallDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "RppProcCallDefinitions(Suite,RppDebug)", 167).add("procCallDefs", (Object)procCallDefs)).log();
            }
            if (RppProcCallDefinitions.logger.level < 9) continue;
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "RppProcCallDefinitions(Suite,RppDebug)", 168).add("procCallDefsIgnore", (Object)procCallDefsIgnore)).log();
        }
        for (Package package_ : this.dictionaryPackages) {
            this.getDictionariesFromPackage(package_);
        }
    }

    public RppProcCallDefinitions(String string) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "RppProcCallDefinitions(String)", 175).addDetail("getPackagesForConverter", string)).log();
        }
        procCallDefs.clear();
        procCallDefsIgnore.clear();
        File file = BaseProcbuilder.getRecordingProcessorConfFile();
        Suite suite = SuiteMap.instance().b(a.normalizeFile(file), true, false);
        if (suite != null) {
            HashSet hashSet = new HashSet();
            Stack stack = new Stack();
            new Includer(this, suite).searchIncludes(suite, this, hashSet, stack);
            if (this.definitionPackages.isEmpty()) {
                RppProcCallDefinitions.logWarningToTerminal("Error: Neither the definition suite " + file.getPath() + " nor any include file contains a top level package 'definitions' in the section 'Packages'", "ProcedureCallRecorder");
            }
        } else {
            RppProcCallDefinitions.logWarningToTerminal("Error: The definition suite " + file.getPath() + " could not be read", "ProcedureCallRecorder");
        }
    }

    public void getDictionariesFromPackage(Package package_) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getDictionariesFromPackage(Package)", 213).addDetail("dictionariesPackage", (Object)package_)).log();
        }
        for (int i2 = 0; i2 < package_.getChildCount(); ++i2) {
            String[][] stringArray;
            AbstractStep abstractStep = package_.getChild(i2);
            if (abstractStep.isDisabled()) continue;
            if (abstractStep instanceof Package) {
                Package package_2 = (Package)abstractStep;
                this.getDictionariesFromPackage(package_2);
                continue;
            }
            if (!(abstractStep instanceof Procedure)) continue;
            Procedure procedure = (Procedure)abstractStep;
            String string2 = procedure.getName();
            Map map = dictionaries.computeIfAbsent(string2, string -> new HashMap());
            for (String[] stringArray2 : stringArray = procedure.getVariables()) {
                if (map.containsKey(stringArray2[0])) continue;
                map.put(stringArray2[0], stringArray2[1]);
            }
        }
        if (RppProcCallDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getDictionariesFromPackage(Package)", 234).add("dictionaries", (Object)dictionaries)).log();
        }
    }

    public void getProcCallDefsFromPackage(RppDebug rppDebug, Package package_, Suite suite, Suite suite2) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getProcCallDefsFromPackage(RppDebug,Package,Suite,Suite)", 253).addDetail("debugLog", (Object)rppDebug)).addDetail("procedures", (Object)package_)).addDetail("recordingSuite", (Object)suite)).addDetail("packageSuite", (Object)suite2)).log();
        }
        for (int i2 = 0; i2 < package_.getChildCount(); ++i2) {
            List list;
            AbstractStep abstractStep = package_.getChild(i2);
            if (abstractStep.isDisabled()) continue;
            if (abstractStep instanceof Package) {
                this.getProcCallDefsFromPackage(rppDebug, (Package)abstractStep, suite, suite2);
                continue;
            }
            if (!(abstractStep instanceof DefinitionStep)) continue;
            DefinitionStep definitionStep = (DefinitionStep)abstractStep;
            try {
                list = definitionStep.a(suite2);
            }
            catch (DataFormatException | MetadataValidationException throwable) {
                rppDebug.logInvalidDefinition(throwable.getMessage(), definitionStep, suite2);
                continue;
            }
            if (Misc.emptyOrNull((Collection)list) || list.isEmpty()) {
                rppDebug.logInvalidDefinition("Invalid YAML data", definitionStep, suite2);
                continue;
            }
            for (RppProcCallDef rppProcCallDef : list) {
                rppProcCallDef.setFullProcName(suite, suite2);
                if (rppProcCallDef.isInvalid()) {
                    rppDebug.logInvalidDefinition("Invalid Procedure Call Definition", rppProcCallDef.getDefStep(), suite2);
                    continue;
                }
                if (rppProcCallDef.ignoreEvent()) {
                    procCallDefsIgnore.add(rppProcCallDef);
                    continue;
                }
                procCallDefs.add(rppProcCallDef);
            }
        }
    }

    public static int processNextSteps(RppPlaceholders rppPlaceholders, List list, RppDebug rppDebug, int n2) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "processNextSteps(RppPlaceholders,List<AbstractStep>,RppDebug,int)", 306).addDetail("placeholders", (Object)rppPlaceholders)).addDetail("steps", (Object)list)).addDetail("debug", (Object)rppDebug)).addDetail("currStep", n2)).log();
        }
        int n3 = 0;
        for (RppProcCallDef rppProcCallDef : procCallDefs) {
            ProcedureCall procedureCall;
            n3 = rppProcCallDef.matches(rppPlaceholders, n2, list, rppDebug, procedureCall = new ProcedureCall("result collector"));
            if (n3 <= 0) continue;
            if (rppProcCallDef.doNotConvertEvent()) {
                rppProcCallDef.transferComment(rppPlaceholders.getStep(n2), procedureCall, (AbstractStep)list.get(n2));
                rppDebug.addLog(new MessageLog("msg.plain", new String[]{"Step not converted, but possibly doctags added:"}));
                rppDebug.addLog(StepLog.makeLog(list.get(n2), rppPlaceholders.getStep(n2).getRecordingSuite()));
                return n3;
            }
            ArrayList<AbstractStep> arrayList = new ArrayList<AbstractStep>();
            for (int i2 = 0; i2 < n3 && n2 + i2 < list.size(); ++i2) {
                arrayList.add((AbstractStep)list.get(n2 + i2));
            }
            rppDebug.logSteps("Steps covered by the procedure call:", arrayList);
            ProcedureCall procedureCall2 = rppProcCallDef.createProcCallAndUpdateProcedure(rppPlaceholders, n2, rppDebug, procedureCall, null);
            list.set(n2, procedureCall2);
            rppDebug.addLog(new MessageLog("msg.plain", new String[]{"Procedure call created:"}));
            rppDebug.addLog(StepLog.makeLog(procedureCall2, rppPlaceholders.getStep(n2).getRecordingSuite()));
            if (RppProcCallDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "processNextSteps(RppPlaceholders,List<AbstractStep>,RppDebug,int)", 336).add(n3 + ". step transformed to procedure call no.", (Object)procedureCall2)).log();
            }
            if (RppProcCallDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "processNextSteps(RppPlaceholders,List<AbstractStep>,RppDebug,int)", 337).add("remove the next ")).add(n3)).add(" steps")).log();
            }
            for (int i3 = 1; i3 < n3 && n2 < list.size(); ++i3) {
                list.remove(n2 + 1);
            }
            return n3;
        }
        return n3;
    }

    static Integer findMatchingIgnoreDefinition(RppPlaceholders rppPlaceholders, int n2, List list, RppDebug rppDebug) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "findMatchingIgnoreDefinition(RppPlaceholders,int,List<AbstractStep>,RppDebug)", 361).addDetail("placeholders", (Object)rppPlaceholders)).addDetail("currentIndex", n2)).addDetail("steps", (Object)list)).addDetail("debug", (Object)rppDebug)).log();
        }
        int n3 = 0;
        for (RppProcCallDef rppProcCallDef : procCallDefsIgnore) {
            ProcedureCall procedureCall;
            n3 = rppProcCallDef.matches(rppPlaceholders, n2, list, rppDebug, procedureCall = new ProcedureCall("result collector"));
            if (n3 <= 0) continue;
            return n3;
        }
        return n3;
    }

    boolean isEmpty() {
        if (RppProcCallDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "isEmpty()", 381).log();
        }
        return procCallDefs.isEmpty();
    }

    private static void logToTerminal(String string) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "logToTerminal(String)", 393).addDetail("output", string)).log();
        }
        if (Options.cached_OPT_RECORDING_PROCESSOR_LOGLEVEL == 10) {
            String string2 = string.replace("|||", "\n            ");
            string2 = string2.replace("||", "\n        ");
            string2 = string2.replace("|", "\n    ");
            if (TerminalOutput.NOTIFIER.level >= 1) {
                TerminalOutput.NOTIFIER.postNotification(1, "terminal.output", null, new Object[]{"data", string2 + "\n", "source", "ProcedureCallRecorder"});
            }
        }
        if (RppProcCallDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "logToTerminal(String)", 401).add("output", string)).log();
        }
    }

    public static void logWarningToTerminal(String string, String string2) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "logWarningToTerminal(String,String)", 412).addDetail("output", string)).addDetail("source", string2)).log();
        }
        if (TerminalOutput.NOTIFIER.level >= 1) {
            TerminalOutput.NOTIFIER.postNotification(1, "terminal.output", null, new Object[]{"data", string + "\n", "source", string2});
        }
        if (RppProcCallDefinitions.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "logWarningToTerminal(String,String)", 415).add("output", string)).log();
        }
    }

    public void visit(Suite suite) {
        RootStep rootStep;
        Object object;
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "visit(Suite)", 421).addDetail("suite", (Object)suite)).log();
        }
        if ((object = suite.getRoot()) instanceof RootStep && (object = (rootStep = (RootStep)object).getProcedures()) != null && !((AbstractStep)object).isDisabled()) {
            String[] stringArray = rootStep.n();
            if (stringArray != null) {
                this.includedProcedureFiles.addAll(Arrays.asList(stringArray));
            }
            TreeUtil.traverse((TreeAdapter)suite, (Object)object, (TraversalCallback)this);
        }
    }

    public boolean nodeEntered(Traversal traversal) {
        Object object = traversal.getNode();
        if (object instanceof Package) {
            Package package_ = (Package)object;
            if (RppProcCallDefinitions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "nodeEntered(Traversal)", 441).add("pkg", (Object)package_)).log();
            }
            if (package_.isDisabled()) {
                return false;
            }
            if (this.definitionPckName.equals(package_.getName())) {
                this.definitionPackages.add(package_);
                this.definitionPackageSuites.add((Suite)traversal.getAdapter());
                return false;
            }
            if (this.dictionaryPckName.equals(package_.getName())) {
                this.dictionaryPackages.add(package_);
                return false;
            }
        }
        return true;
    }

    public void nodeExited(Traversal traversal) {
    }

    public String getDefinitionPckName() {
        if (RppProcCallDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "getDefinitionPckName()", 101).log();
        }
        return this.definitionPckName;
    }

    public String getDictionaryPckName() {
        if (RppProcCallDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "getDictionaryPckName()", 102).log();
        }
        return this.dictionaryPckName;
    }

    public List getDefinitionPackages() {
        if (RppProcCallDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "getDefinitionPackages()", 117).log();
        }
        return this.definitionPackages;
    }

    public List getDefinitionPackageSuites() {
        if (RppProcCallDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "getDefinitionPackageSuites()", 118).log();
        }
        return this.definitionPackageSuites;
    }

    public List getDictionaryPackages() {
        if (RppProcCallDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "getDictionaryPackages()", 126).log();
        }
        return this.dictionaryPackages;
    }

    public List getIncludedProcedureFiles() {
        if (RppProcCallDefinitions.logger.level >= 7) {
            logger.lvlBuild(7, "getIncludedProcedureFiles()", 128).log();
        }
        return this.includedProcedureFiles;
    }

    public RppProcCallDefinitions setDefinitionPckName(String string) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDefinitionPckName(String)", 75).addDetail("definitionPckName", string)).log();
        }
        this.definitionPckName = string;
        return this;
    }

    public RppProcCallDefinitions setDictionaryPckName(String string) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDictionaryPckName(String)", 75).addDetail("dictionaryPckName", string)).log();
        }
        this.dictionaryPckName = string;
        return this;
    }

    public RppProcCallDefinitions setIncludedProcedureFiles(List list) {
        if (RppProcCallDefinitions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setIncludedProcedureFiles(List<String>)", 75).addDetail("includedProcedureFiles", (Object)list)).log();
        }
        this.includedProcedureFiles = list;
        return this;
    }

    static {
        dictionaries = new LinkedHashMap();
    }
}

