/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.script.modules.helper;

import de.qfs.apps.qftest.extensions.qftest.DataBinder;
import de.qfs.apps.qftest.run.AbstractRunContext;
import de.qfs.apps.qftest.script.modules.helper.a;
import de.qfs.apps.qftest.shared.ExternalClassWrapperHelper;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.exceptions.UserException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.RunContext;
import de.qfs.apps.qftest.shared.variables.VariableData;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.schlichtherle.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelAPIHelperImpl
extends ExternalClassWrapperHelper
implements a {
    private static final QFLogger c = new QFLogger("de.qfs.apps.qftest.script.modules.helper.ExcelAPIHelperImpl");

    @Override
    public Object getCellTypeClass() {
        if (ExcelAPIHelperImpl.c.level >= 7) {
            c.lvlBuild(7, "getCellTypeClass()", 69).log();
        }
        return CellType.class;
    }

    @Override
    public Object newWorkbook() {
        if (ExcelAPIHelperImpl.c.level >= 7) {
            c.lvlBuild(7, "newWorkbook()", 73).log();
        }
        return new XSSFWorkbook();
    }

    @Override
    public Object openWorkbook(InputStream inputStream) throws TestException {
        if (ExcelAPIHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "openWorkbook(InputStream)", 77).addDetail("ios", (Object)inputStream)).log();
        }
        try {
            return new XSSFWorkbook(inputStream);
        }
        catch (Throwable throwable) {
            if (ExcelAPIHelperImpl.c.level >= 5) {
                ((LevelAwareLogBuilder)c.lvlBuild(5, "openWorkbook(InputStream)", 81).add("t", (Object)throwable)).log();
            }
            try {
                return new HSSFWorkbook(inputStream);
            }
            catch (Throwable throwable2) {
                throw new TestException(throwable);
            }
        }
    }

    @Override
    public ArrayList read2010File(AbstractRunContext abstractRunContext, String string, String string2, String string3, boolean bl2) throws TestException {
        int n2;
        Row row;
        if (ExcelAPIHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "read2010File(AbstractRunContext,String,String,String,boolean)", 90).addDetail("context", (Object)abstractRunContext)).addDetail("excelFile", string)).addDetail("sheetName", string2)).addDetail("dateFormat", string3)).addDetail("isRowBased", bl2)).log();
        }
        Sheet sheet = null;
        XSSFWorkbook xSSFWorkbook = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            xSSFWorkbook = new XSSFWorkbook((InputStream)fileInputStream);
            sheet = string2 == null || string2 != null && string2.equals("") ? xSSFWorkbook.getSheetAt(0) : xSSFWorkbook.getSheet(string2);
        }
        catch (IOException iOException) {
            if (ExcelAPIHelperImpl.c.level >= 3) {
                ((LevelAwareLogBuilder)c.lvlBuild(3, "read2010File(AbstractRunContext,String,String,String,boolean)", 113).add("ioe", (Object)iOException)).log();
            }
            if (fileInputStream != null) {
                block36: {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException2) {
                        if (ExcelAPIHelperImpl.c.level < 3) break block36;
                        ((LevelAwareLogBuilder)c.lvlBuild(3, "read2010File(AbstractRunContext,String,String,String,boolean)", 119).add("e", (Object)iOException2)).log();
                    }
                }
                fileInputStream = null;
            }
            xSSFWorkbook = null;
            throw new TestException("Error parsing excel-file " + string, "cannotLoadExcelFile", (Object[])new String[]{string, iOException.getLocalizedMessage()}, (Throwable)iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (ExcelAPIHelperImpl.c.level >= 3) {
                ((LevelAwareLogBuilder)c.lvlBuild(3, "read2010File(AbstractRunContext,String,String,String,boolean)", 130).add("ex", (Object)illegalArgumentException)).log();
            }
            if (fileInputStream != null) {
                block37: {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        if (ExcelAPIHelperImpl.c.level < 3) break block37;
                        ((LevelAwareLogBuilder)c.lvlBuild(3, "read2010File(AbstractRunContext,String,String,String,boolean)", 136).add("e", (Object)iOException)).log();
                    }
                }
                fileInputStream = null;
            }
            xSSFWorkbook = null;
            String string4 = "0";
            if (string2 != null) {
                string4 = string2;
            }
            throw new TestException("Error getting spreadsheet from excel-file " + string, "cannotLoadSheetEx", (Object[])new String[]{string, string4, illegalArgumentException.getLocalizedMessage()}, (Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            if (ExcelAPIHelperImpl.c.level >= 3) {
                ((LevelAwareLogBuilder)c.lvlBuild(3, "read2010File(AbstractRunContext,String,String,String,boolean)", 152).add("ex", (Object)exception)).log();
            }
            if (fileInputStream != null) {
                block38: {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        if (ExcelAPIHelperImpl.c.level < 3) break block38;
                        ((LevelAwareLogBuilder)c.lvlBuild(3, "read2010File(AbstractRunContext,String,String,String,boolean)", 158).add("e", (Object)iOException)).log();
                    }
                }
                fileInputStream = null;
            }
            xSSFWorkbook = null;
            throw new TestException("Error parsing excel-file " + string, "cannotLoadExcelFile", (Object[])new String[]{string, exception.getLocalizedMessage()}, (Throwable)exception);
        }
        if (sheet == null) {
            String string5 = "0";
            if (string2 != null) {
                string5 = string2;
            }
            throw new TestException("Error getting spreadsheet from excel-file " + string, "cannotLoadSheet", (Object[])new String[]{string, string5});
        }
        if (sheet.getRow(sheet.getLastRowNum()) == null) {
            String string6 = "0";
            if (string2 != null) {
                string6 = string2;
            }
            throw new TestException("Empty spreadsheet in excel-file " + string, "emptySpreadSheet", (Object[])new String[]{string, string6});
        }
        int n3 = sheet.getFirstRowNum();
        int n4 = sheet.getRow(n3).getLastCellNum();
        int n5 = sheet.getLastRowNum() - n3;
        if (!bl2) {
            for (int i2 = n3; i2 <= n5 + n3; ++i2) {
                row = sheet.getRow(i2);
                if (row == null || (n2 = row.getLastCellNum()) <= n4) continue;
                n4 = n2;
            }
        }
        if (ExcelAPIHelperImpl.c.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(9, "read2010File(AbstractRunContext,String,String,String,boolean)", 209).add("fullColCount", n4)).add("rowCount", n5)).log();
        }
        if (n4 == 0) {
            throw new TestException("No valid column in spreadsheet in excel-file " + string, "noColumnInSpreadsheet", (Object[])new String[]{string});
        }
        ArrayList arrayList = new ArrayList(n5 + 1);
        row = new DataFormatter();
        for (n2 = n3; n2 <= n5 + n3; ++n2) {
            Row row2 = sheet.getRow(n2);
            boolean bl3 = true;
            if (row2 == null) continue;
            ArrayList<VariableData> arrayList2 = new ArrayList<VariableData>(n4 + 1);
            for (int i3 = 0; i3 < n4; ++i3) {
                Cell cell = row2.getCell(i3);
                if (cell != null) {
                    VariableData variableData;
                    CellType cellType = cell.getCellType();
                    if (cellType == CellType.FORMULA || cellType == CellType.NUMERIC) {
                        variableData = this.a((Workbook)xSSFWorkbook, cell, (DataFormatter)row, string3);
                        arrayList2.add(variableData);
                        bl3 = false;
                        continue;
                    }
                    variableData = null;
                    try {
                        String string7 = row.formatCellValue(cell);
                        variableData = cellType == CellType.BOOLEAN ? this.a(cell.getBooleanCellValue(), string7) : (this.a(cell) ? this.a(cell.getDateCellValue(), string7) : this.a(string7));
                    }
                    catch (Exception exception) {
                        variableData = this.a((Workbook)xSSFWorkbook, cell, (DataFormatter)row, string3);
                    }
                    arrayList2.add(i3, variableData);
                    if (VariableData.trimmedEmptyOrNull((VariableData)variableData)) continue;
                    bl3 = false;
                    continue;
                }
                arrayList2.add(null);
            }
            if (bl3) continue;
            arrayList.add(arrayList2);
        }
        if (!bl2) {
            arrayList = this.a(arrayList);
        }
        if (fileInputStream != null) {
            block39: {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    if (ExcelAPIHelperImpl.c.level < 1) break block39;
                    ((LevelAwareLogBuilder)c.lvlBuild(1, "read2010File(AbstractRunContext,String,String,String,boolean)", 285).add("e", (Object)iOException)).log();
                }
            }
            fileInputStream = null;
        }
        xSSFWorkbook = null;
        return arrayList;
    }

    public String getFormulaPOIValue(Workbook workbook, Cell cell, DataFormatter dataFormatter, String string) throws TestException {
        if (ExcelAPIHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "getFormulaPOIValue(Workbook,Cell,DataFormatter,String)", 305).addDetail("wb", (Object)workbook)).addDetail("cell", (Object)cell)).addDetail("df", (Object)dataFormatter)).addDetail("dateFormat", string)).log();
        }
        VariableData variableData = this.a(workbook, cell, dataFormatter, string);
        return Misc.toStringOrNull((Object)variableData);
    }

    protected VariableData a(Workbook workbook, Cell cell, DataFormatter dataFormatter, String string) throws TestException {
        if (ExcelAPIHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "getFormulaPOIValueData(Workbook,Cell,DataFormatter,String)", 312).addDetail("wb", (Object)workbook)).addDetail("cell", (Object)cell)).addDetail("df", (Object)dataFormatter)).addDetail("dateFormat", string)).log();
        }
        try {
            FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
            CellType cellType = cell.getCellType();
            if (cellType == CellType.FORMULA) {
                CellValue cellValue;
                block46: {
                    cellValue = null;
                    try {
                        cellValue = formulaEvaluator.evaluate(cell);
                    }
                    catch (StackOverflowError stackOverflowError) {
                        throw new TestException("poiStackOverflowError", "poiStackOverflowError", new Object[]{cell.getSheet().getSheetName(), CellReference.convertNumToColString((int)cell.getColumnIndex()), cell.getRowIndex() + 1});
                    }
                    catch (NotImplementedException notImplementedException) {
                        try {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                Date date = cell.getDateCellValue();
                                String string2 = new SimpleDateFormat(string).format(date);
                                return this.a(date, string2);
                            }
                            double d2 = cellValue.getNumberValue();
                            String string3 = dataFormatter.createFormat(cell).format(d2);
                            return this.a(d2, string3);
                        }
                        catch (Exception exception) {
                            String string4 = ((XSSFCell)cell).getRawValue();
                            return this.a(string4);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        if (cell instanceof XSSFCell) {
                            try {
                                double d3 = cell.getNumericCellValue();
                                String string5 = dataFormatter.createFormat(cell).format(d3);
                                return this.a(d3, string5);
                            }
                            catch (Exception exception) {
                                String string6 = ((XSSFCell)cell).getRawValue();
                                return this.a(string6);
                            }
                        }
                        if (cell instanceof HSSFCell) {
                            try {
                                double d4 = cell.getNumericCellValue();
                                String string7 = dataFormatter.createFormat(cell).format(d4);
                                return this.a(d4, string7);
                            }
                            catch (Exception exception) {
                                try {
                                    String string8 = ErrorEval.getText((int)((HSSFCell)cell).getErrorCellValue());
                                    return this.a(string8);
                                }
                                catch (Exception exception2) {
                                    if (cell instanceof HSSFCell) {
                                        String string9 = cell.toString();
                                        return this.a(string9);
                                    }
                                    if (cell instanceof XSSFCell) {
                                        String string10 = ((XSSFCell)cell).getRawValue();
                                        return this.a(string10);
                                    }
                                    break block46;
                                }
                            }
                        }
                        String string11 = cell.toString();
                        return this.a(string11);
                    }
                }
                CellType cellType2 = cellValue.getCellType();
                if (cellType2 == CellType.NUMERIC) {
                    if (this.a(cell)) {
                        Date date = cell.getDateCellValue();
                        String string12 = new SimpleDateFormat(string).format(date);
                        return this.a(date, string12);
                    }
                    double d5 = cellValue.getNumberValue();
                    String string13 = dataFormatter.createFormat(cell).format(d5);
                    return this.a(d5, string13);
                }
                if (cellType2 == CellType.STRING) {
                    return this.a(cell.getStringCellValue());
                }
                if (cellType2 == CellType.BOOLEAN) {
                    return this.a(cell.getBooleanCellValue());
                }
                if (cellType2 == CellType.ERROR) {
                    if (cell instanceof XSSFCell) {
                        String string14 = ((XSSFCell)cell).getRawValue();
                        return this.a(string14);
                    }
                    if (cell instanceof HSSFCell) {
                        String string15 = ErrorEval.getText((int)((HSSFCell)cell).getErrorCellValue());
                        return this.a(string15);
                    }
                    String string16 = cell.toString();
                    return this.a(string16);
                }
            } else {
                if (cellType == CellType.NUMERIC) {
                    if (this.a(cell)) {
                        Date date = cell.getDateCellValue();
                        String string17 = new SimpleDateFormat(string).format(date);
                        return this.a(date, string17);
                    }
                    double d6 = cell.getNumericCellValue();
                    String string18 = dataFormatter.formatCellValue(cell);
                    return this.a(d6, string18);
                }
                if (cellType == CellType.ERROR) {
                    if (cell instanceof XSSFCell) {
                        String string19 = ((XSSFCell)cell).getRawValue();
                        return this.a(string19);
                    }
                    if (cell instanceof HSSFCell) {
                        String string20 = ErrorEval.getText((int)((HSSFCell)cell).getErrorCellValue());
                        return this.a(string20);
                    }
                    String string21 = cell.toString();
                    return this.a(string21);
                }
                if (cellType == CellType.BOOLEAN) {
                    return this.a(cell.getBooleanCellValue());
                }
                if (cellType == CellType.STRING) {
                    return this.a(cell.getStringCellValue());
                }
                if (cell instanceof XSSFCell) {
                    String string22 = ((XSSFCell)cell).getRawValue();
                    return this.a(string22);
                }
            }
            return this.a(cell.toString());
        }
        catch (IllegalStateException illegalStateException) {
            if (cell instanceof XSSFCell) {
                String string23 = ((XSSFCell)cell).getRawValue();
                return this.a(string23);
            }
            if (cell instanceof HSSFCell) {
                String string24 = ErrorEval.getText((int)((HSSFCell)cell).getErrorCellValue());
                return this.a(string24);
            }
            String string25 = cell.toString();
            return this.a(string25);
        }
        catch (FormulaParseException formulaParseException) {
            if (ExcelAPIHelperImpl.c.level >= 3) {
                ((LevelAwareLogBuilder)c.lvlBuild(3, "getFormulaPOIValueData(Workbook,Cell,DataFormatter,String)", 473).add("fpe", (Object)formulaParseException)).log();
            }
            try {
                double d7 = cell.getNumericCellValue();
                if (cell.getCellType() == CellType.FORMULA) {
                    FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
                    CellValue cellValue = formulaEvaluator.evaluate(cell);
                    d7 = cellValue.getNumberValue();
                }
                return this.a((Object)d7);
            }
            catch (IllegalStateException illegalStateException) {
                if (ExcelAPIHelperImpl.c.level >= 3) {
                    ((LevelAwareLogBuilder)c.lvlBuild(3, "getFormulaPOIValueData(Workbook,Cell,DataFormatter,String)", 489).add("e", (Object)illegalStateException)).log();
                }
                if (cell instanceof XSSFCell) {
                    String string26 = ((XSSFCell)cell).getRawValue();
                    return this.a(string26);
                }
                String string27 = cell.toString();
                return this.a(string27);
            }
        }
    }

    private VariableData a(Object object) {
        Object object2;
        if (ExcelAPIHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "newVariableData(Object)", 502).addDetail("object", object)).log();
        }
        if (object instanceof Double) {
            object2 = (Double)object;
            object = this.a((Double)object2);
        }
        if (object instanceof String) {
            object2 = (String)object;
            if (Options.cached_OPT_EXCEL_BINDER_REPLACE_WHITESPACES_WITH_STANDARD_WHITESPACE) {
                object = Misc.replaceSpecialWhitespaceCharactersByStandardWhitespace((String)object2);
            }
        }
        return VariableData.from((Object)object);
    }

    private VariableData a(Object object, String string) {
        if (ExcelAPIHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "newVariableData(Object,String)", 512).addDetail("object", object)).addDetail("stringValue", string)).log();
        }
        if (object instanceof Double) {
            Double d2 = (Double)object;
            object = this.a(d2);
        }
        if (Options.cached_OPT_EXCEL_BINDER_REPLACE_WHITESPACES_WITH_STANDARD_WHITESPACE) {
            string = Misc.replaceSpecialWhitespaceCharactersByStandardWhitespace((String)string);
        }
        return VariableData.from((Object)object, (String)string);
    }

    private Number a(double d2) {
        if (ExcelAPIHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "bestNumber(double)", 522).addDetail("numberValue", d2)).log();
        }
        if (d2 == Math.rint(d2)) {
            long l2 = Double.valueOf(d2).longValue();
            try {
                return Math.toIntExact(l2);
            }
            catch (ArithmeticException arithmeticException) {
                return l2;
            }
        }
        return d2;
    }

    private boolean a(Cell cell) {
        if (ExcelAPIHelperImpl.c.level >= 7) {
            ((LevelAwareLogBuilder)c.lvlBuild(7, "isCellDateFormatted(Cell)", 533).addDetail("cell", (Object)cell)).log();
        }
        return DateUtil.isCellDateFormatted((Cell)cell);
    }

    protected ArrayList a(ArrayList arrayList) {
        int n2;
        int n3;
        ArrayList arrayList2 = new ArrayList(((ArrayList)arrayList.get(0)).size());
        for (n3 = 0; n3 < ((ArrayList)arrayList.get(0)).size(); ++n3) {
            ArrayList arrayList3 = new ArrayList(arrayList.size());
            arrayList2.add(arrayList3);
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            for (int i2 = 0; i2 < ((ArrayList)arrayList.get(n3)).size(); ++i2) {
                ((ArrayList)arrayList2.get(i2)).add(n3, (VariableData)((ArrayList)arrayList.get(n3)).get(i2));
            }
        }
        n3 = 0;
        block3: for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
            for (n2 = 0; n2 < ((ArrayList)arrayList2.get(i3)).size(); ++n2) {
                if (VariableData.emptyOrNull((VariableData)((VariableData)((ArrayList)arrayList2.get(i3)).get(n2)))) continue;
                ++n3;
                continue block3;
            }
        }
        ArrayList<ArrayList> arrayList4 = new ArrayList<ArrayList>(n3);
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            boolean bl2 = false;
            for (int i4 = 0; i4 < ((ArrayList)arrayList2.get(n2)).size(); ++i4) {
                if (VariableData.emptyOrNull((VariableData)((VariableData)((ArrayList)arrayList2.get(n2)).get(i4)))) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            arrayList4.add((ArrayList)arrayList2.get(n2));
        }
        return arrayList4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataBinder createLibDataBinder(AbstractRunContext abstractRunContext, String string, String string2, String string3, String string4) throws TestException {
        int n2;
        XSSFRow xSSFRow;
        int n3;
        HSSFSheet hSSFSheet;
        XSSFSheet xSSFSheet;
        HSSFWorkbook hSSFWorkbook;
        XSSFWorkbook xSSFWorkbook;
        LinkedList<String> linkedList;
        block48: {
            if (ExcelAPIHelperImpl.c.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)c.lvlBuild(7, "createLibDataBinder(AbstractRunContext,String,String,String,String)", 602).addDetail("context", (Object)abstractRunContext)).addDetail("filename", string)).addDetail("sheetName", string2)).addDetail("df", string3)).addDetail("dateFormat", string4)).log();
            }
            linkedList = new LinkedList<String>();
            FileInputStream fileInputStream = null;
            xSSFWorkbook = null;
            hSSFWorkbook = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new UserException("File " + string + " not found");
            }
            String string5 = string.toLowerCase();
            if (string5.endsWith(".xlsx") || string5.endsWith(".xlsm")) {
                try {
                    xSSFWorkbook = new XSSFWorkbook((InputStream)fileInputStream);
                }
                catch (Throwable throwable) {
                    if (ExcelAPIHelperImpl.c.level >= 5) {
                        ((LevelAwareLogBuilder)c.lvlBuild(5, "createLibDataBinder(AbstractRunContext,String,String,String,String)", 622).add("t", (Object)throwable)).log();
                    }
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new TestException("Error closing stream!", (Throwable)iOException);
                    }
                }
            }
            if (xSSFWorkbook == null) {
                try {
                    hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);
                }
                catch (Throwable throwable) {
                    throw new TestException("Unable to read file " + string, throwable);
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new TestException("Error closing stream!", (Throwable)iOException);
                    }
                }
            }
            if (Misc.emptyOrNull((String)string2)) {
                throw new UserException("No value for sheet specified!");
            }
            xSSFSheet = null;
            hSSFSheet = null;
            try {
                int n4 = Integer.parseInt(string2);
                if (xSSFWorkbook != null) {
                    xSSFSheet = xSSFWorkbook.getSheetAt(n4);
                } else {
                    hSSFSheet = hSSFWorkbook.getSheetAt(n4);
                }
            }
            catch (Throwable throwable) {
                if (ExcelAPIHelperImpl.c.level < 5) break block48;
                ((LevelAwareLogBuilder)c.lvlBuild(5, "createLibDataBinder(AbstractRunContext,String,String,String,String)", 659).add("t", (Object)throwable)).log();
            }
        }
        if (xSSFWorkbook != null && xSSFSheet == null) {
            xSSFSheet = xSSFWorkbook.getSheet(string2);
        } else if (hSSFWorkbook != null && hSSFSheet == null) {
            hSSFSheet = hSSFWorkbook.getSheet(string2);
        }
        if (xSSFSheet == null && hSSFSheet == null) {
            throw new UserException("No sheet found!");
        }
        if (Misc.emptyOrNull((String)string4)) {
            string3 = "MM/dd/yy";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        DataFormatter dataFormatter = new DataFormatter();
        int n5 = xSSFSheet != null ? xSSFSheet.getFirstRowNum() : hSSFSheet.getFirstRowNum();
        int n6 = xSSFSheet != null ? xSSFSheet.getLastRowNum() : hSSFSheet.getLastRowNum();
        int n7 = 0;
        for (n3 = n5; n3 <= n6; ++n3) {
            if (xSSFSheet != null && (xSSFRow = xSSFSheet.getRow(n3)) != null) {
                n2 = xSSFRow.getLastCellNum();
                n7 = Math.max(n7, n2);
            }
            if (hSSFSheet == null || (xSSFRow = hSSFSheet.getRow(n3)) == null) continue;
            n2 = xSSFRow.getLastCellNum();
            n7 = Math.max(n7, n2);
        }
        for (n3 = n5; n3 <= n6; ++n3) {
            String string6;
            CellReference cellReference;
            String string7;
            XSSFCell xSSFCell;
            if (xSSFSheet != null) {
                xSSFRow = xSSFSheet.getRow(n3);
                for (n2 = 0; n2 < n7; ++n2) {
                    xSSFCell = null;
                    if (xSSFRow != null) {
                        xSSFCell = xSSFRow.getCell(n2);
                    }
                    string7 = "";
                    if (xSSFCell != null && Misc.emptyOrNull((String)(string7 = this.getFormulaPOIValue((Workbook)xSSFWorkbook, (Cell)xSSFCell, dataFormatter, simpleDateFormat.toPattern())))) {
                        string7 = xSSFCell.toString();
                    }
                    cellReference = new CellReference(n3, n2);
                    string6 = cellReference.formatAsString();
                    linkedList.add(string6);
                    linkedList.add(string7);
                }
            }
            if (hSSFSheet == null) continue;
            xSSFRow = hSSFSheet.getRow(n3);
            for (n2 = 0; n2 < n7; ++n2) {
                xSSFCell = null;
                if (xSSFRow != null) {
                    xSSFCell = xSSFRow.getCell(n2);
                }
                string7 = "";
                if (xSSFCell != null && Misc.emptyOrNull((String)(string7 = this.getFormulaPOIValue((Workbook)hSSFWorkbook, (Cell)xSSFCell, dataFormatter, simpleDateFormat.toPattern())))) {
                    string7 = xSSFCell.toString();
                }
                cellReference = new CellReference(n3, n2);
                string6 = cellReference.formatAsString();
                linkedList.add(string6);
                linkedList.add(string7);
            }
        }
        DataBinder dataBinder = new DataBinder(){
            boolean a = true;

            @Override
            public void initialize(RunContext runContext) throws TestException {
                if (ExcelAPIHelperImpl.c.level >= 7) {
                    ((LevelAwareLogBuilder)c.lvlBuild(7, "createLibDataBinder(AbstractRunContext,String,String,String,String).DataBinder.initialize(RunContext)", 745).addDetail("rc", (Object)runContext)).log();
                }
            }

            @Override
            public void reset(RunContext runContext) throws TestException {
                if (ExcelAPIHelperImpl.c.level >= 7) {
                    ((LevelAwareLogBuilder)c.lvlBuild(7, "createLibDataBinder(AbstractRunContext,String,String,String,String).DataBinder.reset(RunContext)", 751).addDetail("rc", (Object)runContext)).log();
                }
            }

            @Override
            public List next(RunContext runContext) throws TestException {
                if (ExcelAPIHelperImpl.c.level >= 7) {
                    ((LevelAwareLogBuilder)c.lvlBuild(7, "createLibDataBinder(AbstractRunContext,String,String,String,String).DataBinder.next(RunContext)", 758).addDetail("rc", (Object)runContext)).log();
                }
                if (this.a) {
                    this.a = false;
                    return linkedList;
                }
                return null;
            }

            @Override
            public void cleanup(RunContext runContext) throws TestException {
                if (ExcelAPIHelperImpl.c.level >= 7) {
                    ((LevelAwareLogBuilder)c.lvlBuild(7, "createLibDataBinder(AbstractRunContext,String,String,String,String).DataBinder.cleanup(RunContext)", 768).addDetail("rc", (Object)runContext)).log();
                }
            }
        };
        return dataBinder;
    }
}

