/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.start;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class X509StoreSocketHelper {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.start.X509StoreSocketHelper");
    private StoreData b;
    private StoreData c;

    private TrustManager[] a() throws NoSuchAlgorithmException, KeyStoreException {
        if (X509StoreSocketHelper.a.level >= 7) {
            a.lvlBuild(7, "getDefaultTrustManagers()", 51).log();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        return trustManagerFactory.getTrustManagers();
    }

    private KeyManager[] b() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        if (X509StoreSocketHelper.a.level >= 7) {
            a.lvlBuild(7, "getDefaultKeyManagers()", 60).log();
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(null, null);
        return keyManagerFactory.getKeyManagers();
    }

    @Nullable
    public TrustManager[] getTrustManagers() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        if (X509StoreSocketHelper.a.level >= 7) {
            a.lvlBuild(7, "getTrustManagers()", 70).log();
        }
        if (this.getTrustManagerData() == null) {
            return this.a();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        try (FileInputStream fileInputStream = new FileInputStream(this.getTrustManagerData().getStoreFile());){
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String string = this.getTrustManagerData().getPassword();
            keyStore.load(fileInputStream, string.toCharArray());
            trustManagerFactory.init(keyStore);
        }
        return trustManagerFactory.getTrustManagers();
    }

    @Nullable
    public KeyManager[] getKeyManagers() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        if (X509StoreSocketHelper.a.level >= 7) {
            a.lvlBuild(7, "getKeyManagers()", 91).log();
        }
        if (this.getKeyManagerData() == null) {
            return this.b();
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        try (FileInputStream fileInputStream = new FileInputStream(this.getKeyManagerData().getStoreFile());){
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String string = this.getTrustManagerData().getPassword();
            keyStore.load(fileInputStream, string.toCharArray());
            fileInputStream.close();
            keyManagerFactory.init(keyStore, string.toCharArray());
        }
        return keyManagerFactory.getKeyManagers();
    }

    public String toString() {
        if (X509StoreSocketHelper.a.level >= 7) {
            a.lvlBuild(7, "toString()", 41).log();
        }
        return "X509StoreSocketHelper(trustManagerData=" + String.valueOf(this.getTrustManagerData()) + ", keyManagerData=" + String.valueOf(this.getKeyManagerData()) + ")";
    }

    public StoreData getTrustManagerData() {
        if (X509StoreSocketHelper.a.level >= 7) {
            a.lvlBuild(7, "getTrustManagerData()", 44).log();
        }
        return this.b;
    }

    public X509StoreSocketHelper setTrustManagerData(StoreData storeData) {
        if (X509StoreSocketHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setTrustManagerData(StoreData)", 45).addDetail("trustManagerData", (Object)storeData)).log();
        }
        this.b = storeData;
        return this;
    }

    public StoreData getKeyManagerData() {
        if (X509StoreSocketHelper.a.level >= 7) {
            a.lvlBuild(7, "getKeyManagerData()", 47).log();
        }
        return this.c;
    }

    public X509StoreSocketHelper setKeyManagerData(StoreData storeData) {
        if (X509StoreSocketHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setKeyManagerData(StoreData)", 48).addDetail("keyManagerData", (Object)storeData)).log();
        }
        this.c = storeData;
        return this;
    }

    public static class StoreData
    implements Cloneable {
        String a;
        String b;

        public StoreData clone() {
            if (X509StoreSocketHelper.a.level >= 7) {
                a.lvlBuild(7, "StoreData.clone()", 121).log();
            }
            return (StoreData)super.clone();
        }

        public String getStoreFile() {
            if (X509StoreSocketHelper.a.level >= 7) {
                a.lvlBuild(7, "StoreData.getStoreFile()", 117).log();
            }
            return this.a;
        }

        public String getPassword() {
            if (X509StoreSocketHelper.a.level >= 7) {
                a.lvlBuild(7, "StoreData.getPassword()", 118).log();
            }
            return this.b;
        }

        public StoreData setStoreFile(String string) {
            if (X509StoreSocketHelper.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "StoreData.setStoreFile(String)", 114).addDetail("storeFile", string)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("storeFile is marked non-null but is null");
            }
            this.a = string;
            return this;
        }

        public StoreData setPassword(String string) {
            if (X509StoreSocketHelper.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "StoreData.setPassword(String)", 114).addDetail("password", string)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("password is marked non-null but is null");
            }
            this.b = string;
            return this;
        }

        public boolean equals(Object object) {
            if (X509StoreSocketHelper.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "StoreData.equals(Object)", 114).addDetail("o", object)).log();
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof StoreData)) {
                return false;
            }
            StoreData storeData = (StoreData)object;
            if (!storeData.a(this)) {
                return false;
            }
            String string = this.getStoreFile();
            String string2 = storeData.getStoreFile();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getPassword();
            String string4 = storeData.getPassword();
            return !(string3 == null ? string4 != null : !string3.equals(string4));
        }

        protected boolean a(Object object) {
            if (X509StoreSocketHelper.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "StoreData.canEqual(Object)", 114).addDetail("other", object)).log();
            }
            return object instanceof StoreData;
        }

        public int hashCode() {
            if (X509StoreSocketHelper.a.level >= 7) {
                a.lvlBuild(7, "StoreData.hashCode()", 114).log();
            }
            int n2 = 1;
            String string = this.getStoreFile();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getPassword();
            n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
            return n2;
        }

        public String toString() {
            if (X509StoreSocketHelper.a.level >= 7) {
                a.lvlBuild(7, "StoreData.toString()", 114).log();
            }
            return "X509StoreSocketHelper.StoreData(storeFile=" + this.getStoreFile() + ", password=" + this.getPassword() + ")";
        }

        public StoreData(String string, String string2) {
            if (X509StoreSocketHelper.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "StoreData.StoreData(String,String)", 115).addDetail("storeFile", string)).addDetail("password", string2)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("storeFile is marked non-null but is null");
            }
            if (string2 == null) {
                throw new IllegalArgumentException("password is marked non-null but is null");
            }
            this.a = string;
            this.b = string2;
        }
    }
}

