/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.step;

import de.qfs.apps.qftest.extensions.qftest.DataBinder;
import de.qfs.apps.qftest.io.a;
import de.qfs.apps.qftest.run.AbstractRunContext;
import de.qfs.apps.qftest.script.modules.ExcelAPI;
import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.variables.VariableData;
import de.qfs.apps.qftest.step.AbstractDataBinder;
import de.qfs.apps.qftest.step.AbstractStep;
import de.qfs.apps.qftest.step.TableBinder;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.format.Format;
import jxl.read.biff.BiffException;

public class ExcelDataBinder
extends AbstractDataBinder {
    private static final QFLogger v = new QFLogger("de.qfs.apps.qftest.step.ExcelDataBinder");
    public static final int ATT_COUNT = 12;
    public static final int I_EXCELFILE = 8;
    public static final String EXCELFILE = "excelfile".intern();
    public static final int I_SHEETNAME = 9;
    public static final String SHEETNAME = "sheetname".intern();
    public static final int I_DATEFORMAT = 10;
    public static final String DATEFORMAT = "dateformat".intern();
    public static final int I_ROWBASED = 11;
    public static final String ROWBASED = "rowbased".intern();
    public static final String[] names = new String[]{ID, UID, PREDELAY, POSTDELAY, DISABLED, NAME, VAR, INTERVALS, EXCELFILE, SHEETNAME, DATEFORMAT, ROWBASED};
    private static String prefix;
    private static String w;
    protected String r;
    protected String s;
    protected String t;
    protected String u = "true";

    public final String getExcelFile() {
        return this.r;
    }

    public final void setExcelFile(String string) {
        this.r = string;
    }

    public final String getSheetName() {
        return this.s;
    }

    public final void setSheetName(String string) {
        this.s = string;
    }

    public final String getDateFormat() {
        return this.t;
    }

    public final void setDateFormat(String string) {
        this.t = string;
    }

    public final String getRowBased() {
        return this.u;
    }

    public final void setRowBased(String string) {
        this.u = string;
    }

    @Override
    public String toString(boolean bl2) {
        if (optTreeLegacyDisplay) {
            return super.toString(bl2);
        }
        return this.getPrefix() + (String)(Misc.emptyOrNull((String)this.o) ? "" : ": " + this.o) + (String)(Misc.emptyOrNull((String)this.r) ? "" : " " + ExcelDataBinder.quoteEmpty(bl2 ? ExcelDataBinder.truncateValue(this.r, optTreeValueLength, false) : this.r)) + (String)(Misc.emptyOrNull((String)this.q) ? "" : " [" + this.q + "]");
    }

    @Override
    public String toHtmlString() {
        if (optTreeLegacyDisplay) {
            return super.toHtmlString();
        }
        return ExcelDataBinder.getHtmlPrefixNameFileInterval(this.getPrefix(), this.o, ExcelDataBinder.quoteEmpty(AbstractStep.truncateValue(this.r, optTreeValueLength, false)), this.q);
    }

    @Override
    public String getPrefix() {
        if (ExcelDataBinder.v.level >= 7) {
            v.lvlBuild(7, "getPrefix()", 323).log();
        }
        if (prefix == null) {
            prefix = Globals.getResources().getString("excelDataBinder.name", "Excel Data binder");
            w = Globals.getResources().getString("excelDataBinder.name.legacy", prefix);
        }
        return optTreeLegacyDisplay ? w : prefix;
    }

    @Override
    protected DataBinder a(AbstractRunContext abstractRunContext) throws TestException {
        if (ExcelDataBinder.v.level >= 7) {
            ((LevelAwareLogBuilder)v.lvlBuild(7, "createDataBinder(AbstractRunContext)", 347).addDetail("context", (Object)abstractRunContext)).log();
        }
        String string = this.expandMandatoryString(abstractRunContext, NAME, this.o, this.getPrefix());
        String string2 = this.expandMandatoryString(abstractRunContext, EXCELFILE, this.r, this.getPrefix());
        String string3 = abstractRunContext.expandString(SHEETNAME, this.s);
        String string4 = abstractRunContext.expandString(DATEFORMAT, this.t);
        if (Util.getDoctag((String)this.getComment(), (String)"libformat") != null) {
            return ExcelAPI.instance().createLibDataBinder(abstractRunContext, string2, string3, string4, string4);
        }
        string2 = a.joinRelativePath(Misc.getBestParentPath((File)abstractRunContext.getCurrentSuite().getFile()), string2);
        if (Misc.emptyOrNull((String)string4)) {
            string4 = "MM/dd/yy";
        }
        boolean bl2 = abstractRunContext.expandBooleanOrEvalTest(ROWBASED, this.u);
        if (string2.endsWith(".xlsx") || string2.endsWith(".xlsm")) {
            return this.a(abstractRunContext, string2, string3, string4, bl2);
        }
        return this.b(abstractRunContext, string2, string3, string4, bl2);
    }

    protected DataBinder a(AbstractRunContext abstractRunContext, String string, String string2, String string3, boolean bl2) throws TestException {
        if (ExcelDataBinder.v.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)v.lvlBuild(5, "createExcel2010DataBinder(AbstractRunContext,String,String,String,boolean)", 392).add("Entered with excelFile", string)).add("sheetName", string2)).add("dateFormat", string3)).log();
        }
        ArrayList arrayList = ExcelAPI.instance().read2010File(abstractRunContext, string, string2, string3, bl2);
        arrayList = this.b(arrayList);
        Object[][] objectArray = new Object[arrayList.size()][];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i2);
            objectArray[i2] = arrayList2.toArray(new VariableData[arrayList2.size()]);
        }
        return new TableBinder(abstractRunContext, this, objectArray);
    }

    protected DataBinder b(AbstractRunContext abstractRunContext, String string, String string2, String string3, boolean bl2) throws TestException {
        int n2;
        int n3;
        Object object;
        if (ExcelDataBinder.v.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)v.lvlBuild(5, "createExcel2007DataBinder(AbstractRunContext,String,String,String,boolean)", 422).add("Entered with excelFile", string)).add("sheetName", string2)).add("dateFormat", string3)).add("isRowBased", bl2)).log();
        }
        Sheet sheet = null;
        Workbook workbook = null;
        try {
            object = new WorkbookSettings();
            object.setEncoding("Cp1252");
            workbook = Workbook.getWorkbook((File)new File(string), (WorkbookSettings)object);
            sheet = string2 == null ? workbook.getSheet(0) : workbook.getSheet(string2);
        }
        catch (IOException iOException) {
            if (ExcelDataBinder.v.level >= 3) {
                ((LevelAwareLogBuilder)v.lvlBuild(3, "createExcel2007DataBinder(AbstractRunContext,String,String,String,boolean)", 444).add("ioe", (Object)iOException)).log();
            }
            if (workbook != null) {
                workbook.close();
            }
            throw new TestException("Error parsing excel-file " + string, "cannotLoadExcelFile", (Object[])new String[]{string, iOException.getLocalizedMessage()}, (Throwable)iOException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (ExcelDataBinder.v.level >= 3) {
                ((LevelAwareLogBuilder)v.lvlBuild(3, "createExcel2007DataBinder(AbstractRunContext,String,String,String,boolean)", 453).add("ex", (Object)indexOutOfBoundsException)).log();
            }
            if (workbook != null) {
                workbook.close();
            }
            String string4 = "0";
            if (string2 != null) {
                string4 = string2;
            }
            throw new TestException("Error getting spreadsheet from excel-file " + string, "cannotLoadSheetEx", (Object[])new String[]{string, string4, indexOutOfBoundsException.getLocalizedMessage()}, (Throwable)indexOutOfBoundsException);
        }
        catch (BiffException biffException) {
            if (ExcelDataBinder.v.level >= 3) {
                ((LevelAwareLogBuilder)v.lvlBuild(3, "createExcel2007DataBinder(AbstractRunContext,String,String,String,boolean)", 466).add("ex", (Object)biffException)).log();
            }
            if (workbook != null) {
                workbook.close();
            }
            throw new TestException("Error parsing excel-file  " + string, "cannotLoadExcelFile", (Object[])new String[]{string, biffException.getLocalizedMessage()}, (Throwable)biffException);
        }
        catch (Exception exception) {
            if (ExcelDataBinder.v.level >= 3) {
                ((LevelAwareLogBuilder)v.lvlBuild(3, "createExcel2007DataBinder(AbstractRunContext,String,String,String,boolean)", 474).add("ex", (Object)exception)).log();
            }
            if (workbook != null) {
                workbook.close();
            }
            throw new TestException("Error parsing excel-file  " + string, "cannotLoadExcelFile", (Object[])new String[]{string, exception.getLocalizedMessage()}, (Throwable)exception);
        }
        if (sheet == null) {
            if (workbook != null) {
                workbook.close();
            }
            object = "0";
            if (string2 != null) {
                object = string2;
            }
            throw new TestException("Error getting spreadsheet from excel-file " + string, "cannotLoadSheet", (Object[])new String[]{string, object});
        }
        if (sheet.getRows() == 0) {
            throw new TestException("Empty spreadsheet in excel-file " + string, "emptySpreadSheet", (Object[])new String[]{string});
        }
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < sheet.getRows() && bl2; ++i2) {
            n3 = 1;
            for (n2 = 0; n2 < sheet.getColumns(); ++n2) {
                if (Misc.emptyOrNull((String)sheet.getCell(n2, i2).getContents())) continue;
                ++n4;
                n3 = 0;
            }
            if (n3 != 0) continue;
            n5 = i2;
            break;
        }
        if (!bl2) {
            n4 = sheet.getColumns();
        }
        if (n4 == 0) {
            throw new TestException("No valid column in spreadsheet in excel-file " + string, "noColumnInSpreadsheet", (Object[])new String[]{string});
        }
        VariableData[][] variableDataArray = new VariableData[sheet.getRows() - n5][n4];
        n3 = 0;
        for (n2 = n5; n2 < sheet.getRows(); ++n2) {
            int n6 = 0;
            boolean bl3 = bl2;
            for (int i3 = 0; i3 < sheet.getColumns(); ++i3) {
                if (bl2 && Misc.emptyOrNull((String)sheet.getCell(i3, n5).getContents())) continue;
                Cell cell = sheet.getCell(i3, n2);
                CellType cellType = cell.getType();
                variableDataArray[n3][n6] = CellType.DATE.equals(cellType) || CellType.DATE_FORMULA.equals(cellType) ? this.d(cell) : (CellType.NUMBER.equals(cellType) || CellType.NUMBER_FORMULA.equals(cellType) ? this.a(cell) : (CellType.BOOLEAN.equals(cellType) || CellType.BOOLEAN_FORMULA.equals(cellType) ? this.c(cell) : this.a(cell.getContents())));
                if (variableDataArray[n3][n6] != null && !VariableData.trimmedEmptyOrNull((VariableData)variableDataArray[n3][n6])) {
                    bl3 = false;
                }
                ++n6;
            }
            if (bl3) continue;
            ++n3;
        }
        if (workbook != null) {
            workbook.close();
        }
        Object[][] objectArray = null;
        objectArray = bl2 ? this.a(n3, n4, variableDataArray) : this.a(variableDataArray);
        return new TableBinder(abstractRunContext, this, objectArray);
    }

    @Override
    public int getAttributeCount() {
        return 12;
    }

    @Override
    public String getAttributeName(int n2) {
        return names[n2];
    }

    @Override
    public String getAttributeValue(int n2) {
        switch (n2) {
            case 8: {
                return this.getExcelFile();
            }
            case 9: {
                return this.getSheetName();
            }
            case 10: {
                return this.getDateFormat();
            }
            case 11: {
                return this.getRowBased();
            }
        }
        return super.getAttributeValue(n2);
    }

    @Override
    public String getAttributeValue(String string) {
        if (EXCELFILE.equals(string)) {
            return this.getExcelFile();
        }
        if (SHEETNAME.equals(string)) {
            return this.getSheetName();
        }
        if (DATEFORMAT.equals(string)) {
            return this.getDateFormat();
        }
        if (ROWBASED.equals(string)) {
            return this.getRowBased();
        }
        return super.getAttributeValue(string);
    }

    @Override
    public boolean isAttributeSpecified(int n2) {
        switch (n2) {
            case 8: {
                return true;
            }
            case 9: {
                return this.s != null;
            }
            case 10: {
                return this.t != null;
            }
            case 11: {
                return !"true".equals(this.u);
            }
        }
        return super.isAttributeSpecified(n2);
    }

    @Override
    public boolean isAttributeSpecified(String string) {
        if (EXCELFILE.equals(string)) {
            return true;
        }
        if (SHEETNAME.equals(string)) {
            return this.s != null;
        }
        if (DATEFORMAT.equals(string)) {
            return this.t != null;
        }
        if (ROWBASED.equals(string)) {
            return !"true".equals(this.u);
        }
        return super.isAttributeSpecified(string);
    }

    @Override
    public boolean setAttribute(String string, String string2) {
        if (EXCELFILE.equals(string)) {
            this.setExcelFile(string2);
            return true;
        }
        if (SHEETNAME.equals(string)) {
            this.setSheetName(string2);
            return true;
        }
        if (DATEFORMAT.equals(string)) {
            this.setDateFormat(string2);
            return true;
        }
        if (ROWBASED.equals(string)) {
            this.setRowBased(string2);
            return true;
        }
        return super.setAttribute(string, string2);
    }

    protected VariableData a(Cell cell) {
        String string;
        if (this.b(cell)) {
            string = "";
            try {
                int n2;
                double d2 = ((NumberCell)cell).getValue();
                String string2 = cell.getCellFormat().getFormat().getFormatString();
                NumberFormat numberFormat = ((NumberCell)cell).getNumberFormat();
                NumberFormat numberFormat2 = NumberFormat.getCurrencyInstance(Locale.getDefault());
                int n3 = string2.lastIndexOf("#");
                string2 = string2.substring(n3 + 1);
                String[] stringArray = string2.split("[^0-9.]");
                for (n2 = 0; n2 < string2.length(); ++n2) {
                    if (Pattern.matches("[0-9.]*", string2.subSequence(0, n2))) continue;
                    string2 = string2.substring(0, n2 - 1);
                    break;
                }
                n2 = string2.indexOf(".");
                int n4 = 0;
                int n5 = 0;
                if (n2 != -1) {
                    n4 = string2.length() - n2 - 1;
                    n5 = string2.length() - n2 - 1;
                }
                numberFormat2.setMaximumFractionDigits(numberFormat.getMaximumFractionDigits());
                numberFormat2.setMaximumIntegerDigits(numberFormat.getMaximumIntegerDigits());
                numberFormat2.setMinimumFractionDigits(n4);
                numberFormat2.setMinimumIntegerDigits(numberFormat.getMinimumIntegerDigits());
                String string3 = numberFormat2.format(d2);
                return this.a(d2, string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = cell.getContents();
        try {
            double d3 = ((NumberCell)cell).getValue();
            return this.a(d3, string);
        }
        catch (Exception exception) {
            if (ExcelDataBinder.v.level >= 3) {
                ((LevelAwareLogBuilder)v.lvlBuild(3, "getFormattedNumberValue(Cell)", 895).add("Could not get Number value:", (Object)exception)).log();
            }
            return this.a(string);
        }
    }

    protected boolean b(Cell cell) {
        CellFormat cellFormat = cell.getCellFormat();
        if (cellFormat != null) {
            Object object;
            NumberCell numberCell;
            try {
                numberCell = (NumberCell)cell;
                object = numberCell.getNumberFormat();
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            numberCell = cellFormat.getFormat();
            object = numberCell.getFormatString();
            return !"".equals(object) && ((String)object).indexOf("#") != -1 && ((String)object).indexOf("E+") == -1 && ((String)object).indexOf("%") == -1;
        }
        return false;
    }

    protected VariableData c(Cell cell) {
        String string = cell.getContents();
        if (cell instanceof BooleanCell) {
            BooleanCell booleanCell = (BooleanCell)cell;
            return this.a(booleanCell, string);
        }
        return this.a(Misc.isBooleanDescriptor((String)string), string);
    }

    protected VariableData d(Cell cell) throws TestException {
        DateCell dateCell = (DateCell)cell;
        CellFormat cellFormat = cell.getCellFormat();
        if (dateCell.isTime()) {
            String string = dateCell.getContents();
            return this.a(string);
        }
        if (Misc.emptyOrNull((String)this.t)) {
            Format format = cellFormat.getFormat();
            String string = format.getFormatString();
            string = string.replaceAll("D", "d");
            string = string.replaceAll("Y", "y");
            string = string.replaceAll("m", "M");
            string = string.replaceAll(";@", "");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            String string2 = dateCell.getContents();
            Date date = dateCell.getDate();
            String string3 = simpleDateFormat.format(date);
            if (string2.indexOf(".") != -1 && string3.indexOf("/") != -1) {
                string3 = string3.replaceAll("/", ".");
            }
            if (string3.indexOf("\\") != -1) {
                string3 = string2;
            }
            return this.a(date, string3);
        }
        try {
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.t);
            simpleDateFormat.setTimeZone(timeZone);
            Date date = dateCell.getDate();
            String string = simpleDateFormat.format(date);
            return this.a(date, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (ExcelDataBinder.v.level >= 5) {
                ((LevelAwareLogBuilder)v.lvlBuild(5, "getFormattedDateValue(Cell)", 1037).add("ie", (Object)illegalArgumentException)).log();
            }
            throw new TestException("Illegal date-format " + this.t, "wrongDateFormat", (Object[])new String[]{this.t, illegalArgumentException.getLocalizedMessage()}, (Throwable)illegalArgumentException);
        }
    }

    protected Object[][] a(VariableData[][] variableDataArray) {
        int n2;
        int n3;
        int n4;
        VariableData[][] variableDataArray2 = new VariableData[variableDataArray[0].length][variableDataArray.length];
        for (n4 = 0; n4 < variableDataArray.length; ++n4) {
            for (n3 = 0; n3 < variableDataArray[n4].length; ++n3) {
                variableDataArray2[n3][n4] = variableDataArray[n4][n3];
            }
        }
        n4 = 0;
        block2: for (n3 = 0; n3 < variableDataArray2.length; ++n3) {
            for (n2 = 0; n2 < variableDataArray2[n3].length; ++n2) {
                if (VariableData.trimmedEmptyOrNull((VariableData)variableDataArray2[n3][n2])) continue;
                ++n4;
                continue block2;
            }
        }
        Object[][] objectArray = new Object[n4][variableDataArray2[0].length];
        n2 = 0;
        for (int i2 = 0; i2 < variableDataArray2.length; ++i2) {
            boolean bl2 = false;
            for (int i3 = 0; i3 < variableDataArray2[i2].length; ++i3) {
                if (VariableData.trimmedEmptyOrNull((VariableData)variableDataArray2[i2][i3])) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            objectArray[n2] = variableDataArray2[i2];
            ++n2;
        }
        return objectArray;
    }

    protected ArrayList a(ArrayList arrayList) {
        int n2;
        int n3;
        ArrayList arrayList2 = new ArrayList(((ArrayList)arrayList.get(0)).size());
        for (n3 = 0; n3 < ((ArrayList)arrayList.get(0)).size(); ++n3) {
            ArrayList arrayList3 = new ArrayList(arrayList.size());
            arrayList2.add(arrayList3);
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            for (int i2 = 0; i2 < ((ArrayList)arrayList.get(n3)).size(); ++i2) {
                ((ArrayList)arrayList2.get(i2)).add(n3, (VariableData)((ArrayList)arrayList.get(n3)).get(i2));
            }
        }
        n3 = 0;
        block3: for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
            for (n2 = 0; n2 < ((ArrayList)arrayList2.get(i3)).size(); ++n2) {
                if (VariableData.emptyOrNull((VariableData)((VariableData)((ArrayList)arrayList2.get(i3)).get(n2)))) continue;
                ++n3;
                continue block3;
            }
        }
        ArrayList<ArrayList> arrayList4 = new ArrayList<ArrayList>(n3);
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            boolean bl2 = false;
            for (int i4 = 0; i4 < ((ArrayList)arrayList2.get(n2)).size(); ++i4) {
                if (VariableData.emptyOrNull((VariableData)((VariableData)((ArrayList)arrayList2.get(n2)).get(i4)))) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            arrayList4.add((ArrayList)arrayList2.get(n2));
        }
        return arrayList4;
    }

    protected Object[][] a(int n2, int n3, VariableData[][] variableDataArray) {
        if (variableDataArray.length == n2) {
            return variableDataArray;
        }
        Object[][] objectArray = new Object[n2][];
        System.arraycopy(variableDataArray, 0, objectArray, 0, n2);
        return objectArray;
    }

    protected ArrayList b(ArrayList arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return arrayList;
        }
        int n2 = 0;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i2 = 0; i2 < ((ArrayList)arrayList.get(0)).size(); ++i2) {
            if (VariableData.emptyOrNull((VariableData)((VariableData)((ArrayList)arrayList.get(0)).get(i2)))) {
                arrayList2.add(i2);
                continue;
            }
            ++n2;
        }
        ArrayList arrayList3 = new ArrayList(n2);
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            ArrayList arrayList4 = new ArrayList(n2);
            arrayList3.add(arrayList4);
            for (int i4 = 0; i4 < ((ArrayList)arrayList.get(i3)).size(); ++i4) {
                if (arrayList2.contains(i4)) continue;
                ((ArrayList)arrayList3.get(i3)).add((VariableData)((ArrayList)arrayList.get(i3)).get(i4));
            }
        }
        return arrayList3;
    }

    private VariableData a(Object object) {
        Object object2;
        if (ExcelDataBinder.v.level >= 7) {
            ((LevelAwareLogBuilder)v.lvlBuild(7, "newVariableData(Object)", 1288).addDetail("object", object)).log();
        }
        if (object instanceof Double) {
            object2 = (Double)object;
            object = this.a((Double)object2);
        }
        if (object instanceof String) {
            object2 = (String)object;
            if (Options.cached_OPT_EXCEL_BINDER_REPLACE_WHITESPACES_WITH_STANDARD_WHITESPACE) {
                object = Misc.replaceSpecialWhitespaceCharactersByStandardWhitespace((String)object2);
            }
        }
        return VariableData.from((Object)object);
    }

    private VariableData a(Object object, String string) {
        if (ExcelDataBinder.v.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)v.lvlBuild(7, "newVariableData(Object,String)", 1298).addDetail("object", object)).addDetail("stringValue", string)).log();
        }
        if (object instanceof Double) {
            Double d2 = (Double)object;
            object = this.a(d2);
        }
        if (Options.cached_OPT_EXCEL_BINDER_REPLACE_WHITESPACES_WITH_STANDARD_WHITESPACE) {
            string = Misc.replaceSpecialWhitespaceCharactersByStandardWhitespace((String)string);
        }
        return VariableData.from((Object)object, (String)string);
    }

    private Number a(double d2) {
        if (ExcelDataBinder.v.level >= 7) {
            ((LevelAwareLogBuilder)v.lvlBuild(7, "bestNumber(double)", 1311).addDetail("numberValue", d2)).log();
        }
        if (d2 == Math.rint(d2)) {
            long l2 = Double.valueOf(d2).longValue();
            try {
                return Math.toIntExact(l2);
            }
            catch (ArithmeticException arithmeticException) {
                return l2;
            }
        }
        return d2;
    }
}

