/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.webapi;

import de.qfs.apps.qftest.extensions.qftest.ResetListener;
import de.qfs.apps.qftest.run.AbstractRunContext;
import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.script.modules.a.b.b;
import de.qfs.apps.qftest.webapi.TrustAllManager;
import de.qfs.apps.qftest.webapi.WebRequestSettings;
import de.qfs.apps.qftest.webapi.WebResponse;
import de.qfs.apps.qftest.webapi.auth.BasicAuth;
import de.qfs.apps.qftest.webapi.auth.e;
import de.qfs.apps.qftest.webapi.f;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonMapper;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.StreamInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.X509TrustManager;

public class WebRequest
extends HttpRequest
implements HttpRequest.Builder {
    private static final QFLogger g = new QFLogger("de.qfs.apps.qftest.webapi.WebRequest");
    private static ThreadLocal h = new ThreadLocal();
    @b
    private static WebRequest i;
    static X509TrustManager a;
    private static CookieManager j;
    private static final Map k;
    protected HttpClient.Version b = HttpClient.Version.HTTP_1_1;
    @b
    private String l;
    private String m;
    private String n;
    private byte[] o;
    private String p;
    private final HttpRequest.Builder q;
    private final Map r = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    String c;
    int d = 8080;
    @b
    e e;
    WebRequestSettings f;
    private Duration s = Duration.ofSeconds(20L);

    public WebRequest(String string, URI uRI, String string2, Map map, String string3, String string4, String string5) throws TestException {
        HttpRequest.BodyPublisher bodyPublisher;
        this.l = string;
        this.n = string3;
        this.p = string4;
        this.m = string5;
        if (Misc.emptyOrNull((String)string4)) {
            bodyPublisher = Misc.emptyOrNull((String)string3) ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(string3);
        } else {
            try {
                bodyPublisher = HttpRequest.BodyPublishers.ofFile(Path.of(string4, new String[0]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (WebRequest.g.level >= 5) {
                    ((LevelAwareLogBuilder)g.lvlBuild(5, "WebRequest(String,URI,String,Map<String, List<String>>,String,String,String)", 253).add("ex", (Object)fileNotFoundException)).log();
                }
                throw new TestException("Cannot load payload file " + string4, "cannotLoadPayloadFile", (Object[])new String[]{string4, fileNotFoundException.getLocalizedMessage()}, (Throwable)fileNotFoundException);
            }
        }
        this.q = HttpRequest.newBuilder(uRI).method(string2, bodyPublisher);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                for (String string6 : (List)entry.getValue()) {
                    this.q.header((String)entry.getKey(), string6);
                    this.r.put((String)entry.getKey(), string6);
                }
            }
        }
    }

    private WebRequest(WebRequest webRequest) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "WebRequest(WebRequest)", 274).addDetail("source", (Object)webRequest)).log();
        }
        this.l = webRequest.l;
        this.r.putAll(webRequest.r);
        this.n = webRequest.n;
        this.m = webRequest.m;
        this.q = webRequest.q.copy();
    }

    public WebRequest(URI uRI, String string, byte[] byArray) throws TestException {
        this.o = byArray;
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(byArray);
        this.q = HttpRequest.newBuilder(uRI).method(string, bodyPublisher);
    }

    @b
    public static WebRequest getCurrent() {
        return (WebRequest)h.get();
    }

    @b
    public void makeCurrent() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "makeCurrent()", 325).log();
        }
        h.set(this);
        i = this;
    }

    @b
    public static void clearCurrent() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "clearCurrent()", 338).log();
        }
        h.remove();
    }

    @b
    public WebResponse send() throws IOException, InterruptedException {
        Object object;
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "send()", 352).log();
        }
        HttpClient httpClient = this.getClient();
        Object object2 = this.e;
        if (object2 instanceof f) {
            object = (f)object2;
            object.extendRequest(this);
        }
        if (WebRequest.g.level >= 9) {
            ((LevelAwareLogBuilder)g.lvlBuild(9, "send()", 361).add("client.connectTimeout()", httpClient.connectTimeout())).log();
        }
        if (WebRequest.g.level >= 9) {
            ((LevelAwareLogBuilder)g.lvlBuild(9, "send()", 362).add("client.followRedirects()", (Object)httpClient.followRedirects())).log();
        }
        object = this.q.build();
        if (this.m == null) {
            object2 = httpClient.send((HttpRequest)object, HttpResponse.BodyHandlers.ofString());
        } else {
            new File(Misc.getBestParentPath((String)this.m)).mkdirs();
            object2 = httpClient.send((HttpRequest)object, HttpResponse.BodyHandlers.ofFile(Path.of(this.m, new String[0]), StandardOpenOption.WRITE, StandardOpenOption.CREATE));
        }
        if (WebRequest.g.level >= 9) {
            ((LevelAwareLogBuilder)g.lvlBuild(9, "send()", 373).add("response", object2)).log();
        }
        if (WebRequest.g.level >= 10) {
            ((LevelAwareLogBuilder)g.lvlBuild(10, "send()", 374).add("response.body()", object2.body())).log();
        }
        return new WebResponse((HttpResponse)object2);
    }

    @b
    public HttpClient getClient() {
        a a2 = new a();
        HttpClient httpClient = (HttpClient)k.get(a2);
        if (httpClient == null) {
            HttpClient.Builder builder = this.a(a2);
            httpClient = builder.build();
            k.put(a2, httpClient);
            if (WebRequest.g.level >= 10) {
                ((LevelAwareLogBuilder)g.lvlBuild(10, "getClient()", 395).add("client", (Object)httpClient)).log();
            }
        }
        return httpClient;
    }

    public HttpClient.Builder newClientBuilder() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "newClientBuilder()", 412).log();
        }
        return this.a(new a());
    }

    @b
    public WebRequest setClient(HttpClient httpClient) {
        k.put(new a(), httpClient);
        return this;
    }

    private HttpClient.Builder a(a a2) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "getClientBuilder(ClientMapKey)", 431).addDetail("clientMapKey", (Object)a2)).log();
        }
        HttpClient.Builder builder = HttpClient.newBuilder();
        builder.sslContext(TrustAllManager.a(a2.c)).version(this.b).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(this.s).proxy(a2.d);
        Object object = a2.a;
        if (object instanceof de.qfs.apps.qftest.webapi.a) {
            de.qfs.apps.qftest.webapi.a a3 = (de.qfs.apps.qftest.webapi.a)object;
            a3.extendClient(builder);
        }
        if (a2.e) {
            builder.cookieHandler(this.c());
        }
        if (a2.b != null) {
            a2.b.extendClient(builder);
        }
        return builder;
    }

    @b
    public String getEffectiveProxy() {
        block5: {
            if (!Misc.emptyOrNull((String)this.getProxyHost())) {
                return this.getProxyHost() + ":" + this.getProxyPort();
            }
            String string = Options.cached_OPT_WEBREQUEST_PROXY;
            if (!Misc.emptyOrNull((String)string)) {
                return string;
            }
            String string2 = System.getProperty("http.proxyHost");
            if (!Misc.emptyOrNull((String)string2)) {
                try {
                    String string3 = System.getProperty("http.proxyPort");
                    return string2 + ":" + string3;
                }
                catch (NumberFormatException numberFormatException) {
                    if (WebRequest.g.level < 1) break block5;
                    ((LevelAwareLogBuilder)g.lvlBuild(1, "getEffectiveProxy()", 477).add("ex", (Object)numberFormatException)).log();
                }
            }
        }
        return null;
    }

    private ProxySelector a() {
        ProxySelector proxySelector;
        block4: {
            String[] stringArray;
            if (WebRequest.g.level >= 7) {
                g.lvlBuild(7, "applyProxySelector()", 486).log();
            }
            proxySelector = HttpClient.Builder.NO_PROXY;
            String string = this.getEffectiveProxy();
            if (!Misc.emptyOrNull((String)string) && (stringArray = string.split(":")).length > 1) {
                try {
                    proxySelector = ProxySelector.of(new InetSocketAddress(stringArray[0], Integer.parseInt(stringArray[1])));
                }
                catch (NumberFormatException numberFormatException) {
                    if (WebRequest.g.level < 1) break block4;
                    ((LevelAwareLogBuilder)g.lvlBuild(1, "applyProxySelector()", 496).add("ex", (Object)numberFormatException)).log();
                }
            }
        }
        return proxySelector;
    }

    @b
    public Object resolveSettings() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "resolveSettings()", 507).log();
        }
        if (WebRequest.g.level >= 9) {
            ((LevelAwareLogBuilder)g.lvlBuild(9, "resolveSettings()", 509).add("settings", (Object)this.f)).log();
        }
        return this.f;
    }

    private X509TrustManager b() {
        if (a != null) {
            return a;
        }
        if (Options.cached_OPT_WEBREQUEST_TRUST_ALL_SSL) {
            a = new TrustAllManager();
            return a;
        }
        return null;
    }

    @b
    public void setTrustManager(X509TrustManager x509TrustManager) {
        a = x509TrustManager;
    }

    private CookieManager c() {
        if (j == null) {
            j = new CookieManager();
        }
        return j;
    }

    @b
    public List getCookies() {
        if (j != null) {
            String string = this.getUri().getHost();
            return j.getCookieStore().getCookies().stream().filter(httpCookie -> HttpCookie.domainMatches(httpCookie.getDomain(), string)).toList();
        }
        return new ArrayList();
    }

    @b
    public List getAllCookies() {
        if (j != null) {
            return j.getCookieStore().getCookies();
        }
        return new ArrayList();
    }

    @b
    public void deleteCookies() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "deleteCookies()", 591).log();
        }
        if (j != null) {
            URI uRI = this.getUri();
            for (HttpCookie httpCookie : this.getCookies()) {
                j.getCookieStore().remove(uRI, httpCookie);
            }
        }
    }

    @b
    public void deleteAllCookies() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "deleteAllCookies()", 607).log();
        }
        if (j != null) {
            j.getCookieStore().removeAll();
        }
    }

    @b
    @Deprecated
    public void setUserName(String string) {
        e e2;
        if (this.e == null) {
            this.e = new BasicAuth();
        }
        if (!((e2 = this.e) instanceof BasicAuth)) {
            throw new IllegalStateException("Can only set username on BasicAuth Object");
        }
        BasicAuth basicAuth = (BasicAuth)e2;
        basicAuth.setUserName(string);
    }

    @b
    @Deprecated
    public void setPassword(String string) {
        e e2;
        if (this.e == null) {
            this.e = new BasicAuth();
        }
        if (!((e2 = this.e) instanceof BasicAuth)) {
            throw new IllegalStateException("Can only set password on BasicAuth Object");
        }
        BasicAuth basicAuth = (BasicAuth)e2;
        basicAuth.setPassword(string);
    }

    @b
    @Deprecated
    public Object getAuthenticator() {
        if (this.e == null) {
            this.e = new BasicAuth();
        }
        return this.e;
    }

    @b
    public Optional bodyPublisher() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "bodyPublisher()", 678).log();
        }
        return this.q.build().bodyPublisher();
    }

    public HttpRequest.BodyPublisher getBodyPublisher() {
        return this.bodyPublisher().orElse(HttpRequest.BodyPublishers.noBody());
    }

    @Override
    @b
    public String method() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "method()", 710).log();
        }
        return this.q.build().method();
    }

    public String getMethod() {
        return this.method();
    }

    @b
    public Optional timeout() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "timeout()", 742).log();
        }
        return this.q.build().timeout();
    }

    public Duration getTimeout() {
        return this.timeout().orElse(null);
    }

    @Override
    @b
    public boolean expectContinue() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "expectContinue()", 773).log();
        }
        return this.q.build().expectContinue();
    }

    public boolean getExpectContinue() {
        return this.expectContinue();
    }

    @Override
    @b
    public URI uri() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "uri()", 803).log();
        }
        return this.q.build().uri();
    }

    public URI getUri() {
        return this.uri();
    }

    @b
    public Optional version() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "version()", 837).log();
        }
        return this.q.build().version();
    }

    public HttpClient.Version getVersion() {
        return this.version().orElse(null);
    }

    @Override
    @b
    public HttpHeaders headers() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "headers()", 872).log();
        }
        return this.q.build().headers();
    }

    public Map getHeaders() {
        return this.r;
    }

    public String header(String string) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "header(String)", 908).addDetail("name", string)).log();
        }
        return (String)this.r.get(string);
    }

    public String getHeader(String string) {
        return this.header(string);
    }

    public List headers(String string) {
        List<String> list;
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "headers(String)", 938).addDetail("name", string)).log();
        }
        if ((list = this.headers().map().get(string)) == null) {
            list = new LinkedList<String>();
        }
        return list;
    }

    public List getHeaders(String string) {
        return this.headers(string);
    }

    @b
    public String body() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "body()", 972).log();
        }
        return this.n;
    }

    public String getBody() {
        return this.body();
    }

    @b
    public String payload() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "payload()", 1000).log();
        }
        if (this.p == null) {
            return this.n;
        }
        try {
            return StreamInput.loadText((Reader)new FileReader(new File(this.p), Misc.UTF8_CHARSET));
        }
        catch (IOException iOException) {
            if (WebRequest.g.level >= 3) {
                ((LevelAwareLogBuilder)g.lvlBuild(3, "payload()", 1008).add("ex", (Object)iOException)).log();
            }
            return null;
        }
    }

    public String getPayload() {
        return this.payload();
    }

    @b
    public Object json() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "json()", 1045).log();
        }
        return JsonMapper.map((JsonValue)Json.parse((String)this.n));
    }

    public Object getJson() {
        return this.json();
    }

    public void addHeader(String string, String string2) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)g.lvlBuild(7, "addHeader(String,String)", 1083).addDetail("name", string)).addDetail("value", string2)).log();
        }
        this.r.put(string, string2);
        this.q.header(string, string2);
    }

    @b
    public WebRequest method(String string) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "method(String)", 1093).addDetail("method", string)).log();
        }
        this.q.method(string, this.getBodyPublisher());
        return this;
    }

    public void setMethod(String string) {
        this.method(string);
    }

    @b
    public WebRequest body(String string) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "body(String)", 1119).addDetail("body", string)).log();
        }
        this.n = string;
        this.q.method(this.method(), HttpRequest.BodyPublishers.ofString(string));
        return this;
    }

    public void setBody(String string) {
        this.body(string);
    }

    @b
    public WebRequest payload(String string) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "payload(String)", 1151).addDetail("body", string)).log();
        }
        this.body(string);
        return this;
    }

    public void setPayload(String string) {
        this.body(string);
    }

    @b
    public WebRequest payloadFile(String string) throws FileNotFoundException {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "payloadFile(String)", 1181).addDetail("path", string)).log();
        }
        this.p = this.p;
        this.n = null;
        this.q.method(this.method(), HttpRequest.BodyPublishers.ofFile(Path.of(string, new String[0])));
        return this;
    }

    public void setPayloadFile(String string) throws FileNotFoundException {
        this.payloadFile(string);
    }

    @Override
    @b
    public WebRequest uri(URI uRI) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "uri(URI)", 1220).addDetail("uri", (Object)uRI)).log();
        }
        this.q.uri(uRI);
        return this;
    }

    public WebRequest setUri(URI uRI) {
        return this.uri(uRI);
    }

    @Override
    public WebRequest expectContinue(boolean bl2) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "expectContinue(boolean)", 1258).addDetail("enable", bl2)).log();
        }
        this.q.expectContinue(bl2);
        return this;
    }

    @Override
    public WebRequest version(HttpClient.Version version) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "version(Version)", 1280).addDetail("version", (Object)version)).log();
        }
        this.q.version(version);
        return this;
    }

    @Override
    public WebRequest header(String string, String string2) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)g.lvlBuild(7, "header(String,String)", 1309).addDetail("name", string)).addDetail("value", string2)).log();
        }
        this.addHeader(string, string2);
        return this;
    }

    @Override
    public WebRequest headers(String ... stringArray) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "headers(String[])", 1335).addDetail("headers", (Object)stringArray)).log();
        }
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            this.addHeader(stringArray[i2], stringArray[i2 + 1]);
        }
        return this;
    }

    @Override
    public WebRequest setHeader(String string, String string2) {
        this.r.put(string, string2);
        this.q.setHeader(string, string2);
        return this;
    }

    @Override
    public WebRequest timeout(Duration duration) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "timeout(Duration)", 1386).addDetail("duration", (Object)duration)).log();
        }
        this.q.timeout(duration);
        return this;
    }

    @Override
    public WebRequest GET() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "GET()", 1402).log();
        }
        this.q.GET();
        return this;
    }

    @Override
    public WebRequest POST(HttpRequest.BodyPublisher bodyPublisher) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "POST(BodyPublisher)", 1419).addDetail("bodyPublisher", (Object)bodyPublisher)).log();
        }
        if (bodyPublisher != this.getBodyPublisher()) {
            if (WebRequest.g.level >= 5) {
                ((LevelAwareLogBuilder)g.lvlBuild(5, "POST(BodyPublisher)", 1422).add("New BodyPublisher, dropping payload")).log();
            }
            this.n = null;
            this.p = null;
        }
        this.q.POST(bodyPublisher);
        return this;
    }

    @Override
    public WebRequest PUT(HttpRequest.BodyPublisher bodyPublisher) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)g.lvlBuild(7, "PUT(BodyPublisher)", 1441).addDetail("bodyPublisher", (Object)bodyPublisher)).log();
        }
        if (bodyPublisher != this.getBodyPublisher()) {
            if (WebRequest.g.level >= 5) {
                ((LevelAwareLogBuilder)g.lvlBuild(5, "PUT(BodyPublisher)", 1444).add("New BodyPublisher, dropping payload")).log();
            }
            this.n = null;
            this.p = null;
        }
        this.q.PUT(bodyPublisher);
        return this;
    }

    @Override
    public WebRequest DELETE() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "DELETE()", 1461).log();
        }
        this.q.DELETE();
        return this;
    }

    @Override
    public WebRequest method(String string, HttpRequest.BodyPublisher bodyPublisher) {
        if (WebRequest.g.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)g.lvlBuild(7, "method(String,BodyPublisher)", 1488).addDetail("method", string)).addDetail("bodyPublisher", (Object)bodyPublisher)).log();
        }
        if (bodyPublisher != this.getBodyPublisher()) {
            if (WebRequest.g.level >= 5) {
                ((LevelAwareLogBuilder)g.lvlBuild(5, "method(String,BodyPublisher)", 1491).add("New BodyPublisher, dropping payload")).log();
            }
            this.n = null;
            this.p = null;
        }
        this.q.method(string, bodyPublisher);
        return this;
    }

    @Override
    public HttpRequest build() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "build()", 1509).log();
        }
        return this;
    }

    @Override
    public WebRequest copy() {
        if (WebRequest.g.level >= 7) {
            g.lvlBuild(7, "copy()", 1527).log();
        }
        return new WebRequest(this);
    }

    @b
    public String toString() {
        return "WebRequest[" + this.q.build().toString() + "]";
    }

    @b
    public String toLogString() {
        HttpRequest httpRequest = this.q.build();
        return httpRequest.method() + " " + String.valueOf(httpRequest.uri());
    }

    public static WebRequest getLatest() {
        return i;
    }

    public static X509TrustManager getTrustManager() {
        return a;
    }

    public String getName() {
        return this.l;
    }

    public WebRequest setName(String string) {
        this.l = string;
        return this;
    }

    public String getResponseFile() {
        return this.m;
    }

    public WebRequest setResponseFile(String string) {
        this.m = string;
        return this;
    }

    public byte[] getRawPayload() {
        return this.o;
    }

    public String getPayloadFile() {
        return this.p;
    }

    public String getProxyHost() {
        return this.c;
    }

    public WebRequest setProxyHost(String string) {
        this.c = string;
        return this;
    }

    public int getProxyPort() {
        return this.d;
    }

    public WebRequest setProxyPort(int n2) {
        this.d = n2;
        return this;
    }

    public e getAuthData() {
        return this.e;
    }

    public WebRequest setAuthData(e e2) {
        this.e = e2;
        return this;
    }

    public WebRequestSettings getSettings() {
        return this.f;
    }

    public WebRequest setSettings(WebRequestSettings webRequestSettings) {
        this.f = webRequestSettings;
        return this;
    }

    static {
        k = new HashMap();
        if (Globals.getGlobalBoolean((String)"interactive", (boolean)true)) {
            AbstractRunContext.addResetListener(new ResetListener(){

                @Override
                public Set beforeReset() {
                    if (WebRequest.g.level >= 7) {
                        g.lvlBuild(7, "ResetListener.beforeReset()", 147).log();
                    }
                    return null;
                }

                @Override
                public void afterReset() {
                    if (WebRequest.g.level >= 7) {
                        g.lvlBuild(7, "ResetListener.afterReset()", 153).log();
                    }
                    WebRequest.clearCurrent();
                    i = null;
                    a = null;
                    j = null;
                    k.clear();
                }
            });
        }
    }

    private class a {
        final Object a;
        final de.qfs.apps.qftest.webapi.a b;
        final X509TrustManager c;
        ProxySelector d;
        final boolean e;
        private HashMap g;
        private String h;
        private static final String i = "host";
        private static final String j = "cookieHandler";
        private static final String k = "authProvider";
        private static final String l = "proxy";
        private static final String m = "settings";

        protected a() {
            de.qfs.apps.qftest.webapi.a a2;
            if (WebRequest.g.level >= 7) {
                g.lvlBuild(7, "ClientMapKey.ClientMapKey()", 1579).log();
            }
            this.a = WebRequest.this.resolveSettings();
            e e2 = WebRequest.this.e;
            this.b = e2 instanceof de.qfs.apps.qftest.webapi.a ? (a2 = (de.qfs.apps.qftest.webapi.a)((Object)e2)) : null;
            this.d = WebRequest.this.a();
            this.c = WebRequest.this.b();
            this.g = new HashMap();
            this.e = Options.cached_OPT_WEBREQUEST_COOKIES;
            this.h = WebRequest.this.getUri().getHost();
            if (!Misc.isTrimmedEmptyOrNull((String)this.h)) {
                this.g.put(i, this.h);
            }
            if (this.a != null) {
                this.g.put(m, this.a.toString());
            }
            if (this.e) {
                this.g.put(j, String.valueOf(WebRequest.this.c()));
            }
            if (this.b != null) {
                this.g.put(k, ":" + Objects.hashCode(this.b));
            }
            if (this.d != HttpClient.Builder.NO_PROXY) {
                this.g.put(l, WebRequest.this.getEffectiveProxy());
            }
            if (WebRequest.g.level >= 10) {
                ((LevelAwareLogBuilder)g.lvlBuild(10, "ClientMapKey.ClientMapKey()", 1606).add("identity", (Object)this.g)).log();
            }
        }

        public String toString() {
            if (WebRequest.g.level >= 7) {
                g.lvlBuild(7, "ClientMapKey.toString()", 1613).log();
            }
            return this.g.toString();
        }

        public boolean equals(Object object) {
            if (WebRequest.g.level >= 7) {
                ((LevelAwareLogBuilder)g.lvlBuild(7, "ClientMapKey.equals(Object)", 1626).addDetail("o", object)).log();
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            a a2 = (a)object;
            if (!((String)a2.g.get(i)).equals(this.h)) {
                return false;
            }
            return Objects.equals(this.g, a2.g);
        }

        public int hashCode() {
            if (WebRequest.g.level >= 7) {
                g.lvlBuild(7, "ClientMapKey.hashCode()", 1642).log();
            }
            return Objects.hashCode(this.g);
        }
    }
}

