/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.python.core.Py;
import org.python.core.PyIntern;
import org.python.core.PyJavaPackage;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTuple;

public class JavaImportHelper {
    private static final String DOT = ".";

    protected static boolean tryAddPackage(String packageName, PyObject fromlist) {
        boolean packageAdded = false;
        if (packageName != null) {
            List<String> stringFromlist = JavaImportHelper.getFromListAsStrings(fromlist);
            for (String fromName : stringFromlist) {
                if (!JavaImportHelper.isJavaClass(packageName, fromName)) continue;
                packageAdded = JavaImportHelper.addPackage(packageName, packageAdded);
            }
            int dotPos = packageName.lastIndexOf(DOT);
            if (dotPos > 0) {
                String lastDottedName = packageName.substring(dotPos + 1);
                String packageCand = packageName.substring(0, dotPos);
                if (JavaImportHelper.isJavaClass(packageCand, lastDottedName)) {
                    packageAdded = JavaImportHelper.addPackage(packageCand, packageAdded);
                }
            }
            if (!packageAdded) {
                Map<String, String> packages = JavaImportHelper.buildLoadedPackages();
                String parentPackageName = packageName;
                if (JavaImportHelper.isLoadedPackage(packageName, packages)) {
                    packageAdded = JavaImportHelper.addPackage(packageName, packageAdded);
                }
                dotPos = 0;
                do {
                    if ((dotPos = parentPackageName.lastIndexOf(DOT)) <= 0 || !JavaImportHelper.isLoadedPackage(parentPackageName = parentPackageName.substring(0, dotPos), packages)) continue;
                    packageAdded = JavaImportHelper.addPackage(parentPackageName, packageAdded);
                } while (dotPos > 0);
                for (String fromName : stringFromlist) {
                    String fromPackageName = packageName + DOT + fromName;
                    if (!JavaImportHelper.isLoadedPackage(fromPackageName, packages)) continue;
                    packageAdded = JavaImportHelper.addPackage(fromPackageName, packageAdded);
                }
            }
        }
        return packageAdded;
    }

    protected static boolean isLoadedPackage(String packageName) {
        return JavaImportHelper.isLoadedPackage(packageName, JavaImportHelper.buildLoadedPackages());
    }

    private static final List<String> getFromListAsStrings(PyObject fromlist) {
        ArrayList<String> stringFromlist = new ArrayList<String>();
        if (fromlist != null && fromlist != Py.EmptyTuple && fromlist instanceof PyTuple) {
            for (Object obj : (PyTuple)fromlist) {
                String fromName;
                if (obj instanceof PyString) {
                    obj = ((PyString)obj).getString();
                }
                if (!(obj instanceof String) || "*".equals(fromName = (String)obj)) continue;
                stringFromlist.add(fromName);
            }
        }
        return stringFromlist;
    }

    private static boolean isLoadedPackage(String javaPackageName, Map<String, String> packages) {
        boolean isLoaded = false;
        if (javaPackageName != null) {
            isLoaded = packages.containsKey(javaPackageName);
        }
        return isLoaded;
    }

    private static Map<String, String> buildLoadedPackages() {
        TreeMap<String, String> packageMap = new TreeMap<String, String>();
        Package[] packages = Package.getPackages();
        for (int i = 0; i < packages.length; ++i) {
            String packageName = packages[i].getName();
            packageMap.put(packageName, "");
            int dotPos = 0;
            do {
                if ((dotPos = packageName.lastIndexOf(DOT)) <= 0) continue;
                packageName = packageName.substring(0, dotPos);
                packageMap.put(packageName, "");
            } while (dotPos > 0);
        }
        return packageMap;
    }

    private static boolean isJavaClass(String packageName, String className) {
        return className != null && className.length() > 0 && Py.findClass(packageName + DOT + className) != null;
    }

    private static boolean addPackage(String packageName, boolean packageAdded) {
        PyObject modules = Py.getSystemState().modules;
        String internedPackageName = PyIntern.intern(packageName);
        PyObject module = modules.__finditem__(internedPackageName);
        if (module == null || module == Py.None) {
            int dotPos = 0;
            do {
                PyJavaPackage p = PySystemState.add_package(packageName);
                if (dotPos == 0) {
                    modules.__setitem__(internedPackageName, (PyObject)p);
                } else {
                    module = modules.__finditem__(internedPackageName);
                    if (module == null || module == Py.None) {
                        modules.__setitem__(internedPackageName, (PyObject)p);
                    }
                }
                dotPos = packageName.lastIndexOf(DOT);
                if (dotPos <= 0) continue;
                packageName = packageName.substring(0, dotPos);
                internedPackageName = PyIntern.intern(packageName);
            } while (dotPos > 0);
            packageAdded = true;
        }
        return packageAdded;
    }
}

