/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.AbstractDict;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyIntern;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.codecs;
import org.python.core.stringlib.FloatFormatter;
import org.python.core.stringlib.IntegerFormatter;
import org.python.core.stringlib.InternalFormat;
import org.python.core.stringlib.TextFormatter;

final class StringFormatter {
    int index = 0;
    String format;
    StringBuilder buffer;
    int argIndex;
    PyObject args;
    boolean needUnicode;

    final char pop() {
        try {
            return this.format.charAt(this.index++);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw Py.ValueError("incomplete format");
        }
    }

    final char peek() {
        return this.format.charAt(this.index);
    }

    final void push() {
        --this.index;
    }

    public StringFormatter(String format) {
        this(format, false);
    }

    public StringFormatter(String format, boolean unicodeCoercion) {
        this.format = format;
        this.needUnicode = unicodeCoercion;
        this.buffer = new StringBuilder(format.length() + 100);
    }

    PyObject getarg() {
        PyObject ret = null;
        switch (this.argIndex) {
            case -3: {
                return this.args;
            }
            case -2: {
                break;
            }
            case -1: {
                this.argIndex = -2;
                return this.args;
            }
            default: {
                ret = this.args.__finditem__(this.argIndex++);
            }
        }
        if (ret == null) {
            throw Py.TypeError("not enough arguments for format string");
        }
        return ret;
    }

    int getNumber() {
        char c = this.pop();
        if (c == '*') {
            PyObject o = this.getarg();
            if (o instanceof PyInteger) {
                return ((PyInteger)o).getValue();
            }
            throw Py.TypeError("* wants int");
        }
        if (Character.isDigit(c)) {
            int numStart = this.index - 1;
            while (Character.isDigit(c = this.pop())) {
            }
            --this.index;
            Integer i = Integer.valueOf(this.format.substring(numStart, this.index));
            return i;
        }
        --this.index;
        return 0;
    }

    private PyObject asNumber(PyObject arg) {
        if (arg instanceof PyInteger || arg instanceof PyLong) {
            return arg;
        }
        if (arg.getClass() == PyFloat.class) {
            return arg.__int__();
        }
        try {
            return arg.__getattr__("__int__").__call__();
        }
        catch (PyException pyException) {
            try {
                return arg.__getattr__("__long__").__call__();
            }
            catch (PyException e) {
                return arg;
            }
        }
    }

    private PyObject asFloat(PyObject arg) {
        if (arg instanceof PyFloat) {
            return arg;
        }
        if (arg.getClass() == PyFloat.class) {
            return arg.__float__();
        }
        try {
            return arg.__getattr__("__float__").__call__();
        }
        catch (PyException e) {
            return arg;
        }
    }

    private PyString asText(PyObject arg) {
        if (arg instanceof PyUnicode) {
            this.needUnicode = true;
            return (PyUnicode)arg;
        }
        if (this.needUnicode) {
            return arg.__unicode__();
        }
        if (arg instanceof PyString) {
            return (PyString)arg;
        }
        PyString s = arg.__str__();
        if (s instanceof PyUnicode) {
            this.needUnicode = true;
        }
        return s;
    }

    public PyString format(PyObject args) {
        PyObject dict = null;
        this.args = args;
        if (args instanceof PyTuple) {
            this.argIndex = 0;
        } else {
            this.argIndex = -1;
            if (args instanceof AbstractDict || !(args instanceof PySequence) && args.object___findattr__(PyIntern.intern("__getitem__")) != null) {
                dict = args;
                this.argIndex = -3;
            }
        }
        while (this.index < this.format.length()) {
            InternalFormat.Formatter f;
            char c = this.pop();
            if (c != '%') {
                this.buffer.append(c);
                continue;
            }
            boolean altFlag = false;
            char sign = '\uffff';
            char fill = ' ';
            char align = '>';
            int width = -1;
            int precision = -1;
            c = this.pop();
            if (c == '(') {
                if (dict == null) {
                    throw Py.TypeError("format requires a mapping");
                }
                int parens = 1;
                int keyStart = this.index;
                while (parens > 0) {
                    c = this.pop();
                    if (c == ')') {
                        --parens;
                        continue;
                    }
                    if (c != '(') continue;
                    ++parens;
                }
                String tmp = this.format.substring(keyStart, this.index - 1);
                this.args = dict.__getitem__(this.needUnicode ? new PyUnicode(tmp) : new PyString(tmp));
            } else {
                this.push();
            }
            block18: while (true) {
                c = this.pop();
                switch (c) {
                    case '-': {
                        align = '<';
                        continue block18;
                    }
                    case '+': {
                        sign = '+';
                        continue block18;
                    }
                    case ' ': {
                        if (InternalFormat.Spec.specified(sign)) continue block18;
                        sign = ' ';
                        continue block18;
                    }
                    case '#': {
                        altFlag = true;
                        continue block18;
                    }
                    case '0': {
                        fill = '0';
                        continue block18;
                    }
                }
                break;
            }
            this.push();
            width = this.getNumber();
            if (width < 0) {
                width = -width;
                align = '<';
            }
            if ((c = this.pop()) == '.') {
                precision = this.getNumber();
                if (precision < -1) {
                    precision = 0;
                }
                c = this.pop();
            }
            if (c == 'h' || c == 'l' || c == 'L') {
                c = this.pop();
            }
            switch (c) {
                case '%': 
                case 'c': 
                case 'r': 
                case 's': {
                    fill = ' ';
                    break;
                }
                default: {
                    if (fill == '0' && align == '>') {
                        align = '=';
                        break;
                    }
                    fill = ' ';
                }
            }
            InternalFormat.Spec spec = new InternalFormat.Spec(fill, align, sign, altFlag, width, false, precision, c);
            switch (spec.type) {
                case 'r': 
                case 's': {
                    PyObject arg = this.getarg();
                    PyString argAsString = this.asText(spec.type == 's' ? arg : arg.__repr__());
                    TextFormatter ft = new TextFormatter(this.buffer, spec);
                    f = ft;
                    ft.setBytes(!this.needUnicode);
                    ft.format(argAsString.getString());
                    break;
                }
                case 'X': 
                case 'c': 
                case 'd': 
                case 'i': 
                case 'o': 
                case 'u': 
                case 'x': {
                    IntegerFormatter.Traditional fi = new IntegerFormatter.Traditional(this.buffer, spec);
                    f = fi;
                    fi.setBytes(!this.needUnicode);
                    PyObject arg = this.getarg();
                    if (arg instanceof PyString && spec.type == 'c') {
                        if (arg.__len__() != 1) {
                            throw Py.TypeError("%c requires int or char");
                        }
                        if (!this.needUnicode && arg instanceof PyUnicode) {
                            this.needUnicode = true;
                            fi.setBytes(false);
                        }
                        fi.format(((PyString)arg).getString().codePointAt(0));
                        break;
                    }
                    PyObject argAsNumber = this.asNumber(arg);
                    if (argAsNumber instanceof PyInteger) {
                        fi.format(((PyInteger)argAsNumber).getValue());
                        break;
                    }
                    if (argAsNumber instanceof PyLong) {
                        fi.format(((PyLong)argAsNumber).getValue());
                        break;
                    }
                    throw Py.TypeError("%" + spec.type + " format: a number is required, not " + arg.getType().fastGetName());
                }
                case 'E': 
                case 'F': 
                case 'G': 
                case 'e': 
                case 'f': 
                case 'g': {
                    FloatFormatter ff = new FloatFormatter(this.buffer, spec);
                    f = ff;
                    ff.setBytes(!this.needUnicode);
                    PyObject arg = this.getarg();
                    PyObject argAsFloat = this.asFloat(arg);
                    if (argAsFloat instanceof PyFloat) {
                        ff.format(((PyFloat)argAsFloat).getValue());
                        break;
                    }
                    throw Py.TypeError("float argument required, not " + arg.getType().fastGetName());
                }
                case '%': {
                    IntegerFormatter.Traditional fi = new IntegerFormatter.Traditional(this.buffer, spec);
                    f = fi;
                    fi.setBytes(!this.needUnicode);
                    fi.format(37);
                    break;
                }
                default: {
                    throw Py.ValueError("unsupported format character '" + codecs.encode(Py.newUnicode(spec.type), null, "replace") + "' (0x" + Integer.toHexString(spec.type) + ") at index " + (this.index - 1));
                }
            }
            f.pad();
        }
        if (this.argIndex == -1 || this.argIndex >= 0 && args.__finditem__(this.argIndex) != null) {
            throw Py.TypeError("not all arguments converted during string formatting");
        }
        return this.needUnicode ? new PyUnicode(this.buffer) : new PyString(this.buffer);
    }
}

