/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import org.python.core.BaseSet;
import org.python.core.BufferProtocol;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyBytecode;
import org.python.core.PyComplex;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyFrozenSet;
import org.python.core.PyInteger;
import org.python.core.PyIntern;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySet;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.modules.PyIOFile;
import org.python.modules.PyIOFileFactory;

public class _marshal
implements ClassDictInit {
    private static final char TYPE_NULL = '0';
    private static final char TYPE_NONE = 'N';
    private static final char TYPE_FALSE = 'F';
    private static final char TYPE_TRUE = 'T';
    private static final char TYPE_STOPITER = 'S';
    private static final char TYPE_ELLIPSIS = '.';
    private static final char TYPE_INT = 'i';
    private static final char TYPE_INT64 = 'I';
    private static final char TYPE_FLOAT = 'f';
    private static final char TYPE_BINARY_FLOAT = 'g';
    private static final char TYPE_COMPLEX = 'x';
    private static final char TYPE_BINARY_COMPLEX = 'y';
    private static final char TYPE_LONG = 'l';
    private static final char TYPE_STRING = 's';
    private static final char TYPE_INTERNED = 't';
    private static final char TYPE_STRINGREF = 'R';
    private static final char TYPE_TUPLE = '(';
    private static final char TYPE_LIST = '[';
    private static final char TYPE_DICT = '{';
    private static final char TYPE_CODE = 'c';
    private static final char TYPE_UNICODE = 'u';
    private static final char TYPE_SET = '<';
    private static final char TYPE_FROZENSET = '>';
    private static final int MAX_MARSHAL_STACK_DEPTH = 2000;
    private static final int CURRENT_VERSION = 2;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__name__", (PyObject)Py.newString("_marshal"));
    }

    public static class Unmarshaller
    extends PyObject
    implements Traverseproc {
        private final PyIOFile file;
        private final PyList strings = new PyList();
        private final int version;
        int depth = 0;
        private boolean debug = false;

        public Unmarshaller(PyObject file) {
            this(file, 2);
        }

        public Unmarshaller(PyObject file, int version2) {
            this.file = PyIOFileFactory.createIOFile(file);
            this.version = version2;
        }

        public void _debug() {
            this.debug = true;
        }

        public PyObject load() {
            try {
                PyObject obj = this.read_object(0);
                if (obj == null) {
                    throw Py.TypeError("NULL object in marshal data");
                }
                return obj;
            }
            catch (StringIndexOutOfBoundsException e) {
                throw Py.EOFError("EOF read where object expected");
            }
        }

        private int read_byte() {
            char b = this.file.read(1).charAt(0);
            if (this.debug) {
                System.err.print("[" + b + "]");
            }
            return b;
        }

        private String read_string(int n) {
            return this.file.read(n);
        }

        private int read_short() {
            int x = this.read_byte();
            return x |= this.read_byte() << 8;
        }

        private int read_int() {
            int x = this.read_byte();
            x |= this.read_byte() << 8;
            x |= this.read_byte() << 16;
            return x |= this.read_byte() << 24;
        }

        private long read_long64() {
            long lo4 = this.read_int();
            long hi4 = this.read_int();
            long x = hi4 << 32 | lo4 & 0xFFFFFFFFL;
            return x;
        }

        private BigInteger read_long() {
            BigInteger result2 = BigInteger.ZERO;
            boolean negative = false;
            int digit = 0;
            int size = this.read_int();
            if (size == 0) {
                return result2;
            }
            if (size < 0) {
                negative = true;
                size = -size;
            }
            for (int i = 0; i < size; ++i) {
                digit = this.read_short();
                if (digit < 0) {
                    throw Unmarshaller.badMarshalData("digit out of range in long");
                }
                result2 = result2.or(BigInteger.valueOf(digit).shiftLeft(i * 15));
            }
            if (digit == 0) {
                throw Unmarshaller.badMarshalData("unnormalized long data");
            }
            return negative ? result2.negate() : result2;
        }

        private double read_float() {
            int size = this.read_byte();
            return Py.newString(this.read_string(size)).atof();
        }

        private double read_binary_float() {
            return Double.longBitsToDouble(this.read_long64());
        }

        private PyObject read_object_notnull(int depth) {
            PyObject v = this.read_object(depth);
            if (v == null) {
                throw Unmarshaller.badMarshalData(null);
            }
            return v;
        }

        private String[] read_strings(int depth) {
            PyTuple t = (PyTuple)this.read_object_notnull(depth);
            String[] some_strings = new String[t.__len__()];
            int i = 0;
            for (PyObject item : t.asIterable()) {
                some_strings[i++] = PyIntern.intern(item.toString());
            }
            return some_strings;
        }

        private PyObject read_object(int depth) {
            if (depth >= 2000) {
                throw Py.ValueError("Maximum marshal stack depth");
            }
            int type = this.read_byte();
            switch (type) {
                case 48: {
                    return null;
                }
                case 78: {
                    return Py.None;
                }
                case 83: {
                    return Py.StopIteration;
                }
                case 46: {
                    return Py.Ellipsis;
                }
                case 70: {
                    return Py.False;
                }
                case 84: {
                    return Py.True;
                }
                case 105: {
                    return Py.newInteger(this.read_int());
                }
                case 73: {
                    return Py.newInteger(this.read_long64());
                }
                case 108: {
                    return Py.newLong(this.read_long());
                }
                case 102: {
                    return Py.newFloat(this.read_float());
                }
                case 103: {
                    return Py.newFloat(this.read_binary_float());
                }
                case 120: {
                    double real = this.read_float();
                    double imag = this.read_float();
                    return new PyComplex(real, imag);
                }
                case 121: {
                    double real = this.read_binary_float();
                    double imag = this.read_binary_float();
                    return new PyComplex(real, imag);
                }
                case 115: 
                case 116: {
                    int size = this.read_int();
                    String s = this.read_string(size);
                    if (type == 116) {
                        PyString pys = PyString.fromInterned(PyIntern.intern(s));
                        this.strings.append(pys);
                        return pys;
                    }
                    return Py.newString(s);
                }
                case 82: {
                    int i = this.read_int();
                    return this.strings.__getitem__(i);
                }
                case 117: {
                    int n = this.read_int();
                    PyString buffer = Py.newString(this.read_string(n));
                    return buffer.decode("utf-8");
                }
                case 40: {
                    int n = this.read_int();
                    if (n < 0) {
                        throw Unmarshaller.badMarshalData(null);
                    }
                    PyObject[] items = new PyObject[n];
                    for (int i = 0; i < n; ++i) {
                        items[i] = this.read_object_notnull(depth + 1);
                    }
                    return new PyTuple(items);
                }
                case 91: {
                    int n = this.read_int();
                    if (n < 0) {
                        throw Unmarshaller.badMarshalData(null);
                    }
                    PyObject[] items = new PyObject[n];
                    for (int i = 0; i < n; ++i) {
                        items[i] = this.read_object_notnull(depth + 1);
                    }
                    return new PyList(items);
                }
                case 123: {
                    PyObject key;
                    PyDictionary d = new PyDictionary();
                    while ((key = this.read_object(depth + 1)) != null) {
                        PyObject value = this.read_object(depth + 1);
                        if (value == null) continue;
                        d.__setitem__(key, value);
                    }
                    return d;
                }
                case 60: 
                case 62: {
                    int n = this.read_int();
                    PyObject[] items = new PyObject[n];
                    for (int i = 0; i < n; ++i) {
                        items[i] = this.read_object(depth + 1);
                    }
                    PyTuple v = new PyTuple(items);
                    if (type == 60) {
                        return new PySet(v);
                    }
                    return new PyFrozenSet(v);
                }
                case 99: {
                    int argcount = this.read_int();
                    int nlocals = this.read_int();
                    int stacksize = this.read_int();
                    int flags = this.read_int();
                    String code2 = this.read_object_notnull(depth + 1).toString();
                    PyObject[] consts2 = ((PyTuple)this.read_object_notnull(depth + 1)).getArray();
                    String[] names = this.read_strings(depth + 1);
                    String[] varnames = this.read_strings(depth + 1);
                    String[] freevars = this.read_strings(depth + 1);
                    String[] cellvars = this.read_strings(depth + 1);
                    String filename = this.read_object_notnull(depth + 1).toString();
                    String name = this.read_object_notnull(depth + 1).toString();
                    int firstlineno = this.read_int();
                    String lnotab = this.read_object_notnull(depth + 1).toString();
                    return new PyBytecode(argcount, nlocals, stacksize, flags, code2, consts2, names, varnames, filename, name, firstlineno, lnotab, cellvars, freevars);
                }
            }
            throw Unmarshaller.badMarshalData("unknown type code");
        }

        private static PyException badMarshalData(String reason) {
            StringBuilder msg = new StringBuilder(60).append("bad marshal data");
            if (reason != null) {
                msg.append(" (").append(reason).append(')');
            }
            return Py.ValueError(msg.toString());
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            int retVal;
            if (this.file instanceof Traverseproc && (retVal = ((Traverseproc)((Object)this.file)).traverse(visit, arg)) != 0) {
                return retVal;
            }
            return visit.visit(this.strings, arg);
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) {
            if (ob == null) {
                return false;
            }
            if (this.file != null && this.file instanceof Traverseproc && ((Traverseproc)((Object)this.file)).refersDirectlyTo(ob)) {
                return true;
            }
            return ob == this.strings;
        }
    }

    public static class Marshaller
    extends PyObject
    implements Traverseproc {
        private final PyIOFile file;
        private final int version;
        private boolean debug = false;

        public Marshaller(PyObject file) {
            this(file, 2);
        }

        public Marshaller(PyObject file, int version2) {
            this.file = PyIOFileFactory.createIOFile(file);
            this.version = version2;
        }

        public void _debug() {
            this.debug = true;
        }

        public void dump(PyObject obj) {
            this.write_object(obj, 0);
        }

        private void write_byte(char c) {
            if (this.debug) {
                System.err.print("[" + c + "]");
            }
            this.file.write(c);
        }

        private void write_string(String s) {
            this.file.write(s);
        }

        private void write_strings(String[] some_strings, int depth) {
            PyObject[] items = new PyObject[some_strings.length];
            for (int i = 0; i < some_strings.length; ++i) {
                items[i] = Py.newString(some_strings[i]);
            }
            this.write_object(new PyTuple(items), depth + 1);
        }

        private void write_short(short x) {
            this.write_byte((char)(x & 0xFF));
            this.write_byte((char)(x >> 8 & 0xFF));
        }

        private void write_int(int x) {
            this.write_byte((char)(x & 0xFF));
            this.write_byte((char)(x >> 8 & 0xFF));
            this.write_byte((char)(x >> 16 & 0xFF));
            this.write_byte((char)(x >> 24 & 0xFF));
        }

        private void write_long64(long x) {
            this.write_int((int)(x & 0xFFFFFFFFFFFFFFFFL));
            this.write_int((int)(x >> 32 & 0xFFFFFFFFFFFFFFFFL));
        }

        private void write_long(BigInteger x) {
            boolean negative;
            boolean bl = negative = x.signum() < 0;
            if (negative) {
                x = x.negate();
            }
            int num_digits = (x.bitLength() + 14) / 15;
            this.write_int(negative ? -num_digits : num_digits);
            BigInteger mask = BigInteger.valueOf(32767L);
            for (int i = 0; i < num_digits; ++i) {
                this.write_short(x.and(mask).shortValue());
                x = x.shiftRight(15);
            }
        }

        private void write_float(PyFloat f) {
            this.write_string(f.__repr__().toString());
        }

        private void write_binary_float(PyFloat f) {
            this.write_long64(Double.doubleToLongBits(f.getValue()));
        }

        private void write_object(PyObject v, int depth) {
            if (depth >= 2000) {
                throw Py.ValueError("Maximum marshal stack depth");
            }
            if (v == null) {
                this.write_byte('0');
            } else if (v == Py.None) {
                this.write_byte('N');
            } else if (v == Py.StopIteration) {
                this.write_byte('S');
            } else if (v == Py.Ellipsis) {
                this.write_byte('.');
            } else if (v == Py.False) {
                this.write_byte('F');
            } else if (v == Py.True) {
                this.write_byte('T');
            } else {
                PyType vt = v.getType();
                if (vt == PyInteger.TYPE) {
                    this.write_byte('i');
                    this.write_int(((PyInteger)v).asInt());
                } else if (vt == PyLong.TYPE) {
                    this.write_byte('l');
                    this.write_long(((PyLong)v).getValue());
                } else if (vt == PyFloat.TYPE) {
                    if (this.version == 2) {
                        this.write_byte('g');
                        this.write_binary_float((PyFloat)v);
                    } else {
                        this.write_byte('f');
                        this.write_float((PyFloat)v);
                    }
                } else if (vt == PyComplex.TYPE) {
                    PyComplex x = (PyComplex)v;
                    if (this.version == 2) {
                        this.write_byte('y');
                        this.write_binary_float(x.getReal());
                        this.write_binary_float(x.getImag());
                    } else {
                        this.write_byte('x');
                        this.write_float(x.getReal());
                        this.write_float(x.getImag());
                    }
                } else if (vt == PyUnicode.TYPE) {
                    this.write_byte('u');
                    String buffer = ((PyUnicode)v).encode("utf-8").toString();
                    this.write_int(buffer.length());
                    this.write_string(buffer);
                } else if (vt == PyString.TYPE) {
                    this.write_byte('s');
                    this.write_int(v.__len__());
                    this.write_string(v.toString());
                } else if (vt == PyTuple.TYPE) {
                    this.write_byte('(');
                    PyTuple t = (PyTuple)v;
                    int n = t.__len__();
                    this.write_int(n);
                    for (int i = 0; i < n; ++i) {
                        this.write_object(t.__getitem__(i), depth + 1);
                    }
                } else if (vt == PyList.TYPE) {
                    this.write_byte('[');
                    PyList list = (PyList)v;
                    int n = list.__len__();
                    this.write_int(n);
                    for (int i = 0; i < n; ++i) {
                        this.write_object(list.__getitem__(i), depth + 1);
                    }
                } else if (vt == PyDictionary.TYPE) {
                    this.write_byte('{');
                    PyDictionary dict = (PyDictionary)v;
                    for (PyObject item : dict.iteritems().asIterable()) {
                        PyTuple pair = (PyTuple)item;
                        this.write_object(pair.__getitem__(0), depth + 1);
                        this.write_object(pair.__getitem__(1), depth + 1);
                    }
                    this.write_object(null, depth + 1);
                } else if (vt == PySet.TYPE || vt == PyFrozenSet.TYPE) {
                    if (vt == PySet.TYPE) {
                        this.write_byte('<');
                    } else {
                        this.write_byte('>');
                    }
                    int n = v.__len__();
                    this.write_int(n);
                    BaseSet set = (BaseSet)v;
                    for (PyObject item : set.asIterable()) {
                        this.write_object(item, depth + 1);
                    }
                } else if (vt == PyBytecode.TYPE) {
                    PyBytecode code2 = (PyBytecode)v;
                    this.write_byte('c');
                    this.write_int(code2.co_argcount);
                    this.write_int(code2.co_nlocals);
                    this.write_int(code2.co_stacksize);
                    this.write_int(code2.co_flags.toBits());
                    this.write_object(Py.newString(new String(code2.co_code)), depth + 1);
                    this.write_object(new PyTuple(code2.co_consts), depth + 1);
                    this.write_strings(code2.co_names, depth + 1);
                    this.write_strings(code2.co_varnames, depth + 1);
                    this.write_strings(code2.co_freevars, depth + 1);
                    this.write_strings(code2.co_cellvars, depth + 1);
                    this.write_object(Py.newString(code2.co_name), depth + 1);
                    this.write_int(code2.co_firstlineno);
                    this.write_object(Py.newString(new String(code2.co_lnotab)), depth + 1);
                } else {
                    try (PyBuffer buf = ((BufferProtocol)((Object)v)).getBuffer(0);){
                        this.write_byte('s');
                        this.write_int(v.__len__());
                        this.write_string(buf.toString());
                    }
                    catch (ClassCastException | PyException e) {
                        throw Py.ValueError("unmarshallable object");
                    }
                }
            }
            --depth;
        }

        @Override
        public int traverse(Visitproc visit, Object arg) {
            return this.file != null && this.file instanceof Traverseproc ? ((Traverseproc)((Object)this.file)).traverse(visit, arg) : 0;
        }

        @Override
        public boolean refersDirectlyTo(PyObject ob) {
            return this.file != null && this.file instanceof Traverseproc ? ((Traverseproc)((Object)this.file)).refersDirectlyTo(ob) : false;
        }
    }
}

