/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.android;

import de.qfs.apps.qftest.client.android.AndroidHelper;
import de.qfs.apps.qftest.client.android.AndroidPlayer;
import de.qfs.apps.qftest.client.android.toolkit.AndroidComponent;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class AndroidTreeItemResolver
implements ItemParentResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.android.AndroidTreeItemResolver");
    private final AndroidHelper b;
    private final AndroidPlayer c;
    private final String d;
    private final String e;

    public AndroidTreeItemResolver(AndroidHelper androidHelper, AndroidPlayer androidPlayer, String string, String string2) {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "AndroidTreeItemResolver(AndroidHelper,AndroidPlayer,String,String)", 69).addDetail("helper", (Object)androidHelper)).addDetail("player", (Object)androidPlayer)).addDetail("treeClass", string)).addDetail("nodeClass", string2)).log();
        }
        this.b = androidHelper;
        this.c = androidPlayer;
        this.d = string;
        this.e = string2;
    }

    public Object[] getParentAndItem(Object object) {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 85).addDetail("element", object)).log();
        }
        if (!(object instanceof AndroidComponent)) {
            return null;
        }
        if (!this.b.isMatchingClass(object, this.e)) {
            return null;
        }
        AndroidComponent androidComponent = this.getTreeParent((AndroidComponent)object);
        if (androidComponent == null) {
            return null;
        }
        return new Object[]{androidComponent, object};
    }

    public Object getElement(Object object, Object object2) throws TestException {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 106).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        return object2;
    }

    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 116).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
        }
        this.checkItem(object, null);
        AndroidComponent androidComponent = (AndroidComponent)object;
        for (int i2 = 0; i2 < subItemIndexArray.length; ++i2) {
            SubItemIndex subItemIndex = subItemIndexArray[i2];
            AndroidComponent androidComponent2 = androidComponent;
            if ((androidComponent = this.resolveIndex((AndroidComponent)object, androidComponent, subItemIndex)) != null) continue;
            if (i2 == 0) {
                throw new IndexNotFoundException(subItemIndex);
            }
            ItemRegistry.instance().setIndexesResolved(i2 + 1);
            return androidComponent2;
        }
        ItemRegistry.instance().setIndexesResolved(subItemIndexArray.length);
        return androidComponent;
    }

    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws TestException {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 143).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        AndroidComponent androidComponent = (AndroidComponent)object;
        AndroidComponent androidComponent2 = (AndroidComponent)object2;
        boolean bl = Options.cached_OPT_RECORD_SUBITEM_TREE_PATH;
        if (bl) {
            if (n2 == 1) {
                block16: {
                    SubItemIndex[] subItemIndexArray = this.getIndexAsPath(androidComponent, androidComponent2, 0);
                    try {
                        Object object3 = this.getItemForIndex(androidComponent, subItemIndexArray);
                        if (object3 == object2) {
                            return subItemIndexArray;
                        }
                    }
                    catch (Throwable throwable) {
                        if (AndroidTreeItemResolver.a.level < 3) break block16;
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getItemIndex(Object,Object,int)", 165).add("Cannot refind any item with string!")).log();
                    }
                }
                return this.getIndexAsPath(androidComponent, androidComponent2, 1);
            }
            if (n2 == 1) {
                return this.getIndexAsPath(androidComponent, androidComponent2, 1);
            }
            if (n2 == 0) {
                return this.getIndexAsPath(androidComponent, androidComponent2, 0);
            }
        } else {
            if (n2 == 1) {
                block17: {
                    SubItemIndex[] subItemIndexArray = this.getIndex(androidComponent, androidComponent2, 0);
                    try {
                        Object object4 = this.getItemForIndex(androidComponent, subItemIndexArray);
                        if (object4 == object2) {
                            return subItemIndexArray;
                        }
                    }
                    catch (Throwable throwable) {
                        if (AndroidTreeItemResolver.a.level < 3) break block17;
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getItemIndex(Object,Object,int)", 183).add("Cannot refind any item with string!")).log();
                    }
                }
                return this.getIndex(androidComponent, androidComponent2, 1);
            }
            if (n2 == 1) {
                return this.getIndex(androidComponent, androidComponent2, 1);
            }
            if (n2 == 0) {
                return this.getIndex(androidComponent, androidComponent2, 0);
            }
        }
        return null;
    }

    public String getDefaultTextOfItem(AndroidComponent androidComponent, AndroidComponent androidComponent2) throws BadItemException {
        String string;
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultTextOfItem(AndroidComponent,AndroidComponent)", 203).addDetail("tree", (Object)androidComponent)).addDetail("item", (Object)androidComponent2)).log();
        }
        if (Misc.emptyOrNull((String)(string = this.b.getFlatIdentifierText(androidComponent2)))) {
            for (AndroidComponent androidComponent3 : androidComponent2.getChildren()) {
                String string2 = this.getDefaultTextOfItem(androidComponent, androidComponent3);
                if (Misc.emptyOrNull((String)string2)) continue;
                return string2;
            }
        }
        return string;
    }

    public String getTextOfItem(AndroidComponent androidComponent, AndroidComponent androidComponent2) throws BadItemException {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getTextOfItem(AndroidComponent,AndroidComponent)", 221).addDetail("tree", (Object)androidComponent)).addDetail("item", (Object)androidComponent2)).log();
        }
        String string = this.getDefaultTextOfItem(androidComponent, androidComponent2);
        return ItemRegistry.instance().getItemName((Object)androidComponent, this.b.getClassNames(androidComponent2), (Object)androidComponent2, string);
    }

    public AndroidComponent getTreeParent(AndroidComponent androidComponent) {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getTreeParent(AndroidComponent)", 232).addDetail("child", (Object)androidComponent)).log();
        }
        while (androidComponent != null && !this.b.isMatchingClass(androidComponent, new String[]{this.d})) {
            androidComponent = androidComponent.getParent();
        }
        return androidComponent;
    }

    public AndroidComponent getTreeOrTreeNodeParent(AndroidComponent androidComponent) throws BadItemException {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getTreeOrTreeNodeParent(AndroidComponent)", 243).addDetail("child", (Object)androidComponent)).log();
        }
        for (androidComponent = androidComponent.getParent(); androidComponent != null && !this.b.isMatchingClass(androidComponent, new String[]{this.d, this.e}); androidComponent = androidComponent.getParent()) {
        }
        return androidComponent;
    }

    public void checkItem(Object object, Object object2) throws BadItemException {
        AndroidComponent androidComponent;
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "checkItem(Object,Object)", 264).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!(object instanceof AndroidComponent)) {
            throw new BadItemException(String.valueOf(object) + " is not an AndroidComponent object!");
        }
        if (object2 != null && !(object2 instanceof AndroidComponent)) {
            throw new BadItemException(String.valueOf(object2) + " is not an AndroidComponent object!");
        }
        if (!this.b.isMatchingClass(object, this.d)) {
            throw new BadItemException("Not a " + this.d + " Tree object: " + String.valueOf(object));
        }
        if (object2 != null && !this.b.isMatchingClass(object2, this.e)) {
            throw new BadItemException("Not a " + this.e + "Tree item: " + String.valueOf(object2));
        }
        if (object2 != null && (androidComponent = this.getTreeParent((AndroidComponent)object2)) != object) {
            throw new BadItemException("Tree of item " + String.valueOf(object2) + " is not " + String.valueOf(object) + " but " + String.valueOf(androidComponent));
        }
    }

    public static void createAndRegister(AndroidHelper androidHelper, AndroidPlayer androidPlayer, String string, String string2) {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(AndroidHelper,AndroidPlayer,String,String)", 296).addDetail("helper", (Object)androidHelper)).addDetail("player", (Object)androidPlayer)).addDetail("treeClass", string)).addDetail("nodeClass", string2)).log();
        }
        AndroidTreeItemResolver androidTreeItemResolver = new AndroidTreeItemResolver(androidHelper, androidPlayer, string, string2);
        ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)androidTreeItemResolver);
        ItemRegistry.instance().registerItemParentResolver(string2, (ItemParentResolver)androidTreeItemResolver);
    }

    public String createReverseStringRepresentation(LinkedList linkedList) {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "createReverseStringRepresentation(LinkedList<Object>)", 306).addDetail("l", (Object)linkedList)).log();
        }
        StringBuilder stringBuilder = new StringBuilder(linkedList.size() * 10);
        Iterator iterator = linkedList.descendingIterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            stringBuilder.append('/').append(e2);
        }
        return stringBuilder.toString();
    }

    public int getIndexInParent(AndroidComponent androidComponent, AndroidComponent androidComponent2) throws BadItemException {
        AndroidComponent androidComponent3;
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getIndexInParent(AndroidComponent,AndroidComponent)", 319).addDetail("tree", (Object)androidComponent)).addDetail("child", (Object)androidComponent2)).log();
        }
        if ((androidComponent3 = this.getTreeOrTreeNodeParent(androidComponent2)) == null) {
            throw new BadItemException("Cannot find parent of " + String.valueOf(androidComponent2) + " having expected class Tree/TreeNode!");
        }
        Object[] objectArray = this.getSubElements(androidComponent3, true);
        int n2 = -1;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != androidComponent2) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            throw new BadItemException("Cannot refind component " + String.valueOf(androidComponent2) + " in " + Arrays.toString(objectArray) + " for parent " + String.valueOf(androidComponent3));
        }
        return n2;
    }

    public Object[] getSubElements(AndroidComponent androidComponent, boolean bl) throws BadItemException {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSubElements(AndroidComponent,boolean)", 345).addDetail("com", (Object)androidComponent)).addDetail("check", bl)).log();
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : this.b.getElementsByClassName(androidComponent, new String[]{this.e}, new String[0], -1, true)) {
            AndroidComponent androidComponent2 = (AndroidComponent)object;
            if (this.getTreeOrTreeNodeParent(androidComponent2) != androidComponent && bl) continue;
            linkedList.add(object);
        }
        return linkedList.toArray(new Object[linkedList.size()]);
    }

    public SubItemIndex[] getIndex(AndroidComponent androidComponent, AndroidComponent androidComponent2, int n2) throws BadItemException {
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getIndex(AndroidComponent,AndroidComponent,int)", 365).addDetail("tree", (Object)androidComponent)).addDetail("item", (Object)androidComponent2)).addDetail("type", n2)).log();
        }
        if (n2 == 0) {
            String string = this.getTextOfItem(androidComponent, androidComponent2);
            SubItemIndex[] subItemIndexArray = new SubItemIndex[]{new SubItemIndex(string, 0)};
            return subItemIndexArray;
        }
        int n3 = -1;
        Object[] objectArray = this.getSubElements(androidComponent2, false);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != androidComponent2) continue;
            n3 = i2;
        }
        SubItemIndex[] subItemIndexArray = new SubItemIndex[]{new SubItemIndex("" + n3, 1)};
        return subItemIndexArray;
    }

    public SubItemIndex[] getIndexAsPath(AndroidComponent androidComponent, AndroidComponent androidComponent2, int n2) throws BadItemException {
        String string;
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getIndexAsPath(AndroidComponent,AndroidComponent,int)", 390).addDetail("tree", (Object)androidComponent)).addDetail("item", (Object)androidComponent2)).addDetail("type", n2)).log();
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (AndroidComponent androidComponent3 = androidComponent2; androidComponent3 != null && androidComponent3 != androidComponent; androidComponent3 = androidComponent3.getParent()) {
            if (!this.b.isMatchingClass(androidComponent3, this.e)) continue;
            string = this.getTextOfItem(androidComponent, androidComponent3);
            if (n2 == 1) {
                linkedList.add(this.getIndexInParent(androidComponent, androidComponent3));
                continue;
            }
            if (n2 == 0) {
                linkedList.add(this.getTextOfItem(androidComponent, androidComponent3));
                continue;
            }
            throw new RuntimeException("Unknown type " + n2);
        }
        string = this.createReverseStringRepresentation(linkedList);
        SubItemIndex[] subItemIndexArray = new SubItemIndex[]{new SubItemIndex(string, n2)};
        return subItemIndexArray;
    }

    public AndroidComponent resolveIndexByName(AndroidComponent androidComponent, AndroidComponent androidComponent2, String string, boolean bl) throws TestException {
        Object[] objectArray;
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "resolveIndexByName(AndroidComponent,AndroidComponent,String,boolean)", 423).addDetail("tree", (Object)androidComponent)).addDetail("current", (Object)androidComponent2)).addDetail("name", string)).addDetail("regexp", bl)).log();
        }
        for (Object object : objectArray = this.b.getElementsByClassName(androidComponent2, new String[]{this.e}, new String[0], -1, true)) {
            String string2 = this.getTextOfItem(androidComponent, (AndroidComponent)object);
            if (Misc.emptyOrNull((String)string2)) {
                string2 = "";
            }
            if (!(bl && !Misc.emptyOrNull((String)string) ? Util.regexpMatches((String)string, (String)string2) : string2.equals(string))) continue;
            return (AndroidComponent)object;
        }
        return null;
    }

    public AndroidComponent[] getDirectChildren(AndroidComponent androidComponent) throws TestException {
        Object[] objectArray;
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getDirectChildren(AndroidComponent)", 448).addDetail("ele", (Object)androidComponent)).log();
        }
        LinkedList<AndroidComponent> linkedList = new LinkedList<AndroidComponent>();
        for (Object object : objectArray = this.b.getElementsByClassName(androidComponent, new String[]{this.e}, new String[0], -1, true)) {
            AndroidComponent androidComponent2 = (AndroidComponent)object;
            if (this.getTreeOrTreeNodeParent(androidComponent2) != androidComponent) continue;
            linkedList.add(androidComponent2);
        }
        return linkedList.toArray(new AndroidComponent[linkedList.size()]);
    }

    public AndroidComponent resolveIndexByIndex(AndroidComponent androidComponent, AndroidComponent androidComponent2, int n2, boolean bl) throws TestException {
        AndroidComponent[] androidComponentArray;
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "resolveIndexByIndex(AndroidComponent,AndroidComponent,int,boolean)", 465).addDetail("tree", (Object)androidComponent)).addDetail("current", (Object)androidComponent2)).addDetail("idx", n2)).addDetail("direct", bl)).log();
        }
        Object[] objectArray = androidComponentArray = bl ? this.getDirectChildren(androidComponent2) : this.b.getElementsByClassName(androidComponent2, new String[]{this.e}, new String[0], -1, true);
        if (0 <= n2 && n2 < androidComponentArray.length) {
            return androidComponentArray[n2];
        }
        if (0 > n2 && (n2 = androidComponentArray.length + n2) < androidComponentArray.length) {
            return androidComponentArray[n2];
        }
        return null;
    }

    public AndroidComponent resolveIndex(AndroidComponent androidComponent, AndroidComponent androidComponent2, SubItemIndex subItemIndex) throws TestException {
        boolean bl;
        if (AndroidTreeItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "resolveIndex(AndroidComponent,AndroidComponent,SubItemIndex)", 483).addDetail("tree", (Object)androidComponent)).addDetail("current", (Object)androidComponent2)).addDetail("idx", (Object)subItemIndex)).log();
        }
        if (androidComponent2 == null) {
            throw new BadItemException(null);
        }
        String string = subItemIndex.getIndex();
        if (Misc.emptyOrNull((String)string)) {
            return this.resolveIndexByName(androidComponent, androidComponent2, "", false);
        }
        boolean bl2 = bl = string.charAt(0) == '/';
        if (bl) {
            string = string.substring(1);
            String[] stringArray = string.split("/");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (subItemIndex.getType() == 1) {
                    int n2 = Integer.parseInt(stringArray[i2]);
                    androidComponent2 = this.resolveIndexByIndex(androidComponent, androidComponent2, n2, true);
                } else if (subItemIndex.getType() == 0) {
                    androidComponent2 = this.resolveIndexByName(androidComponent, androidComponent2, stringArray[i2], false);
                } else if (subItemIndex.getType() == 2) {
                    androidComponent2 = this.resolveIndexByName(androidComponent, androidComponent2, stringArray[i2], true);
                }
                if (androidComponent2 != null) continue;
                throw new IndexNotFoundException(subItemIndex);
            }
            return androidComponent2;
        }
        if (subItemIndex.getType() == 1) {
            int n3 = Integer.parseInt(string);
            return this.resolveIndexByIndex(androidComponent, androidComponent2, n3, false);
        }
        if (subItemIndex.getType() == 0) {
            return this.resolveIndexByName(androidComponent, androidComponent2, string, false);
        }
        if (subItemIndex.getType() == 2) {
            return this.resolveIndexByName(androidComponent, androidComponent2, string, true);
        }
        return null;
    }
}

