/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.assertions;

import de.qfs.lib.assertions.Assertion;
import de.qfs.lib.assertions.AssertionUtil;
import de.qfs.lib.assertions.BaseAssertion;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import lombok.NonNull;

public class AssertionFactory {
    static AssertionFactory instance;
    private static Lock instanceLock;
    private static final Set<String> languageChains;
    private final Map<Object, Set<String>> availableAssertions = new LinkedHashMap<Object, Set<String>>();
    private final ReadWriteLock assertionClassModificationLock = new ReentrantReadWriteLock();

    private AssertionFactory() {
        this.setupBaseAssertionMethods();
    }

    public static AssertionFactory instance() {
        try {
            instanceLock.lock();
            if (instance == null) {
                instance = new AssertionFactory();
            }
            AssertionFactory assertionFactory = instance;
            return assertionFactory;
        }
        finally {
            instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupBaseAssertionMethods() {
        try {
            this.assertionClassModificationLock.writeLock().lock();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Method method : BaseAssertion.class.getDeclaredMethods()) {
                treeSet.add(AssertionFactory.getShortMethodName(method));
            }
            for (Method method : Assertion.class.getDeclaredMethods()) {
                treeSet.add(AssertionFactory.getShortMethodName(method));
            }
            this.availableAssertions.put(Assertion.class, treeSet);
        }
        finally {
            this.assertionClassModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Assertion> void registerExtension(Object object, boolean bl) {
        List<Class<?>> list = this.getAssertionInterfaces(object);
        if (list.isEmpty()) {
            throw new IllegalArgumentException(object + " must implement an Assertion-Interface");
        }
        if (object instanceof Class) {
            object = this.createExtensionObject((Class)object);
        } else {
            try {
                Reflector.set(object, "thisAssertion", (Object)new Assertion(){}, true);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(object + " must not be abstract and must have a field 'thisAssertion' with type 'Assertion'.", exception);
            }
        }
        try {
            this.assertionClassModificationLock.writeLock().lock();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Class<?> clazz : list) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if ((method.getModifiers() & 1) == 0) continue;
                    treeSet.add(AssertionFactory.getShortMethodName(method));
                }
            }
            if (bl) {
                AssertionFactory.putInFront(this.availableAssertions, object, treeSet);
            } else {
                this.availableAssertions.put(object, treeSet);
            }
        }
        finally {
            this.assertionClassModificationLock.writeLock().unlock();
        }
    }

    private <T extends Assertion> Object createExtensionObject(Class<T> clazz) {
        if (clazz.isInterface()) {
            return clazz;
        }
        try {
            Object object = Reflector.createInstance(clazz, true);
            Reflector.set(object, "thisAssertion", (Object)new Assertion(){}, true);
            return object;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(clazz + " must not be abstract and must have a field 'thisAssertion' with type 'Assertion'.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Assertion> void unregisterExtension(Object object) {
        try {
            this.assertionClassModificationLock.writeLock().lock();
            if (object != Assertion.class) {
                this.availableAssertions.remove(object);
            }
            if (object instanceof Class) {
                Iterator<Map.Entry<Object, Set<String>>> iterator = this.availableAssertions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Set<String>> entry = iterator.next();
                    Object object2 = entry.getKey();
                    if (object2 == Assertion.class || !((Class)object).isInstance(object2)) continue;
                    iterator.remove();
                }
            }
        }
        finally {
            this.assertionClassModificationLock.writeLock().unlock();
        }
        assert (this.availableAssertions.size() > 0) : "baseAssertions must not be removed";
    }

    static <K, V> void putInFront(Map<K, V> map, K k, V v) {
        Object[] objectArray = map.keySet().toArray();
        map.put(k, v);
        for (Object object : objectArray) {
            V v2 = map.remove(object);
            map.put(object, v2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Assertion get(Object object, String string, String string2) {
        AssertionInvocationHandler assertionInvocationHandler = new AssertionInvocationHandler();
        try {
            this.assertionClassModificationLock.readLock().lock();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            List<Class> list = this.availableAssertions.keySet().stream().map(this::getAssertionInterfaces).flatMap(Collection::stream).distinct().filter(clazz -> AssertionFactory.isClassVisible(classLoader, clazz)).collect(Collectors.toList());
            Assertion assertion = (Assertion)Proxy.newProxyInstance(classLoader, list.toArray(new Class[list.size()]), (InvocationHandler)assertionInvocationHandler);
            assertionInvocationHandler.baseAssertion = new BaseAssertion(assertion, object, string, string2);
            assertionInvocationHandler.classLoader = classLoader;
            Assertion assertion2 = assertion;
            return assertion2;
        }
        finally {
            this.assertionClassModificationLock.readLock().unlock();
        }
    }

    private List<Class<?>> getAssertionInterfaces(Object object) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        LinkedList linkedList = new LinkedList();
        if (clazz.isInterface()) {
            if (Assertion.class.isAssignableFrom(clazz)) {
                linkedList.add(clazz);
            }
        } else {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!Assertion.class.isAssignableFrom(clazz2)) continue;
                linkedList.add(clazz2);
            }
        }
        return linkedList;
    }

    private static boolean isClassVisible(ClassLoader classLoader, Class<?> clazz) {
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(clazz.getName(), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz2 == clazz;
    }

    @NonNull
    private static String getShortMethodName(Method method) {
        String string = method.toString();
        int n = string.indexOf(40);
        int n2 = string.substring(0, n).lastIndexOf(46);
        String string2 = string.substring(n2 + 1);
        return string2;
    }

    static {
        instanceLock = new ReentrantLock();
        languageChains = Misc.setOf("to", "getTo", "be", "getBe", "been", "getBeen", "is", "getIs", "that", "getThat", "which", "getWhich", "and", "getAnd", "has", "getHas", "have", "getHave", "with", "getWith", "at", "getAt", "of", "getOf", "same", "getSame", "but", "getBut", "does", "getDoes", "still", "getStill", "also", "getAlso", "the", "getThe");
    }

    final class AssertionInvocationHandler
    implements InvocationHandler {
        BaseAssertion baseAssertion;
        ClassLoader classLoader;

        AssertionInvocationHandler() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                return this.doInvoke(object, method, objectArray);
            }
            catch (InvocationTargetException | UndeclaredThrowableException exception) {
                throw exception.getCause();
            }
        }

        /*
         * WARNING - void declaration
         */
        private Object doInvoke(Object object, Method method, Object[] objectArray) throws Throwable {
            void var7_23;
            String string = method.getName();
            if (languageChains.contains(string)) {
                return object;
            }
            String string2 = AssertionFactory.getShortMethodName(method);
            String string3 = string2;
            int n = -1;
            switch (string3.hashCode()) {
                case 866385694: {
                    if (!string3.equals("clone()")) break;
                    boolean entry = false;
                    break;
                }
                case -302597171: {
                    if (!string3.equals("equals(java.lang.Object)")) break;
                    boolean bl = true;
                    break;
                }
                case 1890479171: {
                    if (!string3.equals("getClass()")) break;
                    int n2 = 2;
                    break;
                }
                case 202577500: {
                    if (!string3.equals("hashCode()")) break;
                    int n3 = 3;
                    break;
                }
                case 1585376778: {
                    if (!string3.equals("notify()")) break;
                    int n4 = 4;
                    break;
                }
                case -1770571623: {
                    if (!string3.equals("notifyAll()")) break;
                    int n5 = 5;
                    break;
                }
                case 1774939245: {
                    if (!string3.equals("toString()")) break;
                    int n6 = 6;
                    break;
                }
                case -795275978: {
                    if (!string3.equals("wait()")) break;
                    int n7 = 7;
                    break;
                }
                case -1708668998: {
                    if (!string3.equals("wait(long)")) break;
                    int n8 = 8;
                    break;
                }
                case 763692887: {
                    if (!string3.equals("wait(long,int)")) break;
                    int n9 = 9;
                    break;
                }
                case -906022579: {
                    if (!string3.equals("self()")) break;
                    int n10 = 10;
                    break;
                }
                case -989632600: {
                    if (!string3.equals("flag(java.lang.String)")) break;
                    int n11 = 11;
                    break;
                }
                case 781139115: {
                    if (!string3.equals("flag(java.lang.String,java.lang.Object)")) break;
                    int n12 = 12;
                    break;
                }
                case -1469664455: {
                    if (!string3.equals("_obj()")) break;
                    int n13 = 13;
                    break;
                }
                case -1694217210: {
                    if (!string3.equals("_obj(java.lang.Object)")) break;
                    int n14 = 14;
                }
            }
            switch (var7_23) {
                case 0: {
                    return this.cloneBaseAssertion();
                }
                case 1: {
                    return objectArray[0] == object;
                }
                case 2: {
                    return this.baseAssertion.getClass();
                }
                case 3: {
                    return this.baseAssertion.hashCode();
                }
                case 4: {
                    this.baseAssertion.notify();
                    return null;
                }
                case 5: {
                    this.baseAssertion.notifyAll();
                    return null;
                }
                case 6: {
                    return this.baseAssertion.toString();
                }
                case 7: {
                    this.baseAssertion.wait();
                    return null;
                }
                case 8: {
                    this.baseAssertion.wait((Long)objectArray[0]);
                    return null;
                }
                case 9: {
                    this.baseAssertion.wait((Long)objectArray[0], (Integer)objectArray[1]);
                    return null;
                }
                case 10: {
                    return object;
                }
                case 11: {
                    return this.baseAssertion.flag((String)objectArray[0]);
                }
                case 12: {
                    this.baseAssertion.flag((String)objectArray[0], objectArray[1]);
                    return null;
                }
                case 13: {
                    return this.baseAssertion._obj();
                }
                case 14: {
                    this.baseAssertion._obj(objectArray[0]);
                    return null;
                }
            }
            try {
                AssertionFactory.this.assertionClassModificationLock.readLock().lock();
                for (Map.Entry entry : AssertionFactory.this.availableAssertions.entrySet()) {
                    if (!((Set)entry.getValue()).contains(string2)) continue;
                    Object k = entry.getKey();
                    if (k == Assertion.class) {
                        Object object2 = method.invoke((Object)this.baseAssertion, objectArray);
                        return object2;
                    }
                    if (k instanceof Class) {
                        Object object3 = this.callDefaultMethod(object, (Class)k, method, objectArray);
                        return object3;
                    }
                    Reflector.set(k, "thisAssertion", object, true);
                    Object object4 = method.invoke(k, objectArray);
                    return object4;
                }
                throw new NoSuchMethodException("Method not defined: " + string2);
            }
            finally {
                AssertionFactory.this.assertionClassModificationLock.readLock().unlock();
            }
        }

        private Object callDefaultMethod(Object object, Class<? extends Assertion> clazz, Method method, Object[] objectArray) throws Throwable {
            if (Misc.IS_JAVA_VERSION_AT_LEAST_9) {
                return MethodHandles.lookup().findSpecial(clazz, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), clazz).bindTo(object).invokeWithArguments(objectArray);
            }
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            return ((MethodHandles.Lookup)constructor.newInstance(clazz)).in(clazz).unreflectSpecial(method, clazz).bindTo(object).invokeWithArguments(objectArray);
        }

        private Assertion cloneBaseAssertion() {
            Assertion assertion = AssertionFactory.instance().get(this.baseAssertion, null, null);
            AssertionUtil.transferFlags(this.baseAssertion, assertion, true);
            return assertion;
        }
    }
}

