/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.assertions;

import de.qfs.lib.assertions.Assertion;
import de.qfs.lib.assertions.AssertionError;
import de.qfs.lib.assertions.AssertionFactory;
import de.qfs.lib.assertions.AssertionUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.util.Misc;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

class BaseAssertion
implements Assertion {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.assertions.BaseAssertion");
    private final Assertion thisAssertion;
    protected Map<String, Object> flags = new HashMap<String, Object>();

    public BaseAssertion(Assertion assertion, Object object, String string, String string2) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "BaseAssertion(Assertion,Object,String,String)", 39).addDetail("thisAssertion", assertion)).addDetail("obj", object)).addDetail("msg", string)).addDetail("ssfi", string2)).log();
        }
        this.thisAssertion = assertion;
        this.flag("object", object);
        this.flag("message", string);
        this.flag("ssfi", string2);
    }

    @Override
    public Assertion self() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "self()", 48).log();
        }
        return this.thisAssertion;
    }

    @Override
    public Object flag(String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "flag(String)", 53).addDetail("name", string)).log();
        }
        return this.flags.get(string);
    }

    @Override
    public void flag(String string, Object object) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "flag(String,Object)", 58).addDetail("name", string)).addDetail("value", object)).log();
        }
        this.flags.put(string, object);
    }

    @Override
    public Object _obj() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "_obj()", 63).log();
        }
        return this.flags.get("object");
    }

    @Override
    public void _obj(Object object) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "_obj(Object)", 69).addDetail("value", object)).log();
        }
        this.flags.put("object", object);
    }

    @Override
    public boolean doAssert(BooleanSupplier booleanSupplier, Object object, Object object2, Object object3, Object object4) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "doAssert(BooleanSupplier,Object,Object,Object,Object)", 106).addDetail("expression", booleanSupplier)).addDetail("message", object)).addDetail("negatedMessage", object2)).addDetail("expected", object3)).addDetail("actual", object4)).log();
        }
        boolean bl = AssertionUtil.test(this.thisAssertion, booleanSupplier);
        String string = null;
        HashMap<String, Object> hashMap = null;
        boolean bl2 = BaseAssertion.shouldNotifyAsserts(this.flags);
        this.flag("result", bl);
        if (!bl || bl2) {
            string = AssertionUtil.getMessage(this, object, object2, object3, object4);
            hashMap = new HashMap<String, Object>();
            object4 = AssertionUtil.getActual(this, object4);
            hashMap.put("actual", object4);
            hashMap.put("expected", object3);
            String string2 = AssertionUtil.getOperator(this, object, object2, object3);
            if (string2 != null) {
                hashMap.put("operator", string2);
            }
            this._ssfi(BaseAssertion.class, "doAssert");
            if (bl2) {
                BaseAssertion.notify(bl, string, hashMap);
            }
        }
        if (!bl) {
            AssertionError.doThrow(string, hashMap, (String)this.flags.get("ssfi"));
        }
        return bl;
    }

    public static void throwAssertionError(AssertionError assertionError) {
        Map<String, Object> map;
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "throwAssertionError(AssertionError)", 142).addDetail("error", (Object)assertionError)).log();
        }
        if (BaseAssertion.shouldNotifyAsserts(map = assertionError.props)) {
            BaseAssertion.notify(false, assertionError.getMessage(), map);
        }
        AssertionError.doThrow(assertionError);
    }

    public static void throwAssertionError(String string, Map<String, Object> map, String string2) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "throwAssertionError(String,Map<String, Object>,String)", 150).addDetail("message", string)).addDetail("props", map)).addDetail("ssfi", string2)).log();
        }
        if (BaseAssertion.shouldNotifyAsserts(map)) {
            BaseAssertion.notify(false, string, map);
        }
        AssertionError.doThrow(string, map, string2);
    }

    public static void forceThrowAssertionError(String string, Map<String, Object> map, String string2) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "forceThrowAssertionError(String,Map<String, Object>,String)", 157).addDetail("message", string)).addDetail("props", map)).addDetail("ssfi", string2)).log();
        }
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("throwError", true);
        BaseAssertion.throwAssertionError(string, map, string2);
    }

    protected static boolean shouldNotifyAsserts(Map<String, Object> map) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "shouldNotifyAsserts(Map<String, Object>)", 165).addDetail("props", map)).log();
        }
        if (map != null && Boolean.TRUE.equals(map.get("skipNotification"))) {
            return false;
        }
        return DefaultNotificationCenter.instance().canDispatch("de.qfs.lib.assertions.Assertion.Notifications.assertion made");
    }

    public static void notify(boolean bl, String string, Map<String, Object> map) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "notify(boolean,String,Map<String, Object>)", 170).addDetail("ok", bl)).addDetail("message", string)).addDetail("props", map)).log();
        }
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("ok", bl);
        map.put("message", string);
        if (Assertion.Notifications.NOTIFIER.level >= 1) {
            Assertion.Notifications.NOTIFIER.postNotification(1, "de.qfs.lib.assertions.Assertion.Notifications.assertion made", null, map);
        }
    }

    private void checkAn(@NonNull Object object, String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "checkAn(Object,String)", 239).addDetail("type", object)).addDetail("msg", string)).log();
        }
        if (object == null) {
            throw new IllegalArgumentException("type is marked non-null but is null");
        }
        AssertionUtil.maybeSetMessage(this, string);
        Object object2 = this._obj();
        String string2 = object instanceof Class ? ((Class)object).getName() : String.valueOf(object);
        String string3 = string2.matches("[aeiouAEIOU].*") ? "an " : "a ";
        this.doAssert(() -> {
            if (object2 == null) {
                return false;
            }
            Class<?> clazz = object2.getClass();
            if (object instanceof Class) {
                return ((Class)object).isAssignableFrom(clazz);
            }
            switch (string2) {
                case "array": {
                    return clazz.isArray();
                }
                case "function": {
                    switch (clazz.getName()) {
                        case "org.python.core.PyFunction": {
                            return true;
                        }
                    }
                    return this.hasAnnotationClass(clazz, FunctionalInterface.class);
                }
            }
            return this.isMatchingClassname(clazz, string2);
        }, (Object)("expected #{this} to be " + string3 + string2), (Object)("expected #{this} not to be " + string3 + string2));
    }

    private boolean hasAnnotationClass(Class<?> clazz, Class<FunctionalInterface> clazz2) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "hasAnnotationClass(Class<?>,Class<FunctionalInterface>)", 271).addDetail("aClass", clazz)).addDetail("annotationClass", clazz2)).log();
        }
        while (clazz != null) {
            if (clazz.getAnnotation(clazz2) != null) {
                return true;
            }
            for (Class<?> clazz3 : clazz.getInterfaces()) {
                if (!this.hasAnnotationClass(clazz3, clazz2)) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private boolean isMatchingClassname(Class<?> clazz, @NonNull String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "isMatchingClassname(Class<?>,String)", 287).addDetail("aClass", clazz)).addDetail("type", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("type is marked non-null but is null");
        }
        while (clazz != null) {
            if (string.equals(clazz.getName()) || string.equals(clazz.getSimpleName())) {
                return true;
            }
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!this.isMatchingClassname(clazz2, string)) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    @Override
    public Assertion an(Object object, String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "an(Object,String)", 304).addDetail("type", object)).addDetail("message", string)).log();
        }
        this._ssfi(BaseAssertion.class, "an");
        this.checkAn(object, string);
        return this.thisAssertion;
    }

    protected void includeChainingBehavior() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "includeChainingBehavior()", 310).log();
        }
        this.thisAssertion.flag("contains", true);
    }

    @Override
    public Assertion getInclude() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "getInclude()", 315).log();
        }
        this.includeChainingBehavior();
        return this.thisAssertion;
    }

    @Override
    public Assertion include(Object object3, String string) {
        LinkedList<AssertionError> linkedList;
        String string2;
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "include(Object,String)", 321).addDetail("val", object3)).addDetail("message", string)).log();
        }
        this._ssfi(BaseAssertion.class, "include");
        AssertionUtil.maybeSetMessage(this, string);
        Object object4 = this._obj();
        String string3 = AssertionUtil.flagAsString(this, "message");
        boolean bl = AssertionUtil.flagAsBoolean(this, "negate");
        String string4 = AssertionUtil.flagAsString(this, "ssfi");
        boolean bl2 = AssertionUtil.flagAsBoolean(this, "deep");
        boolean bl3 = AssertionUtil.flagAsBoolean(this, "strict");
        String string5 = string2 = bl2 ? "deep " : "";
        if (bl3) {
            string2 = string2 + "strict ";
        }
        String string6 = string3 = Misc.emptyOrNull(string3) ? "" : string3 + ": ";
        if (bl3 && bl2) {
            BaseAssertion.forceThrowAssertionError(string3 + "The \"strict\" and \"deep\" flags cannot be combined", null, string4);
        }
        boolean bl4 = false;
        boolean bl5 = true;
        BiPredicate<Object, Object> biPredicate = bl3 ? (object, object2) -> object == object2 : (bl2 ? AssertionUtil::deepEql : Misc::equalOrNull);
        if (object4 instanceof String) {
            bl4 = ((String)object4).contains(String.valueOf(object3));
            bl5 = false;
        } else if (object4 instanceof Map) {
            bl4 = ((Map)object4).values().stream().anyMatch(object2 -> biPredicate.test(object3, object2));
        } else if (object4 instanceof Collection) {
            bl4 = ((Collection)object4).stream().anyMatch(object2 -> biPredicate.test(object3, object2));
            bl5 = false;
        } else if (object4 != null && object4.getClass().isArray()) {
            int n = Array.getLength(object4);
            for (int i = 0; i < n && !(bl4 = biPredicate.test(object3, linkedList = Array.get(object4, i))); ++i) {
            }
            bl5 = false;
        }
        if (!bl4 && bl5) {
            List<Object> list;
            Map<String, Object> map = null;
            if (object3 instanceof Map) {
                list = ((Map)object3).keySet().stream().map(object -> String.valueOf(object)).collect(Collectors.toList());
                map = ((Map)object3).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), Map.Entry::getValue));
            } else if (object3 instanceof Collection) {
                list = ((Collection)object3).stream().map(object -> String.valueOf(object)).collect(Collectors.toList());
            } else if (object3 != null && object3.getClass().isArray()) {
                list = new LinkedList();
                int n = Array.getLength(object3);
                for (int i = 0; i < n; ++i) {
                    Object object5 = Array.get(object3, i);
                    list.add(String.valueOf(object5));
                }
            } else if (object3 instanceof String) {
                list = Misc.listOf((String)object3);
            } else {
                linkedList = AssertionUtil.type(object3);
                BaseAssertion.forceThrowAssertionError(string3 + "the given combination of arguments (" + AssertionUtil.type(object4) + " and " + linkedList + ") is invalid for this assertion. You can use an array, a map, a collection, or a string, instead of a " + linkedList, null, string4);
                return this.thisAssertion;
            }
            linkedList = new LinkedList<AssertionError>();
            for (Object object5 : list) {
                Assertion assertion = AssertionFactory.instance().get(object4, null, null);
                AssertionUtil.transferFlags(this, assertion, true);
                assertion.flag("throwError", true);
                assertion.flag("skipNotification", true);
                Object object6 = map == null ? NO_ARG : map.get(object5);
                try {
                    assertion.property((String)object5, object6);
                }
                catch (AssertionError assertionError) {
                    assertionError.props.remove("throwError");
                    linkedList.add(assertionError);
                }
            }
            boolean bl6 = true;
            if (bl && list.size() > 1) {
                if (list.size() == linkedList.size()) {
                    BaseAssertion.throwAssertionError((AssertionError)((Object)linkedList.get(0)));
                    bl6 = false;
                }
            } else {
                linkedList.forEach(BaseAssertion::throwAssertionError);
                bl6 = false;
            }
            this.flag("result", bl6);
            return this.thisAssertion;
        }
        this.doAssert(bl4, (Object)("expected #{this} to " + string2 + "include " + this._inspect(object3)), (Object)("expected #{this} to not " + string2 + "include " + this._inspect(object3)));
        return this.thisAssertion;
    }

    @Override
    public Assertion getOk() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "getOk()", 449).log();
        }
        this._ssfi(BaseAssertion.class, "getOk");
        this.doAssert(Misc.toBoolean(this._obj()), (Object)"expected #{this} to be truthy", (Object)"expected #{this} to be falsy");
        return this.thisAssertion;
    }

    @Override
    public Assertion getTRUE() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "getTRUE()", 460).log();
        }
        this._ssfi(BaseAssertion.class, "getTRUE");
        this.doAssert(Boolean.TRUE.equals(this._obj()), (Object)"expected #{this} to be true", (Object)"expected #{this} not to be true");
        return this.thisAssertion;
    }

    @Override
    public Assertion getFALSE() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "getFALSE()", 471).log();
        }
        this._ssfi(BaseAssertion.class, "getFALSE");
        this.doAssert(Boolean.FALSE.equals(this._obj()), (Object)"expected #{this} to be false", (Object)"expected #{this} not to be false");
        return this.thisAssertion;
    }

    @Override
    public Assertion getNULL() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "getNULL()", 482).log();
        }
        this._ssfi(BaseAssertion.class, "getNULL");
        this.doAssert(null == this._obj(), (Object)"expected #{this} to be null", (Object)"expected #{this} not to be null");
        return this.thisAssertion;
    }

    @Override
    public Assertion getExists() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "getExists()", 493).log();
        }
        this._ssfi(BaseAssertion.class, "getExists");
        this.doAssert(null != this._obj(), (Object)"expected #{this} to exists", (Object)"expected #{this} to not exists");
        return this.thisAssertion;
    }

    @Override
    public Assertion getEmpty() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "getEmpty()", 504).log();
        }
        this._ssfi(BaseAssertion.class, "getEmpty");
        Object object = this._obj();
        String string = AssertionUtil.flagAsString(this, "ssfi");
        String string2 = AssertionUtil.flagAsString(this, "message");
        boolean bl = false;
        String string3 = string2 = Misc.emptyOrNull(string2) ? "" : string2 + ": ";
        if (object != null && object.getClass().isArray()) {
            bl = Array.getLength(object) == 0;
        } else if (object instanceof Collection) {
            bl = ((Collection)object).isEmpty();
        } else if (object instanceof Map) {
            bl = ((Map)object).isEmpty();
        } else if (object instanceof String) {
            bl = ((String)object).isEmpty();
        } else {
            try {
                bl = (Boolean)AssertionUtil.getProperty(object, "empty", true);
            }
            catch (Exception exception) {
                try {
                    bl = ((Number)AssertionUtil.getProperty(object, "size", true)).intValue() == 0;
                }
                catch (Exception exception2) {
                    try {
                        bl = ((Number)AssertionUtil.getProperty(object, "length", true)).intValue() == 0;
                    }
                    catch (Exception exception3) {
                        BaseAssertion.forceThrowAssertionError(string2 + ".empty was passed to an incompatible object " + this._inspect(object), null, string);
                    }
                }
            }
        }
        this.doAssert(bl, (Object)"expected #{this} to be empty", (Object)"expected #{this} not to be empty");
        return this.thisAssertion;
    }

    private void assertEqual(Object object, String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "assertEqual(Object,String)", 543).addDetail("val", object)).addDetail("msg", string)).log();
        }
        AssertionUtil.maybeSetMessage(this, string);
        Object object2 = this._obj();
        boolean bl = AssertionUtil.flagAsBoolean(this, "deep");
        boolean bl2 = AssertionUtil.flagAsBoolean(this, "strict");
        if (bl) {
            this.assertEql(object, string);
        } else {
            String string2;
            String string3 = string2 = bl2 ? "strict " : "";
            this.doAssert(bl2 ? object == object2 : Misc.equalOrNull(object2, object), (Object)("expected #{this} to " + string2 + "equal #{exp}"), (Object)("expected #{this} to not " + string2 + "equal #{exp}"), object, object2);
        }
    }

    @Override
    public Assertion equal(Object object, String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "equal(Object,String)", 562).addDetail("val", object)).addDetail("message", string)).log();
        }
        this._ssfi(BaseAssertion.class, "equal");
        this.assertEqual(object, string);
        return this.thisAssertion;
    }

    private void assertEql(Object object, String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "assertEql(Object,String)", 569).addDetail("val", object)).addDetail("msg", string)).log();
        }
        AssertionUtil.maybeSetMessage(this, string);
        Object object2 = this._obj();
        boolean bl = AssertionUtil.flagAsBoolean(this, "strict");
        String string2 = AssertionUtil.flagAsString(this, "ssfi");
        String string3 = AssertionUtil.flagAsString(this, "message");
        String string4 = string3 = Misc.emptyOrNull(string3) ? "" : string3 + ": ";
        if (bl) {
            BaseAssertion.forceThrowAssertionError(string3 + "The \"strict\" flag cannot be combined with deep 'eql'", null, string2);
        }
        this.doAssert(AssertionUtil.deepEql(object, object2), (Object)"expected #{this} to deeply equal #{exp}", (Object)"expected #{this} to not deeply equal #{exp}", object, object2);
    }

    @Override
    public Assertion eql(Object object, String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "eql(Object,String)", 590).addDetail("val", object)).addDetail("message", string)).log();
        }
        this._ssfi(BaseAssertion.class, "eql");
        this.assertEql(object, string);
        return this.thisAssertion;
    }

    private void assertProperty(String string, Object object, String string2) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "assertProperty(String,Object,String)", 597).addDetail("name", string)).addDetail("val", object)).addDetail("msg", string2)).log();
        }
        AssertionUtil.maybeSetMessage(this, string2);
        boolean bl = AssertionUtil.flagAsBoolean(this, "nested");
        boolean bl2 = AssertionUtil.flagAsBoolean(this, "own");
        String string3 = AssertionUtil.flagAsString(this, "message");
        Object object2 = this._obj();
        String string4 = AssertionUtil.flagAsString(this, "ssfi");
        String string5 = string3 = Misc.emptyOrNull(string3) ? "" : string3 + ": ";
        if (bl && bl2) {
            BaseAssertion.forceThrowAssertionError(string3 + "The \"nested\" and \"own\" flags cannot be combined.", null, string4);
        }
        if (object2 == null) {
            BaseAssertion.forceThrowAssertionError(string3 + "Target cannot be null.", null, string4);
        }
        boolean bl3 = AssertionUtil.flagAsBoolean(this, "deep");
        boolean bl4 = AssertionUtil.flagAsBoolean(this, "strict");
        boolean bl5 = AssertionUtil.flagAsBoolean(this, "negate");
        StringBuilder stringBuilder = new StringBuilder();
        if (bl3) {
            stringBuilder.append("deep ");
        }
        if (bl4) {
            stringBuilder.append("strict ");
        }
        if (bl4 && bl3) {
            BaseAssertion.forceThrowAssertionError(string3 + "The \"strict\" and \"deep\" flags cannot be combined", null, string4);
        }
        if (bl2) {
            stringBuilder.append("own ");
        }
        if (bl) {
            stringBuilder.append("nested ");
        }
        stringBuilder.append("property ");
        String string6 = stringBuilder.toString();
        boolean bl6 = true;
        Object object3 = null;
        if (bl) {
            AssertionUtil.PathInfo pathInfo = AssertionUtil.getPathInfo(object2, string);
            object3 = pathInfo.value;
            bl6 = pathInfo.exists;
        } else {
            try {
                object3 = AssertionUtil.getProperty(object2, string, !bl2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (BaseAssertion.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "assertProperty(String,Object,String)", 642).add("ex", noSuchFieldException)).log();
                }
                bl6 = false;
            }
        }
        if (BaseAssertion.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "assertProperty(String,Object,String)", 646).add("value", object3)).log();
        }
        if (!bl5 || object == NO_ARG) {
            this.doAssert(bl6, (Object)("expected #{this} to have " + string6 + this._inspect(string)), (Object)("expected #{this} to not have " + string6 + this._inspect(string)));
        }
        if (object != NO_ARG) {
            boolean bl7 = bl6 && (bl4 ? object == object3 : (bl3 ? AssertionUtil.deepEql(object, object3) : Misc.equalOrNull(object, object3)));
            this.doAssert(bl7, (Object)("expected #{this} to have " + string6 + this._inspect(string) + " of #{exp}, but got #{act}"), (Object)("expected #{this} to not have " + string6 + this._inspect(string) + " of #{act}"), object, object3);
        }
        this.flag("object", object3);
    }

    private boolean valueIsValidForInclude(Object object) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "valueIsValidForInclude(Object)", 671).addDetail("val", object)).log();
        }
        return object instanceof Map || object instanceof Collection || object != null && object.getClass().isArray() || object instanceof String;
    }

    @Override
    public Assertion property(String string, Object object, String string2) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "property(String,Object,String)", 679).addDetail("name", string)).addDetail("value", object)).addDetail("message", string2)).log();
        }
        this._ssfi(BaseAssertion.class, "property");
        this.assertProperty(string, object, string2);
        return this.thisAssertion;
    }

    protected void assertLengthChain() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "assertLengthChain()", 685).log();
        }
        this.flag("doLength", true);
    }

    @Override
    public Assertion getLengthOf() {
        if (BaseAssertion.logger.level >= 7) {
            logger.lvlBuild(7, "getLengthOf()", 690).log();
        }
        this.assertLengthChain();
        return this.thisAssertion;
    }

    public void assertLength(int n, String string) {
        long l;
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "assertLength(int,String)", 696).addDetail("n", n)).addDetail("msg", string)).log();
        }
        AssertionUtil.maybeSetMessage(this, string);
        Object object = this._obj();
        String string2 = AssertionUtil.flagAsString(this, "message");
        String string3 = AssertionUtil.flagAsString(this, "ssfi");
        String string4 = "length";
        if (object == null) {
            l = 0L;
        } else if (object instanceof Collection) {
            l = ((Collection)object).size();
            string4 = "size";
        } else if (object instanceof Map) {
            l = ((Map)object).size();
            string4 = "size";
        } else if (object.getClass().isArray()) {
            l = Array.getLength(object);
        } else {
            Assertion assertion = AssertionFactory.instance().get(object, string2, string3);
            assertion.flag("throwError", true);
            try {
                assertion.property("length");
            }
            catch (AssertionError assertionError) {
                assertionError.props.remove("throwError");
                AssertionError.doThrow(assertionError);
                return;
            }
            l = ((Number)AssertionUtil.getProperty(object, "length", true)).longValue();
        }
        this.doAssert(l == (long)n, (Object)("expected #{this} to have a " + string4 + " of #{exp} but got #{act}"), (Object)("expected #{this} to not have a " + string4 + " of #{act}"), (Object)n, (Object)l);
    }

    @Override
    public Assertion lengthOf(int n, String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "lengthOf(int,String)", 737).addDetail("n", n)).addDetail("message", string)).log();
        }
        this._ssfi(BaseAssertion.class, "length");
        this.assertLength(n, string);
        return this.thisAssertion;
    }

    private void assertMatch(Pattern pattern, String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "assertMatch(Pattern,String)", 743).addDetail("re", pattern)).addDetail("msg", string)).log();
        }
        AssertionUtil.maybeSetMessage(this, string);
        Object object = this._obj();
        this.doAssert(pattern.matcher(String.valueOf(object)).find(), (Object)("expected #{this} to match " + this._inspect(pattern)), (Object)("expected #{this} not to match " + this._inspect(pattern)));
    }

    @Override
    public Assertion match(Pattern pattern, String string) {
        if (BaseAssertion.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "match(Pattern,String)", 754).addDetail("re", pattern)).addDetail("message", string)).log();
        }
        this._ssfi(Assertion.class, "match");
        this.assertMatch(pattern, string);
        return this.thisAssertion;
    }
}

