/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.command;

import de.qfs.lib.command.AsyncCommand;
import de.qfs.lib.command.CancelCommandException;
import de.qfs.lib.command.Command;
import de.qfs.lib.command.CommandException;
import de.qfs.lib.command.CommandHandler;
import de.qfs.lib.command.DialogCommandException;
import de.qfs.lib.command.Invokable;
import de.qfs.lib.command.MessageCommandException;
import de.qfs.lib.command.RuntimeCommandException;
import de.qfs.lib.command.UnhandledCommandException;
import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.ExceptionHandler;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class CommandDistributor {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.command.CommandDistributor");
    private static CommandDistributor defaultDistributor = new CommandDistributor();
    private List exHandlers = new ArrayList();
    private Set handlers = new HashSet();
    public static final String COMMAND_CANCELLED = "Command cancelled";
    private Map objectHandlers = new HashMap();
    private Map classHandlers = new HashMap();
    private static int threadCount;

    public static CommandDistributor getDefaultDistributor() {
        return defaultDistributor;
    }

    public static void setDefaultDistributor(CommandDistributor commandDistributor) {
        defaultDistributor = commandDistributor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object assignCommand(Command command) {
        block33: {
            if (CommandDistributor.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "assignCommand(Command)", 204).addDetail("command", command)).log();
            }
            try {
                return this.assignCommandSilently(command);
            }
            catch (RuntimeCommandException runtimeCommandException) {
                ExceptionHandler[] exceptionHandlerArray;
                if (CommandDistributor.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "assignCommand(Command)", 209).add("ex", runtimeCommandException)).log();
                }
                if (runtimeCommandException.getMessageResource() != null) {
                    Object object = runtimeCommandException.getParent();
                    if (object == null) {
                        object = command.getSource();
                    }
                    Message.showMessage(object instanceof Component ? (Component)object : null, runtimeCommandException.getMessageResource(), runtimeCommandException.getMessageParameters());
                }
                if (runtimeCommandException.getNested() == null) break block33;
                Throwable throwable = runtimeCommandException.getNested();
                if (CommandDistributor.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "assignCommand(Command)", 222).add("nested", throwable)).log();
                }
                CommandDistributor commandDistributor = this;
                synchronized (commandDistributor) {
                    exceptionHandlerArray = this.exHandlers.toArray(new ExceptionHandler[0]);
                }
                if (CommandDistributor.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "assignCommand(Command)", 226).add("hdlr", exceptionHandlerArray)).log();
                }
                for (int i = 0; i < exceptionHandlerArray.length; ++i) {
                    try {
                        if (!exceptionHandlerArray[i].handleException(throwable)) continue;
                        return null;
                    }
                    catch (Throwable throwable2) {
                        if (CommandDistributor.logger.level < 1) continue;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "assignCommand(Command)", 233).add("ex2", throwable2)).add("Exception in ExceptionHandler")).add("hdlr[i]", exceptionHandlerArray[i])).add("caused by ")).add("nested", throwable)).log();
                    }
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw runtimeCommandException;
            }
            catch (MessageCommandException messageCommandException) {
                if (CommandDistributor.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "assignCommand(Command)", 244).add("ex", messageCommandException)).log();
                }
                Message.showMessage(messageCommandException.getParent(), messageCommandException.getMessageResource(), messageCommandException.getMessageParameters());
            }
            catch (DialogCommandException dialogCommandException) {
                if (CommandDistributor.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "assignCommand(Command)", 248).add("ex", dialogCommandException)).log();
                }
                dialogCommandException.getDialog().show();
            }
            catch (CancelCommandException cancelCommandException) {
                if (CommandDistributor.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "assignCommand(Command)", 251).add("ex", cancelCommandException)).log();
                }
                return COMMAND_CANCELLED;
            }
            catch (UnhandledCommandException unhandledCommandException) {
                if (CommandDistributor.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "assignCommand(Command)", 254).add("ex", unhandledCommandException)).log();
                }
            }
            catch (CommandException commandException) {
                if (CommandDistributor.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "assignCommand(Command)", 256).add("ex", commandException)).log();
                }
            }
            catch (Error | RuntimeException throwable) {
                ExceptionHandler[] exceptionHandlerArray;
                if (CommandDistributor.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "assignCommand(Command)", 258).add("ex", throwable)).log();
                }
                CommandDistributor commandDistributor = this;
                synchronized (commandDistributor) {
                    exceptionHandlerArray = this.exHandlers.toArray(new ExceptionHandler[0]);
                }
                for (int i = 0; i < exceptionHandlerArray.length; ++i) {
                    if (exceptionHandlerArray[i] == null) continue;
                    try {
                        if (!exceptionHandlerArray[i].handleException(throwable)) continue;
                        return null;
                    }
                    catch (Throwable throwable3) {
                        if (CommandDistributor.logger.level < 1) continue;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "assignCommand(Command)", 270).add("ex2", throwable3)).add("Exception in ExceptionHandler")).add("hdlr[i]", exceptionHandlerArray[i])).add("caused by ")).add("ex", throwable)).log();
                    }
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object assignCommandSilently(Command command) throws CommandException {
        Object object;
        Object v;
        if (CommandDistributor.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "assignCommandSilently(Command)", 296).addDetail("command", command)).log();
        }
        if (command instanceof Invokable) {
            return ((Invokable)((Object)command)).invoke();
        }
        CommandHandler[] commandHandlerArray = null;
        CommandDistributor commandDistributor = this;
        synchronized (commandDistributor) {
            v = this.objectHandlers.get(command.getSource());
            if (v != null) {
                commandHandlerArray = ((Collection)v).toArray(new CommandHandler[0]);
            }
        }
        if (commandHandlerArray != null) {
            for (int i = 0; i < commandHandlerArray.length; ++i) {
                object = commandHandlerArray[i].handleCommand(command);
                if (!command.isHandled()) continue;
                return object;
            }
        }
        CommandDistributor commandDistributor2 = this;
        synchronized (commandDistributor2) {
            v = this.classHandlers.get(command.getSource().getClass());
            if (v != null) {
                commandHandlerArray = ((Collection)v).toArray(new CommandHandler[0]);
            }
        }
        if (commandHandlerArray != null) {
            for (int i = 0; i < commandHandlerArray.length; ++i) {
                object = commandHandlerArray[i].handleCommand(command);
                if (!command.isHandled()) continue;
                return object;
            }
        }
        commandHandlerArray = this.handlers.toArray(new CommandHandler[0]);
        for (int i = 0; i < commandHandlerArray.length; ++i) {
            object = commandHandlerArray[i].handleCommand(command);
            if (!command.isHandled()) continue;
            return object;
        }
        if (command.mustBeHandled()) {
            throw new UnhandledCommandException(command);
        }
        return null;
    }

    public void assignAsyncCommand(AsyncCommand asyncCommand) {
        new CommandThread(asyncCommand).start();
    }

    public synchronized void addCommandHandler(CommandHandler commandHandler) {
        this.handlers.add(commandHandler);
    }

    public synchronized void addCommandHandler(CommandHandler commandHandler, Object object) {
        HashSet<CommandHandler> hashSet = (HashSet<CommandHandler>)this.objectHandlers.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<CommandHandler>();
            this.objectHandlers.put(object, hashSet);
        }
        hashSet.add(commandHandler);
    }

    public synchronized void addCommandHandler(CommandHandler commandHandler, Class clazz) {
        HashSet<CommandHandler> hashSet = (HashSet<CommandHandler>)this.classHandlers.get(clazz);
        if (hashSet == null) {
            hashSet = new HashSet<CommandHandler>();
            this.classHandlers.put(clazz, hashSet);
        }
        hashSet.add(commandHandler);
    }

    public synchronized void removeCommandHandler(CommandHandler commandHandler) {
        this.handlers.remove(commandHandler);
    }

    public synchronized void removeCommandHandler(CommandHandler commandHandler, Object object) {
        if (this.objectHandlers.containsKey(object)) {
            ((Collection)this.objectHandlers.get(object)).remove(commandHandler);
        }
    }

    public synchronized void removeCommandHandler(CommandHandler commandHandler, Class clazz) {
        if (this.classHandlers.containsKey(clazz)) {
            ((Collection)this.classHandlers.get(clazz)).remove(commandHandler);
        }
    }

    public synchronized void addExceptionHandler(ExceptionHandler exceptionHandler) {
        if (CommandDistributor.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addExceptionHandler(ExceptionHandler)", 498).addDetail("handler", exceptionHandler)).log();
        }
        this.exHandlers.remove(exceptionHandler);
        this.exHandlers.add(0, exceptionHandler);
    }

    public synchronized void removeExceptionHandler(ExceptionHandler exceptionHandler) {
        if (CommandDistributor.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeExceptionHandler(ExceptionHandler)", 512).addDetail("handler", exceptionHandler)).log();
        }
        this.exHandlers.remove(exceptionHandler);
    }

    private class CommandThread
    extends DaemonThread {
        private Command command;

        public CommandThread(Command command) {
            this.setName("CommandThread-" + threadCount++);
            this.command = command;
        }

        @Override
        public void run() {
            CommandDistributor.this.assignCommand(this.command);
        }
    }
}

