/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.config;

import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.ConfigurationEvent;
import de.qfs.lib.config.ConfigurationListener;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.SortedProperties;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import lombok.Generated;

public class Configuration {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.config.Configuration");
    private static Configuration theInstance = new Configuration();
    private static final String LINESEP = System.getProperty("line.separator");
    protected ReferenceQueue refQueue = new ReferenceQueue();
    protected Hashtable configurables = new Hashtable();
    protected Hashtable nameMap = new Hashtable();
    protected Hashtable states = new Hashtable();
    protected Vector names = new Vector();
    private String comment;
    private Hashtable comments = new Hashtable();
    private Vector listeners = new Vector();
    private Vector silenced = new Vector();
    private boolean sortNames;
    private static final Charset confFileCharset = Misc.getCharsetByJavaProperty("qftest.propertyFileEncoding", Misc.LATIN1_CHARSET);

    protected Configuration() {
        if (Configuration.logger.level >= 7) {
            logger.lvlBuild(7, "Configuration()", 200).log();
        }
    }

    public static Configuration instance() {
        if (Configuration.logger.level >= 7) {
            logger.lvlBuild(7, "instance()", 213).log();
        }
        return theInstance;
    }

    public void register(Configurable configurable) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "register(Configurable)", 233).addDetail("configurable", configurable)).log();
        }
        this.registerAs(configurable, configurable.getConfigurableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAs(Configurable configurable, String string) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "registerAs(Configurable,String)", 249).addDetail("configurable", configurable)).addDetail("name", string)).log();
        }
        this.clearReferenceQueue();
        Properties properties = null;
        boolean bl = false;
        WeakConfigurable weakConfigurable = new WeakConfigurable(configurable);
        Configuration configuration = this;
        synchronized (configuration) {
            Object v = this.configurables.get(string);
            Object object = null;
            if (Configuration.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "registerAs(Configurable,String)", 261).add("old", v)).log();
            }
            if (v != null) {
                if (v instanceof Vector) {
                    object = v;
                    int n = ((Vector)v).size();
                    for (int i = 0; i < n; ++i) {
                        WeakConfigurable weakConfigurable2 = (WeakConfigurable)((Vector)v).elementAt(i);
                        Object t = weakConfigurable2.get();
                        if (t == null) continue;
                        try {
                            properties = ((Configurable)t).getConfigurableState();
                            bl = true;
                            break;
                        }
                        catch (RuntimeException runtimeException) {
                            if (Configuration.logger.level < 5) continue;
                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "registerAs(Configurable,String)", 278).add("ex", runtimeException)).log();
                        }
                    }
                    ((Vector)object).insertElementAt(weakConfigurable, 0);
                } else {
                    Object t = ((WeakConfigurable)v).get();
                    if (t != null) {
                        object = new Vector();
                        ((Vector)object).insertElementAt(v, 0);
                        ((Vector)object).insertElementAt(weakConfigurable, 0);
                        try {
                            properties = ((Configurable)t).getConfigurableState();
                            bl = true;
                        }
                        catch (RuntimeException runtimeException) {
                            if (Configuration.logger.level >= 5) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(5, "registerAs(Configurable,String)", 295).add("ex", runtimeException)).log();
                            }
                        }
                    } else {
                        this.nameMap.remove(v);
                        if (Configuration.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "registerAs(Configurable,String)", 300).add("nameMap", this.nameMap)).log();
                        }
                    }
                }
            }
            if (object == null) {
                object = weakConfigurable;
                properties = (Properties)this.states.get(string);
                if (properties == null) {
                    properties = weakConfigurable.getConfigurableState();
                    this.states.put(string, properties);
                } else {
                    bl = true;
                }
            }
            this.configurables.put(string, object);
            this.nameMap.put(weakConfigurable, string);
            if (!this.names.contains(string)) {
                this.names.addElement(string);
            }
            weakConfigurable.registrationChanged(this, string, true, false);
        }
        if (Configuration.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "registerAs(Configurable,String)", 322).add("mustSet", bl)).log();
        }
        if (Configuration.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "registerAs(Configurable,String)", 323).add("state", properties)).log();
        }
        if (properties != null && bl) {
            try {
                this.silenced.addElement(Thread.currentThread());
                weakConfigurable.setConfigurableState(properties);
            }
            finally {
                this.silenced.removeElement(Thread.currentThread());
            }
        }
        if (Configuration.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "registerAs(Configurable,String)", 333).add("nameMap", this.nameMap)).log();
        }
    }

    public void unregister(Configurable configurable, boolean bl) {
        String string = (String)this.nameMap.get(configurable);
        if (Configuration.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "unregister(Configurable,boolean)", 351).add("name", string)).log();
        }
        if (string == null) {
            string = configurable.getConfigurableName();
            if (Configuration.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "unregister(Configurable,boolean)", 355).add("name", string)).log();
            }
        }
        this.unregisterAs(configurable, string, bl);
    }

    public synchronized void unregisterAs(Configurable configurable, String string, boolean bl) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "unregisterAs(Configurable,String,boolean)", 372).addDetail("configurable", configurable)).addDetail("name", string)).addDetail("keepValues", bl)).log();
        }
        this.clearReferenceQueue();
        Object v = this.configurables.get(string);
        if (Configuration.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "unregisterAs(Configurable,String,boolean)", 379).add("old", v)).log();
        }
        if (v == null) {
            if (Configuration.logger.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "unregisterAs(Configurable,String,boolean)", 382).add("Trying to unregister unknown Configurable ")).add(string)).log();
            }
        } else if (v instanceof Vector) {
            ((Vector)v).removeElement(new WeakConfigurable(configurable));
            if (((Vector)v).size() == 0) {
                if (bl) {
                    try {
                        Properties properties = configurable.getConfigurableState();
                        if (Configuration.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "unregisterAs(Configurable,String,boolean)", 391).add("Keeping state: ")).add(properties)).log();
                        }
                        this.states.put(string, properties);
                    }
                    catch (RuntimeException runtimeException) {
                        if (Configuration.logger.level >= 5) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "unregisterAs(Configurable,String,boolean)", 394).add("ex", runtimeException)).log();
                        }
                    }
                } else {
                    this.names.removeElement(string);
                    this.states.remove(string);
                }
                this.configurables.remove(string);
            }
        } else if (!v.equals(configurable)) {
            if (Configuration.logger.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "unregisterAs(Configurable,String,boolean)", 404).add("Trying to unregister different Configurable under name ")).add(string)).log();
            }
        } else {
            if (bl) {
                try {
                    Properties properties = configurable.getConfigurableState();
                    if (Configuration.logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "unregisterAs(Configurable,String,boolean)", 410).add("Keeping state: ")).add(properties)).log();
                    }
                    this.states.put(string, properties);
                }
                catch (RuntimeException runtimeException) {
                    if (Configuration.logger.level >= 5) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "unregisterAs(Configurable,String,boolean)", 413).add("ex", runtimeException)).log();
                    }
                }
            } else {
                this.names.removeElement(string);
                this.states.remove(string);
            }
            this.configurables.remove(string);
        }
        this.nameMap.remove(configurable);
        configurable.registrationChanged(this, string, false, bl);
        if (Configuration.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "unregisterAs(Configurable,String,boolean)", 423).add("nameMap", this.nameMap)).log();
        }
    }

    public void unregisterAll(String string, boolean bl) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "unregisterAll(String,boolean)", 437).addDetail("name", string)).addDetail("keepValues", bl)).log();
        }
        this.clearReferenceQueue();
        Object v = this.configurables.get(string);
        if (Configuration.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "unregisterAll(String,boolean)", 442).add("old", v)).log();
        }
        if (v == null) {
            if (!bl) {
                this.states.remove(string);
                this.names.removeElement(string);
            }
            return;
        }
        Configurable configurable = null;
        if (v instanceof Vector) {
            for (int i = 0; i < ((Vector)v).size(); ++i) {
                WeakConfigurable weakConfigurable = (WeakConfigurable)((Vector)v).elementAt(i);
                this.nameMap.remove(weakConfigurable);
                Object t = weakConfigurable.get();
                if (t == null) continue;
                ((Configurable)t).registrationChanged(this, string, false, bl);
                if (configurable != null) continue;
                configurable = (Configurable)t;
            }
        } else {
            this.nameMap.remove(v);
            Object t = ((WeakConfigurable)v).get();
            if (t != null) {
                ((Configurable)t).registrationChanged(this, string, false, bl);
                configurable = (Configurable)t;
            }
        }
        this.configurables.remove(string);
        if (bl && configurable != null) {
            try {
                Properties properties = configurable.getConfigurableState();
                if (Configuration.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "unregisterAll(String,boolean)", 480).add("Keeping state: ")).add(properties)).log();
                }
                this.states.put(string, properties);
            }
            catch (RuntimeException runtimeException) {
                if (Configuration.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "unregisterAll(String,boolean)", 483).add("ex", runtimeException)).log();
                }
            }
        } else {
            this.names.removeElement(string);
            this.states.remove(string);
        }
        if (Configuration.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "unregisterAll(String,boolean)", 489).add("nameMap", this.nameMap)).log();
        }
    }

    public String getRegistrationName(Configurable configurable) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRegistrationName(Configurable)", 504).addDetail("configurable", configurable)).log();
        }
        return (String)this.nameMap.get(configurable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream outputStream) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "save(OutputStream)", 521).addDetail("out", outputStream)).log();
        }
        this.clearReferenceQueue();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, confFileCharset));
        try {
            if (this.comment != null) {
                this.printComment(printWriter, this.comment);
            }
            Vector vector = this.names;
            if (this.sortNames) {
                Vector vector2 = new Vector(vector);
                Collections.sort(vector2, Collator.getInstance(new Locale("en")));
                vector = vector2;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                if (Configuration.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "save(OutputStream)", 541).add("name", string)).log();
                }
                Object v = this.configurables.get(string);
                Properties properties = null;
                if (Configuration.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "save(OutputStream)", 545).add("state", properties)).log();
                }
                if ((properties = v instanceof Vector ? ((Configurable)((Vector)v).elementAt(0)).getConfigurableState() : (v instanceof Configurable ? ((Configurable)v).getConfigurableState() : (Properties)this.states.get(string))) == null) {
                    if (Configuration.logger.level < 3) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "save(OutputStream)", 558).add("No state for ")).add(string)).log();
                    continue;
                }
                if (i > 0) {
                    printWriter.println();
                }
                printWriter.print("[");
                printWriter.print(string);
                printWriter.println("]");
                String string2 = (String)this.comments.get(string);
                if (Configuration.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "save(OutputStream)", 569).add("cmt", string2)).log();
                }
                if (string2 != null) {
                    this.printComment(printWriter, string2);
                }
                printWriter.print(this.writeProps(properties));
                printWriter.flush();
            }
        }
        finally {
            block18: {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable) {
                    if (Configuration.logger.level < 9) break block18;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "save(OutputStream)", 580).add("t", throwable)).log();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(InputStream inputStream) throws IOException {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "restore(InputStream)", 597).addDetail("in", inputStream)).log();
        }
        this.clearReferenceQueue();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, confFileCharset));
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.fetchLine(bufferedReader);
            string = this.fetchComment(string, bufferedReader, stringBuffer);
            this.comment = stringBuffer.toString().trim();
            try {
                this.silenced.addElement(Thread.currentThread());
                while (string != null) {
                    if (string.startsWith("[") && string.endsWith("]")) {
                        String string2 = string.substring(1, string.length() - 1);
                        stringBuffer = new StringBuffer();
                        string = this.fetchComment(this.fetchLine(bufferedReader), bufferedReader, stringBuffer);
                        String string3 = stringBuffer.toString().trim();
                        if (string3.length() > 0) {
                            this.comments.put(string2, string3);
                        }
                        stringBuffer = new StringBuffer();
                        string = this.fetchContent(string, bufferedReader, stringBuffer);
                        Properties properties = this.readProps(stringBuffer.toString());
                        Object v = this.configurables.get(string2);
                        if (properties != null) {
                            this.states.put(string2, properties);
                        }
                        if (v instanceof Vector) {
                            for (int i = 0; i < ((Vector)v).size(); ++i) {
                                ((Configurable)((Vector)v).elementAt(i)).setConfigurableState(properties);
                            }
                        } else if (v != null) {
                            ((Configurable)v).setConfigurableState(properties);
                        }
                        if (this.names.contains(string2)) continue;
                        this.names.addElement(string2);
                        continue;
                    }
                    throw new IOException("Malformed Configuration InputStream");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IOException("Malformed Configuration InputStream");
            }
            finally {
                this.silenced.removeElement(Thread.currentThread());
            }
        }
        finally {
            block22: {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable) {
                    if (Configuration.logger.level < 9) break block22;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "restore(InputStream)", 652).add("t", throwable)).log();
                }
            }
        }
    }

    public void setComment(String string) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setComment(String)", 665).addDetail("comment", string)).log();
        }
        this.clearReferenceQueue();
        this.comment = string;
    }

    public void setComment(String string, String string2) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setComment(String,String)", 678).addDetail("name", string)).addDetail("comment", string2)).log();
        }
        this.clearReferenceQueue();
        this.comments.put(string, string2);
    }

    public String getComment() {
        if (Configuration.logger.level >= 7) {
            logger.lvlBuild(7, "getComment()", 691).log();
        }
        this.clearReferenceQueue();
        return this.comment;
    }

    public String getComment(String string) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getComment(String)", 705).addDetail("name", string)).log();
        }
        this.clearReferenceQueue();
        return (String)this.comments.get(string);
    }

    public final boolean isSortNames() {
        if (Configuration.logger.level >= 7) {
            logger.lvlBuild(7, "isSortNames()", 720).log();
        }
        return this.sortNames;
    }

    public final void setSortNames(boolean bl) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSortNames(boolean)", 733).addDetail("sortNames", bl)).log();
        }
        this.sortNames = bl;
    }

    public void addConfigurationListener(ConfigurationListener configurationListener) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addConfigurationListener(ConfigurationListener)", 750).addDetail("listener", configurationListener)).log();
        }
        this.clearReferenceQueue();
        this.listeners.addElement(configurationListener);
    }

    public void removeConfigurationListener(ConfigurationListener configurationListener) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeConfigurationListener(ConfigurationListener)", 765).addDetail("listener", configurationListener)).log();
        }
        this.clearReferenceQueue();
        this.listeners.removeElement(configurationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(Configurable configurable) {
        Object object;
        int n;
        Object object2;
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "stateChanged(Configurable)", 786).addDetail("configurable", configurable)).log();
        }
        this.clearReferenceQueue();
        if (this.silenced.contains(Thread.currentThread())) {
            return;
        }
        String string = (String)this.nameMap.get(configurable);
        if (string == null) {
            if (Configuration.logger.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "stateChanged(Configurable)", 796).add("unregistered Configurable: ")).add(configurable)).log();
            }
            return;
        }
        Object object3 = this;
        synchronized (object3) {
            object2 = this.configurables.get(string);
            if (object2 instanceof Vector) {
                if (Configuration.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "stateChanged(Configurable)", 803).add("old", object2)).log();
                }
                if ((n = ((Vector)object2).indexOf(new WeakConfigurable(configurable))) > 0) {
                    object = ((Vector)object2).remove(n);
                    ((Vector)object2).insertElementAt(object, 0);
                    if (Configuration.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "stateChanged(Configurable)", 809).add("old", object2)).log();
                    }
                }
            }
        }
        object3 = configurable.getConfigurableState();
        if (Configuration.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "stateChanged(Configurable)", 815).add("newState", object3)).log();
        }
        object2 = (Properties)this.states.get(string);
        this.states.put(string, object3);
        if (this.listeners.size() == 0) {
            return;
        }
        if (object2 != null) {
            int n2 = n = ((Properties)object3).size() == ((Properties)object2).size() ? 1 : 0;
            if (n != 0) {
                object = ((Properties)object2).keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    if (((Properties)object2).get(string2).equals(((Properties)object3).get(string2))) continue;
                    n = 0;
                    break;
                }
            }
            if (n != 0) {
                return;
            }
        }
        ConfigurationEvent configurationEvent = new ConfigurationEvent(configurable, string, (Properties)object3);
        object = (Vector)this.listeners.clone();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            ((ConfigurationListener)((Vector)object).elementAt(i)).stateChanged(configurationEvent);
        }
    }

    private String writeProps(Properties properties) {
        Object object;
        block7: {
            if (Configuration.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "writeProps(Properties)", 864).addDetail("state", properties)).log();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            SortedProperties sortedProperties = new SortedProperties();
            object = properties.keys();
            while (object.hasMoreElements()) {
                Object object2 = object.nextElement();
                sortedProperties.put(object2, properties.get(object2));
            }
            try {
                sortedProperties.store(byteArrayOutputStream, "");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = null;
            try {
                object = new String(byteArrayOutputStream.toByteArray(), Misc.LATIN1_CHARSET.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (Configuration.logger.level < 1) break block7;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "writeProps(Properties)", 891).add("ISO-8859-1 encoding not known ...")).log();
            }
        }
        while (((String)object).length() > 0 && ((String)object).charAt(0) == '#' && ((String)object).indexOf(LINESEP) > 0) {
            object = ((String)object).substring(((String)object).indexOf(LINESEP) + LINESEP.length());
        }
        return object;
    }

    private Properties readProps(String string) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "readProps(String)", 911).addDetail("input", string)).log();
        }
        Properties properties = new Properties();
        try {
            byte[] byArray = string.getBytes(Misc.LATIN1_CHARSET.name());
            properties.load(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            logger.log("readProps(String)", iOException);
        }
        return properties;
    }

    private void printComment(PrintWriter printWriter, String string) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "printComment(PrintWriter,String)", 938).addDetail("out", printWriter)).addDetail("comment", string)).log();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINESEP, true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(0);
            if (c == '\n' || c == '\r') {
                bl = false;
            } else {
                bl = true;
                if (!this.isComment(string2)) {
                    printWriter.print("# ");
                }
            }
            printWriter.print(string2);
        }
        if (bl) {
            printWriter.println();
        }
    }

    private boolean isComment(String string) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "isComment(String)", 975).addDetail("line", string)).log();
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '#') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private String fetchLine(BufferedReader bufferedReader) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "fetchLine(BufferedReader)", 1000).addDetail("br", bufferedReader)).log();
        }
        try {
            String string = bufferedReader.readLine();
            return string;
        }
        catch (IOException iOException) {
            logger.log("fetchLine(BufferedReader)", iOException);
            return null;
        }
    }

    private String fetchComment(String string, BufferedReader bufferedReader, StringBuffer stringBuffer) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fetchComment(String,BufferedReader,StringBuffer)", 1026).addDetail("line", string)).addDetail("br", bufferedReader)).addDetail("sb", stringBuffer)).log();
        }
        while (string != null && this.isComment(string)) {
            stringBuffer.append(string);
            stringBuffer.append(LINESEP);
            string = this.fetchLine(bufferedReader);
        }
        return string;
    }

    private String fetchContent(String string, BufferedReader bufferedReader, StringBuffer stringBuffer) {
        if (Configuration.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fetchContent(String,BufferedReader,StringBuffer)", 1055).addDetail("line", string)).addDetail("br", bufferedReader)).addDetail("sb", stringBuffer)).log();
        }
        while (string != null && !string.startsWith("[")) {
            if (!this.isComment(string)) {
                stringBuffer.append(string);
                stringBuffer.append(LINESEP);
            }
            string = this.fetchLine(bufferedReader);
        }
        return string;
    }

    private void clearReferenceQueue() {
        WeakConfigurable weakConfigurable;
        if (Configuration.logger.level >= 7) {
            logger.lvlBuild(7, "clearReferenceQueue()", 1077).log();
        }
        while ((weakConfigurable = (WeakConfigurable)this.refQueue.poll()) != null) {
            if (Configuration.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "clearReferenceQueue()", 1084).add("wconf", weakConfigurable)).log();
            }
            Object t = weakConfigurable.get();
            String string = (String)this.nameMap.remove(weakConfigurable);
            if (Configuration.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "clearReferenceQueue()", 1090).add("name", string)).log();
            }
            if (string != null) {
                Object v = this.configurables.get(string);
                if (v instanceof Vector) {
                    ((Vector)v).removeElement(weakConfigurable);
                    if (((Vector)v).size() == 0) {
                        this.configurables.remove(string);
                    }
                } else if (weakConfigurable.equals(v)) {
                    this.configurables.remove(string);
                }
            }
            if (Configuration.logger.level < 9) continue;
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "clearReferenceQueue()", 1102).add("nameMap", this.nameMap)).log();
        }
    }

    protected class WeakConfigurable
    extends WeakReference
    implements Configurable {
        private String name;
        private int hash;

        public WeakConfigurable(Configurable configurable) {
            super(configurable, Configuration.this.refQueue);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "WeakConfigurable.WeakConfigurable(Configurable)", 1138).addDetail("configurable", configurable)).log();
            }
            this.name = configurable.getConfigurableName();
            this.hash = configurable.hashCode();
        }

        @Override
        public void setConfigurableName(String string) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "WeakConfigurable.setConfigurableName(String)", 1155).addDetail("name", string)).log();
            }
            this.name = string;
            Configurable configurable = (Configurable)this.get();
            if (configurable != null) {
                configurable.setConfigurableName(string);
            }
        }

        @Override
        public String getConfigurableName() {
            Configurable configurable;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "WeakConfigurable.getConfigurableName()", 1173).log();
            }
            if ((configurable = (Configurable)this.get()) != null) {
                this.name = configurable.getConfigurableName();
            }
            return this.name;
        }

        @Override
        public Properties getConfigurableState() {
            Configurable configurable;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "WeakConfigurable.getConfigurableState()", 1191).log();
            }
            if ((configurable = (Configurable)this.get()) != null) {
                return configurable.getConfigurableState();
            }
            return new Properties();
        }

        @Override
        public void setConfigurableState(Properties properties) {
            Configurable configurable;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "WeakConfigurable.setConfigurableState(Properties)", 1209).addDetail("state", properties)).log();
            }
            if ((configurable = (Configurable)this.get()) != null) {
                configurable.setConfigurableState(properties);
            }
        }

        @Override
        public void registrationChanged(Configuration configuration, String string, boolean bl, boolean bl2) {
            Configurable configurable;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "WeakConfigurable.registrationChanged(Configuration,String,boolean,boolean)", 1234).addDetail("config", configuration)).addDetail("name", string)).addDetail("registered", bl)).addDetail("valuesKept", bl2)).log();
            }
            if ((configurable = (Configurable)this.get()) != null) {
                configurable.registrationChanged(configuration, string, bl, bl2);
            }
        }

        public int hashCode() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "WeakConfigurable.hashCode()", 1256).log();
            }
            return this.hash;
        }

        public boolean equals(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "WeakConfigurable.equals(Object)", 1274).addDetail("o", object)).log();
            }
            if (object == this) {
                return true;
            }
            Object t = this.get();
            Object object2 = object instanceof WeakReference ? ((WeakReference)object).get() : object;
            return t != null && t.equals(object2);
        }

        public String toString() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "WeakConfigurable.toString()", 1294).log();
            }
            return "WeakConfigurable@" + Integer.toHexString(super.hashCode()) + "[" + this.get() + "]";
        }
    }
}

