/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.config;

import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.util.Enumeration;
import java.util.Vector;
import lombok.Generated;

public class Configurator {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.config.Configurator");
    private Vector registered;
    private String name;
    private String fullname;
    private Configurator parent;
    private Vector children = new Vector();

    public Configurator(String string) {
        if (Configurator.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "Configurator(String)", 99).addDetail("name", string)).log();
        }
        this.name = string;
        this.registered = new Vector();
    }

    public void add(Configurable configurable) {
        if (Configurator.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "add(Configurable)", 117).addDetail("configurable", configurable)).log();
        }
        if (this.children.contains(configurable)) {
            if (Configurator.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "add(Configurable)", 121).add("Already added", configurable)).log();
            }
            return;
        }
        this.children.addElement(configurable);
        if (Configurator.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "add(Configurable)", 125).add("children", this.children)).log();
        }
        Enumeration enumeration = this.registered.elements();
        while (enumeration.hasMoreElements()) {
            ((Configuration)enumeration.nextElement()).registerAs(configurable, this.getName() + "." + configurable.getConfigurableName());
        }
    }

    public void add(Configurator configurator) {
        if (Configurator.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "add(Configurator)", 143).addDetail("configurator", configurator)).log();
        }
        if (this.children.contains(configurator)) {
            if (Configurator.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "add(Configurator)", 147).add("Already added", configurator)).log();
            }
            return;
        }
        this.children.addElement(configurator);
        if (Configurator.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "add(Configurator)", 151).add("children", this.children)).log();
        }
        configurator.setParent(this);
        Enumeration enumeration = this.registered.elements();
        while (enumeration.hasMoreElements()) {
            configurator.register((Configuration)enumeration.nextElement());
        }
    }

    public void remove(Configurable configurable, boolean bl) {
        if (Configurator.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "remove(Configurable,boolean)", 172).addDetail("configurable", configurable)).addDetail("keepValues", bl)).log();
        }
        if (this.children.removeElement(configurable)) {
            Enumeration enumeration = this.registered.elements();
            while (enumeration.hasMoreElements()) {
                ((Configuration)enumeration.nextElement()).unregisterAs(configurable, this.getName() + "." + configurable.getConfigurableName(), bl);
            }
        } else if (Configurator.logger.level >= 3) {
            ((LevelAwareLogBuilder)logger.lvlBuild(3, "remove(Configurable,boolean)", 184).add("Unknown configurable", configurable)).log();
        }
    }

    public void remove(Configurator configurator, boolean bl) {
        if (Configurator.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "remove(Configurator,boolean)", 198).addDetail("configurator", configurator)).addDetail("keepValues", bl)).log();
        }
        if (this.children.contains(configurator)) {
            Enumeration enumeration = this.registered.elements();
            while (enumeration.hasMoreElements()) {
                configurator.unregister((Configuration)enumeration.nextElement(), bl);
            }
            this.children.removeElement(configurator);
            configurator.setParent(null);
        } else if (Configurator.logger.level >= 3) {
            ((LevelAwareLogBuilder)logger.lvlBuild(3, "remove(Configurator,boolean)", 209).add("Unknown configurator", configurator)).log();
        }
    }

    public boolean isRegistered() {
        return this.isRegistered(Configuration.instance());
    }

    public boolean isRegistered(Configuration configuration) {
        return this.registered.contains(configuration);
    }

    public void register() {
        if (Configurator.logger.level >= 7) {
            logger.lvlBuild(7, "register()", 250).log();
        }
        this.register(Configuration.instance());
    }

    public void register(Configuration configuration) {
        if (Configurator.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "register(Configuration)", 263).addDetail("configuration", configuration)).log();
        }
        if (this.registered.contains(configuration)) {
            if (Configurator.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "register(Configuration)", 266).add("Already registered.")).log();
            }
            return;
        }
        this.fullname = this.getName();
        if (Configurator.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "register(Configuration)", 270).add("children", this.children)).log();
        }
        this.registered.addElement(configuration);
        Vector vector = (Vector)this.children.clone();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (Configurator.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "register(Configuration)", 277).add("child: [")).add(i)).add("[")).add(e)).log();
            }
            if (!this.children.contains(e)) {
                if (Configurator.logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "register(Configuration)", 279).add("Child removed")).log();
                continue;
            }
            if (e instanceof Configurator) {
                ((Configurator)e).register(configuration);
                continue;
            }
            configuration.registerAs((Configurable)e, this.getName() + "." + ((Configurable)e).getConfigurableName());
        }
    }

    public void unregister(boolean bl) {
        if (Configurator.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "unregister(boolean)", 302).addDetail("keepValues", bl)).log();
        }
        this.unregister(Configuration.instance(), bl);
    }

    public void unregister(Configuration configuration, boolean bl) {
        if (Configurator.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "unregister(Configuration,boolean)", 314).addDetail("configuration", configuration)).addDetail("keepValues", bl)).log();
        }
        if (!this.registered.contains(configuration)) {
            if (Configurator.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "unregister(Configuration,boolean)", 317).add("Not registered.")).log();
            }
            return;
        }
        Vector vector = (Vector)this.children.clone();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (Configurator.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "unregister(Configuration,boolean)", 325).add("child: [")).add(i)).add("[")).add(e)).log();
            }
            if (!this.children.contains(e)) {
                if (Configurator.logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "unregister(Configuration,boolean)", 327).add("Child removed")).log();
                continue;
            }
            if (e instanceof Configurator) {
                ((Configurator)e).unregister(configuration, bl);
                continue;
            }
            configuration.unregisterAs((Configurable)e, this.getName() + "." + ((Configurable)e).getConfigurableName(), bl);
        }
        this.registered.removeElement(configuration);
    }

    public String getName() {
        if (this.registered.size() > 0) {
            return this.fullname;
        }
        if (this.parent != null) {
            return this.parent.getName() + "." + this.name;
        }
        return this.name;
    }

    public Configurator copy() {
        Configurator configurator = new Configurator(this.name);
        for (int i = 0; i < this.children.size(); ++i) {
            Object e = this.children.elementAt(i);
            if (e instanceof Configurator) {
                configurator.add(((Configurator)e).copy());
                continue;
            }
            configurator.add((Configurable)e);
        }
        return configurator;
    }

    protected void setParent(Configurator configurator) {
        if (Configurator.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setParent(Configurator)", 405).addDetail("parent", configurator)).log();
        }
        this.parent = configurator;
    }
}

