/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.config;

import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Component;
import java.awt.Point;
import java.util.Properties;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicToolBarUI;
import lombok.Generated;

public class JToolBarConfigWrapper
extends ConfigWrapper {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.config.JToolBarConfigWrapper");
    protected JToolBar toolbar;

    public JToolBarConfigWrapper() {
        if (JToolBarConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "JToolBarConfigWrapper()", 71).log();
        }
        this.setConfigurableName("toolbar");
    }

    @Override
    protected void setClient(Object object) {
        if (JToolBarConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setClient(Object)", 86).addDetail("client", object)).log();
        }
        this.toolbar = (JToolBar)object;
    }

    @Override
    public Properties getConfigurableState() {
        if (JToolBarConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "getConfigurableState()", 98).log();
        }
        Properties properties = new Properties();
        BasicToolBarUI basicToolBarUI = null;
        if (this.toolbar.getUI() instanceof BasicToolBarUI) {
            basicToolBarUI = (BasicToolBarUI)this.toolbar.getUI();
        }
        properties.put("floating", "" + (basicToolBarUI != null && basicToolBarUI.isFloating()));
        if (basicToolBarUI != null && basicToolBarUI.isFloating()) {
            Point point = SwingUtilities.getRootPane(this.toolbar).getParent().getLocation();
            properties.put("x", "" + point.x);
            properties.put("y", "" + point.y);
        } else {
            String string;
            if (this.toolbar.getParent() == null) {
                string = "North";
            } else {
                int n = this.toolbar.getLocation().x - this.toolbar.getParent().getInsets().left;
                int n2 = this.toolbar.getLocation().y - this.toolbar.getParent().getInsets().top;
                int n3 = this.toolbar.getSize().width + this.toolbar.getParent().getInsets().left + this.toolbar.getParent().getInsets().right;
                if (JToolBarConfigWrapper.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getConfigurableState()", 125).add("x: ")).add("x", n)).add(", y: ")).add("y", n2)).add(", width: ")).add("width", n3)).add(", parent: ")).add("toolbar.getParent()", this.toolbar.getParent())).add(", parent insets: ")).add("toolbar.getParent().getInsets()", this.toolbar.getParent().getInsets())).log();
                }
                string = n3 > this.toolbar.getParent().getSize().width - 10 && n3 < this.toolbar.getParent().getSize().width + 10 ? (n2 == 0 ? "North" : "South") : (n == 0 ? "West" : "East");
            }
            properties.put("anchor", string);
        }
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        if (JToolBarConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setConfigurableState(Properties)", 159).addDetail("state", properties)).log();
        }
        String string = properties.getProperty("floating");
        if (JToolBarConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 162).add("floating", string)).log();
        }
        if (string == null) {
            if (JToolBarConfigWrapper.logger.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 164).add("Invalid state: floating: ")).add(string)).log();
            }
            return;
        }
        BasicToolBarUI basicToolBarUI = null;
        if (this.toolbar.getUI() instanceof BasicToolBarUI) {
            basicToolBarUI = (BasicToolBarUI)this.toolbar.getUI();
        }
        if (basicToolBarUI != null && Boolean.valueOf(string).booleanValue()) {
            String string2 = properties.getProperty("x");
            String string3 = properties.getProperty("y");
            if (JToolBarConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 176).add("x: ")).add(string2)).add(", y: ")).add(string3)).log();
            }
            if (string2 == null || string3 == null) {
                if (JToolBarConfigWrapper.logger.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 178).add("Invalid state: x: ")).add(string2)).add(", y: ")).add(string3)).log();
                }
                return;
            }
            try {
                Point point = new Point(Integer.parseInt(string2), Integer.parseInt(string3));
                basicToolBarUI.setFloating(true, point);
                SwingUtilities.getRootPane(this.toolbar).getParent().setLocation(point);
            }
            catch (NumberFormatException numberFormatException) {
                if (JToolBarConfigWrapper.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 191).add("ex", numberFormatException)).log();
                }
            }
        } else {
            String string4 = properties.getProperty("anchor");
            if (JToolBarConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 195).add("anchor", string4)).log();
            }
            if (basicToolBarUI != null) {
                basicToolBarUI.setFloating(false, null);
            }
            this.toolbar.getParent().add((Component)this.toolbar, string4);
            if (basicToolBarUI != null) {
                if ("East".equals(string4) || "West".equals(string4)) {
                    basicToolBarUI.setOrientation(1);
                } else {
                    basicToolBarUI.setOrientation(0);
                }
            }
            this.toolbar.revalidate();
        }
    }
}

