/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.config;

import de.qfs.lib.config.FrameConfigWrapper;
import de.qfs.lib.gui.EventQueueMark;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.util.Properties;
import javax.swing.JFrame;
import lombok.Generated;

public class RelativeFrameConfigWrapper
extends FrameConfigWrapper {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.config.RelativeFrameConfigWrapper");
    protected Window master;
    protected Point location;
    protected String reference;
    protected EventQueueMark mark;
    protected boolean constrain;
    protected boolean storeSize;

    public RelativeFrameConfigWrapper(Frame frame, String string, boolean bl, boolean bl2) {
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RelativeFrameConfigWrapper(Frame,String,boolean,boolean)", 104).addDetail("frame", frame)).addDetail("name", string)).addDetail("constrain", bl)).addDetail("storeSize", bl2)).log();
        }
        this.frame = frame;
        this.constrain = bl;
        this.storeSize = bl2;
        this.setConfigurableName(string);
        this.getLocation();
    }

    public void setMaster(Window window) {
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setMaster(Window)", 126).addDetail("window", window)).log();
        }
        if (this.master != null) {
            this.master.removeComponentListener(this);
        }
        this.master = window;
        if (this.master != null) {
            this.master.removeComponentListener(this);
            this.master.addComponentListener(this);
        }
        if (this.master == null || "Absolute".equalsIgnoreCase(this.reference)) {
            this.getLocation();
            this.regHelper.stateChanged(this);
        } else {
            this.setLocation(this.frame.getSize());
        }
    }

    @Override
    public Properties getConfigurableState() {
        Object object;
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "getConfigurableState()", 155).log();
        }
        Properties properties = new Properties();
        properties.put("reference", this.reference);
        Point point = new Point(this.location);
        if ("Absolute".equalsIgnoreCase(this.reference) || this.master == null) {
            object = SwingUtil.getClosestGraphicsConfiguration(point.x, point.y);
            Rectangle rectangle = null;
            if (object != null) {
                rectangle = ((GraphicsConfiguration)object).getBounds();
                point.x -= rectangle.x;
                point.y -= rectangle.y;
                properties.put("gcx", "" + rectangle.x);
                properties.put("gcy", "" + rectangle.y);
            }
        }
        properties.put("x", "" + point.x);
        properties.put("y", "" + point.y);
        if (this.storeSize) {
            object = this.frame.getSize();
            properties.put("width", "" + ((Dimension)object).width);
            properties.put("height", "" + ((Dimension)object).height);
        }
        return properties;
    }

    @Override
    public void setConfigurableState(Properties properties) {
        String string;
        String string2;
        Dimension dimension;
        block27: {
            block25: {
                String string3;
                block24: {
                    String string4;
                    if (RelativeFrameConfigWrapper.logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "setConfigurableState(Properties)", 189).addDetail("state", properties)).log();
                    }
                    if ((string4 = properties.getProperty("x")) != null) {
                        try {
                            this.location.x = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (RelativeFrameConfigWrapper.logger.level < 3) break block24;
                            ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 196).add("ex", numberFormatException)).log();
                        }
                    }
                }
                if ((string3 = properties.getProperty("y")) != null) {
                    try {
                        this.location.y = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (RelativeFrameConfigWrapper.logger.level < 3) break block25;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 204).add("ex", numberFormatException)).log();
                    }
                }
            }
            if (properties.containsKey("reference")) {
                this.reference = properties.getProperty("reference");
            }
            dimension = this.frame.getSize();
            if (this.storeSize) {
                block26: {
                    string2 = properties.getProperty("width");
                    if (string2 != null) {
                        try {
                            dimension.width = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (RelativeFrameConfigWrapper.logger.level < 3) break block26;
                            ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 219).add("ex", numberFormatException)).log();
                        }
                    }
                }
                if ((string = properties.getProperty("height")) != null) {
                    try {
                        dimension.height = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (RelativeFrameConfigWrapper.logger.level < 3) break block27;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 228).add("ex", numberFormatException)).log();
                    }
                }
            }
        }
        if ("Absolute".equalsIgnoreCase(this.reference) || this.master == null) {
            Cloneable cloneable;
            GraphicsConfiguration graphicsConfiguration;
            block28: {
                string2 = properties.getProperty("gcx");
                string = properties.getProperty("gcy");
                graphicsConfiguration = null;
                try {
                    if (string2 != null && string != null) {
                        graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(Integer.parseInt(string2), Integer.parseInt(string));
                        if (RelativeFrameConfigWrapper.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 242).add("gc", graphicsConfiguration)).log();
                        }
                        if (RelativeFrameConfigWrapper.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 243).add("bounds: ")).add("gc.getBounds()", graphicsConfiguration.getBounds())).log();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (RelativeFrameConfigWrapper.logger.level < 3) break block28;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "setConfigurableState(Properties)", 246).add("ex", numberFormatException)).log();
                }
            }
            if (graphicsConfiguration != null) {
                cloneable = graphicsConfiguration.getBounds();
                this.location.x += cloneable.x;
                this.location.y += cloneable.y;
            } else {
                graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(this.location.x, this.location.y);
            }
            cloneable = SwingUtil.getLocationInsideGraphicsConfiguration(new Rectangle(this.location.x, this.location.y, dimension.width, dimension.height), graphicsConfiguration);
            if (RelativeFrameConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setConfigurableState(Properties)", 257).add("pos", cloneable)).log();
            }
            this.location.x = ((Point)cloneable).x;
            this.location.y = ((Point)cloneable).y;
        }
        this.setLocation(dimension);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "componentMoved(ComponentEvent)", 278).addDetail("e", componentEvent)).log();
        }
        if (componentEvent.getSource() == this.master) {
            this.getLocation();
            return;
        }
        if (componentEvent.getSource() == this.frame) {
            if (this.mark != null && this.mark.isActive()) {
                return;
            }
            this.getLocation();
            super.componentMoved(componentEvent);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "componentResized(ComponentEvent)", 302).addDetail("e", componentEvent)).log();
        }
        if (this.storeSize && componentEvent.getSource() == this.frame) {
            super.componentResized(componentEvent);
        }
    }

    @Override
    protected void restore(final Dimension dimension, final Point point) {
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "restore(Dimension,Point)", 323).addDetail("size", dimension)).addDetail("location", point)).log();
        }
        if (this.mark == null) {
            this.mark = new EventQueueMark();
        }
        this.mark.activate(200);
        if (this.frame instanceof JFrame) {
            SwingUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "restore(Dimension,Point).Runnable.run()", 332).log();
                    }
                    RelativeFrameConfigWrapper.this.frame.setLocation(point);
                    RelativeFrameConfigWrapper.this.frame.pack();
                    RelativeFrameConfigWrapper.this.frame.setSize(dimension);
                    RelativeFrameConfigWrapper.this.frame.validate();
                }
            });
        } else {
            this.frame.setLocation(point);
            this.frame.pack();
            this.frame.setSize(dimension);
            this.frame.validate();
        }
        this.mark.activate();
    }

    protected void setLocation(Dimension dimension) {
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setLocation(Dimension)", 356).addDetail("size", dimension)).log();
        }
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setLocation(Dimension)", 358).add("location", this.location)).log();
        }
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setLocation(Dimension)", 359).add("reference", this.reference)).log();
        }
        Point point = new Point(this.location);
        if ("Absolute".equalsIgnoreCase(this.reference) || this.master == null) {
            this.restore(dimension, point);
            return;
        }
        Point point2 = this.master.getLocation();
        Dimension dimension2 = this.master.getSize();
        if (RelativeFrameConfigWrapper.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setLocation(Dimension)", 369).add("mPos", point2)).add("mSize", dimension2)).log();
        }
        if ("Northwest".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x, point2.y);
        } else if ("Northeast".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x + dimension2.width, point2.y);
        } else if ("Southwest".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x, point2.y + dimension2.height);
        } else if ("Southeast".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x + dimension2.width, point2.y + dimension2.height);
        } else if ("Center".equalsIgnoreCase(this.reference)) {
            point.translate(point2.x + dimension2.width / 2, point2.y + dimension2.height / 2);
        }
        if (this.constrain) {
            Dimension dimension3 = this.frame.getToolkit().getScreenSize();
            GraphicsConfiguration graphicsConfiguration = SwingUtil.getClosestGraphicsConfiguration(point2.x, point2.y);
            if (RelativeFrameConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setLocation(Dimension)", 385).add("gc", graphicsConfiguration)).log();
            }
            Rectangle rectangle = graphicsConfiguration == null ? new Rectangle(0, 0, dimension3.width, dimension3.height) : graphicsConfiguration.getBounds();
            if (RelativeFrameConfigWrapper.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setLocation(Dimension)", 392).add("bounds", rectangle)).log();
            }
            point.x = Math.min(point.x, rectangle.x + rectangle.width - dimension.width);
            point.y = Math.min(point.y, rectangle.y + rectangle.height - dimension.height);
            point.x = Math.max(point.x, rectangle.x);
            point.y = Math.max(point.y, rectangle.y);
        }
        this.restore(dimension, point);
    }

    protected void getLocation() {
        if (RelativeFrameConfigWrapper.logger.level >= 7) {
            logger.lvlBuild(7, "getLocation()", 407).log();
        }
        this.location = this.frame.getLocation();
        if (this.master == null) {
            this.reference = "Absolute";
            return;
        }
        Dimension dimension = this.frame.getSize();
        Point point = new Point(this.location.x + dimension.width / 2, this.location.y + dimension.height / 2);
        Point point2 = this.master.getLocation();
        Dimension dimension2 = this.master.getSize();
        double d = Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y));
        this.reference = "Northwest";
        Point point3 = new Point(this.location.x - point2.x, this.location.y - point2.y);
        double d2 = Math.sqrt((point.x - point2.x - dimension2.width) * (point.x - point2.x - dimension2.width) + (point.y - point2.y) * (point.y - point2.y));
        if (d2 < d) {
            d = d2;
            this.reference = "Northeast";
            point3 = new Point(this.location.x - point2.x - dimension2.width, this.location.y - point2.y);
        }
        if ((d2 = Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y - dimension2.height) * (point.y - point2.y - dimension2.height))) < d) {
            d = d2;
            this.reference = "Southwest";
            point3 = new Point(this.location.x - point2.x, this.location.y - point2.y - dimension2.height);
        }
        if ((d2 = Math.sqrt((point.x - point2.x - dimension2.width) * (point.x - point2.x - dimension2.width) + (point.y - point2.y - dimension2.height) * (point.y - point2.y - dimension2.height))) < d) {
            d = d2;
            this.reference = "Southeast";
            point3 = new Point(this.location.x - point2.x - dimension2.width, this.location.y - point2.y - dimension2.height);
        }
        if ((d2 = Math.sqrt((point.x - point2.x - dimension2.width / 2) * (point.x - point2.x - dimension2.width / 2) + (point.y - point2.y - dimension2.height / 2) * (point.y - point2.y - dimension2.height / 2))) < d) {
            d = d2;
            this.reference = "Center";
            point3 = new Point(this.location.x - point2.x - dimension2.width / 2, this.location.y - point2.y - dimension2.height / 2);
        }
        this.location = point3;
    }
}

