/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.ui.FlatScrollPane;
import de.qfs.lib.util.Reflector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lombok.Generated;

public class BetterScrollPane
extends FlatScrollPane {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.gui.BetterScrollPane");
    public static final String PARENT = "BetterScrollPane.Parent";
    private boolean smooth = true;

    public BetterScrollPane() {
    }

    public BetterScrollPane(Component component) {
        super(component);
    }

    public BetterScrollPane(Component component, int n, int n2) {
        super(component, n, n2);
    }

    public BetterScrollPane(int n, int n2) {
        super(n, n2);
    }

    public final boolean isSmooth() {
        return this.smooth;
    }

    public final void setSmooth(boolean bl) {
        if (BetterScrollPane.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSmooth(boolean)", 150).addDetail("smooth", bl)).log();
        }
        this.smooth = bl;
    }

    @Override
    public void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        boolean bl;
        JScrollPane jScrollPane;
        if (BetterScrollPane.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "processMouseWheelEvent(MouseWheelEvent)", 169).addDetail("e", mouseWheelEvent)).log();
        }
        if ((jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this)) == null || jScrollPane.getVerticalScrollBar() == null || !jScrollPane.getVerticalScrollBar().isShowing()) {
            this.scroll(mouseWheelEvent);
            return;
        }
        Rectangle rectangle = this.getViewport().getViewRect();
        boolean bl2 = bl = this.getVerticalScrollBar() == null || !this.getVerticalScrollBar().isShowing() || mouseWheelEvent.getWheelRotation() < 0 && rectangle.y == 0 || mouseWheelEvent.getWheelRotation() > 0 && rectangle.y + rectangle.height == this.getViewport().getView().getHeight();
        if (!bl) {
            Container container = this;
            for (Container container2 = this.getParent(); container2 != null && container2 != jScrollPane; container2 = container2.getParent()) {
                if (!(container2 instanceof JComponent) || ((JComponent)container2).getClientProperty(PARENT) == null) continue;
                container = container2;
                break;
            }
            if (BetterScrollPane.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "processMouseWheelEvent(MouseWheelEvent)", 200).add("parent", container)).log();
            }
            Rectangle rectangle2 = SwingUtilities.convertRectangle(container, SwingUtilities.getLocalBounds(container), jScrollPane);
            Dimension dimension = jScrollPane.getSize();
            if (mouseWheelEvent.getWheelRotation() < 0 && rectangle2.y < 0 || mouseWheelEvent.getWheelRotation() > 0 && rectangle2.y + rectangle2.height > dimension.height) {
                bl = true;
            }
        }
        if (!bl) {
            this.scroll(mouseWheelEvent);
            return;
        }
        try {
            Reflector.call((Object)this, "dispatchMouseWheelToAncestor", MouseWheelEvent.class, (Object)mouseWheelEvent, true);
        }
        catch (Throwable throwable) {
            if (BetterScrollPane.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "processMouseWheelEvent(MouseWheelEvent)", 219).add("ex", throwable)).log();
            }
            this.scroll(mouseWheelEvent);
        }
    }

    protected void scroll(MouseWheelEvent mouseWheelEvent) {
        if (this.smooth) {
            super.processMouseWheelEvent(mouseWheelEvent);
        } else {
            JScrollBar jScrollBar = this.getVerticalScrollBar();
            if (jScrollBar.isShowing()) {
                int n = jScrollBar.getValue();
                if (BetterScrollPane.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "scroll(MouseWheelEvent)", 246).add("val", n)).log();
                }
                int n2 = jScrollBar.getUnitIncrement();
                if (BetterScrollPane.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "scroll(MouseWheelEvent)", 248).add("incr", n2)).log();
                }
                n += n2 * mouseWheelEvent.getWheelRotation() * mouseWheelEvent.getScrollAmount();
                if (BetterScrollPane.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "scroll(MouseWheelEvent)", 250).add("val", n)).log();
                }
                jScrollBar.setValue(n);
            } else {
                super.processMouseWheelEvent(mouseWheelEvent);
            }
        }
    }
}

