/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.SVGIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import javax.swing.ImageIcon;

public class BlockModeConverter
implements SVGIcon.ImageIconConverter {
    public boolean pigmode = false;
    public boolean reduceColor = true;
    public int reduceColorSize = 64;
    public boolean pixels = true;
    public int pixelSize = 2;
    public boolean finnerPixels = false;
    public boolean transparency = false;
    public boolean moveDown = true;
    public boolean makeBox = true;
    public boolean randomChangeColorBlock = true;
    public boolean applySobel = true;

    public int getR(int n) {
        return (n & 0xFF0000) >>> 16;
    }

    public int getG(int n) {
        return (n & 0xFF00) >>> 8;
    }

    public int getB(int n) {
        return n & 0xFF;
    }

    public int getA(int n) {
        return (n & 0xFF000000) >>> 24;
    }

    public int toInt(int n, int n2, int n3, int n4) {
        return ((n & 0xFF) << 24) + (n4 & 0xFF) + ((n3 & 0xFF) << 8) + ((n2 & 0xFF) << 16);
    }

    public int reduceInt(int n) {
        if (n >= 255 - this.reduceColorSize / 2) {
            return 255;
        }
        int n2 = (int)(Math.round((double)n / (1.0 * (double)this.reduceColorSize)) * (long)this.reduceColorSize);
        return n2;
    }

    public int reduce(int n) {
        int n2 = this.reduceInt(this.getA(n));
        int n3 = this.reduceInt(this.getR(n));
        int n4 = this.reduceInt(this.getG(n));
        int n5 = this.reduceInt(this.getB(n));
        return this.toInt(n2, n3, n4, n5);
    }

    public int toLInt(int n, int n2, int n3, int n4) {
        n2 = Math.max(n2 - 32, 0);
        n3 = Math.max(n3 - 32, 0);
        n4 = Math.max(n4 - 32, 0);
        return this.toInt(n, n2, n3, n4);
    }

    public int toDInt(int n, int n2, int n3, int n4) {
        n2 = Math.min(n2 + 16, 255);
        n3 = Math.min(n3 + 16, 255);
        n4 = Math.min(n4 + 16, 255);
        return this.toInt(n, n2, n3, n4);
    }

    public int toMInt(int n, int n2, int n3, int n4) {
        n2 = Math.min(n2, 255);
        n3 = Math.min(n3, 255);
        n4 = Math.min(n4, 255);
        return this.toInt(n, n2, n3, n4);
    }

    public int mediumColorChange(int n) {
        float[] fArray = new float[3];
        int n2 = this.getR(n);
        int n3 = this.getG(n);
        int n4 = this.getB(n);
        Color.RGBtoHSB(n2, n3, n4, fArray);
        float f = 0.05f * ((float)Math.random() - 0.5f);
        float f2 = 0.1f * ((float)Math.random() - 0.5f);
        float f3 = 0.1f * ((float)Math.random() - 0.5f);
        fArray[0] = fArray[0] + f;
        fArray[1] = Math.max(0.0f, Math.min(1.0f, fArray[1] + f2));
        fArray[2] = Math.max(0.0f, Math.min(1.0f, fArray[2] + f3));
        int n5 = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]);
        return n5;
    }

    private static void sobel(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        float[][] fArrayArray = new float[][]{{-1.0f, 0.0f, 1.0f}, {-2.0f, 0.0f, 2.0f}, {-1.0f, 0.0f, 1.0f}};
        float[][] fArrayArray2 = new float[][]{{-1.0f, -2.0f, -1.0f}, {0.0f, 0.0f, 0.0f}, {1.0f, 2.0f, 1.0f}};
        float f = (float)Math.sqrt(2.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (int k = fArrayArray[0].length - 1; k >= 0; --k) {
                    for (int i2 = fArrayArray.length - 1; i2 >= 0; --i2) {
                        int n10 = bufferedImage.getRGB(Math.min(n - 1, i + k), Math.min(n2 - 1, j + i2));
                        n6 = n10 >> 24 & 0xFF;
                        n7 = n10 >> 16 & 0xFF;
                        n8 = n10 >> 8 & 0xFF;
                        n9 = n10 & 0xFF;
                        n3 = (int)((float)(n7 + n8 + n9) / 3.0f);
                        n4 = (int)((float)n4 + fArrayArray[i2][k] * (float)n3);
                        n5 = (int)((float)n5 + fArrayArray2[i2][k] * (float)n3);
                    }
                }
                float f2 = (float)n4 / 8.0f / 128.0f;
                float f3 = (float)n5 / 8.0f / 128.0f;
                float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3) / f * 100.0f;
                n7 = (int)Math.max(0.0f, Math.min(255.0f, (float)n7 - f4));
                n8 = (int)Math.max(0.0f, Math.min(255.0f, (float)n8 - f4));
                n9 = (int)Math.max(0.0f, Math.min(255.0f, (float)n9 - f4));
                n3 = (n6 << 24) + (n7 << 16) + (n8 << 8) + n9;
                bufferedImage.setRGB(i, j, n3);
            }
        }
    }

    @Override
    public ImageIcon convertIcon(ImageIcon imageIcon) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        Image image = imageIcon.getImage();
        int n12 = imageIcon.getIconWidth();
        int n13 = imageIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n12, n13, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        imageIcon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        if (this.pigmode) {
            for (n11 = 0; n11 < bufferedImage.getWidth(); ++n11) {
                for (n10 = 0; n10 < bufferedImage.getHeight(); ++n10) {
                    n9 = bufferedImage.getRGB(n11, n10);
                    n8 = n9 & 0xFFFFFF;
                    n8 = 0xFFFFFF - n8;
                    n9 = (0xFF000000 & n9) + n8;
                    bufferedImage.setRGB(n11, n10, n9);
                }
            }
        }
        if (this.reduceColor) {
            for (n11 = 0; n11 < bufferedImage.getWidth(); ++n11) {
                for (n10 = 0; n10 < bufferedImage.getHeight(); ++n10) {
                    n9 = bufferedImage.getRGB(n11, n10);
                    n9 = this.reduce(n9);
                    bufferedImage.setRGB(n11, n10, n9);
                }
            }
        }
        if (this.pixels) {
            for (n11 = 0; n11 < bufferedImage.getWidth() / this.pixelSize; ++n11) {
                for (n10 = 0; n10 < bufferedImage.getHeight() / this.pixelSize; ++n10) {
                    n9 = 0;
                    n8 = 0;
                    n7 = 0;
                    n6 = 0;
                    n5 = 0;
                    n4 = 0;
                    for (n3 = 0; n3 < this.pixelSize; ++n3) {
                        for (n2 = 0; n2 < this.pixelSize; ++n2) {
                            n = bufferedImage.getRGB(n11 * this.pixelSize + n3, n10 * this.pixelSize + n2);
                            n6 += this.getA(n);
                            if (this.getA(n) >= 127) {
                                n9 += this.getR(n);
                                n8 += this.getG(n);
                                n7 += this.getB(n);
                                ++n5;
                                continue;
                            }
                            ++n4;
                        }
                    }
                    if (this.finnerPixels && n4 >= n5 || n5 == 0) {
                        for (n3 = 0; n3 < this.pixelSize; ++n3) {
                            for (n2 = 0; n2 < this.pixelSize; ++n2) {
                                bufferedImage.setRGB(n11 * this.pixelSize + n3, n10 * this.pixelSize + n2, 0);
                            }
                        }
                        continue;
                    }
                    n6 = this.transparency ? n6 / n5 : 255;
                    n3 = this.toInt(n6, n9 /= n5, n8 /= n5, n7 /= n5);
                    if (this.randomChangeColorBlock) {
                        n3 = this.mediumColorChange(n3);
                    }
                    for (n2 = 0; n2 < this.pixelSize; ++n2) {
                        for (n = 0; n < this.pixelSize; ++n) {
                            bufferedImage.setRGB(n11 * this.pixelSize + n2, n10 * this.pixelSize + n, n3);
                        }
                    }
                }
            }
        }
        if (this.moveDown) {
            for (n11 = 1; n11 < bufferedImage.getWidth(); ++n11) {
                for (n10 = bufferedImage.getHeight() - 2; n10 >= 0; --n10) {
                    n9 = bufferedImage.getRGB(n11, n10);
                    bufferedImage.setRGB(n11 - 1, n10 + 1, n9);
                }
            }
        }
        if (this.makeBox) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (n10 = bufferedImage.getWidth() - 3; n10 >= 0; --n10) {
                for (n9 = 2; n9 < bufferedImage.getHeight(); ++n9) {
                    if (hashSet.contains(n10 + n9 * n12)) continue;
                    n8 = bufferedImage.getRGB(n10, n9);
                    n7 = this.getR(n8);
                    n6 = this.getG(n8);
                    n5 = this.getB(n8);
                    if (this.getA(n8) < 127) continue;
                    n4 = bufferedImage.getRGB(n10 + 1, n9 - 1);
                    n3 = bufferedImage.getRGB(n10 + 2, n9 - 2);
                    if (this.getA(n4) >= 127) continue;
                    n2 = bufferedImage.getRGB(n10, n9 - 1);
                    n = bufferedImage.getRGB(n10 + 1, n9);
                    if (this.getA(n2) < 127 && this.getA(n) < 127) {
                        bufferedImage.setRGB(n10 + 1, n9 - 1, this.toMInt(255, n7, n6, n5));
                        if (this.getA(n3) < 127) {
                            bufferedImage.setRGB(n10 + 2, n9 - 2, this.toMInt(255, n7, n6, n5));
                        }
                    }
                    if (this.getA(n2) < 127) {
                        bufferedImage.setRGB(n10 + 1, n9 - 1, this.toDInt(255, n7, n6, n5));
                        if (this.getA(n3) < 127) {
                            bufferedImage.setRGB(n10 + 2, n9 - 2, this.toDInt(255, n7, n6, n5));
                        }
                    } else if (this.getA(n) < 127) {
                        bufferedImage.setRGB(n10 + 1, n9 - 1, this.toLInt(255, n7, n6, n5));
                        if (this.getA(n3) < 127) {
                            bufferedImage.setRGB(n10 + 2, n9 - 2, this.toLInt(255, n7, n6, n5));
                        }
                    }
                    hashSet.add(n10 + n9 * n12);
                }
            }
        }
        if (this.applySobel) {
            BlockModeConverter.sobel(bufferedImage);
        }
        return new ImageIcon(bufferedImage);
    }
}

